#ifndef RpFillStrategy_CLASS
#define RpFillStrategy_CLASS

#include <RpReferenced.h>
#include <RpImageTile.h>

// ************************************************************************
// CLASS: RpFillStrategy
// DESC:
//    This is the base class for fill strategies.  Fill strategies
//    should be used internally by RpSampledImage classes in order
//    to validate out-of-domain areas.
//
class RpSampledImage;
class RpFillStrategy : public RpReferenced {
   public:   
      RpFillStrategy( void ) { }
      ~RpFillStrategy( void ) { }
      
      // ------------------------------------------------------------------
      // post: returns non-zero on error
      //
      virtual int
      fillTile( RpSampledImage *pHost, RpImageTile *pWriteHere ) = 0;    
};

#endif
