#ifndef lint
static       char    rcsid[] = "$Header: output.c,v 1.1 90/12/12 15:30:21 zhang Exp $";
#endif

/*
 * $Log:	output.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#include "defs.h"

/*
 * sort all entities according their layer name
 *
 * not used now, as entities are not resorted according to
 * their layer names
 */

static	CHAR	TmpFileName[BUFSIZ];	/* temp output file name buffer */

VOID	ResortEntities()
{
}

/*
 * output a polygon into DXF file
 */

VOID	OutputDxfPolygon(n, p, entity)
INT	n;
FLOAT	p[][3];
ENTITY	*entity;
{
	INT	i;
	FLOAT	q[3];

	if (n != 3 && n != 4)
		GENERR("cannot output a %d-edge polygon into DXF file", n);

	NameDxfOutput(entity->layer);
	for (i = 0; i < n; i++)
		if (CurrentStack == NULL) {
			CoordDxfOutput(i, p[i]);
			if (i == 2 && n == 3)
				CoordDxfOutput(i + 1, p[i]);
		} else {
			/*
			 * the polygon is in a block
			 * the point have to be transformed
			 */

			XformPoint(CurrentStack->matrix[0], p[i], q);
			CoordDxfOutput(i, q);
			if (i == 2 && n == 3)
				CoordDxfOutput(i + 1, q);
		}
}

/*
 * output a phong polygon into NFF file
 */

VOID	OutputNffPhongPolygon(n, point, normal, entity)
INT	n;
FLOAT	point[][3];
FLOAT	normal[][3];
ENTITY	*entity;
{
	INT	i;
	FLOAT	q[3];

	if (OutFileType != FILE_NFF) {
		OutputPolygon(n, point, entity);
		return;
	}

	fprintf(OutFile, "ppatch %d\n", n);

	for (i = 0; i < n; i++)
		if (CurrentStack == NULL)
			fprintf(OutFile, "%g %g %g %g %g %g\n",
				point[i][0], point[i][1], point[i][2],
				normal[i][0], normal[i][1], normal[i][2]);
		else {
			/*
			 * the polygon is in a block
			 * the point have to be transformed
			 */

			XformPoint(CurrentStack->matrix[0], point[i], q);
			fprintf(OutFile, "%g %g %g", q[0], q[1], q[2]);
			XformVector(CurrentStack->matrix[0], normal[i], q);
			fprintf(OutFile, " %g %g %g\n", q[0], q[1], q[2]);
		}

}

/*
 * output a polygon into NFF/DEF/DXF/RAD file
 */

VOID	OutputPolygon(n, p, entity)
INT	n;
FLOAT	p[][3];
ENTITY	*entity;
{
	INT	i;
	FLOAT	q[3];

	if (OutFileType == FILE_DXF) {
		OutputDxfPolygon(n, p, entity);
		return;
	}

	if (OutFileType == FILE_DEF)
		fprintf(OutFile, "polygon %d\n", n);
	else
	if (OutFileType == FILE_NFF)
		fprintf(OutFile, "polygon %d\n", n);
	else
	if (OutFileType == FILE_RAD) {
		NameRadOutput(entity->layer);
		fprintf(OutFile, "polygon %d\n0\n0\n%d\n", RadId++, 3 * n);
	}
	else
		GENERR("invalid output file type %d\n", OutFileType);

	if (OutFileType == FILE_DEF)
		(VOID) CheckOrientation(n, p, entity->layer);

	for (i = 0; i < n; i++)
		if (CurrentStack == NULL)
			fprintf(OutFile, "%g %g %g\n", p[i][0], p[i][1], p[i][2]);
		else {
			/*
			 * the polygon is in a block
			 * the point have to be transformed
			 */

			XformPoint(CurrentStack->matrix[0], p[i], q);
			fprintf(OutFile, "%g %g %g\n", q[0], q[1], q[2]);
		}
}

/*
 * output enitities into DEF/NFF/DXF/RAD file
 */

VOID	OutputFile(OutFileName)
CHAR	*OutFileName;
{
	ENTITY	*entity;
	NAME	*name;

	(VOID) strcpy(TmpFileName, OutFileName);

	if (OutFileType == FILE_DEF)
		(VOID) strcat(TmpFileName, ".def");
	else
	if (OutFileType == FILE_NFF)
		(VOID) strcat(TmpFileName, ".nff");
	else
	if (OutFileType == FILE_DXF)
		(VOID) strcat(TmpFileName, ".ent");
	else
	if (OutFileType == FILE_RAD)
		(VOID) strcat(TmpFileName, ".rad");
	else
		GENERR("invalid output file type %d\n", OutFileType);

	/*
	 * ResortEntities();
	 */

	OutFile = fopen(TmpFileName, "w");

	if (OutFile == NULL) {
		fprintf(stderr, "%s: output file %s - cannot be opened\n",
				ProgName, TmpFileName);
		exit(-1);
	}

	/*
	 * output all entities
	 */

	if (OutFileType == FILE_DEF) {
		fprintf(OutFile, "# object definition are in %s.obj\n\n",
				OutFileName);
		for (entity = EntityList; entity != NULL; entity = entity->next)
			(*(EntityProcs[entity->type].defoutput)) (entity);
		fprintf(OutFile, "\n# EndofFile\n");
	} else
	if (OutFileType == FILE_NFF) {
		fprintf(OutFile, "# surface definition are in %s.sur\n\n",
				OutFileName);
		for (entity = EntityList; entity != NULL; entity = entity->next)
			(*(EntityProcs[entity->type].nffoutput)) (entity);
		fprintf(OutFile, "\n# EndofFile\n");
	} else
	if (OutFileType == FILE_RAD) {
		fprintf(OutFile, "# a list of all modifiers is in %s.mod\n\n",
				OutFileName);
		for (entity = EntityList; entity != NULL; entity = entity->next)
			(*(EntityProcs[entity->type].radoutput)) (entity);
		fprintf(OutFile, "\n# EndofFile\n");
	} else
	if (OutFileType == FILE_DXF) {
		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "SECTION\n");
		fprintf(OutFile, "  2\n");
		fprintf(OutFile, "ENTITIES\n");
		for (entity = EntityList; entity != NULL; entity = entity->next)
			(*(EntityProcs[entity->type].dxfoutput)) (entity);
		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "ENDSEC\n");
		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "EOF\n");
	}

	(VOID) fclose(OutFile);

	(VOID) strcpy(TmpFileName, OutFileName);

	if (OutFileType == FILE_DEF)
		(VOID) strcat(TmpFileName, ".obj");
	else
	if (OutFileType == FILE_NFF)
		(VOID) strcat(TmpFileName, ".sur");
	else
	if (OutFileType == FILE_DXF)
		(VOID) strcat(TmpFileName, ".lay");
	else
	if (OutFileType == FILE_RAD)
		(VOID) strcat(TmpFileName, ".mod");

	OutFile = fopen(TmpFileName, "w");

	if (OutFile == NULL) {
		fprintf(stderr, "%s: output file %s - cannot be opened\n",
				ProgName, TmpFileName);
		exit(-1);
	}

	if (OutFileType == FILE_DEF) {
		fprintf(OutFile, "# geometry data are defined in %s.def\n\n",
				OutFileName);

		for (name = NameList; name != NULL; name = name->next) {
			CHAR	*c;

			fprintf(OutFile, "define ");

			if (isalpha(name->name[0]) == 0) {
				fprintf(OutFile, "%s", PrefixStr);
			}

			for (c = name->name; *c != '\0'; c++)
			if (*c == '-')
				fputc('_', OutFile);
			else
				fputc(*c, OutFile);

			fprintf(OutFile, "\n");
		}

		fprintf(OutFile, "\n# EndofFile\n");
	} else
	if (OutFileType == FILE_NFF) {
		fprintf(OutFile, "# geometry data are defined in %s.nff\n\n",
				OutFileName);

		for (name = NameList; name != NULL; name = name->next) {
			CHAR	*c;

			fprintf(OutFile, "surface ");

			if (isalpha(name->name[0]) == 0) {
				fprintf(OutFile, "%s", PrefixStr);
			}

			for (c = name->name; *c != '\0'; c++)
			if (*c == '-')
				fputc('_', OutFile);
			else
				fputc(*c, OutFile);

			fprintf(OutFile, "\n");
		}

		fprintf(OutFile, "\n# EndofFile\n");
	} else
	if (OutFileType == FILE_RAD) {
		fprintf(OutFile, "# geometry data are defined in %s.rad\n\n",
				OutFileName);

		for (name = NameList; name != NULL; name = name->next) {
			CHAR	*c;

			/*
			 * fprintf(OutFile, "modifier ");
			 */

			if (isalpha(name->name[0]) == 0) {
				fprintf(OutFile, "%s", PrefixStr);
			}

			for (c = name->name; *c != '\0'; c++)
			if (*c == '-')
				fputc('_', OutFile);
			else
				fputc(*c, OutFile);

			fprintf(OutFile, "\n");
		}

		fprintf(OutFile, "\n# EndofFile\n");
	} else
	if (OutFileType == FILE_DXF) {
		INT	nlayers;
		INT	colornumber;

		/*
		 * check the number of layers used
		 */

		nlayers = 0;
		for (name = NameList; name != NULL; name = name->next)
			nlayers++;

		/*
		 * output the header of TABLES section
		 */

		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "SECTION\n");
		fprintf(OutFile, "  2\n");
		fprintf(OutFile, "TABLES\n");

		/*
		 * define a linetype used for exploded DXF files
		 */

		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "TABLE\n");
		fprintf(OutFile, "  2\n");
		fprintf(OutFile, "LTYPE\n");

		/*
		 * there is only one linetype defined
		 */
		fprintf(OutFile, " 70\n");
		fprintf(OutFile, "1\n");

		/*
		 * define the name of the linetype
		 */

		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "LTYPE\n");
		fprintf(OutFile, "  2\n");
		fprintf(OutFile, "EXPLODED-DXF-LINE\n");
		fprintf(OutFile, " 70\n");
		fprintf(OutFile, "64\n");
		fprintf(OutFile, "  3\n");
		fprintf(OutFile, "Exploded-DXF-Line from DXF Converter\n");
		fprintf(OutFile, "72\n");
		fprintf(OutFile, "65\n");
		fprintf(OutFile, "73\n");
		fprintf(OutFile, "0\n");
		fprintf(OutFile, "40\n");
		fprintf(OutFile, "0.0\n");

		fprintf(OutFile, "0\n");
		fprintf(OutFile, "ENDTAB\n");

		/*
		 * define layers
		 */

		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "TABLE\n");
		fprintf(OutFile, "  2\n");
		fprintf(OutFile, "LAYER\n");

		/*
		 * table max item count
		 */

		fprintf(OutFile, " 70\n");
		fprintf(OutFile, "%d\n", nlayers);

		colornumber = 0;
		for (name = NameList; name != NULL; name = name->next) {

			/*
			 * table type
			 */

			fprintf(OutFile, "  0\n");
			fprintf(OutFile, "LAYER\n");

			/*
			 * layer name
			 */

			fprintf(OutFile, "  2\n");
			fprintf(OutFile, "%s\n", name->name);

			/*
			 * layer flag
			 */

			fprintf(OutFile, " 70\n");
			fprintf(OutFile, "64\n");

			/*
			 * use floating color
			 *
			 * fprintf(OutFile, " 62\n");
			 * fprintf(OutFile, "0\n");
			 */

			/*
			 * use dynamic color
			 *
			 * note: max number of colors is 16 for VGA
			 */

			fprintf(OutFile, " 62\n");
			fprintf(OutFile, "%d\n", (colornumber++ % 16) + 1);

			/*
			 * linetype
			 *
			 * default BYLAYER
			 * floating linetype: BYBLOCK
			 */

			fprintf(OutFile, "  6\n");
			fprintf(OutFile, "EXPLODED-DXF-LINE\n");
		}

		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "ENDTAB\n");
		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "ENDSEC\n");

		/*
		 * define an empty BLOCK section
		 */

		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "SECTION\n");
		fprintf(OutFile, "  2\n");
		fprintf(OutFile, "BLOCKS\n");
		fprintf(OutFile, "  0\n");
		fprintf(OutFile, "ENDSEC\n");

	}

	(VOID) fclose(OutFile);
}
