#ifndef lint
static       char    rcsid[] = "$Header: point.c,v 1.2 90/12/12 l5:30:21 zhang Exp $";
#endif

/*
 * $Log:	point.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#include "defs.h"

/*
 * a POINT is used as the reference point of a layer in which the
 * orientation of all faces have to be checked
 *
 * each layer should at most have one POINT
 */

typedef	struct	point	{
	FLOAT	point[3];		/* position */
	FLOAT	angle;			/* angle of X axis for the UCS in */
					/* effect when the point was drawn */
					/* for use when PDMODE is nonzero */
					/* default 0 */
} POINT;

ENTITY	*PointDxfParse(layerlist)
LAYER	**layerlist;
{
	ENTITY	*entity;
	POINT	*point;
	INT	pointset = 0;
	INT	angleset = 0;
	INT	defaultflag = 0;

	entity = Malloc(ENTITY, 1);
	point = Malloc(POINT, 1);
	entity->type = ENTITY_POINT;
	entity->data = (VOID *) point;

	entity->layer = LayerDxfParse(layerlist);

	point->angle = 0.0;

	do {
		GetNextGroup();
		switch(Group->code) {
		case 10:
			/*
			 * position
			 * 10, 20, 30
			 */

			if (pointset != 0)
				DXFERR("duplicated position for a POINT %s", "\n");
			pointset = 1;
			CoordDxfParse(0, point->point);
			break;

		case 50:
			/*
			 * angle
			 */

			if (angleset != 0)
				DXFERR("duplicated angle for a POINT %s", "\n");

			angleset = 1;
			point->angle = DEG_TO_RAD(Group->fltnum);
			break;

		default:
			if (OptionsDxfParse(&entity->options) == 0)
				defaultflag = 1;
			break;
		}
	} while (defaultflag == 0);

	/*
	 * check if position is defined
	 */

	if (pointset == 0)
		DXFERR("undefined position of a POINT %s", "\n");

	/*
	 * set up reference point for the layer
	 */

	if (entity->layer->point == NULL) {
		entity->layer->point = Malloc(FLOAT, 3);
		VecCopy(point->point, entity->layer->point);
	} else
		DXFERR("more than one POINT defined in layer %s\n",
			entity->layer->name);

	return(entity);
}

/*ARGSUSED*/
VOID	PointDefOutput(entity)
ENTITY	*entity;
{
}

/*ARGSUSED*/
VOID	PointNffOutput(entity)
ENTITY	*entity;
{
}

/*
 * output a point into DXF file
 */

VOID	PointDxfOutput(entity)
ENTITY	*entity;
{
	POINT	*point;

	point = (POINT *) entity->data;

	fprintf(OutFile, "  0\nPOINT\n");
	fprintf(OutFile, "  8\n%s\n", NameInsert(entity->layer));
	CoordDxfOutput(0, point->point);
	fprintf(OutFile, " 50\n%g\n", point->angle);
}

/*ARGSUSED*/
VOID	PointRadOutput(entity)
ENTITY	*entity;
{
}
