/* vectoroctree.h: octrees containing vectors */

#ifndef _VECTOROCTREE_H_
#define _VECTOROCTREE_H_

#include "vector.h"
#include "Octree.h"

/* same layout as struct OCTREE in Octree.h. Different number of chldren is allowed */
typedef struct VECTOROCTREE {
	struct VECTOR *vector;
	struct VECTOROCTREE *child[8];
} VECTOROCTREE;

#define VectorOctreeCreate()	((VECTOROCTREE *)OctreeCreate())

#define VectorOctreeAdd(poctree, pvector)     \
        (VECTOROCTREE *)OctreeAdd((OCTREE *)poctree, (void *)pvector, (int (*)(void *, void *))VectorCompare)

#define VectorOctreeFind(poctree, pvector)     \
        (VECTOR *)OctreeFind((OCTREE *)poctree, (void *)pvector, (int (*)(void *, void *))VectorCompare)

#define VectorOctreeDestroy(poctree) \
        OctreeDestroy((OCTREE *)poctree)

/* returns 0 if the two vectors are equal, 
 * 1 if p1->x < p2->x 	2 if p->x > p2->x
 * 3 if p1->y < p2->y 	4 if p->y > p2->y
 * 5 if p1->z < p2->z 	6 if p->z > p2->z */
extern int VectorCompare(VECTOR *p1, VECTOR *p2);

#endif /*_VECTOROCTREE_H_*/
