/* vectoroctree.c */

#include "vectoroctree.h"
#include "Float.h"

int VectorCompare(VECTOR *p1, VECTOR *p2)
{
	float d;

	d = p1->x - p2->x;
	if (d < -EPSILON) 
		return 1;
	if (d > EPSILON)
		return 2;

	d = p1->y - p2->y;
	if (d < -EPSILON) 
		return 3;
	if (d > EPSILON)
		return 4;

	d = p1->z - p2->z;
	if (d < -EPSILON) 
		return 5;
	if (d > EPSILON)
		return 6;

	return 0;	/* equal */
}


