/* shadowcaching.h */
#ifndef _SHADOWCACHING_H_
#define _SHADOWCACHING_H_

#include "patch.h"
#include "patchlist.h"
#include "geomlist.h"
#include "ray.h"

extern int ShadowRays, ShadowCacheHits; 

extern void InitShadowCache(void);
extern PATCH *CacheHit(RAY *ray, float *dist);
extern void AddToShadowCache(PATCH *patch);
extern PATCH *ShadowTestGeomlist(RAY *ray, GEOMLIST *world, float dist);
extern PATCH *ShadowTestPatchlist(RAY *ray, PATCHLIST *ShadowList, float dist);

#endif /*_SHDOWCACHING_H_*/
