/* render.h */

#ifndef _RENDER_H_
#define _RENDER_H_

#include <Xm/Xm.h>

/* open window for rendering */
extern Widget RenderCreateWindow(Widget parent);

#include "patch.h"
extern void RenderLink(INTERACTION *PQ);
extern void PatchRenderLinks(PATCH *patch);
extern void RenderElementOutline(PATCH *patch);

/* RenderPatch wordt ingesteld door RenderScene(): als de rendering mode of
 * andere instelling gewijzigd wordt, kan dus best eerst eens RenderScene() 
 * gedaan worden. */
extern void (*RenderPatch)(PATCH *patch);

/* de gehele scene renderen */
extern void RenderScene(void);

/* renders a single pixel */
extern void RenderPixels(int x, int y, int n, RGB *rgb);

/* beeld op het scherm opslaan in een bestand (PPM formaat) */
#include <stdio.h>
extern void SaveScreen(FILE *fp);

/* bepaalt IDs van patches zichtbaar in de x * y pixels van het scherm */
extern unsigned long *GetIDs(long *x, long *y);

#include "color.h"
extern void RenderSetOptions(char gouraud_shading, 
			     char backface_culling,
			     char draw_outlines, 
			     RGB *outline_color,
			     char showlinks, 
			     RGB *link_color);

extern void RenderSetBackfaceCulling(char backface_culling);
extern void RenderSetGouraudShading(char gouraud_shading);
extern void RenderSetOutlineDrawing(char draw_outlines);
extern void RenderSetOutlineColor(RGB *outline_color);
extern void RenderShowLinks(char showlinks);
extern void RenderSetLinkColor(RGB *outline_color);

extern void RenderSetAmbientRadiance(COLOR *ambient);

extern int RenderGetGouraudShading(void);

/* rendering modes */
#define RENDER_ID			1
#define RENDER_REFLECTIVITY		2
#define RENDER_RADIANCE			3
#define RENDER_UNSHOT_RADIANCE		4
#define RENDER_IMPORTANCE		5
#define RENDER_UNSHOT_IMPORTANCE	6

extern void RenderSetMode(char mode);
extern char RenderGetMode(void);

#endif _RENDER_H_

