/* message.c: message dialogs and callback stuff */

#include <Xm/Xm.h>
#include <Xm/MessageB.h>

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include "message.h"
#include "boolean.h"

static Widget messageDialog;
static void (*AfterMessageProc)(void);

/* defaults procedure called after the user clicks the OK button on a
 * message dialog */
static void DefaultAfterMessageProc(void)
{
	/* does nothing */
}

/* sets the procedure to be called when the user clicks on the OK
 * button on the message dialog -- returns the previous routine
 * that was used for this so you can restore it later */
void (*SetAfterMessageProc(void (*proc)(void)))(void)
{
	void (*oldproc)(void);

	oldproc = AfterMessageProc;
	AfterMessageProc = proc;
	return oldproc;
}

static void MessageOkCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	Widget dialog = (Widget)client_data;

	XtUnmanageChild(dialog);
	AfterMessageProc();
}

void InitMessage(Widget topLevel, Arg *args, int nrargs)
{
	Widget temp;

	messageDialog = XmCreateMessageDialog(topLevel, "messageDialog", args, nrargs);
	temp = XmMessageBoxGetChild(messageDialog, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(temp);

	XtAddCallback(messageDialog, XmNokCallback, MessageOkCallback, (XtPointer)messageDialog);

	SetAfterMessageProc(DefaultAfterMessageProc);
}

/* displays a message box */
void Message(char *text, ...)
{
	va_list pvar;
	char buf[256];

	va_start(pvar, text);
	vsprintf(buf, text, pvar);
	va_end(pvar);

	XtVaSetValues(messageDialog,
		      XtVaTypedArg,
		         XmNmessageString, XmRString, buf, strlen(buf)+1,
		      NULL);

	XtManageChild(messageDialog);
}

