/* cubature.h: numerical cubature rules needed to compute formfactors
 * and so on */

#ifndef _CUBATURE_H_
#define _CUBATURE_H_

#ifndef TRUE
#define TRUE 1
#endif /*TRUE*/

#ifndef FALSE
#define FALSE 0
#endif /*FALSE*/

#define CUBAMAXNODES	20	/* no rule has more than 20 nodes */

typedef struct CUBARULE {
	char	*description;	/* description of the rule */
	int	degree, 	/* degree */
	        nrnodes;	/* nr of nodes */
	double	u[CUBAMAXNODES], v[CUBAMAXNODES], w[CUBAMAXNODES];	/* abscissae (u,v) and weights w */
} CUBARULE;

#ifndef TEST
extern CUBARULE CRQ3;	/* quads, degree 3,  4 nodes */
extern CUBARULE CRQ5;	/* quads, degree 5,  7 nodes */
extern CUBARULE CRQ7;	/* quads, degree 7, 12 nodes */

extern CUBARULE CRQ3PG;	/* quads, degree 3,  4 nodes product rule */
extern CUBARULE CRQ5PG;	/* quads, degree 5,  9 nodes product rule */
extern CUBARULE CRQ7PG;	/* quads, degree 7, 16 nodes product rule */

extern CUBARULE CRT3;	/* triangles, degree 3,  4 nodes */
extern CUBARULE CRT5;	/* triangles, degree 5,  7 nodes */
extern CUBARULE CRT7;	/* triangles, degree 7, 12 nodes */

/* This routine should be called during initialization of the program: it
 * transforms the rules over [-1,1]^2 to rules over the unit square [0,1]^2,
 * which we use to map to patches. */
extern void FixCubatureRules(void);

/* after the fixing, the weights for every rule will sum to 1.0, which
 * will allow us to treat parallelipipeda and triangles the same way. */
#endif /*TEST*/

#endif /*_CUBATURE_H_*/
