/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

				RAD
		       (Interactive Radiosity)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: modif.c
  Description	: Routines de gestion de queue de modification d'objet
**************************************************************************/

#include <stdio.h>
#include "types.h"
#include "macros.h"
#include "modif.h"

#define MAX_MODIF	10

MODIF	modif_queue[MAX_MODIF];
int	in_modif = 0, out_modif = 0;
BOOLEAN	queue_full = FALSE, queue_empty = TRUE;

void enq_modif(MODIFP modif)
/**************************************************************************
  But	: Place une modification dans la queue des modifications
  Entree: modif	    : la modification
  Sortie: neant
**************************************************************************/
{
  if (!queue_full)
    {
      modif_queue[in_modif] = *modif;
      in_modif = (in_modif+1)%MAX_MODIF;
      queue_full = (((in_modif+1)%MAX_MODIF) == out_modif);

      queue_empty = FALSE;
    };
}

void remove_modif()
/**************************************************************************
  But	: Retire la prochaine modification de la queue
  Entree: neant
  Sortie: neant
**************************************************************************/
{
  if (!queue_empty)
    {
      out_modif = (out_modif+1)%MAX_MODIF;
      if (in_modif == out_modif)
        queue_empty = TRUE;

      queue_full = FALSE;
    }
}

void next_modif(MODIFP modif)
/**************************************************************************
  But	: Rend la prochaine modification a faire
  Entree: modif	    : la modification rendue
  Sortie: neant
**************************************************************************/
{
  if (!queue_empty)
    *modif = modif_queue[out_modif];
}

BOOLEAN modif_q_not_empty()
/**************************************************************************
  But	: Rend l'etat de la queue de modification
  Entree: neant
  Sortie: TRUE si la queue n'est pas vide, FALSE sinon
**************************************************************************/
{
  return (!queue_empty);
}

void empty_modif_queue()
/**************************************************************************
  But	: Vide la queue
  Entree: neant
  Sortie: neant
**************************************************************************/
{
  queue_empty = TRUE;
  queue_full  = FALSE;
  in_modif    = out_modif = 0;
}
