/**********************************************************************/
/*                                                                    */
/* args.c : handle command line args                                  */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          *
/**********************************************************************/
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <gl/gl.h>
#include <fmclient.h>
#define IRIS4D 1
#include "geo.h"
#include "walk.h"
#include "vcr.h"

extern char *meshfilename;
#define shift argc--; argv++;

/**********************************************************************/
static char StrUsage[] =              /* program usage                */
  "[-dghBW] [-s #] [[-w x y x y] -p patch-file";

/**********************************************************************/
/* Syntax                                                             */
/**********************************************************************/
static void Usage()
{
  fprintf(stderr,"usage: %s %s\n", ProgName, StrUsage);
}

/**********************************************************************/
/* Help                                                               */
/**********************************************************************/
static void LongUsage()
{
  fprintf(stderr,"\nWhere:\n");
  fprintf(stderr,"\td : debug mode\n");
  fprintf(stderr,"\tg : gamma correction\n");
  fprintf(stderr,"\tp : set patch file to use\n");
  fprintf(stderr,"\th : this message\n");
  fprintf(stderr,"\tw x y x y : window origin(x,y) and size(x,y)\n");
  fprintf(stderr,"\tn : Set to NTSC mode\n");
  fprintf(stderr,"\ts : RGB scale factor\n");
  fprintf(stderr,"\tv : Record to VCR in NTSC mode\n");
  fprintf(stderr,"\tB : Black and white mesh rendering\n");
  fprintf(stderr,"\tW : Display on full screen\n");
}

/**********************************************************************/
/* Parse command line arguments                                       */
/**********************************************************************/
void ParseArgs(argc, argv)
     int argc;
     char **argv;
{
  float tmp;
  int has_patchname = 0;

  if (argc < 2) {
    Usage();
    exit(1);
  }

  shift;
  while (argc && **argv == '-') {
    switch(*++*argv) {

    case 'd':                     /* Run in debug mode */
      fprintf(stderr,"In debug mode\n");
      Option.debug = 1; 
      break;

    case 'g':                     /* Gamma correction */
      System.gamma = TRUE;
      break;
      
    case 'h':                     /* Help */
      Usage();
      LongUsage();
      exit(0);
      break;

    case 'n':                     /* Set NTSC window size and placement */
      System.VCRmode = NTSC;
      System.UseVCR = TRUE;
      fprintf(stderr,"Displaying NTSC mode\n");
      break;
      
    case 'p':                    /* Patch file name */
      shift;
      if (!argc) {
	fprintf(stderr,"Sorry, no patch file parameter given\n");
	exit(1);
      }
      meshfilename = *argv;
      has_patchname = 1;
      break;

    case 's':                     /* RGB scaling factor */
      shift;
      if (!argc) {
	fprintf(stderr,"No RGB colour scaling given\n");
	exit(1);
      }
      tmp = atof(*argv);
      Option.RGBscale = tmp;
      fprintf(stderr,"Scaling by factor %g\n", Option.RGBscale);
      break;

    case 'v':                    /* Run in NTSC mode */
      fprintf(stderr,"Recording NTSC mode\n");
      System.VCRmode = REC;
      System.UseVCR = TRUE;
      Option.debug = 0;
      break;

    case 'w': /* provide x1,y1,x2,y2  and xsize, ysize */
      shift;
      if (argc < 4) {
	fprintf(stderr,"Not enough args for w\n");
        exit(1);
      }
      WindXorigin = atoi(*argv); shift;
      WindYorigin = atoi(*argv); shift;
      WindXsize = atoi(*argv); shift;
      WindYsize = atoi(*argv); ;
      System.UsePrefpos = 1;
      System.UsePrefsize = 1;
      fprintf(stderr,"Window parms are: Origin: %d,%d Size: %d,%d\n",
	     WindXorigin, WindYorigin, WindXsize, WindYsize);
      break;

    case 'B':                    /* Black & white mesh rendering */
      Option.shadeBW = TRUE;
      break;

    case 'F':                    /* Display on full screen */
      System.FullScreen = 1;
      break;

    case 'P':           /* Directory containing patch files (not used) */
      Option.data_dir = ".";
      fprintf(stderr,"Set patch directory to current. Not done yet.\n");
      break;

    default:
      Usage();
      exit(-1);
    }
    shift;
  }

  if (has_patchname == 0) {
    fprintf(stderr, "Sorry, no patch file parameter given\n");
    exit(0);
  }
}
