/**********************************************************************/
/* rlog.c                                                             */
/*                                                                    */
/* For storing data in LaTex table form.                              */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "geo.h"
#include "struct.h"
#include "io.h"
#include "ray.h"
#include "ff.h"

extern char *ProgName;

FILE *rlogfile;               /* File of data points of convergence */
char *rlogfilename =          /* Filename */
  "                              ";

/**********************************************************************/
/* Switch log on / off */
/**********************************************************************/
void LogRlog(logflag,fname,fext)
     int logflag;
     char *fname;
     char *fext;
{
  if (logflag) {
    sprintf(rlogfilename,"%s.%s.tex",fname,fext);   /* RLog log */
    if (!(rlogfile = fopen(rlogfilename, "w"))) {
      fprintf(stderr,"%s: cannot open log file %s\n", ProgName, rlogfilename);
      exit(1);
    } 
    printf("\n\t*** Print run log data to %s ***\n", rlogfilename);
  } else 
    fclose(rlogfile);
}
