/**********************************************************************/
/* ff.h                                                               */
/*                                                                    */
/* Form factor data structures                                        */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
/* Requires geo.h, struct.h */

#ifndef FF_H
#define FF_H

#define NUMERICAL_FF 0       /* Use numerical ff approximation        */
#define ANALYTIC_FF 1        /* Use analytic ff approximation         */
#define ELLIPSE_FF 2         /* Use ellipse ff approx                 */
#define DISC_FF 3            /* Use disc ff approx                    */

#define UNITEST -1           /* For testing only (not used)           */
#define UNIFORM 0            /* Uniform sampling flag                 */
#define JITTERED 1           /* Jitter sampling flag                  */

#define MAX_SAMPLES 64       /* Maximum number of samples per poly    */
#define DEFAULT_SAMPLES 16   /* Default grid of samples for PR        */
#define DEFAULT_LSAMPLES 1   /* Default grid of samples for linkage 
				 forming */
#define DEFAULT_ASAMPLES 4   /* Default # of positions to sample from 
				on receiver for analytic ff */

#define DEFAULT_F_max 0.05   /* maximum allowed ff per 2 patches      */
#define DEFAULT_F_min 0.005  /* minimum allowed ff                    */
#define DEFAULT_B_max 0.01   /* maximum allowed B                     */
#define DEFAULT_B_min 0.001  /* minimum allowed B                     */
#define MAX_F_DIFF_POLY 0.02 /* maximum allowed difference between ff
				of 2 patches before you have to 
				subdivide */
#define MAX_PATCH_LEVELS 0    /* Number of levels to subdivide a 
				 polygon into elements */

typedef struct {             /* Sample point for ray casting form-factor */
  Polygon *p;                /* Polygon sample take from              */
  Vector pos;                /* Sample position                       */
  Vector norm;               /* Normal at position                    */
  double area;               /* Area sample extends to                */
  Vector corners[MAX_PATCH_VTX]; /* Corners of sample area            */
} Sampletype;

typedef struct {
  double B_min, B_max;       /* Min and max radiosity shot per interaction */
  double F_min, F_max;       /* Min and max formfactor per interaction */
  int sampling_type;         /* JITTERED or UNIFORM sampling          */
  int num_samples;           /* Number of samples per source polygon  */
  int fftype;                /* Form factor approximation type        */
  double F_diff_poly;        /* Maximum allowed difference between 2 polys */
  double F_diff_edge;        /* Maximum allowed difference between 2 edge
				vertices */
  int max_levels;            /* Maximum number of levels to subdivide */
  int sample_shape;          /* Sample shape circle or ellipse ff approx */
  int varying_numsamps;      /* Vary # of source samples per rec. vtx */
  int use_analytic;          /* Use analytic form-factors for special
				cases */
  int src_rec_cull;          /* Cull to find objects between source and
				receiver patches */
  int quadtri_ray;           /* Use ray-quad/triangle intersection 
				routine	versus ray-general polygon 
				intersection routine */
  int shaft_cull;            /* Use shaft culling for ray visibility tests */
  double min_element_area;   /* Minimum element area = fraction of area
				of the world. */
} FF_OptionType;

typedef struct {             /* form-factor info                      */
  double val;                /* ff value                              */
  Polygon *patch_i,*patch_j; /* id of patches formfactor is between   */
} FF_type;

/**********************************************************************/
extern void UVToXYZ();
extern int Init_Samples();
extern int ff_Generate_Patch_Samples();
extern double ff_da_analytic();
extern double ff_da_disc();
extern double ff_patches();
extern int shoot_ray();
extern void ff_print_samples();
void ff_print_FF_Options();

#endif /* FF_H */
