/* EDGE standard header file for graphics programs 
 * Stripped down version 3/11/94 
 */

#ifndef GRAPHICS_H
#define GRAPHICS_H
#endif

#define       ABS(a)          ((a) > 0 ? (a) : -(a))
double fabs(), sqrt(), sin(), cos(), tan();

  typedef struct xyz_td
          {
              float    x,
                       y,
                       z;
	  } xyz_td;



  typedef struct rgb_td
          {
              float    r,
                       g,
                       b;
	  } rgb_td;


typedef float tran_mat_td[4][4];


/*
 *****************************************************************************
 *                  FUNCTION FIELD DEFINITIONS
 *****************************************************************************
 */

typedef unsigned char flow_func_type;

typedef struct flow_func_td       
    {
      short         func_type;
      xyz_td        center, axis;
      float         distance;
      float         falloff_start;
      short         falloff_type;
      float         parms[20];
    } flow_func_td;

typedef struct vol_shape_td
    {
      xyz_td         center;
      xyz_td         inv_rad_sq;
      xyz_td         inv_rad;
    } vol_shape_td;

typedef struct vol_td
    {
      short          obj_type;
      float          y_obj_min,    /* min & max y per volume             */
	             y_obj_max;
      float          x_obj_min,    /* min & max x per volume             */
	             x_obj_max;
      int            shape_type;   /* 0=sphere, 1=box;                   */
      int            self_shadow;  /* 0=no, 1=yes                        */
      xyz_td         scale_obj;   /*how to scale obj to get into -1:1 space*/
      xyz_td         trans_obj;   /*how to trans obj to get into -1:1 space*/
      vol_shape_td   shape;
      int            funct_name;
      rgb_td         color;
      float          amb_coef;
      float          diff_coef;
      float          spec_coef;
      float          spec_power;
      int            illum_type;  /* illumination - phong, blinn, c-t, gas */
      int            color_type;  /* constant, solid*/
      float          indx_refrac;
    } vol_td;
	 




