
/*  @(#)popitopgm.c 1.1 91/12/28
 *
 *  Small filter to convert old format popi image files to raw pgm format
 *  files. The old popi image is given on standard input, and the raw pgm
 *  file is written to standard output.
 *
 *  Command line options:
 *
 *  -x nnn  -  width of the image in pixels.
 *  -y nnn  -  height of the image in pixels.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include <stdio.h>

#define  PATCHLEVEL  0

#define  FPRINTF     (void) fprintf
#define  PRINTF      (void) printf


main(argc, argv)
int argc ;
char *argv[] ;
{
  char *progname = argv[0] ;    /* Name of this program. */
  int c ;
  int x = 512 ;                 /* Default width is 512 pixels. */
  int y = 512 ;                 /* Default height is 512 pixels. */

  argv++ ;                      /* Extract command line options (if any). */
  argc-- ;
  while (argc > 0)
    {
      switch (argv[0][1])
        {
          case 'x' : argv++ ;            /* New width value. */
                     argc-- ;
                     x = atoi(*argv) ;
                     break ;
          case 'y' : argv++ ;            /* New height value. */
                     argc-- ;
                     y = atoi(*argv) ;
                     break ;
          case 'v' : FPRINTF(stderr, "%s version 1.2.%1d\n",
                                     progname, PATCHLEVEL) ;
                     break ;
          case '?' : FPRINTF(stderr, "Usage: %s [-x] [-y] [-v] [-?]\n",
                                     progname) ;
                     exit(1) ;
        }
      argc-- ;
      argv++ ;
    }

  PRINTF("P5\n%d %d\n255\n", x, y) ;
  while ((c = getchar()) != EOF) putchar(c) ;
}
