
/*  @(#)expr.h 1.2 91/12/30
 *
 *  Definitions used in the popi yacc grammar.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include <stdio.h>

enum tree { T_Abs,     T_Add,    T_And,    T_Atan,   T_Bang,
            T_Color,   T_Cond,   T_Coord,  T_Cos,    T_Debug,
            T_Display, T_Div,    T_Eq,     T_File,   T_Fnum,
            T_Free,    T_Ge,     T_Genep,  T_Genps,  T_Gray,
            T_Gt,      T_Help,   T_Hypot,  T_Image,  T_Inum,
            T_Land,    T_Le,     T_List,   T_Log,    T_Logfile,
            T_Lor,     T_Lshift, T_Lt,     T_Matte,  T_Melt,
            T_Minus,   T_Mod,    T_Mono,   T_Mul,    T_Ne,
            T_Neg,     T_New,    T_Not,    T_Ofmt,   T_Oil,
            T_Or,      T_Pang,   T_Plus,   T_Polar,  T_Pow,
            T_Prad,    T_Quit,   T_Rand,   T_Read,   T_Rshift,
            T_Shear,   T_Signed, T_Sin,    T_Slice,  T_Sqrt,
            T_Sub,     T_Tile,   T_Trunc,  T_Undo,   T_Ver,
            T_Verbose, T_Write,  T_Xcoord, T_Xor,    T_Ycoord } ;

typedef struct Tree Tree ;

struct Tree {
  enum tree t ;
  int i ;
  double d ;
  void *kids[3] ;
} ;

/* alloc.c */
extern void *ealloc P((size_t)) ;
extern void *alloc  P((size_t)) ;
extern void afree   P((void)) ;

#ifndef offsetof
#define  offsetof(t, m)  ((size_t) &((t *) 0)->m)
#endif /*!offsetof*/

#define  treealloc(x)    alloc(offsetof(Tree, kids[x]))

/* main.c */
extern int saw_eof ;
extern Tree *tree ;

/* gen.c */
extern void compile  P((Tree *)) ;

/* mk.c */
extern Tree *mk      P((enum tree, Tree *, Tree *)) ;
extern Tree *mkCond  P((Tree *, Tree *, Tree *)) ;
extern Tree *mkun    P((enum tree, void *)) ;
extern Tree *mkInum  P((int)) ;
extern Tree *mkFnum  P((double)) ;
extern Tree *mkempty P((enum tree)) ;

/* special.c */
extern void debug      P((Tree *)) ;
extern void displayimg P((Tree *)) ;
extern void dolog      P((Tree *)) ;
extern void dosigned   P((Tree *)) ;
extern void freeimg    P((Tree *)) ;
extern void genepson   P((Tree *)) ;
extern void genps      P((Tree *)) ;
extern void help       P((void)) ;
extern void imtrunc    P((Tree *)) ;
extern void matte      P((Tree *)) ;
extern void melt       P((Tree *)) ;
extern void ofmt       P((Tree *)) ;
extern void oil        P((Tree *)) ;
extern void readimg    P((Tree *)) ;
extern void setcolor   P((void)) ;
extern void setgray    P((void)) ;
extern void setmono    P((void)) ;
extern void shear      P((Tree *)) ;
extern void slice      P((Tree *)) ;
extern void tile       P((Tree *)) ;
extern void undo       P((void)) ;
extern void verbose    P((Tree *)) ;
extern void writeimg   P((Tree *)) ;
