/* file: convex.h - define constants for convex testers */

/***** first are generic debug aids *****/

#define	DEBUG	0
#if	DEBUG
#define GIAssure(cond)                                                  \
        if (!(cond)) {                                                  \
            printf( "\7\7\7??? 'cond' failed\n");                       \
            printf( "GIAssure: Line %d, File %s\n\n", __LINE__, __FILE__); \
        }

#define	GITrace(level, args)	if ( verbose >= level ) { args };

#else
#define GIAssure(cond)
#define	GITrace(level, args)
#endif

/********** customize the performance gathering program perf.c **********/
/* following for testing polygon convexity */
extern	int	verbose;		/* for tracing level */
extern	float	epsilon;		/* for tiny changes */

#define	ReturnDegenerateNonConvex	1
#define	ReturnDegenerateConvex		2
#define	ReturnNonConvex			3
#define	ReturnConvex			4

#define	DirUnknown	0
#define	DirPlus		1
#define	DirNeg		-1

typedef	float	Number;		/* float or double */

#undef	feof
#define	feof	perf_feof

#define	fscanf	perf_fscanf

#define	TEST_SETUP_2D   setUpFakeScanf2D( onVert, pgon2D );		\

#define	TEST_SETUP_3D 

#define	FIX_RETURN							\
	if ( status[onRoutine] == -1 ) status[onRoutine] = 1; 		\

#define PRINT_ONE_TEST_RESULT(pname)					\
	printf( "%-17s says %s\n", pname, 				\
	    status[onRoutine] == ReturnConvex    ? "Convex" : 		\
	    status[onRoutine] == ReturnNonConvex ? "Non-Convex" :	\
	    status[onRoutine] == ReturnDegenerateConvex ? "Degen-convex" :\
	    status[onRoutine] == ReturnDegenerateNonConvex ? 		\
			"Degen-non-convex" : "???UNKNOWN RETURN" );	\

#define	CHECK_RETURN(pname)						\
    if ( 1 ) {								\
	int	cs = status[onRoutine],					\
		ps = status[onRoutine-1];				\
	if ( cs == ReturnDegenerateNonConvex ) cs = ReturnNonConvex;	\
	if ( cs == ReturnDegenerateConvex    ) cs = ReturnConvex;	\
	if ( ps == ReturnDegenerateNonConvex ) ps = ReturnNonConvex;	\
	if ( ps == ReturnDegenerateConvex    ) ps = ReturnConvex;	\
	if ( onRoutine  &&  cs != ps ) {				\
	    printf(        						\
"\7\7\7???ROUTINE '%s' status %d disagress with previous routine status %d\n",\
		pname, status[onRoutine], status[onRoutine-1] );	\
	    printf(							\
"    onVert = %d, onPolygon = %d, prev stat = %d, cur stat = %d\n",	\
		onVert,onPolygon, status[onRoutine-1], status[onRoutine] ); \
	    if ( verbose >= 6 )						\
	        printPoly( onVert, pgon2D );				\
	}								\
    }
