/*
 * Determines whether a polygon is convex in O(n) time and O(1) space.
 * Points maybe repeated and collinear.
 * Author: Peter Schorn, schorn@inf.ethz.ch
 * 29-Oct-92
 */

#include <stdio.h>
#include "perf.h"

#define TRUE (-1)
#define FALSE (0)

typedef struct Point2d { Number x, y; } Point2d;

/*****************************************************************************/
int WhichSide(p, q, r)
Point2d p, q, r;
{
 Number	result;
 result = (p.x - q.x) * (q.y - r.y) - (p.y - q.y) * (q.x - r.x);
 if (result > 0) return 1;
 if (result < 0) return -1;
 return 0;
}

int Compare(p, q)
Point2d p, q;
{
 if (p.x < q.x) return -1;
 if (p.x > q.x) return 1;
 if (p.y < q.y) return -1;
 if (p.y > q.y) return 1;
 return 0;
}

int GetPoint(f, p)
 FILE *f;
 Point2d *p;
 {
  return !feof(f) && (2 == fscanf(f, " %lf %lf", &(p->x), &(p->y)));
 }

int GetDifferentPoint(f, previous, next)
 FILE *f;
 Point2d previous, *next;
 {
  int eof;
  while ((eof = GetPoint(f, next)) && (Compare(previous, *next) == 0));
  return eof;
 }

#define CheckTriple \
  if (((thisDir = Compare(second, third)) == -curDir) && \
      (++dirChanges > 2)) return ReturnNonConvex; \
  curDir = thisDir; \
  if (thisSign = WhichSide(third, second, first)) \
  { \
   if (angleSign == -thisSign) return ReturnNonConvex; \
   angleSign = thisSign; \
  } \
  first = second; \
  second = third;

isConvexSchorn( f )
 FILE *f;
 {
  int curDir, thisDir, thisSign, angleSign = 0, dirChanges = 0;
  Point2d first, second, third, saveFirst, saveSecond;

  if (!GetPoint(f, &first) ||
      !GetDifferentPoint(f, first, &second)) return ReturnConvex;
  saveFirst = first; saveSecond = second;
  curDir = Compare(first, second);
  while (GetDifferentPoint(f, second, &third))
  {
   CheckTriple;
  }
  if (Compare(second, saveFirst))
   {
    third = saveFirst;
    CheckTriple;
   }
  third = saveSecond;
  CheckTriple;
  return ReturnConvex;
 }

/*****************************************************************************/
#define	MacroGetPoint(p)				\
	( (p).x = pVert[onStreamVert][0],		\
	  (p).y = pVert[onStreamVert][1],		\
	  onStreamVert++ >= nvert ? 0 : 1 )		\

#define	MacroCompare(p, q)				\
    ( (p.x < q.x) ? -1 :				\
      (p.x > q.x) ?  1 :				\
      (p.y < q.y) ? -1 :				\
      (p.y > q.y) ?  1 : 0 )				\

#define	MacroGetDifferentPoint(previous, next)		\
    while ( (result = MacroGetPoint( next )) && 	\
	    (MacroCompare(previous, next) == 0) ) ;	\

#define	MacroCross(p, q, r) 				\
	(p.x - q.x) * (q.y - r.y) - (p.y - q.y) * (q.x - r.x);

#define MacroCheckTriple(third)					\
    if ( ((thisDir = MacroCompare(second, third)) == -curDir) && 	\
          (++dirChanges > 2) ) return ReturnNonConvex; 		\
    curDir = thisDir; 						\
    cross = MacroCross(third, second, first);			\
    if ( cross > 0 ) thisSign = 1;				\
    else if ( cross < 0 ) thisSign = -1;			\
    else thisSign = 0;						\
    if ( thisSign ) { 						\
        if ( angleSign == -thisSign ) return ReturnNonConvex; 	\
        angleSign = thisSign; 					\
    } 								\
    first = second;		/* copy x and y */		\
    second = third;		/* copy x and y */		\

isConvexSchorn2( nvert, pVert )
int     nvert;
Number  pVert[][2];
{
    int	     curDir, thisDir, thisSign, angleSign = 0, dirChanges = 0, result;
    int	     onStreamVert = 0;
    Point2d  first, second, third, saveFirst, saveSecond;
    Number   cross;

    if ( !MacroGetPoint(first) ) return ReturnConvex;
    MacroGetDifferentPoint( first, second );
    if ( !result ) return ReturnConvex;

    saveFirst = first; saveSecond = second;
    curDir = MacroCompare(first, second);
    
    while ( 1 ) {
        MacroGetDifferentPoint(second, third);
	if ( !result ) break;
        MacroCheckTriple(third);
    }
    if ( MacroCompare(second, saveFirst) ) {
        MacroCheckTriple(saveFirst);
    }
    MacroCheckTriple(saveSecond);
    return ReturnConvex;
}

/*****************************************************************************/
#define	Macro3GetPoint(p)				\
	( (p)[0] = pVert[onStreamVert][0],		\
	  (p)[1] = pVert[onStreamVert][1],		\
	  onStreamVert++ >= nvert ? 0 : 1 )		\

#define	Macro3Compare(delta)				\
    ( (delta[0] < 0) ? -1 :				\
      (delta[0] > 0) ?  1 :				\
      (delta[1] < 0) ? -1 :				\
      (delta[1] > 0) ?  1 : 0 )				\

#define	Macro3GetDifferentPoint(delta, previous, next)	\
    while ( result = Macro3GetPoint( next ) ) {		\
	delta[0] = next[0] - previous[0];		\
	delta[1] = next[1] - previous[1];		\
	if ( delta[0] || delta[1] ) break;		\
    }							\

#define	Macro3Cross(p, q) p[0] * q[1] - p[1] * q[0];

#define Macro3CheckTriple 					\
    if ( ((thisDir = Macro3Compare(dnext)) == -curDir) && 	\
          (++dirChanges > 2) ) return ReturnNonConvex; 		\
    curDir = thisDir; 						\
    cross = Macro3Cross(dcur, dnext);				\
    if ( cross > 0 ) thisSign = 1;				\
    else if ( cross < 0 ) thisSign = -1;			\
    else thisSign = 0;						\
    if ( thisSign ) { 						\
        if ( angleSign == -thisSign ) return ReturnNonConvex; 	\
        angleSign = thisSign; 					\
    } 								\
    dcur[0]   = dnext[0]; dcur[1]   = dnext[1];	/* copy second delta */	\
    second[0] = third[0]; second[1] = third[1];	/* and save third point */\

isConvexSchorn3( nvert, pVert )
int     nvert;
Number  pVert[][2];
{
    int	     curDir, thisDir, thisSign, angleSign = 0, dirChanges = 0, result;
    int	     onStreamVert = 0;
    Number   thefirst[2], thesecond[2], thethird[2],
    		*first = thefirst, *second = thesecond, *third = thethird,
    		saveFirst[2], saveSecond[2], dcur[2], dnext[2], cross;

    if ( !Macro3GetPoint(first) ) return ReturnConvex;
    Macro3GetDifferentPoint( dcur, first, second );
    if ( !result ) return ReturnConvex;

    saveFirst[0]  = first[0]; 	saveFirst[1]  = first[1];
    saveSecond[0] = second[0]; 	saveSecond[1] = second[1];
    curDir = Macro3Compare(dcur);
    
    while ( 1 ) {
        Macro3GetDifferentPoint(dnext, second, third);
	if ( !result ) break;
        Macro3CheckTriple;
    }

    third = saveFirst;
    dnext[0] = saveFirst[0] - second[0];
    dnext[1] = saveFirst[1] - second[1];
    if ( Macro3Compare(dnext) ) {
        Macro3CheckTriple;
    }

    dnext[0] = saveSecond[0] - second[0];
    dnext[1] = saveSecond[1] - second[1];
    Macro3CheckTriple;
    return ReturnConvex;
}

/*****************************************************************************/
#define	Macro4Compare(delta)				\
    ( (delta[0] < 0) ? -1 :				\
      (delta[0] > 0) ?  1 :				\
      (delta[1] < 0) ? -1 :				\
      (delta[1] > 0) ?  1 : 0 )				\

#define	Macro4GetDifferentPoint(delta, pprev, pcur)	\
    while ( status = (iread < nvert) ) {		\
	pcur = pVert[iread++];				\
	delta[0] = pcur[0] - pprev[0];			\
	delta[1] = pcur[1] - pprev[1];			\
	if ( delta[0] || delta[1] ) break;		\
    }							\

#define	Macro4Cross(p, q) p[0] * q[1] - p[1] * q[0];

#define Macro4CheckTriple 					\
    if ( ((thisDir = Macro4Compare(dcur)) == -curDir) && 	\
          (++dirChanges > 2) ) return ReturnNonConvex; 		\
    curDir = thisDir; 						\
    cross = Macro4Cross(dprev, dcur);				\
    if ( cross > 0 ) { if ( angleSign == -1) return ReturnNonConvex; \
		       angleSign = 1;				\
		     }						\
    else if ( cross < 0 ) { if ( angleSign == 1) return ReturnNonConvex; \
		            angleSign = -1;			\
	                  }					\
    pSecond = pThird;		/* remember ptr to current point */	\
    dprev[0] = dcur[0];		/* remember current delta */	\
    dprev[1] = dcur[1];						\

isConvexSchorn4( nvert, pVert )
int     nvert;
Number  pVert[][2];
/* determine polygon type. return one of: ReturnNonConvex or ReturnConvex */
{
    int	     curDir, thisDir, angleSign = 0, dirChanges = 0, status,
    	     iread = 1;
    Number   *pSecond, *pThird, *pSaveSecond, dprev[2], dcur[2], cross;

    /* if ( nvert <= 0 ) return error;       if you care */
    /* if ( nvert < 3 ) return ReturnConvex; this only slows down other cases */

    Macro4GetDifferentPoint( dprev, pVert[0], pSecond);
    if ( !status ) return ReturnConvex;
    pSaveSecond = pSecond;

    curDir = Macro4Compare(dprev);
    
    while ( 1 ) {
        Macro4GetDifferentPoint(dcur, pSecond, pThird);
	if ( !status ) break;
        Macro4CheckTriple;
    }

    pThird = pVert[0];
    dcur[0] = pThird[0] - pSecond[0];
    dcur[1] = pThird[1] - pSecond[1];
    if ( Macro4Compare(dcur) ) {
        Macro4CheckTriple;
    }

    dcur[0] = pSaveSecond[0] - pSecond[0];
    dcur[1] = pSaveSecond[1] - pSecond[1];
    Macro4CheckTriple;
    return ReturnConvex;
}

/*****************************************************************************/
retnow()
{ 
    return(1);
}

/*****************************************************************************/
#define	Macro5Compare(delta)				\
    ( (delta[0] < 0) ? -1 :				\
      (delta[0] > 0) ?  1 :				\
      (delta[1] < 0) ? -1 :				\
      (delta[1] > 0) ?  1 : 0 )				\

#define	Macro5GetDifferentPoint(delta, pprev, pcur)	\
    while ( status = (iread < nvert) ) {		\
	pcur = pVert[iread++];				\
	delta[0] = pcur[0] - pprev[0];			\
	delta[1] = pcur[1] - pprev[1];			\
	if ( delta[0] || delta[1] ) break;		\
    }							\

#define	Macro5Cross(p, q) p[0] * q[1] - p[1] * q[0];

#define Macro5CheckTriple 					\
    if ( (thisDir = Macro5Compare(dcur)) == -curDir ) 		\
          ++dirChanges; 					\
    curDir = thisDir; 						\
    cross = Macro5Cross(dprev, dcur);				\
    if ( cross > 0 ) { if ( angleSign == -1 ) return ReturnNonConvex;	\
		       degenerate = 0;				\
		       angleSign = 1;				\
		     }						\
    else if ( cross < 0 ) { if ( angleSign == 1 ) return ReturnNonConvex; \
		            degenerate = 0;			\
		            angleSign = -1;			\
	                  }					\
    pSecond = pThird;		/* remember ptr to current point */	\
    dprev[0] = dcur[0];		/* remember current delta */	\
    dprev[1] = dcur[1];						\

isConvexSchorn5( nvert, pVert )
int     nvert;
Number  pVert[][2];
/* determine polygon type. return one of: ReturnDegenerateNonConvex,
 *	ReturnDegenerateConvex, ReturnNonConvex, or ReturnConvex
 */
{
    int	     curDir, thisDir, dirChanges = 0, 
             angleSign = 0, degenerate = 1, status, iread = 1;
    Number   *pSecond, *pThird, *pSaveSecond, dprev[2], dcur[2], cross;

    /* if ( nvert <= 0 ) return error;       if you care */
    /* if ( nvert < 3 ) return ReturnConvex; this only slows down other cases */

    Macro5GetDifferentPoint( dprev, pVert[0], pSecond);
    if ( !status ) return ReturnConvex;	/* ret if < 3 diff points */
    pSaveSecond = pSecond;

    curDir = Macro5Compare(dprev);
    
    while ( 1 ) {
        Macro5GetDifferentPoint(dcur, pSecond, pThird);
	if ( !status ) break;
        Macro5CheckTriple;
    }

    pThird = pVert[0];
    dcur[0] = pThird[0] - pSecond[0];
    dcur[1] = pThird[1] - pSecond[1];
    if ( Macro5Compare(dcur) ) {
        Macro5CheckTriple;
    }

    dcur[0] = pSaveSecond[0] - pSecond[0];
    dcur[1] = pSaveSecond[1] - pSecond[1];
    Macro5CheckTriple;

    /* decide on polygon type given accumulated status */
    if ( degenerate ) {
	/* the polygon is composed of points and lines - no area */
        if ( dirChanges > 2 )
	    return ReturnDegenerateNonConvex;
	return ReturnDegenerateConvex;
    }
    if ( dirChanges > 2 )
	return ReturnNonConvex;
    return ReturnConvex;
}

/*****************************************************************************/
#define	Macro6Compare(delta)				\
    ( (delta[0] < 0) ? -1 :				\
      (delta[0] > 0) ?  1 :				\
      (delta[1] < 0) ? -1 :				\
      (delta[1] > 0) ?  1 : 0 )				\

#define	Macro6GetDifferentPoint(delta, pprev, pcur)	\
    while ( status = (iread < nvert) ) {		\
	pcur = pVert[iread++];				\
	delta[0] = pcur[0] - pprev[0];			\
	delta[1] = pcur[1] - pprev[1];			\
	if ( delta[0] || delta[1] ) break;		\
    }							\

#define	Macro6Cross(p, q) p[0] * q[1] - p[1] * q[0];

#define Macro6CheckTriple 					\
    if ( (thisDir = Macro6Compare(dcur)) == -curDir ) 		\
          ++dirChanges; 					\
    curDir = thisDir; 						\
    cross = Macro6Cross(dprev, dcur);				\
    if ( cross > epsilon ) { if ( angleSign == -1 ) return ReturnNonConvex; \
		       degenerate = 0;				\
		       angleSign = 1;				\
		     }						\
    else if ( cross < -epsilon ) { if (angleSign == 1) return ReturnNonConvex;\
		            degenerate = 0;			\
		            angleSign = -1;			\
	                  }					\
    pSecond = pThird;		/* remember ptr to current point */	\
    dprev[0] = dcur[0];		/* remember current delta */	\
    dprev[1] = dcur[1];						\

isConvexSchorn6( nvert, pVert )
int     nvert;
Number  pVert[][2];
/* determine polygon type. return one of: ReturnDegenerateNonConvex,
 *	ReturnDegenerateConvex, ReturnNonConvex, or ReturnConvex
 */
{
    int	     curDir, thisDir, dirChanges = 0, 
             angleSign = 0, degenerate = 1, status, iread = 1;
    Number   *pSecond, *pThird, *pSaveSecond, dprev[2], dcur[2], cross;

    /* if ( nvert <= 0 ) return error;       if you care */
    /* if ( nvert < 3 ) return ReturnConvex; this only slows down other cases */

    Macro6GetDifferentPoint( dprev, pVert[0], pSecond);
    if ( !status ) return ReturnConvex;	/* ret if < 3 diff points */
    pSaveSecond = pSecond;

    curDir = Macro6Compare(dprev);
    
    while ( 1 ) {
        Macro6GetDifferentPoint(dcur, pSecond, pThird);
	if ( !status ) break;
        Macro6CheckTriple;
    }

    pThird = pVert[0];
    dcur[0] = pThird[0] - pSecond[0];
    dcur[1] = pThird[1] - pSecond[1];
    if ( Macro6Compare(dcur) ) {
        Macro6CheckTriple;
    }

    dcur[0] = pSaveSecond[0] - pSecond[0];
    dcur[1] = pSaveSecond[1] - pSecond[1];
    Macro6CheckTriple;

    /* decide on polygon type given accumulated status */
    if ( degenerate ) {
	/* the polygon is composed of points and lines - no area */
        if ( dirChanges > 2 )
	    return ReturnDegenerateNonConvex;

	/* don't return yet, this may be a slowly arcing circle */
	dprev[0] = pVert[1][0] - pVert[0][0];
	dprev[1] = pVert[1][1] - pVert[0][1];
	for ( iread = 2;  iread < nvert;  iread++ ) {
	    dcur[0] = pVert[iread][0] - pVert[0][0];
	    dcur[1] = pVert[iread][1] - pVert[1][1];
	    cross = Macro6Cross(dprev, dcur);
	    if ( cross > 0 ) { if ( angleSign == -1 ) GIAssure( !cross );
			       degenerate = 0;
			       angleSign = 1;
			     }
	    else if ( cross < 0 ) { if ( angleSign == 1 ) GIAssure( !cross );
				    degenerate = 0;
				    angleSign = -1;
				  }
	}
	if ( !degenerate ) return ReturnConvex;	/* it's a circle */
	return ReturnDegenerateConvex;
    }

    if ( dirChanges > 2 )
	return ReturnNonConvex;
    return ReturnConvex;
}
