/* $Id: xmsupport.c,v 1.1 1992/11/07 07:59:12 mjl Exp $
 * $Log: xmsupport.c,v $
 * Revision 1.1  1992/11/07  07:59:12  mjl
 * Files for the Plplot Motif device driver.  The menus are still just barely
 * sketched out, and this doesn't currently offer any additional functionality
 * over the Xlib driver (but soon, soon..).
 *
*/

/*	xmsupport.c

	Miscellaneous support routines for PLPLOT OSF/Motif driver.
*/

/* Define dialog buttons. 
*
*  The Cancel and Help buttons are defined here for completeness.
*  Right now the Cancel button doesn't need any additional behavior
*  because the Exit Dialog unmaps itself whenever any button is
*  chosen.  Since there is no online help available (yet), the Help
*  button is not used. 
*
*   If you add additional dialogs, add similar button definitions. 
*/

#define DIALOG_Exit_OK       101
#define DIALOG_Exit_Cancel   102
#define DIALOG_Exit_Help     103

#include "xm.h"

/*----------------------------------------------------------------------*\
* DialogCB()
*
* Callback routine for reacting to button presses within dialogs.  
\*----------------------------------------------------------------------*/

void DialogCB (
     Widget	w,		/*  widget id		*/
     XtPointer	client_data,	/*  data from application   */
     XtPointer	call_data	/*  data from widget class  */
)
{
  Widget         button;

  int      i;

  switch ((int)client_data)
    {
    case DIALOG_Exit_OK:
      /* Prepare Xt to quit. */
      XtUnmapWidget(topLevel);
      XtDestroyApplicationContext(XtWidgetToApplicationContext(topLevel));

      /* Exit without error. */
      exit(0);
      break;
      
    default:
      /* A client_data was received for which 
	 there is no case setup to handle */
      printf ("Unknown client_data in DialogCB(): %d\n", client_data);
      break;
    }
  
}

/*----------------------------------------------------------------------*\
* CreateExitDialog()
*
* A convenience function for creating the Exit dialog.
\*----------------------------------------------------------------------*/

Widget  CreateExitDialog(Widget parent)
{

  Widget    dialog;
  XmString  title, message;

  /* Create the XmStrings needed for creating the dialog. */
  title = XmStringCreateSimple ("Plplot - Exit");
  message = XmStringCreateSimple ("Exit application?");

  /* Create the dialog widget. */
  ac = 0;
  XtSetArg(al[ac], XmNdialogTitle, title);  ac++;
  XtSetArg(al[ac], XmNmessageString, message);  ac++;
  XtSetArg(al[ac], XmNtransient, True);  ac++;
  XtSetArg(al[ac], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL);  ac++;
  XtSetArg(al[ac], XmNnoResize, True);  ac++;
  dialog = XmCreateQuestionDialog (parent, "exitDialog", al, ac);

  /* Remove the Help button (since there is no help available). */
  XtUnmanageChild (XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));

  /* Add the callback for the OK button. */
  XtAddCallback (dialog, XmNokCallback, DialogCB, (XtPointer) DIALOG_Exit_OK);

  /* Free the memory used to create the original XmStrings. */
  XmStringFree (title);
  XmStringFree (message);

  /* Return the widget ID of the dialog. */
  return (dialog);

}
