/*
$Header: main.c,v 1.4 93/08/30 11:01:35 hmallat Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include "pixel.h"
#include "main.h"
#include "misc.h"
#include "tools1.h"
#include "file_access.h"
#include "draw.h"
#include "block.h"

int rnd_seed, depth = 0;
int force_gray = FALSE;
char *visual = NULL;

/* FUNCTION:       void main(int argc, char *argv[])
   DESCRIPTION:    Initialize routines and start X main loop
   PARAMETERS:
   argc            arg count
   *argv[]         command line arguments
   RETURNS:        nothing

   Written by Hannu Mallat, last modifications 28th August 1993.
*/   
void main(int argc, char *argv[])
{
  struct timeval tv;

  gettimeofday(&tv, NULL);
  set_rnd_seed(tv.tv_sec^tv.tv_usec);
  parse_args(argc, argv);
  find_entries();
  create_brush(POINT_B, 1);
  init_phoenix(&argc, argv);
}

#define REQ_ARG(s) \
  fprintf(stderr, "phoenix: Option %s requires an argument\n", s); err = 1;

/* FUNCTION:       parse_args(int argc, char *argv[])
   DESCRIPTION:    Parse command line arguments and do neccessary settings.
   PARAMETERS:
   argc            arg count
   *argv[]         argument strings
   RETURNS:        nothing

   Written by Hannu Mallat, last modifications 25th August 1993.
*/   
void parse_args(int argc, char *argv[])
{
  extern char *visual;
  extern int depth, force_gray;
  int c = 1, err = 0;

  while(c<argc)
    {
      if(!strcmp(argv[c], "-depth"))
	{
	  if(++c<argc && argv[c][0] != '-')
	    depth = atoi(argv[c++]);
	  else
	    {
	      REQ_ARG(argv[c-1]);
	    }
	}
      else if(!strcmp(argv[c], "-forcegray"))
	{
	  force_gray = TRUE;
	  c++;
	}
      else if(!strcmp(argv[c], "-iconic"))
	c++;
      else if(!strcmp(argv[c], "-display"))
	{
	  if(++c<argc && argv[c][0] != '-')
	    c++;
	  else
	    {
	      REQ_ARG(argv[c-1]);
	    }
	}
      else if(!strcmp(argv[c], "-xrm"))
	{
	  if(++c<argc && argv[c][0] != '-')
	    c++;
	  else
	    {
	      REQ_ARG(argv[c-1]);
	    }
	}
      else if(!strcmp(argv[c], "-name"))
	{
	  if(++c<argc && argv[c][0] != '-')
	    c++;
	  else
	    {
	      REQ_ARG(argv[c-1]);
	    }
	}
      else if(!strcmp(argv[c], "-bg") || !strcmp(argv[c], "-background"))
	{
	  if(++c<argc && argv[c][0] != '-')
	    c++;
	  else
	    {
	      REQ_ARG(argv[c-1]);
	    }
	}
      else if(!strcmp(argv[c], "-bd") || !strcmp(argv[c], "-bordercolor"))
	{
	  if(++c<argc && argv[c][0] != '-')
	    c++;
	  else
	    {
	      REQ_ARG(argv[c-1]);
	    }
	}
      else if(!strcmp(argv[c], "-fg") || !strcmp(argv[c], "-foreground"))
	{
	  if(++c<argc && argv[c][0] != '-')
	    c++;
	  else
	    {
	      REQ_ARG(argv[c-1]);
	    }
	}
      else if(!strcmp(argv[c], "-visual"))
	{
	  if(++c<argc && argv[c][0] != '-')
	    {
	      visual = malloc((strlen(argv[c])+1)*sizeof(char));
	      if(visual != NULL)
		strcpy(visual, argv[c++]);
	    }
	  else
	    {
	      REQ_ARG(argv[c-1]);
	    }
	}
      else
	{
	  fprintf(stderr, "phoenix: Unrecognized option %s\n", argv[c]);
	  err = 1;
	  break;
	}
    }
  if(err)
    {
      fprintf(stderr, "\
Usage: phoenix [-bg | backround color] [-bd | bordercolor color] [-depth n ]\n\
               [-display displayname] [-fg | foreground color] [-forcegray]\n\
               [-iconic] [-name name] [-visual visualclass]\n\
               [-xrm resourcestring]\n");
      exit(2);
    }
}
