/*
 dialog.c: Dialog creating functions. create_dialogs calls all the other
           functions in this file.

 $Header: dialog.c,v 2.14 93/09/03 14:46:12 wet Exp $
 */
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/DrawingA.h>
#include <Xm/LabelG.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/ArrowBG.h>
#include <Xm/Text.h>
#include <Xm/Scale.h>
#include <Xm/SeparatoG.h>
#include <stdio.h>
#include "list.h"
#include "window.h"
#include "dialog.h"
#include "dialogw.h"
#include "callb.h"
#include "X_misc.h"
#include "bitmaps/help_about.xbm"


/* FUNCTION:       create_dialogs(Widget parent)
   DESCRIPTION:    Creates all dialogs.
   PARAMETERS:
   Widget parent   Parent widget for the dialogs.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void create_dialogs(Widget parent)
{
  XFontStruct *dialog_font;
  XmFontList dialog_fontlist;
  Display *disp;
  disp = XtDisplay(parent);
  dialog_font = XLoadQueryFont(disp, "-b&h-lucida-bold-r-normal-sans-14-100-100-100-p-80-iso8859-1");
  dialog_fontlist = XmFontListCreate(dialog_font, "dialog_chset");

  create_file_new_dialog(parent, dialog_fontlist);
  create_file_open_dialog(parent, dialog_fontlist);
  create_file_saveas_dialog(parent, dialog_fontlist);

  create_edit_pastetool_dialog(parent, dialog_fontlist);

  create_image_brighten_dialog(parent, dialog_fontlist);
  create_image_darken_dialog(parent, dialog_fontlist);
  create_image_matrix_dialog(parent, dialog_fontlist);
  create_image_RGB_adjust_dialog(parent, dialog_fontlist);
  create_image_HSV_adjust_dialog(parent, dialog_fontlist);
  create_image_addnoise_dialog(parent, dialog_fontlist);
  create_image_resize_dialog(parent, dialog_fontlist);
  create_image_rotate_dialog(parent, dialog_fontlist);
  create_image_addview_dialog(parent, dialog_fontlist);
  create_image_zoom_dialog(parent, dialog_fontlist);

  create_color_select_dialog(parent, dialog_fontlist);

  create_options_brush_dialog(parent, dialog_fontlist);
  create_options_airbrush_dialog(parent, dialog_fontlist);
  create_options_fill_dialog(parent, dialog_fontlist);
  create_options_hotspot_dialog(parent, dialog_fontlist);
  create_options_range_dialog(parent, dialog_fontlist);
  create_options_display_dialog(parent, dialog_fontlist);
  create_options_copy_dialog(parent, dialog_fontlist);

  create_help_about_dialog(parent, dialog_fontlist);

  create_error_dialog(parent);
  create_question_dialog(parent);
  create_question3_dialog(parent);
}


/* FUNCTION:       create_file_new_dialog(Widget parent,
                                          XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the File/New... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 15th July 1993.
*/   
void create_file_new_dialog(Widget parent, XmFontList dialog_fontlist)
{
  char *labels[] = {"Width", "Height", "Name"};
  char *editors[] = {"width", "height", "name"};
  Widget title, buttons, input, label[3];
  Arg wargs[15];
  Cardinal n;

  new_times = 0;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 260); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  fi_new_dialog = XmCreateFormDialog(parent, "New...", wargs, n);

  title = create_title(fi_new_dialog, "New Picture", dialog_fontlist);
  buttons = create_buttons(fi_new_dialog, "OK", "Cancel",
			   new_dialog_callback);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, fi_new_dialog,
				wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 35); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
  XtSetArg(wargs[n], XmNrightPosition, 45); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
  XtSetArg(wargs[n], XmNleftPosition, 10); n++;
  new_edit[WIDTH] = XtCreateWidget(editors[WIDTH], xmTextWidgetClass, input,
			       wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 35); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
  XtSetArg(wargs[n], XmNrightPosition, 90); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
  XtSetArg(wargs[n], XmNleftPosition, 55); n++;
  new_edit[HEIGHT] = XtCreateWidget(editors[HEIGHT], xmTextWidgetClass, input,
				    wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 95); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
  XtSetArg(wargs[n], XmNrightPosition, 90); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
  XtSetArg(wargs[n], XmNleftPosition, 10); n++;
  new_edit[NAME] = XtCreateWidget(editors[NAME], xmTextWidgetClass, input,
				  wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, new_edit[WIDTH]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, new_edit[WIDTH]); n++;
  label[WIDTH] = XtCreateWidget(labels[0],xmLabelGadgetClass, input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, new_edit[HEIGHT]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, new_edit[HEIGHT]); n++;
  label[HEIGHT] = XtCreateWidget(labels[1],xmLabelGadgetClass, input, wargs,
				 n);
  
  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, new_edit[NAME]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, new_edit[NAME]); n++;
  label[NAME] = XtCreateWidget(labels[2],xmLabelGadgetClass, input, wargs, n);

  XtManageChildren(new_edit, XtNumber(editors));
  XtManageChildren(label, XtNumber(labels));
}



/* FUNCTION:       create_file_open_dialog(Widget parent,
                                           XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the File/Open... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.
   
   Written by Vesa T|rm{nen, last modifications 14th July 1993.
*/   
void create_file_open_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, file_open_selector;
  
  n = 0;
  XtSetArg(wargs[n], XmNheight, 430); n++;
  XtSetArg(wargs[n], XmNwidth, 280); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  fi_open_dialog = XmCreateFormDialog(parent, "Open...", wargs, n);

  title = create_title(fi_open_dialog, "Open file", dialog_fontlist);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  file_open_selector = XtCreateManagedWidget("Open_Selector",
					     xmFileSelectionBoxWidgetClass,
					     fi_open_dialog,
					     wargs, n);
  XtAddCallback(file_open_selector, XmNokCallback,
		(XtCallbackProc)open_dialog_callback, (caddr_t)B_OK);
  XtAddCallback(file_open_selector, XmNcancelCallback,
 (XtCallbackProc)open_dialog_callback, (caddr_t)B_CANCEL);

  XtUnmanageChild(XmFileSelectionBoxGetChild(file_open_selector, 
					     XmDIALOG_HELP_BUTTON));
}


/* FUNCTION:       create_file_saveas_dialog(Widget parent,
                                             XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the File/Save as... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 15th July 1993.
*/   
void create_file_saveas_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, file_saveas_selector;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 430); n++;
  XtSetArg(wargs[n], XmNwidth, 280); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  fi_saveas_dialog = XmCreateFormDialog(parent, "Save_as...", wargs, n);

  title = create_title(fi_saveas_dialog, "Save file", dialog_fontlist);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  file_saveas_selector = XtCreateManagedWidget("Saveas_Selector",
					       xmFileSelectionBoxWidgetClass,
					       fi_saveas_dialog,
					       wargs, n);
  XtAddCallback(file_saveas_selector, XmNokCallback,
		(XtCallbackProc)saveas_dialog_callback, (caddr_t)B_OK);
  XtAddCallback(file_saveas_selector, XmNcancelCallback,
 (XtCallbackProc)saveas_dialog_callback, (caddr_t)B_CANCEL);

  XtUnmanageChild(XmFileSelectionBoxGetChild(file_saveas_selector, 
					     XmDIALOG_HELP_BUTTON));
}



/* FUNCTION:       create_edit_pastetool_dialog(Widget parent, 
                                               XmFontListdialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Edit/Paste to toolbox... menu 
                   entry. The dialog is only mapped via request from the
		   main module.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void create_edit_pastetool_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Display *disp;
  Arg wargs[15];
  Cardinal n;
  int i;
  Widget title, buttons, input, frame, label, radiobox;
  char *labels[] = {"User #1", "User #2", "User #3"};

  n = 0;
  XtSetArg(wargs[n], XmNheight, 270); n++;
  XtSetArg(wargs[n], XmNwidth, 250); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  ed_ptool_dialog = XmCreateFormDialog(parent, "Paste_to_toolbox...",
					   wargs, n);

  title = create_title(ed_ptool_dialog, "Paste to toolbox",
		       dialog_fontlist);
  buttons = create_buttons(ed_ptool_dialog, "Paste", "Cancel",
			   pastetool_dialog_callback);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				ed_ptool_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  label = XtCreateManagedWidget("Which brush do you want replace ?",
				xmLabelGadgetClass, input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, label); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  radiobox = XmCreateRadioBox(input, "Radio", wargs, n);
  XtManageChild(radiobox);

  for (i = 0; i<3; i++)
    {
      ptool_btns[i] = XtCreateManagedWidget(labels[i],
					    xmToggleButtonGadgetClass,
					    radiobox, NULL, 0);
      XtAddCallback(ptool_btns[i], XmNarmCallback,
		    (XtCallbackProc)pastetool_dialog_callback,
		    (caddr_t)i);
    }

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, label); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 15); n++;
  frame = XtCreateManagedWidget("Frame", xmFrameWidgetClass, input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNwidth, BRUSH_MAX+1); n++;
  XtSetArg(wargs[n], XmNheight, BRUSH_MAX+1); n++;
  XtSetArg(wargs[n], XmNbackground, 0); n++;
  ptool_window = XtCreateManagedWidget("Brush_window", 
				       xmDrawingAreaWidgetClass, frame, wargs,
				       n);
  XtAddCallback(ptool_window, XmNexposeCallback,
		(XtCallbackProc)pastetool_dialog_callback,
		(caddr_t)EXPOSE);

  ptool_gc = XtGetGC(ptool_window, (XtGCMask)NULL, NULL);
  disp = XtDisplay(ptool_window);
  XSetForeground(disp, ptool_gc, WhitePixel(disp, DefaultScreen(disp)));
  XSetBackground(disp, ptool_gc, BlackPixel(disp, DefaultScreen(disp)));
} 


/* FUNCTION:       create_image_brighten_dialog(Widget parent,
                                                XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/Brighten... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 5th August 1993.
*/   
void create_image_brighten_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input;
  XmString label = XmStringCreateLtoR("Brighten-%", 
				      XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 290); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_brighten_dialog = XmCreateFormDialog(parent, "Brighten...", wargs, n);

  title = create_title(im_brighten_dialog, "Brighten", dialog_fontlist);
  buttons = create_buttons(im_brighten_dialog, "Brighten", "Cancel",
			   brighten_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_brighten_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 30); n++;
  XtSetArg(wargs[n], XmNmaximum, 100); n++;
  XtSetArg(wargs[n], XmNminimum, 1); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  brighten_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
					  wargs, n);
  XmStringFree(label);
}


/* FUNCTION:       create_image_darken_dialog(Widget parent,
                                                  XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/Darken... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 5th August 1993.
*/   
void create_image_darken_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input;
  XmString label = XmStringCreateLtoR("Darken-%", 
				      XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 290); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_darken_dialog = XmCreateFormDialog(parent, "Darken...", wargs, n);

  title = create_title(im_darken_dialog, "Darken", dialog_fontlist);
  buttons = create_buttons(im_darken_dialog, "Darken", "Cancel",
			   darken_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_darken_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 30); n++;
  XtSetArg(wargs[n], XmNmaximum, 100); n++;
  XtSetArg(wargs[n], XmNminimum, 1); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  darken_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
					  wargs, n);
  XmStringFree(label);
}

/* FUNCTION:       create_image_matrix_dialog(Widget parent,
                                                  XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/User matrix... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void create_image_matrix_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input, separ;
  int i, j;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 340); n++;
  XtSetArg(wargs[n], XmNwidth, 325); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_matrix_dialog = XmCreateFormDialog(parent, "User_Matrix...", wargs, n);

  title = create_title(im_matrix_dialog, "User matrix", dialog_fontlist);
  buttons = create_buttons(im_matrix_dialog, "Apply", "Cancel",
			   matrix_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_matrix_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 20); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 60); n++;
  XtSetArg(wargs[n], XmNcolumns, 4); n++;
  XtSetArg(wargs[n], XmNvalue, "0.0"); n++;
  user_matrix[0] = XmCreateText(input, "Text", wargs, n);

  for (j = 1; j<5; j++)
    {
      n = 0;
      XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(wargs[n], XmNtopWidget, user_matrix[0]); n++;
      XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
      XtSetArg(wargs[n], XmNleftWidget, user_matrix[j-1]); n++;
      XtSetArg(wargs[n], XmNleftOffset, 10); n++;
      XtSetArg(wargs[n], XmNcolumns, 4); n++;
      XtSetArg(wargs[n], XmNvalue, "0.0"); n++;
      user_matrix[j] = XmCreateText(input, "Text", wargs, n);
    }
  for (i = 1; i<5; i++)
    {
      n = 0;
      XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
      XtSetArg(wargs[n], XmNtopWidget, user_matrix[(i-1)*5]); n++;
      XtSetArg(wargs[n], XmNtopOffset, 10); n++;
      XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
      XtSetArg(wargs[n], XmNleftOffset, 60); n++;
      XtSetArg(wargs[n], XmNcolumns, 4); n++;
      XtSetArg(wargs[n], XmNvalue, "0.0"); n++;
      user_matrix[i*5] = XmCreateText(input, "Text", wargs, n);
      for (j = 1; j<5; j++)
	{
	  n = 0;
	  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
	  XtSetArg(wargs[n], XmNtopWidget, user_matrix[i*5]); n++;
	  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	  XtSetArg(wargs[n], XmNleftWidget, user_matrix[i*5+j-1]); n++;
	  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
	  XtSetArg(wargs[n], XmNcolumns, 4); n++;
	  XtSetArg(wargs[n], XmNvalue, "0.0"); n++;
	  user_matrix[i*5+j] = XmCreateText(input, "Text", wargs, n);
	}
    }
  XtSetArg(wargs[0], XmNvalue, "1.0"); n++;
  XtSetValues(user_matrix[12], wargs, 1);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, user_matrix[5]); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  XtSetArg(wargs[n], XmNcolumns, 4); n++;
  XtSetArg(wargs[n], XmNvalue, "1.0"); n++;
  num = XtCreateManagedWidget("Text", xmTextWidgetClass, input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, user_matrix[10]); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, num); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNrightWidget, num); n++;
  separ = XtCreateManagedWidget("Separator", xmSeparatorGadgetClass,
				input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, user_matrix[15]); n++;
  XtSetArg(wargs[n], XmNtopOffset, -15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  XtSetArg(wargs[n], XmNcolumns, 4); n++;
  XtSetArg(wargs[n], XmNvalue, "25.0"); n++;
  denom = XtCreateManagedWidget("Text", xmTextWidgetClass, input, wargs, n);

  XtManageChildren(user_matrix, XtNumber(user_matrix));
}


/* FUNCTION:       create_image_RGB_adjust_dialog(Widget parent,
                                                  XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/RGB_adjust... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void create_image_RGB_adjust_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input, arrow[12], m_label, o_label, c_label[3];
  Dimension height;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 260); n++;
  XtSetArg(wargs[n], XmNwidth, 230); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_RGB_adjust_dialog = XmCreateFormDialog(parent, "RGB_adjust...", wargs, n);

  title = create_title(im_RGB_adjust_dialog, "RGB adjust", dialog_fontlist);
  buttons = create_buttons(im_RGB_adjust_dialog, "Adjust", "Cancel",
			   RGB_adjust_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_RGB_adjust_dialog, wargs, n);


  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 70); n++;
  m_label = XtCreateManagedWidget("Multiplier", xmLabelGadgetClass, input,
				  wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, m_label); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  o_label = XtCreateManagedWidget("Offset", xmLabelGadgetClass, input,
				  wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, m_label); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
  c_label[R] = XtCreateManagedWidget("Red:", xmLabelGadgetClass, input,
				     wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, c_label[R]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, m_label); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  XtSetArg(wargs[n], XmNvalue, "1.000"); n++;
  mul[R] = XmCreateText(input, "Text", wargs, n);

  XtSetArg(wargs[0], XmNheight, &height);
  XtGetValues(mul[R], wargs, 1);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, mul[R]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, mul[R]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[0] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[0], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback, (caddr_t)R_MUL_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, mul[R]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, mul[R]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[1] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[1], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback,
		(caddr_t)R_MUL_DOWN);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, c_label[R]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, o_label); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  XtSetArg(wargs[n], XmNvalue, "0"); n++;
  offset[R] = XmCreateText(input, "Text", wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, offset[R]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, offset[R]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[2] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[2], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback, (caddr_t)R_OFF_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, offset[R]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, offset[R]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[3] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[3], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback,
		(caddr_t)R_OFF_DOWN);


  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, c_label[R]); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
  c_label[G] = XtCreateManagedWidget("Green:", xmLabelGadgetClass, input,
				     wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, c_label[G]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, m_label); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  XtSetArg(wargs[n], XmNvalue, "1.000"); n++;
  mul[G] = XmCreateText(input, "Text", wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, mul[G]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, mul[G]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[4] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[4], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback, (caddr_t)G_MUL_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, mul[G]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, mul[G]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[5] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[5], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback,
		(caddr_t)G_MUL_DOWN);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, c_label[G]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, o_label); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  XtSetArg(wargs[n], XmNvalue, "0"); n++;
  offset[G] = XmCreateText(input, "Text", wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, offset[G]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, offset[G]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[6] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[6], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback, (caddr_t)G_OFF_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, offset[G]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, offset[G]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[7] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[7], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback,
		(caddr_t)G_OFF_DOWN);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, c_label[G]); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
  c_label[B] = XtCreateManagedWidget("Blue:", xmLabelGadgetClass, input,
				     wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, c_label[B]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, m_label); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  XtSetArg(wargs[n], XmNvalue, "1.000"); n++;
  mul[B] = XmCreateText(input, "Text", wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, mul[B]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, mul[B]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[8] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[8], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback, (caddr_t)B_MUL_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, mul[B]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, mul[B]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[9] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[9], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback,
		(caddr_t)B_MUL_DOWN);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, c_label[B]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, o_label); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  XtSetArg(wargs[n], XmNvalue, "0"); n++;
  offset[B] = XmCreateText(input, "Text", wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, offset[B]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, offset[B]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[10] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[10], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback, (caddr_t)B_OFF_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, offset[B]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, offset[B]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[11] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[11], XmNarmCallback,
		(XtCallbackProc)RGB_adjust_dialog_callback,
		(caddr_t)B_OFF_DOWN);

  XtManageChildren(mul, XtNumber(mul));
  XtManageChildren(offset, XtNumber(offset));
}


/* FUNCTION:       create_image_HSV_adjust_dialog(Widget parent,
                                                  XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/HSV_adjust... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void create_image_HSV_adjust_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input;
  XmString slid_label;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 500); n++;
  XtSetArg(wargs[n], XmNwidth, 300); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_HSV_adjust_dialog = XmCreateFormDialog(parent, "HSV_adjust...", wargs, n);

  title = create_title(im_HSV_adjust_dialog, "HSV adjust", dialog_fontlist);
  buttons = create_buttons(im_HSV_adjust_dialog, "Adjust", "Cancel",
			   HSV_adjust_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_HSV_adjust_dialog, wargs, n);

  slid_label = XmStringCreateLtoR("H", XmSTRING_DEFAULT_CHARSET);
  
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  XtSetArg(wargs[n], XmNminimum, -35900); n++;
  XtSetArg(wargs[n], XmNmaximum, 35900); n++;
  XtSetArg(wargs[n], XmNdecimalPoints, 2); n++;
  XtSetArg(wargs[n], XmNvalue, 0); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, slid_label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  HSV_slides[H_S] = XtCreateManagedWidget("Scale", xmScaleWidgetClass,
					  input, wargs, n);

  slid_label = XmStringCreateLtoR("S", XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, HSV_slides[H_S]); n++;
  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
  XtSetArg(wargs[n], XmNminimum, -10000); n++;
  XtSetArg(wargs[n], XmNmaximum, 10000); n++;
  XtSetArg(wargs[n], XmNdecimalPoints, 4); n++;
  XtSetArg(wargs[n], XmNvalue, 0); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, slid_label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  HSV_slides[S_S] = XtCreateManagedWidget("Scale", xmScaleWidgetClass,
					  input, wargs, n);

  slid_label = XmStringCreateLtoR("V", XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, HSV_slides[S_S]); n++;
  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
  XtSetArg(wargs[n], XmNminimum, -10000); n++;
  XtSetArg(wargs[n], XmNmaximum, 10000); n++;
  XtSetArg(wargs[n], XmNvalue, 0); n++;
  XtSetArg(wargs[n], XmNdecimalPoints, 4); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, slid_label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  HSV_slides[V_S] = XtCreateManagedWidget("Scale", xmScaleWidgetClass,
					  input, wargs, n);

  XmStringFree(slid_label);
}




/* FUNCTION:       create_image_addnoise_dialog(Widget parent,
                                              XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/Add noise... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 10th August 1993.
*/   
void create_image_addnoise_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input;
  XmString label = XmStringCreateLtoR("Amount", 
				      XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 360); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_addnoise_dialog = XmCreateFormDialog(parent, "Add_noise...", wargs, n);

  title = create_title(im_addnoise_dialog, "Add noise", dialog_fontlist);
  buttons = create_buttons(im_addnoise_dialog, "Add", "Cancel",
			   addnoise_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_addnoise_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 30); n++;
  XtSetArg(wargs[n], XmNmaximum, 128); n++;
  XtSetArg(wargs[n], XmNminimum, 0); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  addnoise_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
					 wargs, n);
  XmStringFree(label);
}



/* FUNCTION:       create_image_resize_dialog(Widget parent,
                                              XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/Resize... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 7th August 1993.
*/   
void create_image_resize_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input, arrow[4], w_label, h_label;
  Dimension height;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 240); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_resize_dialog = XmCreateFormDialog(parent, "Resize...", wargs, n);

  title = create_title(im_resize_dialog, "Resize", dialog_fontlist);
  buttons = create_buttons(im_resize_dialog, "Resize", "Cancel",
			   resize_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_resize_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
  keep = XtCreateManagedWidget("Keep width/height ratio",
			       xmToggleButtonGadgetClass, input, wargs, n);
  XtAddCallback(keep, XmNvalueChangedCallback,
		(XtCallbackProc)resize_dialog_callback, (caddr_t)KEEP);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, keep); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 20); n++;
  w_label = XtCreateManagedWidget("Width: ", xmLabelGadgetClass, input,
				  wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, keep); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, w_label); n++;
  XtSetArg(wargs[n], XmNleftOffset, 5); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  size[WIDTH] = XtCreateManagedWidget("Text", xmTextWidgetClass, input,
				  wargs, n);
  XtAddCallback(size[WIDTH], XmNvalueChangedCallback,
		(XtCallbackProc)resize_dialog_callback, (caddr_t)WIDTH);

  XtSetArg(wargs[0], XmNheight, &height);
  XtGetValues(size[WIDTH], wargs, 1);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, size[WIDTH]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, size[WIDTH]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[0] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[0], XmNarmCallback,
		(XtCallbackProc)resize_dialog_callback, (caddr_t)W_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, size[WIDTH]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, size[WIDTH]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[1] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[1], XmNarmCallback,
		(XtCallbackProc)resize_dialog_callback, (caddr_t)W_DOWN);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, w_label); n++;
  XtSetArg(wargs[n], XmNtopOffset, 20); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 20); n++;
  h_label = XtCreateManagedWidget("Height: ", xmLabelGadgetClass, input,
				  wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, w_label); n++;
  XtSetArg(wargs[n], XmNtopOffset, 20); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, w_label); n++;
  XtSetArg(wargs[n], XmNleftOffset, 5); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  size[HEIGHT] = XtCreateManagedWidget("Text", xmTextWidgetClass, input,
				  wargs, n);
  XtAddCallback(size[HEIGHT], XmNvalueChangedCallback,
		(XtCallbackProc)resize_dialog_callback, (caddr_t)HEIGHT);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, size[HEIGHT]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, size[HEIGHT]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[2] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[2], XmNarmCallback,
		(XtCallbackProc)resize_dialog_callback, (caddr_t)H_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, size[HEIGHT]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, size[HEIGHT]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[3] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[3], XmNarmCallback,
		(XtCallbackProc)resize_dialog_callback, (caddr_t)H_DOWN);

  XtManageChildren(arrow, XtNumber(arrow));
}



/* FUNCTION:       create_image_rotate_dialog(Widget parent,
                                              XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/Rotate... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 7th August 1993.
*/   
void create_image_rotate_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input, radiobox, arrow[2], toggle[2];
  Dimension height;
  char *labels[] = { "Clockwise", "Counterclockwise" };
  int i;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 230); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_rotate_dialog = XmCreateFormDialog(parent, "Rotate...", wargs, n);

  title = create_title(im_rotate_dialog, "Rotate", dialog_fontlist);
  buttons = create_buttons(im_rotate_dialog, "Rotate", "Cancel",
			   rotate_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_rotate_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  radiobox = XmCreateRadioBox(input, "Radio", wargs, n);
  XtManageChild(radiobox);

  for (i = 0; i<2; i++)
    {
      toggle[i] = XtCreateManagedWidget(labels[i],
					xmToggleButtonGadgetClass,
					radiobox, NULL, 0);
      XtAddCallback(toggle[i], XmNarmCallback,
		    (XtCallbackProc)rotate_dialog_callback, (caddr_t)(i+2));
    }
  dir = CW;
  XtSetArg(wargs[0], XmNset, TRUE); n++;
  XtSetValues(toggle[0], wargs, 1);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, radiobox); n++;
  XtSetArg(wargs[n], XmNtopOffset, 10); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 35); n++;
  XtSetArg(wargs[n], XmNcolumns, 6); n++;
  XtSetArg(wargs[n], XmNvalue, "0.00"); n++;
  angle = XtCreateManagedWidget("Text", xmTextWidgetClass, input,
				  wargs, n);
  XtSetArg(wargs[0], XmNheight, &height);
  XtGetValues(angle, wargs, 1);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, angle); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, angle); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[0] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[0], XmNarmCallback,
		(XtCallbackProc)rotate_dialog_callback, (caddr_t)ANGLE_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, angle); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, angle); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[1] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, input,
				   wargs, n);
  XtAddCallback(arrow[1], XmNarmCallback,
		(XtCallbackProc)rotate_dialog_callback, (caddr_t)ANGLE_DOWN);

  XtManageChildren(arrow, XtNumber(arrow));
}


/* FUNCTION:       create_image_addview_dialog(Widget parent,
                                              XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/Add view... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 19th July 1993.
*/   
void create_image_addview_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input;
  XmString label = XmStringCreateLtoR("Zoom factor", 
				      XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 290); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_addview_dialog = XmCreateFormDialog(parent, "Add_view...", wargs, n);

  title = create_title(im_addview_dialog, "Add view", dialog_fontlist);
  buttons = create_buttons(im_addview_dialog, "Add view", "Cancel",
			   addview_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_addview_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 30); n++;
  XtSetArg(wargs[n], XmNmaximum, 50); n++;
  XtSetArg(wargs[n], XmNminimum, 1); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  addview_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
					 wargs, n);
  XmStringFree(label);
}



/* FUNCTION:       create_image_zoom_dialog(Widget parent,
                                            XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Image/Zoom... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 20th July 1993.
*/   
void create_image_zoom_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input;
  XmString label = XmStringCreateLtoR("Zoom factor", 
				      XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 290); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  im_zoom_dialog = XmCreateFormDialog(parent, "Zoom...", wargs, n);

  title = create_title(im_zoom_dialog, "Zoom", dialog_fontlist);
  buttons = create_buttons(im_zoom_dialog, "Zoom", "Cancel",
			   zoom_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				im_zoom_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 30); n++;
  XtSetArg(wargs[n], XmNmaximum, 50); n++;
  XtSetArg(wargs[n], XmNminimum, 1); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  zoom_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
				      wargs, n);
  XmStringFree(label);
}



/* FUNCTION:       create_color_select_dialog(Widget parent,
                                              XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Color/Select... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void create_color_select_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input, radiobox; /* label[2], frame[2]; */
  int i;
  char *labels[] = {"Primary color", "Secondary color"};
  char *slid_labels[] = {"R", "G", "B", "H", "S", "V"};
  int slid_max[] = {255, 255, 255, 36000, 10000, 10000};
  int slid_offset[] = {15, 0, 0, 10, 0, 0};
  int slid_dec[] = {0, 0, 0, 2, 4, 4};
  XmString slid_label;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 500); n++;
  XtSetArg(wargs[n], XmNwidth, 405); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage,FALSE); n++;
  co_select_dialog = XmCreateFormDialog(parent,"Color_select", wargs, n);

  title = create_title(co_select_dialog, "Select color", dialog_fontlist);
  buttons = create_buttons(co_select_dialog, "Select", "Cancel",
			   select_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				co_select_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  radiobox = XmCreateRadioBox(input, "Radio", wargs, n);
  XtManageChild(radiobox);

  for (i = 0; i<2; i++)
    {
      col_btn[i] = XtCreateManagedWidget(labels[i],
					      xmToggleButtonGadgetClass,
					      radiobox, NULL, 0);
      XtAddCallback(col_btn[i], XmNarmCallback,
		    (XtCallbackProc)select_dialog_callback, (caddr_t)(i+10));
    }

  XtSetArg(wargs[0], XmNset, TRUE); n++;
  XtSetValues(col_btn[PRIM], wargs, 1);

/*
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 15); n++;
  frame[SEC] = XtCreateManagedWidget("Frame", xmFrameWidgetClass, input, 
				     wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNwidth, 100); n++;
  XtSetArg(wargs[n], XmNheight, 50); n++;
  col_ind[SEC] = XtCreateManagedWidget("Secondary", xmDrawingAreaWidgetClass,
				       frame[SEC], wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNrightWidget, frame[SEC]); n++;
  XtSetArg(wargs[n], XmNrightOffset, 0); n++;
  label[SEC] = XtCreateManagedWidget("2:", xmLabelGadgetClass, input, 
				      wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNrightWidget, label[SEC]); n++;
  XtSetArg(wargs[n], XmNrightOffset, 0); n++;
  frame[PRIM] = XtCreateManagedWidget("Frame", xmFrameWidgetClass, input, 
				     wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNwidth, 100); n++;
  XtSetArg(wargs[n], XmNheight, 50); n++;
  col_ind[PRIM] = XtCreateManagedWidget("Primary", xmDrawingAreaWidgetClass,
					frame[PRIM], wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNrightWidget, frame[PRIM]); n++;
  XtSetArg(wargs[n], XmNrightOffset, 0); n++;
  label[PRIM] = XtCreateManagedWidget("1:", xmLabelGadgetClass, input, 
                                      wargs, n);
*/
  for (i = 0; i<6; i++)
    {
      slid_label = XmStringCreateLtoR(slid_labels[i], 
				      XmSTRING_DEFAULT_CHARSET);
      n = 0;
      XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
      XtSetArg(wargs[n], XmNtopWidget, radiobox); n++;
      XtSetArg(wargs[n], XmNtopOffset, 15); n++;
      XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
      XtSetArg(wargs[n], XmNbottomOffset, 15); n++;
      if (i==0)
	{
	  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	}
      else
	{
	  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	  XtSetArg(wargs[n], XmNleftWidget, color_slides[i-1]); n++;
	}
      XtSetArg(wargs[n], XmNleftOffset, slid_offset[i]); n++;
      XtSetArg(wargs[n], XmNminimum, 0); n++;
      XtSetArg(wargs[n], XmNmaximum, slid_max[i]); n++;
      XtSetArg(wargs[n], XmNdecimalPoints, slid_dec[i]); n++;
      XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
      XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
      XtSetArg(wargs[n], XmNtitleString, slid_label); n++;
      XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
      color_slides[i] = XtCreateManagedWidget("Scale", xmScaleWidgetClass,
					       input, wargs, n);
      XtAddCallback(color_slides[i], XmNdragCallback,
		    (XtCallbackProc)select_dialog_callback, (caddr_t)i);
      XtAddCallback(color_slides[i], XmNvalueChangedCallback,
		    (XtCallbackProc)select_dialog_callback, (caddr_t)i);
      XmStringFree(slid_label);
    }
}


/* FUNCTION:       create_options_brush_dialog(Widget parent, 
                                               XmFontListdialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Options/Brush options... menu 
                   entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void create_options_brush_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Display *disp;
  Arg wargs[15];
  Cardinal n;
  int i;
  Widget title, buttons, input, frame, radiobox, radiobuttons[NO_BRUSHES];
  XmString label = XmStringCreateLtoR("Brush size", 
				      XmSTRING_DEFAULT_CHARSET);
  char *labels[] = {"Point", "Circle", "Square", "H-line", "V-line",
		      "D-line up", "D-line down", "User #1", "User #2",
		      "User #3"};

  brush_times = 0;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 405); n++;
  XtSetArg(wargs[n], XmNwidth, 250); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  op_brush_dialog = XmCreateFormDialog(parent, "Brush_options...", wargs, n);

  title = create_title(op_brush_dialog, "Brush options", dialog_fontlist);
  buttons = create_buttons(op_brush_dialog, "Select", "Cancel",
			   brush_dialog_callback);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				op_brush_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  radiobox = XmCreateRadioBox(input, "Radio", wargs, n);
  XtManageChild(radiobox);

  for (i = 0; i<NO_BRUSHES; i++)
    {
      radiobuttons[i] = XtCreateManagedWidget(labels[i],
					      xmToggleButtonGadgetClass,
					      radiobox, NULL, 0);
      XtAddCallback(radiobuttons[i], XmNarmCallback,
		    (XtCallbackProc)brush_dialog_callback, (caddr_t)(i+1));
    }

  XtSetArg(wargs[0], XmNset, TRUE); n++;
  XtSetValues(radiobuttons[0], wargs, 1);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 15); n++;
  frame = XtCreateManagedWidget("Frame", xmFrameWidgetClass, input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNwidth, BRUSH_MAX+1); n++;
  XtSetArg(wargs[n], XmNheight, BRUSH_MAX+1); n++;
  XtSetArg(wargs[n], XmNbackground, 0); n++;
  brush_window = XtCreateManagedWidget("Brush_window", 
				       xmDrawingAreaWidgetClass, frame, wargs,
				       n);
  XtAddCallback(brush_window, XmNexposeCallback,
		(XtCallbackProc)brush_dialog_callback, (caddr_t)EXPOSE);

  brush_gc = XtGetGC(brush_window, (XtGCMask)NULL, NULL);
  disp = XtDisplay(brush_window);
  XSetForeground(disp, brush_gc, WhitePixel(disp, DefaultScreen(disp)));
  XSetBackground(disp, brush_gc, BlackPixel(disp, DefaultScreen(disp)));

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, frame); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 15); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 15); n++;
  XtSetArg(wargs[n], XmNmaximum, BRUSH_MAX); n++;
  XtSetArg(wargs[n], XmNminimum, 1); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  brush_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
				      wargs, n);
  XtAddCallback(brush_slider, XmNdragCallback,
		(XtCallbackProc)brush_dialog_callback, (caddr_t)SLIDER);
  XtAddCallback(brush_slider, XmNvalueChangedCallback,
		(XtCallbackProc)brush_dialog_callback, (caddr_t)SLIDER);
  XmStringFree(label);
} 



/* FUNCTION:       create_options_airbrush_dialog(Widget parent, 
                                                  XmFontListdialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Options/Airrush options... menu 
                   entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void create_options_airbrush_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input;
  XmString size = XmStringCreateLtoR("Size", 
				     XmSTRING_DEFAULT_CHARSET); 
  XmString flow = XmStringCreateLtoR("Flow", 
				     XmSTRING_DEFAULT_CHARSET);
  n = 0;
  XtSetArg(wargs[n], XmNheight, 260); n++;
  XtSetArg(wargs[n], XmNwidth, 180); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  op_airbrush_dialog = XmCreateFormDialog(parent, "Airbrush_options...", 
					  wargs, n);

  title = create_title(op_airbrush_dialog, "Airbrush options",
		       dialog_fontlist);
  buttons = create_buttons(op_airbrush_dialog, "Set", "Cancel",
			   airbrush_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				op_airbrush_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 15); n++;
  XtSetArg(wargs[n], XmNmaximum, 100); n++;
  XtSetArg(wargs[n], XmNminimum, 1); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, flow); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  airbrush_slider[FLOW] = XtCreateManagedWidget("Scale", xmScaleWidgetClass, 
						input, wargs, n);
  
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNrightWidget, airbrush_slider[FLOW]); n++;
  XtSetArg(wargs[n], XmNrightOffset, 15); n++;
  XtSetArg(wargs[n], XmNmaximum, 100); n++;
  XtSetArg(wargs[n], XmNminimum, 1); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, size); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  airbrush_slider[SIZE] = XtCreateManagedWidget("Scale", xmScaleWidgetClass, 
						input, wargs, n);
  XmStringFree(size);
  XmStringFree(flow);
}



/* FUNCTION:       create_options_fill_dialog(Widget parent, 
                                               XmFontListdialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Options/Fill options... menu 
                   entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void create_options_fill_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Display *disp;
  Arg wargs[15];
  Cardinal n;
  int i;
  Widget title, buttons, input, frame, radiobox, radiobuttons[NO_BRUSHES];
  XmString label;
  char *labels[] = {"Solid", "Circles", "Squares", "H-lines", "V-lines",
		      "D-lines up", "D-lines down", "User #1", "User #2",
		      "User #3"};

  fill_times = 0;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 405); n++;
  XtSetArg(wargs[n], XmNwidth, 300); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  op_fill_dialog = XmCreateFormDialog(parent, "Fill_options...", wargs, n);

  title = create_title(op_fill_dialog, "Fill options", dialog_fontlist);
  buttons = create_buttons(op_fill_dialog, "Select", "Cancel",
			   fill_dialog_callback);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				op_fill_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  radiobox = XmCreateRadioBox(input, "Radio", wargs, n);
  XtManageChild(radiobox);

  for (i = 0; i<NO_BRUSHES; i++)
    {
      radiobuttons[i] = XtCreateManagedWidget(labels[i],
					      xmToggleButtonGadgetClass,
					      radiobox, NULL, 0);
      XtAddCallback(radiobuttons[i], XmNarmCallback,
		    (XtCallbackProc)fill_dialog_callback, (caddr_t)(i+1));
    }

  XtSetArg(wargs[0], XmNset, TRUE); 
  XtSetValues(radiobuttons[0], wargs, 1);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 50); n++;
  frame = XtCreateManagedWidget("Frame", xmFrameWidgetClass, input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNwidth, BRUSH_MAX+1); n++;
  XtSetArg(wargs[n], XmNheight, BRUSH_MAX+1); n++;
  XtSetArg(wargs[n], XmNbackground, 0); n++;
  fill_window = XtCreateManagedWidget("Fill_window", 
				       xmDrawingAreaWidgetClass, frame, wargs,
				       n);
  XtAddCallback(fill_window, XmNexposeCallback,
		(XtCallbackProc)fill_dialog_callback, (caddr_t)EXPOSE);

  fill_gc = XtGetGC(fill_window, (XtGCMask)NULL, NULL);
  disp = XtDisplay(fill_window);
  XSetForeground(disp, fill_gc, WhitePixel(disp, DefaultScreen(disp)));
  XSetBackground(disp, fill_gc, BlackPixel(disp, DefaultScreen(disp)));

  label = XmStringCreateLtoR("Size", XmSTRING_DEFAULT_CHARSET);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, frame); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 15); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 15); n++;
  XtSetArg(wargs[n], XmNmaximum, BRUSH_MAX/2); n++;
  XtSetArg(wargs[n], XmNminimum, 1); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  fill_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
				      wargs, n);
  XtAddCallback(fill_slider, XmNdragCallback,
		(XtCallbackProc)fill_dialog_callback, (caddr_t)SLIDER);
  XtAddCallback(fill_slider, XmNvalueChangedCallback,
		(XtCallbackProc)fill_dialog_callback, (caddr_t)SLIDER);

  label = XmStringCreateLtoR("Tolerance", XmSTRING_DEFAULT_CHARSET);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, frame); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNrightWidget, fill_slider); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 15); n++;
  XtSetArg(wargs[n], XmNmaximum, 100); n++;
  XtSetArg(wargs[n], XmNminimum, 0); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  toler_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
				      wargs, n);
  XmStringFree(label);
} 



/* FUNCTION:       create_options_hotspot_dialog(Widget parent, 
                                               XmFontListdialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Options/Fill options... menu 
                   entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void create_options_hotspot_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  int i;
  Widget title, buttons, input, radiobox, radiobuttons[9];
  char *labels[] = {"Center", "Left", "Right", "Top", "Bottom",
		      "Top left", "Top right", "Bottom left",
		      "Bottom right"};

  hotspot_times = 0;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 280); n++;
  XtSetArg(wargs[n], XmNwidth, 220); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  op_hotspot_dialog = XmCreateFormDialog(parent, "Fill_options...", wargs, n);

  title = create_title(op_hotspot_dialog, "Set hot spot", dialog_fontlist);
  buttons = create_buttons(op_hotspot_dialog, "Set", "Cancel",
			   hotspot_dialog_callback);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				op_hotspot_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  XtSetArg(wargs[n], XmNnumColumns, 2); n++;
  radiobox = XmCreateRadioBox(input, "Radio", wargs, n);
  XtManageChild(radiobox);

  for (i = 0; i<9; i++)
    {
      radiobuttons[i] = XtCreateManagedWidget(labels[i],
					      xmToggleButtonGadgetClass,
					      radiobox, NULL, 0);
      XtAddCallback(radiobuttons[i], XmNarmCallback,
		    (XtCallbackProc)hotspot_dialog_callback, (caddr_t)(i+1));
    }

  XtSetArg(wargs[0], XmNset, TRUE);
  XtSetValues(radiobuttons[0], wargs, 1);
}



/* FUNCTION:       create_options_range_dialog(Widget parent,
                                            XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Options/Range... menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 20th July 1993.
*/   
void create_options_range_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input;
  XmString label = XmStringCreateLtoR("Range", 
				      XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 320); n++;
  XtSetArg(wargs[n], XmNwidth, 220); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  op_range_dialog = XmCreateFormDialog(parent, "Color_range_options...",
				       wargs, n);

  title = create_title(op_range_dialog, "Range selection options",
		       dialog_fontlist);
  buttons = create_buttons(op_range_dialog, "Set", "Cancel",
			   range_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				op_range_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 25); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 25); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 60); n++;
  XtSetArg(wargs[n], XmNmaximum, 128); n++;
  XtSetArg(wargs[n], XmNminimum, 0); n++;
  XtSetArg(wargs[n], XmROrientation, XmVERTICAL); n++;
  XtSetArg(wargs[n], XmRProcessingDirection, XmMAX_ON_TOP); n++;
  XtSetArg(wargs[n], XmNtitleString, label); n++;
  XtSetArg(wargs[n], XmNshowValue, TRUE); n++;
  range_slider = XtCreateManagedWidget("Scale", xmScaleWidgetClass, input,
				      wargs, n);
  XmStringFree(label);
}



/* FUNCTION:       create_options_display_dialog(Widget parent,
                                                 XmFontList dialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Options/Display options... 
                   menu entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 31st August 1993.
*/   
void create_options_display_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, input, arrow[4], x_label, y_label;
  Dimension height;

  n = 0;
  XtSetArg(wargs[n], XmNheight, 270); n++;
  XtSetArg(wargs[n], XmNwidth, 230); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  op_display_dialog = XmCreateFormDialog(parent, "Display_options...", 
					wargs, n);

  title = create_title(op_display_dialog, "Display options", dialog_fontlist);
  buttons = create_buttons(op_display_dialog, "Set", "Cancel",
			   display_dialog_callback);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				op_display_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 20); n++;
  show_grid = XtCreateManagedWidget("Show grid", xmToggleButtonGadgetClass, 
				    input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, show_grid); n++;
  XtSetArg(wargs[n], XmNtopOffset, 10); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 20); n++;
  snap_grid = XtCreateManagedWidget("Snap to grid", xmToggleButtonGadgetClass, 
				    input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, snap_grid); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
  x_label = XtCreateManagedWidget("Horizontal density:", 
				  xmLabelGadgetClass, input, wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, snap_grid); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, x_label); n++;
  XtSetArg(wargs[n], XmNleftOffset, 5); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  XtSetArg(wargs[n], XmNvalue, "10"); n++;
  grid_coords[G_X] = XtCreateManagedWidget("Text", xmTextWidgetClass, input,
				  wargs, n);
  XtSetArg(wargs[0], XmNheight, &height);
  XtGetValues(grid_coords[G_X], wargs, 1);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, grid_coords[G_X]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, grid_coords[G_X]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[G_X_UP] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, 
					input, wargs, n);
  XtAddCallback(arrow[G_X_UP], XmNarmCallback,
		(XtCallbackProc)display_dialog_callback, (caddr_t)G_X_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, grid_coords[G_X]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, grid_coords[G_X]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[G_X_DOWN] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, 
					  input, wargs, n);
  XtAddCallback(arrow[G_X_DOWN], XmNarmCallback,
		(XtCallbackProc)display_dialog_callback, (caddr_t)G_X_DOWN);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, x_label); n++;
  XtSetArg(wargs[n], XmNtopOffset, 20); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 10); n++;
  y_label = XtCreateManagedWidget("Vertical density:", xmLabelGadgetClass, 
				  input, wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, x_label); n++;
  XtSetArg(wargs[n], XmNtopOffset, 20); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, x_label); n++;
  XtSetArg(wargs[n], XmNleftOffset, 5); n++;
  XtSetArg(wargs[n], XmNcolumns, 5); n++;
  XtSetArg(wargs[n], XmNvalue, "10"); n++;
  grid_coords[G_Y] = XtCreateManagedWidget("Text", xmTextWidgetClass, input,
				  wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, grid_coords[G_Y]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, grid_coords[G_Y]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_UP); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[G_Y_UP] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, 
					input, wargs, n);
  XtAddCallback(arrow[G_Y_UP], XmNarmCallback,
		(XtCallbackProc)display_dialog_callback, (caddr_t)G_Y_UP);

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, grid_coords[G_Y]); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNleftWidget, grid_coords[G_Y]); n++;
  XtSetArg(wargs[n], XmNarrowDirection, XmARROW_DOWN); n++;
  XtSetArg(wargs[n], XmNwidth, height/2); n++;
  XtSetArg(wargs[n], XmNheight, height/2); n++;
  arrow[G_Y_DOWN] = XtCreateManagedWidget("Arrow", xmArrowButtonGadgetClass, 
					  input, wargs, n);
  XtAddCallback(arrow[G_Y_DOWN], XmNarmCallback,
		(XtCallbackProc)display_dialog_callback, (caddr_t)G_Y_DOWN);

  XtManageChildren(arrow, XtNumber(arrow));
}




/* FUNCTION:       create_options_copy_dialog(Widget parent, 
                                               XmFontListdialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Options/Fill options... menu 
                   entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void create_options_copy_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  int i;
  Widget title, buttons, input, label, column;
  char *labels[] = {"Red Channel", "#7", "#6", "#5", "#4", "#3", "#2", "#1",
		      "#0", "Green Channel", "#7", "#6", "#5", "#4", "#3",
		      "#2", "#1", "#0", "Blue Channel", "#7", "#6", "#5",
		      "#4", "#3", "#2", "#1", "#0"};

  n = 0;
  XtSetArg(wargs[n], XmNheight, 405); n++;
  XtSetArg(wargs[n], XmNwidth, 335); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  op_copy_dialog = XmCreateFormDialog(parent, "Copy_options...", wargs, n);

  title = create_title(op_copy_dialog, "Copy options", dialog_fontlist);
  buttons = create_buttons(op_copy_dialog, "Set", "Cancel",
			   copy_dialog_callback);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				op_copy_dialog, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 15); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  label = XtCreateManagedWidget("Select the color channels to be copied",
				xmLabelGadgetClass, input, wargs, n);

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, label); n++;
  XtSetArg(wargs[n], XmNtopOffset, 10); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 15); n++;
  XtSetArg(wargs[n], XmNnumColumns, 3); n++;
  XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
  column = XtCreateManagedWidget("RowColumn", xmRowColumnWidgetClass, input,
				 wargs, n);
  for (i = 0; i<NUM_CHANNELS; i++)
    {
      XtSetArg(wargs[0], XmNset, TRUE);
      channels[i] = XtCreateManagedWidget(labels[i],
					  xmToggleButtonGadgetClass,
					  column, wargs, 1);
      XtAddCallback(channels[i], XmNdisarmCallback,
		    (XtCallbackProc)copy_dialog_callback, (caddr_t)i);
    }
  r_set = g_set = b_set = True;
}


/* FUNCTION:       create_help_about_dialog(Widget parent, 
                                               XmFontListdialog_fontlist)
   DESCRIPTION:    Creates the dialog for the Help/About... menu 
                   entry.
   PARAMETERS:
   Widget parent              Parent Widget of the dialog.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 20th August 1993.
*/   
void create_help_about_dialog(Widget parent, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, buttons, separ, ok_button, input, draw;
  Pixmap bitmap;
  Display *disp = XtDisplay(parent);
  int scr = DefaultScreen(disp);
  Window root = DefaultRootWindow(disp);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 305); n++;
  XtSetArg(wargs[n], XmNwidth, 476); n++;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  he_about_dialog = XmCreateFormDialog(parent, "Help_about...", wargs, n);

  title = create_title(he_about_dialog, "Help about", dialog_fontlist);
  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  buttons = XtCreateManagedWidget("Buttons", xmFormWidgetClass,
				  he_about_dialog, wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  separ = XtCreateManagedWidget("Separator" ,xmSeparatorGadgetClass, 
				 buttons, wargs, n);
  
  n = 0;
  XtSetArg(wargs[n], XmNheight, 30); n++;
  XtSetArg(wargs[n], XmNwidth, 60); n++;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 20); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 10); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 208); n++;
  ok_button= XtCreateManagedWidget("OK",
				   xmPushButtonGadgetClass, 
				   buttons, wargs, n);
  XtAddCallback(ok_button, XmNactivateCallback,
                (XtCallbackProc)about_dialog_callback, (caddr_t)NULL);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNtopWidget, title); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(wargs[n], XmNbottomWidget, buttons); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  input = XtCreateManagedWidget("Input", xmFormWidgetClass, 
				he_about_dialog, wargs, n);
  
  bitmap = 
    XCreatePixmapFromBitmapData(disp, root, help_about_bits,
				help_about_width, help_about_height,
                                BlackPixel(disp, scr), WhitePixel(disp, scr),
				DefaultDepth(disp, scr));
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbackgroundPixmap, bitmap); n++;
  draw = XtCreateManagedWidget("Draw_Area", xmDrawingAreaWidgetClass, 
			       input, wargs, n);
}


/* FUNCTION:       create_error_dialog(Widget parent)
   DESCRIPTION:    Creates an error dialog.
   PARAMETERS:
   Widget parent   Parent widget of the dialog.
   RETURNS:        Nothing

   Written by Vesa T|rm{nen, last modifications 19th July 1993.
*/   
void create_error_dialog(Widget parent)
{
  Arg wargs[5];
  Cardinal n;

  n = 0;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  error_dialog = XmCreateErrorDialog(parent, "", wargs, n);

  XtAddCallback(error_dialog, XmNokCallback,
		(XtCallbackProc)error_dialog_callback, (caddr_t)B_OK);

  XtUnmanageChild(XmMessageBoxGetChild(error_dialog, 
					     XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(error_dialog, 
					     XmDIALOG_CANCEL_BUTTON));
}


/* FUNCTION:       create_question_dialog(Widget parent)
   DESCRIPTION:    Creates a question dialog.
   PARAMETERS:
   Widget parent   Parent widget of the dialog.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 19th July 1993.
*/   
void create_question_dialog(Widget parent)
{
  Arg wargs[5];
  Cardinal n;

  n = 0;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  question_dialog = XmCreateQuestionDialog(parent, "", wargs, n);

  XtAddCallback(question_dialog, XmNokCallback,
		(XtCallbackProc)question_dialog_callback, (caddr_t)B_OK);
  XtAddCallback(question_dialog, XmNcancelCallback,
		(XtCallbackProc)question_dialog_callback, (caddr_t)B_CANCEL);

  XtUnmanageChild(XmMessageBoxGetChild(question_dialog, 
					     XmDIALOG_HELP_BUTTON));
}


/* FUNCTION:       create_question3_dialog(Widget parent)
   DESCRIPTION:    Creates a question dialog with three buttons.
   PARAMETERS:
   Widget parent   Parent widget of the dialog.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4h August 1993.
*/   
void create_question3_dialog(Widget parent)
{
  Arg wargs[5];
  Cardinal n;

  n = 0;
  XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(wargs[n], XmNautoUnmanage, FALSE); n++;
  question3_dialog = XmCreateQuestionDialog(parent, "", wargs, n);

  XtAddCallback(question3_dialog, XmNokCallback,
		(XtCallbackProc)question3_dialog_callback, (caddr_t)B_OK);
  XtAddCallback(question3_dialog, XmNcancelCallback,
		(XtCallbackProc)question3_dialog_callback, (caddr_t)B_NO);
  XtAddCallback(question3_dialog, XmNhelpCallback,
		(XtCallbackProc)question3_dialog_callback, (caddr_t)B_CANCEL);
}


/* FUNCTION:       create_title(Widget parent, char *title_s,
                                XmFontList dialog_fontlist)
   DESCRIPTION:    Creates a title to the top of a FormDialog.
   PARAMETERS:
   Widget parent              Title area's parent form.
   XmString title_s           Title string.
   XmFontList dialog_fontlist Title fontlist.
   RETURNS:        Widget id of the created form.

   Written by Vesa T|rm{nen, last modifications 17th July 1993.
*/   
Widget create_title(Widget parent, char *title_s, XmFontList dialog_fontlist)
{
  Arg wargs[15];
  Cardinal n;
  Widget title, title_label, separ;
  XmString label_str = XmStringCreateLtoR(title_s, "dialog_chset");

  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  title = XtCreateManagedWidget("Title", xmFormWidgetClass, parent,
				wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 10); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 10); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
  XtSetArg(wargs[n], XmNleftPosition, 10); n++;
  XtSetArg(wargs[n], XmNlabelString, label_str); n++;
  XtSetArg(wargs[n], XmNfontList, dialog_fontlist); n++;      
  title_label = XtCreateManagedWidget("New picture" ,xmLabelGadgetClass, title,
				      wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  separ = XtCreateManagedWidget("Separator" ,xmSeparatorGadgetClass, 
				title, wargs, n);

  XmStringFree(label_str);
  return title;
}


/* FUNCTION:       create_buttons(Widget parent, char *ok_s, char*cancel_s,
                                  void (*callback)());
   DESCRIPTION:    Creates buttons to the bottom of a FormDialog.
   PARAMETERS:
   Widget parent   Title area's parent form widget.
   char *ok_s         Label string of the ok button.
   char *cancel_s     Label string of the cancel button.
   void (*callback)() Callback to be invoked.
   RETURNS:        Widget id of the created form.

   Written by Vesa T|rm{nen, last modifications 17th July 1993.
*/   
Widget create_buttons(Widget parent, char *ok_s, char*cancel_s, 
		      void (*callback)())
{
  Arg wargs[15];
  Cardinal n;
  Widget buttons, separ, ok_button, cancel_button;

  n = 0;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  buttons = XtCreateManagedWidget("Buttons", xmFormWidgetClass,
				  parent, wargs, n);
  n = 0;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  separ = XtCreateManagedWidget("Separator" ,xmSeparatorGadgetClass, 
				 buttons, wargs, n);
  
  n = 0;
  XtSetArg(wargs[n], XmNheight, 30); n++;
  XtSetArg(wargs[n], XmNwidth, 60); n++;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 20); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 10); n++;
  XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNleftOffset, 20); n++;
  ok_button= XtCreateManagedWidget(ok_s,
				   xmPushButtonGadgetClass, 
				   buttons, wargs, n);
  XtAddCallback(ok_button, XmNactivateCallback,
                (XtCallbackProc)callback, (caddr_t)B_OK);

  n = 0;
  XtSetArg(wargs[n], XmNheight, 30); n++;
  XtSetArg(wargs[n], XmNwidth, 60); n++;
  XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNtopOffset, 20); n++;
  XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNbottomOffset, 10); n++;
  XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(wargs[n], XmNrightOffset, 20); n++;
  cancel_button= XtCreateManagedWidget(cancel_s,
				       xmPushButtonGadgetClass, 
				       buttons, wargs, n);
  XtAddCallback(cancel_button, XmNactivateCallback,
                (XtCallbackProc)callback, (caddr_t)B_CANCEL);

  return buttons;
}

