/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : CrtORTCircularArcList
Type : int
Written on   : 20-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/LPEG/src/ListRoutines

==============================================================================

Input parameters    : 

 p_InFile			-- Pointer to input file

Output parameters    : 

 ORTCircularArcList		-- The structure containing the ORT CircularArcs
 ORTCircularArcListID	-- The List ID of the ORT CircularArcs
 Nlist			-- Number of items in the List

Output result       : 

  0 = End of file with no errors 
 -1 = Error during read

Called Functions :

AddElmList		-- From libListe
CreateList		-- From libListe

Calling procedure:

#include "LPEG.h" 		 Header for ORT library
#include "ListeMacros.h"     Macros the Liste library
#include "Liste.h"           Header file for the Liste library

 double MinCircularArcLength;

 FILE *p_InFile;

 int   Nlist

 Liste ORTCircularArcListID;

 struct ORTCircularArc *ORTCircularArcList;

	CrtORTCircularArcList(  &p_InFile,
                        	   &ORTCircularArcList,
                        	   &ORTCircularArcListID,
			   	   &Nlist);


Functionality: 

This function creates a List of ORT CircularArc structures using functions from the 
Liste library. All memory allocation for structures is done within this 
routine. The CircularArcs data is also filtered by length.

----------------------------------------------------------------------------*/

#include "FEX.h"
#include "LPEG.h"
#include "ListeMacros.h"
#include "Liste.h"

#define MAXLINE 100

int CrtORTCircularArcList(  p_InFile,
				ORTCircularArcList,
				ORTCircularArcListID,
				Nlist)

 FILE *(*p_InFile);

 struct ORTCircularArc *(*ORTCircularArcList);

 Liste *ORTCircularArcListID;

 int *Nlist;

{

 int flag;
 char text[MAXLINE];
 long element;

#ifdef debug
          fprintf(stderr," Start of function CrtORTCircularArcList \n");
#endif


/*
 Start at the top of the file
*/
    fseek((*p_InFile),0,0);

/* 
  Skip text to relevant section of FEX output
*/
     flag = fscanf((*p_InFile),"%s",text);
     while  ( strcmp(text,"#CircularArcs") && flag != 0 && flag != EOF) {
              flag = fscanf((*p_InFile),"%s",text);
     }

/*
 Create an empty list to store the ORT CircularArcs

*/

 *ORTCircularArcListID = CreatList();
 *Nlist = 0;

      while (flag != 0 && flag != EOF) {

        *ORTCircularArcList = MACAllocateMem(ORTCircularArc);
        flag = fscanf((*p_InFile),"%d %d %d %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf\n",
			   &(*ORTCircularArcList)->ID,
                        &(*ORTCircularArcList)->StringID,
                        &(*ORTCircularArcList)->Direction,
                        &(*ORTCircularArcList)->Origin.Col,
                        &(*ORTCircularArcList)->Origin.Row,
                        &(*ORTCircularArcList)->Start.Col,
                        &(*ORTCircularArcList)->Start.Row,
                        &(*ORTCircularArcList)->MidPoint.Col,
                        &(*ORTCircularArcList)->MidPoint.Row,
                        &(*ORTCircularArcList)->End.Col,
                        &(*ORTCircularArcList)->End.Row,
                        &(*ORTCircularArcList)->VLPoint.Col,
                        &(*ORTCircularArcList)->VLPoint.Row,
                        &(*ORTCircularArcList)->Radius,
                        &(*ORTCircularArcList)->Length,
                        &(*ORTCircularArcList)->LengthParlVar,
                        &(*ORTCircularArcList)->LengthPerpVar,
                        &(*ORTCircularArcList)->Width,
                        &(*ORTCircularArcList)->Height,
                        &(*ORTCircularArcList)->Theta);

	  if (flag != 0 && flag != EOF)  {
         	AddElmList (*ORTCircularArcListID, (long) (*ORTCircularArcList) );
		(*Nlist)++;
         }
  }

	if (flag == -1) {
	    return(0);
	} else {
	    return(-1);
       }

#ifdef debug
          fprintf(stderr," End of function CrtORTCircularArcList \n");
#endif

}

