#ifndef _MPEG_H_
#define _MPEG_H_

short *get_mb();

void code_i_mb();

void code_intra();

void quantize_dc();

void quantize_ac();

void make_zz();

void make_unzz();

void print_block();

void decode_i();

void put_mb();

extern void fast_dct_2d();
extern void fast_idct_2d();

short **make_mb();
void free_mb();

/* Quantizer Matrix for Intraframe DCT components from MPEG specs*/
int intra_quant[DCT_SIZE_2] = {
   8, 16, 19, 22, 26, 27, 29, 34,
  16, 16, 22, 24, 27, 29, 34, 37,
  19, 22, 26, 27, 29, 34, 34, 38,
  22, 22, 26, 27, 29, 34, 37, 40,
  22, 26, 27, 29, 32, 35, 40, 48,
  26, 27, 29, 32, 35, 40, 48, 58,
  26, 27, 29, 34, 38, 46, 56, 69,
  27, 29, 35, 38, 46, 56, 69, 83 };

/* zig-zag scanning pattern */
int scan[DCT_SIZE][DCT_SIZE] = {
   {  0,  1,  5,  6, 14, 15, 27, 28},
   {  2,  4,  7, 13, 16, 26, 29, 42},
   {  3,  8, 12, 17, 25, 30, 41, 43},
   {  9, 11, 18, 24, 31, 40, 44, 53},
   { 10, 19, 23, 32, 39, 45, 52, 54},
   { 20, 22, 33, 38, 46, 51, 55, 60},
   { 21, 34, 37, 47, 50, 56, 59, 61},
   { 35, 36, 48, 49, 57, 58, 62, 63}
};

#endif



