/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

/**********************************************************************
  Creates the MPEGTool Error dialog. This dialog is called when some
  error was happened in MPEGTool. A corresponding error message will
  popup in the title bar stating what the error have happened. 
  Global value errnum specifies which error have happened. Some errnum
  handles global value errmsg, which shows details of error such as
  file name. 
 ***********************************************************************/

#include <Xm/DialogS.h>
#include <Xm/MessageB.h>
#include <stdio.h>
#include "errormsg.h"

Widget GetTopShell();

/* error handling global parameter. Add errorhandle.h to use 
   this error handle routine. */

int errnum;
char errmsg[256] = "\0";

void
  error_popup(w)
Widget w;
{
  Widget  dialog;
  char base_str[256];
  XmString msg_str, ok;
  Arg args[2];
  extern void dlg_callback();
  /*------ errnum evaluation ------*/
  if (errnum > MAX_ERROR_MESSAGE) errnum = 0; /* errnum range check */
  if (errnum < 0) { /* nothing to do if errnum < 0 */
    errnum = 0;
    return;
  }
  if(strlen(errmsg)!=0) {
    sprintf(base_str,msg[errnum],errmsg);
    msg_str = XmStringCreateSimple(base_str);
    errmsg[0] = '\0';
  }
  else {
    sprintf(base_str,"%s",msg[errnum]);
#ifdef DEBUG
    sprintf(base_str,"%d:%s",errnum,msg[errnum]);
    fprintf(stderr,"\n*** %d:%s\n",errnum,msg[errnum]);
#endif
    msg_str = XmStringCreateSimple(base_str);     
  }
  errnum = 0; /* reset errnum */
  /*------ error dialog ------*/
  ok  = XmStringCreateSimple("OK");
  XtSetArg(args[0], XmNautoUnmanage, False);
  XtSetArg(args[1], XmNcancelLabelString, ok);
  dialog = XmCreateErrorDialog(GetTopShell(w), "error", args, 2);
  XtVaSetValues(XtParent(dialog),
    XmNtitle, "MPEGTool: Error",
    NULL);
  XtAddCallback(dialog, XmNcancelCallback, dlg_callback, NULL);
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
  XtVaSetValues(dialog,
    XmNmessageString,  msg_str,
    XmNdialogStyle,    XmDIALOG_FULL_APPLICATION_MODAL,
    NULL);
  XmStringFree(msg_str);
  XmStringFree(ok);
  XtManageChild(dialog);
  XtPopup(XtParent(dialog), XtGrabNone);
}
