/*
 * This file is part of
 * Movietool: display a succession of rasterfile frames in real-time
 *
 * Copyright 1989 by Ole H. Nielsen
 * This software may be distributed freely provided that:
 * 1) this copyright notice is kept intact,
 * 2) you do not try to sell this software for a profit,
 * 3) you provide the full source code.
 *
 * Author: Ole H. Nielsen
 *         Lab of Applied Physics, Bygn. 307
 *         Technical University of Denmark, DK-2800 Lyngby
 *         E-mail: ohnielse@ltf.dth.dk
 */

#include "movietool.h"
#include <stdio.h>

/* global declarations */

extern Pixwin	*canvaspw;
extern Image	*current_frame;
extern int	encoded_flag;

void my_pw_rop (pw, dx, dy, dw, dh, op, pr, sx, sy)
Pixwin *pw;
int dx, dy, dw, dh, op, sx, sy;
struct pixrect *pr;
{
	struct pixrect *pr_tmp;
	int *planes, *save_planes;

	if (encoded_flag && current_frame->ras_type == RT_BYTE_ENCODED) {
		/* Copy to intermediate pixrect */
		pr_tmp = mem_create(pr->pr_size.x, pr->pr_size.y, pr->pr_depth);
		(void) pr_decode (pr_tmp, 0, 0, pr);
		(void) pw_rop (canvaspw, dx, dy, dw, dh, op, pr_tmp, sx, sy);
		pr_close (pr_tmp);
	} else {
		(void) pw_rop (canvaspw, dx, dy, dw, dh, op, pr, sx, sy);
	}
}
