/*
 * file:     menuBar.c
 * author:   Wes Barris
 * date:     10/15/93
 * purpose:  creates main menu bar
 *
 * copyright info:
 *
 *    @Copyright 1993
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "icop.h"
#include "proto.h"
#include <Xm/RowColumn.h>

Widget
MenuBarInit(Widget parent)
{
	int		n;
	Arg		arg[10];
	Widget		mbar;

	n = 0;
	XtSetArg(arg[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++;
	mbar = XmCreateMenuBar(parent, "menuBar", arg, n); 
	XtManageChild(mbar);
	
	FileMenuInit(mbar);
	PlotMenuInit(mbar);
	ImageMenuInit(mbar);
	PrefMenuInit(mbar);

	return(mbar);
}
