/*
 * file:     icop.h
 * author:   Wes Barris
 * date:     10/15/93
 * purpose:  header file for Icop application
 *
 * copyright info:
 *
 *    @Copyright, Research Equipment Inc., d/b/a Minnesota Supercomputer
 *    Center, Inc., 1993.
 *
 */

#ifndef ICOP_HEADER
#define ICOP_HEADER

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Intrinsic.h>

#define MAJOR_VERSION	1
#define MINOR_VERSION	2
#define PETTY_VERSION	0

#define APP_CLASS	("Icop")
/*
 * Standards.
 */
#define NTSC		1
#define PAL		2
/*
 * Plot types.
 */
#define YIQ_LEGAL	1
#define YUV_LEGAL	2
#define YIQ_3D		3
#define YUV_3D		4
#define RGB_3D		5
/*
 * Image types.
 */
#define LEGAL_ONLY	1
#define ILLEGAL_ONLY	2
#define ALL		3
#define CORRECTED	4
/*
 * File types.
 */
#define ASCII_MAP	1	/* ASCII colormap */
#define BINARY_MAP	2	/* Binary colormap */
#define IMAGE_FILE	3	/* Image file (any format) */
/*
 * Define plot and image structures.
 */
typedef struct {
	Widget		w;
	short		width;
	short		height;
        unsigned long	*buf;
	} Plot;

typedef struct {
	Widget		w;
	int		width;
	int		height;
        unsigned long	*origbuf;
        unsigned long	*legalbuf;
        unsigned long	*illegalbuf;
        unsigned long	*correctedbuf;
	} Image;

typedef struct {
	XtAppContext	appContext;
	Widget		toplevel;
	Plot		plot;
	Image		image;
	} ICOP;
#endif
