/*
 * file:     viewMenu.c
 * author:   Wes Barris
 * date:     9/02/92
 * purpose:  creates View menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <X11/StringDefs.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include "Umsc/List.h"
#include "SelfM/SelfM.h"

extern DESI	desi;
extern UmscList	theList;
extern void	ShowRecordPanelCB();
extern int	needtosave;
int		nFrames = 1;
int		currentFrame = 1;
static Widget	gotoPanel = NULL;
static Widget	movePanel = NULL;
static Widget	deletePanel = NULL;

static void
UnDrawCurrentFrame(void)
{
   Arg		args[2];
   GenericInfo	*thisObject;
   int		i, n;
/*
 * Un-draw all objects in the current frame.
 * This is done by unmanaging their parent (selfmoving).
 */
   n = 0;
   XtSetArg(args[n], XtNselected, False); n++;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->frame == currentFrame) {
         thisObject->selected = 0;
         XtSetValues(XtParent(thisObject->w), args, n);
         XtUnmanageChild(XtParent(thisObject->w));
         }
      thisObject = UmscListGetNext(theList);
      }
}


static void
DrawCurrentFrame(void)
{
   GenericInfo	*thisObject;
   int		i;
/*
 * Draw all objects in this new frame.
 * This is done by either managing them (if they have already been created)
 * or by creating them (if this is the first time they've been shown).
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->frame == currentFrame) {
         if (thisObject->w)
            XtManageChild(XtParent(thisObject->w));
         else
            CreateObject(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
}


static void
BumpFrameCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   Arg		args[2];
   GenericInfo	*thisObject;
   int		i, n;
   if (nFrames == 1)
      return;
   UnDrawCurrentFrame();
/*
 * Change Frames.
 */
   if (!strcmp(XtName(w), "next"))
      currentFrame = (currentFrame == nFrames ? 1 : currentFrame + 1);
   else
      currentFrame = (currentFrame == 1 ? nFrames : currentFrame - 1);
   DrawCurrentFrame();
   SetDesiTitle("----");
}


static void
GotoCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmSelectionBoxCallbackStruct	*call_data;
{
   Arg		args[2];
   GenericInfo	*thisObject;
   char	*sP;
   int	i, n, newframe;

   sP = XmTextGetString(XmSelectionBoxGetChild(gotoPanel, XmDIALOG_TEXT));
   newframe = atoi(sP);
   free(sP);
   if (newframe >= 1 && newframe <= nFrames) {
      UnDrawCurrentFrame();
      currentFrame = newframe;
      DrawCurrentFrame();
      SetDesiTitle("----");
      }
}


static void
GotoPanelInit(void)
{
   Arg		args[10];
   int		n;
/*
 * Let the user type in the text.
 */
   n = 0;
   XtSetArg(args[n], XmNselectionLabelString,
                     XmStringCreateSimple("Go to frame number:")); n++;
   gotoPanel = XmCreatePromptDialog(desi.toplevel, "gotoPanel", args, n);
   XtUnmanageChild(XmSelectionBoxGetChild(gotoPanel, XmDIALOG_HELP_BUTTON));
   XtAddCallback(gotoPanel, XmNokCallback, (XtCallbackProc)GotoCB, NULL);
   XtAddCallback(gotoPanel, XmNokCallback, (XtCallbackProc)unmanageCB, NULL);
   XtAddCallback(gotoPanel, XmNcancelCallback, (XtCallbackProc)unmanageCB, NULL);
}


static void
GotoFrameCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   if (nFrames == 1)
      return;
   if (!gotoPanel)
      GotoPanelInit();
   XtManageChild(gotoPanel);
}


static void
DeleteCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmSelectionBoxCallbackStruct	*call_data;
{
   GenericInfo	*thisObject;
   char	*sP;
   int	i, n;
/*
 * Delete all objects in the current frame.  And bring any objects on higher
 * frame numbers down a notch.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   i = UmscListGetCount(theList);
   for (n=0; n<i; n++) {
      if (thisObject->frame == currentFrame) {
         XtDestroyWidget(XtParent(thisObject->w));
         UmscListRemove(theList, UmscNEXT);
         thisObject = UmscListGetCurrent(theList);
         needtosave = 1;
         }
      else if (thisObject->frame > currentFrame) {
         thisObject->frame--;
         thisObject = UmscListGetNext(theList);
         }
      else
         thisObject = UmscListGetNext(theList);
      }
   nFrames--;
   if (currentFrame > nFrames)
      currentFrame = nFrames;
   DrawCurrentFrame();
/*
 * Update the title bar.
 */
   SetDesiTitle("----");
}


static void
DeletePanelInit(void)
{
   Arg		args[10];
   int		n;
/*
 * Let the user type in the text.
 */
   n = 0;
   XtSetArg(args[n], XmNmessageString,
                     XmStringCreateSimple("Delete current frame?")); n++;
   deletePanel = XmCreateQuestionDialog(desi.toplevel, "deletePanel", args, n);
   XtUnmanageChild(XmMessageBoxGetChild(deletePanel, XmDIALOG_HELP_BUTTON));
   XtAddCallback(deletePanel, XmNokCallback, (XtCallbackProc)DeleteCB, NULL);
   XtAddCallback(deletePanel, XmNokCallback, (XtCallbackProc)unmanageCB, NULL);
   XtAddCallback(deletePanel, XmNcancelCallback, (XtCallbackProc)unmanageCB, NULL);
}


static void
DeleteFrameCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   if (nFrames == 1)
      return;
   if (!deletePanel)
      DeletePanelInit();
   XtManageChild(deletePanel);
}


static void
MoveCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmSelectionBoxCallbackStruct	*call_data;
{
   Arg		args[2];
   GenericInfo	*thisObject;
   char		*sP;
   int		i, n, newframe;

   sP = XmTextGetString(XmSelectionBoxGetChild(movePanel, XmDIALOG_TEXT));
   newframe = atoi(sP);
   free(sP);
   if (newframe >= 1 && newframe <= nFrames && newframe != currentFrame) {
/*
 * Un-draw (and unselect) all selected objects in the current frame.
 * This is done by unmanaging their parent (selfmoving).
 */
      n = 0;
      XtSetArg(args[n], XtNselected, False); n++;
      thisObject = UmscListSetCurrent(theList, UmscFIRST);
      for (i=0; i<UmscListGetCount(theList); i++) {
         if (thisObject->frame == currentFrame && thisObject->selected) {
            thisObject->selected = 0;
            thisObject->frame = newframe;
            XtSetValues(XtParent(thisObject->w), args, n);
            XtUnmanageChild(XtParent(thisObject->w));
            needtosave = 1;
            }
         thisObject = UmscListGetNext(theList);
         }
      }
}


static void
MovePanelInit(void)
{
   Arg		args[10];
   int		n;
/*
 * Let the user type in the text.
 */
   n = 0;
   XtSetArg(args[n],
            XmNselectionLabelString,
            XmStringCreateLtoR("Move all selected objects\nto frame number:",
            XmSTRING_DEFAULT_CHARSET)); n++;
   movePanel = XmCreatePromptDialog(desi.toplevel, "movePanel", args, n);
   XtUnmanageChild(XmSelectionBoxGetChild(movePanel, XmDIALOG_HELP_BUTTON));
   XtAddCallback(movePanel, XmNokCallback, (XtCallbackProc)MoveCB, NULL);
   XtAddCallback(movePanel, XmNokCallback, (XtCallbackProc)unmanageCB, NULL);
   XtAddCallback(movePanel, XmNcancelCallback, (XtCallbackProc)unmanageCB, NULL);
}


static void
MoveFrameCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   if (nFrames == 1)
      return;
   if (!movePanel)
      MovePanelInit();
   XtManageChild(movePanel);
}


static void
NewFrameCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   Arg		args[2];
   GenericInfo	*thisObject;
   int		i, n;
/*
 * Un-draw all objects in the current frame.
 * And increment all frame numbers greater than the currentFrame.
 */
   n = 0;
   XtSetArg(args[n], XtNselected, False); n++;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->frame == currentFrame) {
         thisObject->selected = 0;
         XtSetValues(XtParent(thisObject->w), args, n);
         XtUnmanageChild(XtParent(thisObject->w));
         }
      else if (thisObject->frame > currentFrame)
         thisObject->frame++;
      thisObject = UmscListGetNext(theList);
      }
/*
 * Bump the current frame to the next new frame.
 */
   currentFrame++;
   nFrames++;
   SetDesiTitle("----");
   needtosave = 1;
}


static struct {
   char		*name;			/* name of menu item widget */
   void		(*callbackFcn)();	/* callback function */
   } items[] = {
      { "prev",		BumpFrameCB	},
      { "next",		BumpFrameCB	},
      { "goto",		GotoFrameCB	},
      { "move",		MoveFrameCB	},
      { "delete",	DeleteFrameCB	},
      { "new",		NewFrameCB	},
      { NULL,		NULL		},
      { "record",	ShowRecordPanelCB	},
      };

void
ViewMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	viewMenu, w;

/*
 * Create pulldown menu.
 */
   n = 0;
   viewMenu = XmCreatePulldownMenu(parent, "viewMenu", arg, n);
/*
 * Create the entries for this menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].name != NULL) {
         w = XmCreatePushButton(viewMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)items[i].callbackFcn, NULL);
         }
      else
         w = XmCreateSeparator(viewMenu, "sep", arg, 0);
      XtManageChild(w);
      }
/*
 * Create the cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, viewMenu); n++;
   w = XmCreateCascadeButton(parent, "view", arg, n);
   XtManageChild(w);
}
