/*
 * file:     record.c
 * author:   Wes Barris
 * date:     9/17/92
 * purpose:  handles Record panel functionality
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gl/gl.h>
#include <gl/image.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

unsigned long* longimagedata(char*);

#define DPRINTF(str) (debug ? printf("%s\n", str) : system(str))

extern DESI	desi;
extern UmscList	theList;
extern int	nFrames;		/* number of Desi frames available */
extern int	currentFrame;		/* currently displayed frame */
extern char	*filename;
extern int	dumppending;

static Widget	recordPanel = NULL;
static int	abekas = 0;		/* Are we sending data to the Abekas? */
static int	shellcmd = 0;		/* Are we using scripts instead? */
static int	timecode = 0;		/* Are we using timecode (vfr_load)? */
static int	astart = 0;		/* Abekas A60 starting location */
static int	startframe;		/* Desi frame number to start with */
static int	endframe;		/* Desi frame number to end with */
static int	totalframes;		/* number of frame (with fades) */
static int	bhold, ehold = 0;	/* beginning and ending holds */
static char	precmd[80], postcmd[80];
static char	aprecmd[80], apostcmd[80];
static Widget	fstartt,
		fendt,
		precmdt,
		postcmdt,
		aprecmdt,
		apostcmdt,
		transPanel;
static int	*fadelist = NULL;
int		debug = 0;


/*
 * This routine is called whenever a transition button is pressed.
 */
static void
SetTransTypeCB(Widget w, XtPointer client_data, char *call_data)
{
   char	*fP, str[10];
   int	transition_number, fadetype;
   int	i;
/*
 * Find both the transition number and the type of fade (fade number).
 */
   fP = strchr(XtName(XtParent(w)), '_');
   transition_number = atoi(++fP);
   fP = strchr(XtName(w), '_');
   fadetype = atoi(++fP);
   fadelist[transition_number] = fadetype;
/*
 * Determine the total number of frames.
 */
   totalframes = 0;
   for (i=startframe-1; i<endframe; i++) {
      if (fadelist[i])
         totalframes += 30;
      else if (!fadelist[i+1])
         totalframes++;
      }
   if (fadelist[endframe])
      totalframes += 30;
/*
 * Update the Abekas A60 outpoint?
 */
   if (abekas) {
      if (astart+totalframes-1 > 749) {
         astart = 750 - totalframes;
         sprintf(str, "%d", astart);
         XmTextSetString(precmdt, str);
         }
      else {
         sprintf(str, "%d", astart+totalframes-1);
         XmTextSetString(postcmdt, str);
         }
      }
}


static void
DestroyTransPanelCB(Widget w, XtPointer client_data, char *call_data)
{
  XtDestroyWidget(transPanel);
}


static void
CreateTButsCB(Widget w, XtPointer client_data, char *call_data)
{
   Arg		args[3];
   Widget	rc,
		f1,
		f2,
		rc1,
		rc2,
		wi,
		done;
   char		name[10];
   int		i, n;

   transPanel = XmCreateFormDialog(desi.toplevel, "transPanel", args, 0);

   rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, transPanel, args, 0);

   f1 = XtCreateManagedWidget("frame", xmFrameWidgetClass, rc, args, 0);
   f2 = XtCreateManagedWidget("frame", xmFrameWidgetClass, rc, args, 0);

   rc1 = XtCreateManagedWidget("rctoo", xmRowColumnWidgetClass, f1, args, 0);
   rc2 = XtCreateManagedWidget("rctoo", xmRowColumnWidgetClass, f2, args, 0);
/*
 * Create a label for each frame and a transition menu between each one.
 */
   n = 0;
   XtSetArg(args[n], XmNbuttonCount, 10); n++;
   XtSetArg(args[n], XmNsimpleCallback, SetTransTypeCB); n++;
   if (fadelist)
      XtSetArg(args[n], XmNbuttonSet, fadelist[startframe-1]); n++;
   sprintf(name, "tran_%d", startframe-1);
   wi = XmCreateSimpleOptionMenu(rc1, name, args, n);
   n--;
   XtManageChild(wi);
   for (i = startframe; i <= endframe; i++) {
      sprintf(name, "Frame %d", i);
      wi = XtCreateManagedWidget(name, xmLabelWidgetClass, rc1, args, 0);
      sprintf(name, "tran_%d", i);
      if (fadelist)
         XtSetArg(args[n], XmNbuttonSet, fadelist[i]); n++;
      wi = XmCreateSimpleOptionMenu(rc1, name, args, n);
      XtManageChild(wi);
      n--;
      }
/*
 * A way to get out.
 */
   done = XtCreateManagedWidget("done", xmPushButtonWidgetClass, rc2, args, 0);
   XtAddCallback(done, XmNactivateCallback, (XtCallbackProc)DestroyTransPanelCB, (char *)transPanel);
   XtManageChild(transPanel);
}


/*
 * This routine is called whenever a new start or end frame is entered.
 */
static void
NewRangeCB(w, client_data, call_data)
Widget			w;
XtPointer		client_data;
XmAnyCallbackStruct	*call_data;
{
   char	*txt, str[10];
   int	i;

   txt = XmTextGetString(w);
/*
 * Check for and empty string.
 */
   if (!strcmp(txt, "")) {
      if (!strcmp(XtName(w), "fstartt")) {
         sprintf(str, "%d", startframe);
         XmTextSetString(w, str);
         }
      else {
         sprintf(str, "%d", endframe);
         XmTextSetString(w, str);
         }
      }
   else {
/*
 * Check for an illegal character.
 */
      for (i=0; i<strlen(txt); i++)
         if ((int)txt[i] < '0' || (int)txt[i] > '9') {
            if (!strcmp(XtName(w), "fstartt")) {
               sprintf(str, "%d", startframe);
               XmTextSetString(w, str);
               }
            else {
               sprintf(str, "%d", endframe);
               XmTextSetString(w, str);
               }
            free(txt);
            return;
            }
/*
 * Check for an illegal number.
 */
      i = atoi(txt);
      free(txt);

      if (!strcmp(XtName(w), "fstartt")) {
         if (i < 1) {
            XmTextSetString(w, "1");
            return;
            }
         else if (i > endframe) {
            sprintf(str, "%d", endframe);
            XmTextSetString(w, str);
            return;
            }
         }
      else {
         if (i < startframe) {
            sprintf(str, "%d", startframe);
            XmTextSetString(w, str);
            return;
            }
         else if (i > nFrames) {
            sprintf(str, "%d", nFrames);
            XmTextSetString(w, str);
            return;
            }
         }


/*
      if (i < 1 || i > nFrames) {
         if (!strcmp(XtName(w), "fstartt")) {
            sprintf(str, "%d", startframe);
            XmTextSetString(w, str);
            }
         else {
            sprintf(str, "%d", endframe);
            XmTextSetString(w, str);
            }
         return;
         }
*/
/*
 * Check for numbers out of order.
 */
/*
      if (!strcmp(XtName(w), "fstartt") && i > endframe) {
         sprintf(str, "%d", startframe);
         XmTextSetString(w, str);
         return;
         }
      else if (!strcmp(XtName(w), "fendt") && i < startframe) {
         sprintf(str, "%d", endframe);
         XmTextSetString(w, str);
         return;
         }
*/
/*
 * Ok, it seems we got a valid frame number.
 */
      if (!strcmp(XtName(w), "fstartt"))
         startframe = i;
      else
         endframe = i;
      totalframes = endframe - startframe + 1;
      }
}


static long
tcodetoframe(char *tcode)
{
   char hour[3], minute[3], second[3], frame[3];
   int  nh, nm, ns, nf;

   if (strlen(tcode) == 11) {
      strncpy(hour, &tcode[0], 2);
      hour[2] = '\0';
      strncpy(minute, &tcode[3], 2);
      minute[2] = '\0';
      strncpy(second, &tcode[6], 2);
      second[2] = '\0';
      strncpy(frame, &tcode[9], 2);
      frame[2] = '\0';
      }
   else if (strlen(tcode) == 8) {
      strcpy(hour, "00");
      hour[2] = '\0';
      strncpy(minute, &tcode[0], 2);
      minute[2] = '\0';
      strncpy(second, &tcode[3], 2);
      second[2] = '\0';
      strncpy(frame, &tcode[6], 2);
      frame[2] = '\0';
      }
   else {
      /*fprintf(stderr, "I'm having trouble decoding that time code.\n");*/
      return -1;
        }
   nh = atoi(hour);
   nm = atoi(minute);
   ns = atoi(second);
   nf = atoi(frame);
   return nf + ns*30 + nm*1800 + nh*108000;
}


static char*
frametotcode(long frame)
{
   static char tcode[13];
   int  nh, nm, ns, nf;

   if (frame >= 108000) {
      nh = frame / 108000;
      frame-= nh*108000;
      }
   else
      nh = 0;
   if (frame >= 1800) {
      nm = frame / 1800;
      frame-= nm*1800;
      }
   else
      nm = 0;
   if (frame >= 30) {
      ns = frame / 30;
      frame-= ns*30;
      }
   else
      ns = 0;
   nf = frame;

   if (nh == 0)
      sprintf(tcode, "%02d:%02d:%02d", nm, ns, nf);
   else
      sprintf(tcode, "%02d:%02d:%02d:%02d", nh, nm, ns, nf);
   return tcode;
}


/*
 * This routine is called whenever a new command (or Abekas A60 frame number)
 * is entered into the "cmd" areas.
 */
static void
NewCmdCB(w, client_data, call_data)
Widget			w;
char *			client_data;
XmAnyCallbackStruct	*call_data;
{
   char	*txt, str[10];
   int	n, cmd;
   long	tstart, tend;
   struct stat buf;

   txt = XmTextGetString(w);
/*
 * Was the string deleted?
 */
   if (!strcmp(txt, "")) {
      if (!strcmp(XtName(w), "precmdt"))
         strcpy(precmd, "");
      else if (!strcmp(XtName(w), "postcmdt"))
         strcpy(postcmd, "");
      else if (!strcmp(XtName(w), "aprecmdt"))
         strcpy(aprecmd, "");
      else if (!strcmp(XtName(w), "apostcmdt"))
         strcpy(apostcmd, "");
      }
/*
 * Is this string to be executed right now?
 */
   else if ((int)txt[0] == '!') {
      DPRINTF(&txt[1]);
      if (!strcmp(XtName(w), "precmdt"))
         XmTextSetString(precmdt, "");
      else if (!strcmp(XtName(w), "postcmdt"))
         XmTextSetString(postcmdt, "");
      else if (!strcmp(XtName(w), "aprecmdt"))
         XmTextSetString(aprecmdt, "");
      else if (!strcmp(XtName(w), "apostcmdt"))
         XmTextSetString(apostcmdt, "");
      free(txt);
      return;
      }
   else {
/*
 * Well, what is it: an Abekas A60 frame number, timecode, or a shell command?
 */
      cmd = 0;
      for (n=0; n<strlen(txt); n++)
         if ((int)txt[n] == ':')
            timecode++;
         else if ((int)txt[n] < '0' || (int)txt[n] > '9')
            cmd++;
/*
 * The string had non-numeric characters -- assume it is a command.
 */
      if (cmd) {


/* this section is commented out.

         if (stat(txt, &buf))
            printf("%s is not in your current working directory.\n", txt);
         else if (buf.st_mode & 0100 && getuid() == buf.st_uid ||
             buf.st_mode & 0010 && getgid() == buf.st_gid ||
             buf.st_mode & 0001) {
*/
            shellcmd = 1;
            abekas = 0;
            if (!strcmp(XtName(w), "precmdt")) {
               strcpy(precmd, txt);
               }
            else if (!strcmp(XtName(w), "postcmdt")) {
               strcpy(postcmd, txt);
               }
            else if (!strcmp(XtName(w), "aprecmdt")) {
               strcpy(aprecmd, txt);
               }
            else if (!strcmp(XtName(w), "apostcmdt")) {
               strcpy(apostcmd, txt);
               }
/*
            }
         else {
            printf("%s is not executable\n", txt);
            shellcmd = 0;
            }
*/

         }
      else if (timecode) {
/*
 * Figure out what the outpoint (or inpoint) should be.
 */
         abekas = 0;
         shellcmd = 0;
         if (!strcmp(XtName(w), "aprecmdt")) {
            strcpy(aprecmd, txt);
            tstart = tcodetoframe(txt);
            tend = tstart + totalframes;
            XmTextSetString(apostcmdt, frametotcode(tend));
            }
         else if (!strcmp(XtName(w), "precmdt")) {
            strcpy(precmd, txt);
            bhold = atoi(txt);
            }
         else if (!strcmp(XtName(w), "apostcmdt")) {
            strcpy(apostcmd, txt);
            tend = tcodetoframe(txt);
            tstart = tend - totalframes;
            XmTextSetString(aprecmdt, frametotcode(tstart));
            }
         else if (!strcmp(XtName(w), "postcmdt")) {
            strcpy(postcmd, txt);
            ehold = atoi(txt);
            }
         }
/*
 * The string had only numerals -- assume it is a frame number.
 */
      else {
         if (desi.back.width != 720 || desi.back.height != 486)
            printf("Your background is not the correct size for the Abekas A60.\n");
         shellcmd = 0;
         timecode = 0;
         strcpy(precmd, "");
         strcpy(postcmd, "");
         n = atoi(txt);
         if (!strcmp(XtName(w), "precmdt")) {
            if (n < 0 || n+totalframes-1 > 749)
               printf("out of range\n");
            else {
               astart = n;
               sprintf(str, "%d", n + totalframes - 1);
               XmTextSetString(postcmdt, str);
               abekas = 1;
               bhold = n; /* in case this is used in smart_load */
               }
            }
         else if (!strcmp(XtName(w), "postcmdt")) {
            if (n+1-totalframes < 0 || n > 749)
               printf("out of range\n");
            else {
               astart = n + 1 - totalframes;
               sprintf(str, "%d", astart);
               XmTextSetString(precmdt, str);
               abekas = 1;
               ehold = n; /* in case this is used in smart_load */
               }
            }
         }
      }
   free(txt);
}


static char*
GetFadeCmd(int type)
{
   static char	cmd[20];

   switch (type) {
      case 0:
         sprintf(cmd, "-none");
         break;
      case 1:
         sprintf(cmd, "-fade");
         break;
      case 2:
         sprintf(cmd, "-in");
         break;
      case 3:
         sprintf(cmd, "-out");
         break;
      case 4:
         sprintf(cmd, "-scaleup");
         break;
      case 5:
         sprintf(cmd, "-scaledown");
         break;
      case 6:
         sprintf(cmd, "-rollup");
         break;
      case 7:
         sprintf(cmd, "-rolldown");
         break;
      case 8:
         sprintf(cmd, "-rollleft");
         break;
      case 9:
         sprintf(cmd, "-rollright");
         break;
      default:
         sprintf(cmd, "-unknown");
         break;
      }
   return cmd;
}


static void
SendToAbekas(void)
{
   FILE		*fp;
   char		cmd[80];
   int		i;
   struct stat	buf;
/*
 * Send all frames to the (Abekas A60 | screen) in the right order -- duh!
 */
   fp = fopen("_toabekas", "w");
   fprintf(fp, "#!/bin/csh -f\n#\n# Abekas recording script.\n#\n");
   for (i=startframe-1; i<endframe; i++) {
/*
 * Do a fade then send the 30 frames...
 */
      if (fadelist[i] && i == startframe-1) {
         fprintf(fp, "smart_vfr -fs 1 -fe 30 -ext sgi -a %d &\n", astart);
         astart += 30;
         fprintf(fp, "sgifade -l frame.%04d.sgi %s\n",
                 startframe, GetFadeCmd(fadelist[startframe-1]));
         }
      else if (fadelist[i]) {
         fprintf(fp, "wait\nsmart_vfr -fs 1 -fe 30 -ext sgi -a %d &\n", astart);
         astart += 30;
         fprintf(fp, "sgifade -f frame.%04d.sgi -l frame.%04d.sgi %s\n",
                 i, i+1, GetFadeCmd(fadelist[i]));
                 /*i+startframe-1, i+startframe, GetFadeCmd(fadelist[i]));*/
         }
/*
 * Send one frame.
 */
      else if (!fadelist[i+1]) {
         fprintf(fp, "smart_vfr -base frame -fs %d -fe %d -ext sgi -a %d\n",
                                i+1, i+1, astart);
         astart++;
         }
      }
/*
 * Do a fade then send the last 30 frames...
 */
   if (fadelist[endframe]) {
      fprintf(fp, "wait\nsmart_vfr -fs 1 -fe 30 -ext sgi -a %d &\n", astart);
      astart += 30;
      fprintf(fp, "sgifade -f frame.%04d.sgi %s\n", endframe, GetFadeCmd(fadelist[endframe]));
      }
   fprintf(fp, "\necho Done.\n\n");
   fclose(fp);
   XtManageChild(recordPanel);
/*
 * Send the files to the Abekas A60.
 */
   DPRINTF("chmod 755 _toabekas;_toabekas &");
}


static void
DisplayWithCommands(void)
{
   GenericInfo		*thisObject;
   char			cmd[80];
   int			i, n;
   unsigned long	*imgbuf;
   struct stat		buf;
/*
 * First, remove any displayed objects.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->frame == currentFrame) {
         thisObject->selected = 0;
         XtUnmanageChild(XtParent(thisObject->w));
         }
      thisObject = UmscListGetNext(theList);
      }
   XSync(XtDisplay(desi.toplevel), False);
/*
 * Display all frames while executing both pre and post commands.
 */
   for (i=startframe-1; i<endframe; i++) {
/*
 * This section will handle a "fade in".
 */
      if (fadelist[i] && i == startframe-1) {
         sprintf(cmd, "sgifade -l frame.%04d.sgi %s &", startframe, GetFadeCmd(fadelist[startframe-1]));
         DPRINTF(cmd);
         for (n=1; n<=30; n++) {
            sprintf(cmd, "fade.%04d.sgi", n);
            while ((stat(cmd, &buf) == -1) && (debug == 0))
               sleep(5);
            if (strcmp(precmd, "")) {
               sprintf(cmd, "%s fade.%04d.sgi", precmd, n);
               DPRINTF(cmd);
               }
            printf("displaying fade.%04d.sgi\n", n);
            sprintf(cmd, "fade.%04d.sgi", n);
            if (!debug) {
               imgbuf = (unsigned long *) longimagedata(cmd);
               lrectwrite(0,0,desi.back.width-1,desi.back.height-1,imgbuf);
               free(imgbuf);
               }
            if (strcmp(postcmd, "")) {
               sprintf(cmd, "%s fade.%04d.sgi", postcmd, n);
               DPRINTF(cmd);
               }
            sprintf(cmd, "rm -f fade.%04d.sgi", n);
            DPRINTF(cmd);
            }
         }
/*
 * This section will handle a fade between two frames.
 */
      else if (fadelist[i]) {
         /*sprintf(cmd, "sgifade -f frame.%04d.sgi -l frame.%04d.sgi %s &",
                   i+startframe-1, i+startframe, GetFadeCmd(fadelist[i]));*/
         sprintf(cmd, "sgifade -f frame.%04d.sgi -l frame.%04d.sgi %s &",
                   i, i+1, GetFadeCmd(fadelist[i]));
         DPRINTF(cmd);
         for (n=1; n<=30; n++) {
            sprintf(cmd, "fade.%04d.sgi", n);
            while ((stat(cmd, &buf) == -1) && (debug == 0))
               sleep(5);
            if (strcmp(precmd, "")) {
               sprintf(cmd, "%s fade.%04d.sgi", precmd, n);
               DPRINTF(cmd);
               }
            printf("displaying fade.%04d.sgi\n", n);
            sprintf(cmd, "fade.%04d.sgi", n);
            if (!debug) {
               imgbuf = (unsigned long *) longimagedata(cmd);
               lrectwrite(0,0,desi.back.width-1,desi.back.height-1,imgbuf);
               free(imgbuf);
               }
            if (strcmp(postcmd, "")) {
               sprintf(cmd, "%s fade.%04d.sgi", postcmd, n);
               DPRINTF(cmd);
               }
            sprintf(cmd, "rm -f fade.%04d.sgi", n);
            DPRINTF(cmd);
            }
         }
/*
 * Send one frame.
 */
      else if (!fadelist[i+1]) {
         if (strcmp(precmd, "")) {
            sprintf(cmd, "%s frame.%04d.sgi", precmd, i+1);
            DPRINTF(cmd);
            }
         /*sprintf(cmd, "fromutah frame.%04d.sgi frame.%04d.sgi", i+1, i+1);
         DPRINTF(cmd);*/
         sprintf(cmd, "frame.%04d.sgi", i+1);
         printf("displaying %s\n", cmd);
         if (!debug) {
            imgbuf = (unsigned long *) longimagedata(cmd);
            lrectwrite(0,0,desi.back.width-1,desi.back.height-1,imgbuf);
            free(imgbuf);
            }
         if (strcmp(postcmd, "")) {
            sprintf(cmd, "%s frame.%04d.sgi", postcmd, i+1);
            DPRINTF(cmd);
            }
         sprintf(cmd, "rm frame.%04d.sgi", i+1);
         DPRINTF(cmd);
         }
      }
/*
 * This section will handle a fade out.
 */
   if (fadelist[endframe]) {
      sprintf(cmd, "sgifade -f frame.%04d.sgi %s &", endframe, GetFadeCmd(fadelist[endframe]));
      DPRINTF(cmd);
      for (n=1; n<=30; n++) {
         sprintf(cmd, "fade.%04d.sgi", n);
         while ((stat(cmd, &buf) == -1) && (debug == 0))
            sleep(5);
         if (strcmp(precmd, "")) {
            sprintf(cmd, "%s fade.%04d.sgi", precmd, n);
            DPRINTF(cmd);
            }
         printf("displaying fade.%04d.sgi\n", n);
         sprintf(cmd, "fade.%04d.sgi", n);
         if (!debug) {
            imgbuf = (unsigned long *) longimagedata(cmd);
            lrectwrite(0,0,desi.back.width-1,desi.back.height-1,imgbuf);
            free(imgbuf);
            }
         if (strcmp(postcmd, "")) {
            sprintf(cmd, "%s fade.%04d.sgi", postcmd, n);
            DPRINTF(cmd);
            }
         sprintf(cmd, "rm -f fade.%04d.sgi", n);
         DPRINTF(cmd);
         }
      }
   free(precmd);
   free(postcmd);
   for (i=startframe; i<=endframe; i++) {
      sprintf(cmd, "rm -f frame.%04d.sgi", i);
      DPRINTF(cmd);
      }
/*
 * Re-display any objects in the current frame and redraw the background.
 */
   DrawBackCB(desi.back.w, (XtPointer)0, (char *)0);
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->frame == currentFrame) {
         if (thisObject->w)
            XtManageChild(XtParent(thisObject->w));
         else
            DrawObject(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
   printf("Finished recording.\n");
}


static void
SendToVFR(void)
{
   FILE			*fp;
   char			cmd[80];
   int			i, n;
   long			iframe;
   struct stat		buf;
/*
 * Get the starting frame.
 */
   if (strcmp(aprecmd, ""))
      iframe = tcodetoframe(aprecmd);
   else {
      fprintf(stderr, "Could not get inpoint from \"Pre-anim cmd\"\n");
      return;
      }
/*
 * Prepare to write the driving script.
 */
   fp = fopen("_tovfr", "w");
   fprintf(fp, "#!/bin/csh -f\n#\n# smart_load recording script.\n");
   for (i=startframe-1; i<endframe; i++) {
/*
 * Create a fade then send the 30 frames...
 */
      if (fadelist[i] && i == startframe-1) {
         fprintf(fp, "#\nsgifade -l frame.%04d.sgi %s &\nsleep 15\n",
                 startframe, GetFadeCmd(fadelist[startframe-1]));
         fprintf(fp, "smart_load -base fade -fs 1 -fe 30 -ext sgi -inpoint %s -bh %d -eh %d\n", frametotcode(iframe), bhold, ehold);
         iframe += 30 + bhold + ehold;
         }
      else if (fadelist[i]) {
         fprintf(fp, "#\nsgifade -f frame.%04d.sgi -l frame.%04d.sgi %s &\nsleep 15\n",
                 i+startframe-1, i+startframe, GetFadeCmd(fadelist[i]));
         fprintf(fp, "smart_load -base fade -fs 1 -fe 30 -ext sgi -inpoint %s -bh %d -eh %d\n", frametotcode(iframe), bhold, ehold);
         iframe += 30 + bhold + ehold;
         }
/*
 * Send one frame.
 */
      else if (!fadelist[i+1]) {
         fprintf(fp, "#\nsmart_load -base frame -fs %d -fe %d -ext sgi -inpoint %s -bh %d -eh %d\n", i+1, i+1, frametotcode(iframe), bhold, ehold);
         iframe += 1 + bhold + ehold;
         }
      }
/*
 * Do a fade then send the last 30 frames...
 */
   if (fadelist[endframe]) {
      fprintf(fp, "#\nsgifade -f frame.%04d.sgi %s &\nsleep 15\n",
                  endframe, GetFadeCmd(fadelist[endframe]));
      fprintf(fp, "smart_load -base fade -fs 1 -fe 30 -ext sgi -inpoint %s -bh %d -eh %d\n", frametotcode(iframe), bhold, ehold);
      iframe += 30 + bhold + ehold;
      }
   free(precmd);
   free(postcmd);
   fclose(fp);
   XtManageChild(recordPanel);
/*
 * Send the files using vfr_load.
 */
   DPRINTF("chmod 755 _tovfr;_tovfr &");
}


static void
RecordCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   Arg		args[2];
   GenericInfo	*thisObject;
   Widget	menuBar;
   char		cmd[80];
   int 		i, j, n;
   struct stat	buf;
/*
 * I have to put a bunch of these DrawBack/Event things in here so that
 * the background gets refreshed properly.
 */
   /*DrawBackCB(desi.back.w);*/
/*
 * Remove the menu bar and make the background bigger.
 */
   if (shellcmd) {
      menuBar = XtNameToWidget(desi.toplevel, "form.menuBar");
      XtUnmanageChild(menuBar);
      n = 0;
      XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
      XtSetValues(desi.container, args, n);
      }
/*
 * We're going to do a loop thing here where we clear the current frame then
 * display the next after which we dump the whole desi window to a file.  This
 * way we will be left with an image file of each frame.
 */
   for (i=startframe; i<=endframe; i++) {
/*
 * Unmanage any object displayed on the current frame.
 */
         j = 0;
         XtSetArg(args[j], XtNselected, False); j++;
         thisObject = UmscListSetCurrent(theList, UmscFIRST);
         for (n=0; n<UmscListGetCount(theList); n++) {
            if (thisObject->frame == currentFrame) {
               thisObject->selected = 0;
               XtSetValues(XtParent(thisObject->w), args, j);
               XtUnmanageChild(XtParent(thisObject->w));
               }
            thisObject = UmscListGetNext(theList);
            }
         /*DrawBackCB(desi.back.w);*/
/*
 * Display a new Desi frame.
 */
         currentFrame = i;
         thisObject = UmscListSetCurrent(theList, UmscFIRST);
         for (n=0; n<UmscListGetCount(theList); n++) {
            if (thisObject->frame == currentFrame) {
               if (thisObject->w)
                  XtManageChild(XtParent(thisObject->w));
               else
                  CreateObject(thisObject);
               }
            thisObject = UmscListGetNext(theList);
            }
/*
 * Synch up all events so that everything gets drawn.
 */
      XSync(XtDisplay(desi.toplevel), False);
      while (XtAppPending(desi.appContext))
         XtAppProcessEvent(desi.appContext, XtIMAll);
/*
 * Check to see if we have URT commands available.
 */
      /*{
         char	*path, *sP, *eP;
         char	pathname[80];
         int	nchar;
         struct stat buf;
         path = getenv("PATH");

         dumppending = 2;
         sprintf(cmd, "frame.%04d.sgi", i);
         sP = path;
         eP = strchr(sP, (int)':');
         nchar = (int)(eP - sP);
         while (nchar > 0) {
            strncpy(pathname, sP, nchar);
            pathname[nchar] = '\0';
            strcat(pathname, "/rawtorle");
            if (!stat(pathname, &buf)) {
               dumppending = 1;
               sprintf(cmd, "frame.%04d.rle", i);
               }
            if (eP == NULL)
               nchar = 0;
            else {
               sP = eP + 1;
               eP = strchr(sP, (int)':');
               if (eP == NULL)
                  nchar = strlen(path) - (int)(sP - path);
               else
                  nchar = (int)(eP - sP);
               }
            }
      }*/
/*
 * and Take a snapshot of it.
 * Setting this value caused a dump to be made after the background is redrawn.
 */
      dumppending = 2;
      sprintf(cmd, "frame.%04d.sgi", i);
      filename = cmd;
      printf("Saving %s\n", filename);
      DrawBackCB(desi.back.w, (XtPointer)0, (char *)0);
      }
/*
 * Have Desi show the new frame number in the header.
 */
   SetDesiTitle("----");
/*
 * What do I do now?
 */
   if (abekas) {
      DPRINTF(aprecmd);
      SendToAbekas();
      DPRINTF(apostcmd);
      }
   else if (shellcmd) {
      DPRINTF(aprecmd);
      DisplayWithCommands();
      DPRINTF(apostcmd);
/*
 * Re-display the menu bar and re-attach the background to the bottom of it.
 */
      XtManageChild(menuBar);
      n = 0;
      XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
      XtSetArg(args[n], XmNtopWidget, menuBar); n++;
      XtSetValues(desi.container, args, n);
      }
   else if (timecode) {
      /*DPRINTF(aprecmd);*/
      SendToVFR();
      /*DPRINTF(apostcmd);*/
      }
   else
      printf("An sgi image of each frame has been saved.\n");
}


static void
AbortCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   if (abekas) {
      DPRINTF("/etc/killall _toabekas");
      DPRINTF("rsh abekas enable");
      }
   else if (timecode)
      DPRINTF("/etc/killall _tovfr");
   DPRINTF("/etc/killall smart_vfr");
   DPRINTF("/etc/killall smart_load");
   DPRINTF("/etc/killall sgifade");
   DPRINTF("rm -f fade.*.sgi");
   DPRINTF("rm -f frame*.sgi");
   printf("Recording aborted.\n");
}


static void
RemoveTransPanelCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   free(fadelist);
   fadelist = NULL;
   XtUnmanageChild(recordPanel);
}


/*
 *  RecordPanelInit:  creates (but does not manage) recordPanel.
 */
static void
RecordPanelInit(void)
{
   Arg		args[1];
   Widget	rc,
		f1,
		f2,
		f3,
		f4,
		rc1,
		rc2,
		rc3,
		rc4,
		fstartl, fendl,
		precmdl, postcmdl,
		aprecmdl, apostcmdl,
		transitions,
		define,
		record,
		abort,
		done;

   recordPanel = XmCreateFormDialog(desi.toplevel, "recordPanel", args, 0);

   rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, recordPanel, args, 0);

   f1 = XtCreateManagedWidget("frame", xmFrameWidgetClass, rc, args, 0);
   f2 = XtCreateManagedWidget("frame", xmFrameWidgetClass, rc, args, 0);
   f3 = XtCreateManagedWidget("frame", xmFrameWidgetClass, rc, args, 0);
   f4 = XtCreateManagedWidget("frame", xmFrameWidgetClass, rc, args, 0);

   rc1 = XtCreateManagedWidget("rctoo", xmRowColumnWidgetClass, f1, args, 0);
   rc2 = XtCreateManagedWidget("rctoo", xmRowColumnWidgetClass, f2, args, 0);
   rc3 = XtCreateManagedWidget("rctoo", xmRowColumnWidgetClass, f3, args, 0);
   rc4 = XtCreateManagedWidget("rctoo", xmRowColumnWidgetClass, f4, args, 0);

   fstartl = XtCreateManagedWidget("fstartl", xmLabelWidgetClass, rc1, args, 0);
   fstartt = XtCreateManagedWidget("fstartt", xmTextWidgetClass,  rc1, args, 0);
   fendl   = XtCreateManagedWidget("fendl",   xmLabelWidgetClass, rc1, args, 0);
   fendt   = XtCreateManagedWidget("fendt",   xmTextWidgetClass,  rc1, args, 0);

   aprecmdl = XtCreateManagedWidget("aprecmdl",  xmLabelWidgetClass,rc2,args, 0);
   aprecmdt = XtCreateManagedWidget("aprecmdt",  xmTextWidgetClass, rc2,args, 0);
   apostcmdl= XtCreateManagedWidget("apostcmdl", xmLabelWidgetClass,rc2,args, 0);
   apostcmdt= XtCreateManagedWidget("apostcmdt", xmTextWidgetClass, rc2,args, 0);

   precmdl = XtCreateManagedWidget("precmdl",  xmLabelWidgetClass,rc3,args, 0);
   precmdt = XtCreateManagedWidget("precmdt",  xmTextWidgetClass, rc3,args, 0);
   postcmdl= XtCreateManagedWidget("postcmdl", xmLabelWidgetClass,rc3,args, 0);
   postcmdt= XtCreateManagedWidget("postcmdt", xmTextWidgetClass, rc3,args, 0);

   XtAddCallback(fstartt,  XmNactivateCallback,    (XtCallbackProc)NewRangeCB, NULL);
   XtAddCallback(fstartt,  XmNlosingFocusCallback, (XtCallbackProc)NewRangeCB, NULL);
   XtAddCallback(fendt,    XmNactivateCallback,    (XtCallbackProc)NewRangeCB, NULL);
   XtAddCallback(fendt,    XmNlosingFocusCallback, (XtCallbackProc)NewRangeCB, NULL);
   XtAddCallback(precmdt,  XmNactivateCallback,    (XtCallbackProc)NewCmdCB,   "bfa");
   XtAddCallback(precmdt,  XmNlosingFocusCallback, (XtCallbackProc)NewCmdCB,   "bfl");
   XtAddCallback(postcmdt, XmNactivateCallback,    (XtCallbackProc)NewCmdCB,   "afa");
   XtAddCallback(postcmdt, XmNlosingFocusCallback, (XtCallbackProc)NewCmdCB,   "afl");
   XtAddCallback(aprecmdt, XmNactivateCallback,    (XtCallbackProc)NewCmdCB,   "baa");
   XtAddCallback(aprecmdt, XmNlosingFocusCallback, (XtCallbackProc)NewCmdCB,   "bal");
   XtAddCallback(apostcmdt,XmNactivateCallback,    (XtCallbackProc)NewCmdCB,   "aaa");
   XtAddCallback(apostcmdt,XmNlosingFocusCallback, (XtCallbackProc)NewCmdCB,   "aal");

   record= XtCreateManagedWidget("record",xmPushButtonWidgetClass, rc4, args, 0);
   define= XtCreateManagedWidget("define",xmPushButtonWidgetClass, rc4, args, 0);
   abort = XtCreateManagedWidget("abort", xmPushButtonWidgetClass, rc4, args, 0);
   done  = XtCreateManagedWidget("done",  xmPushButtonWidgetClass, rc4, args, 0);

   XtAddCallback(define, XmNactivateCallback, (XtCallbackProc)CreateTButsCB, NULL);
   XtAddCallback(record, XmNactivateCallback, (XtCallbackProc)unmanageCB, (char *)recordPanel);
   XtAddCallback(record, XmNactivateCallback, (XtCallbackProc)RecordCB, NULL);
   XtAddCallback(abort,  XmNactivateCallback, (XtCallbackProc)AbortCB, NULL);
   XtAddCallback(done,   XmNactivateCallback, (XtCallbackProc)RemoveTransPanelCB, NULL);
}



/*
 * ShowRecordPanelCB:  displays the record panel.
 */
void
ShowRecordPanelCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmPushButtonCallbackStruct	*call_data;
{
   Arg	args[2];
   char	str[10];
   int	n;

   if (recordPanel == NULL)
      RecordPanelInit();
/*
 * Set frame endpoints.
 */
   startframe = 1;
   endframe = totalframes = nFrames;
   XmTextSetString(fstartt, "1");
   sprintf(str, "%d", endframe);
   XmTextSetString(fendt, str);
/*
 * Zero out the frame numbers?
 */
   if (abekas) {
      XmTextSetString(precmdt, "");
      XmTextSetString(postcmdt, "");
      }
/*
 * Create a list to hold fade information.
 */
   if (!fadelist) {
      fadelist = (int *)malloc((nFrames+1)*sizeof(int));
      for (n=0; n<=nFrames; n++)
         fadelist[n] = 0;
      }
/*
 * Display the panel.
 */
   XtManageChild(recordPanel);
}
