/*
 * file:     back.c
 * author:   Wes Barris
 * date:     5/27/92
 * purpose:  handles background functionality
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include "PSutils.h"
#include <X11/StringDefs.h>
#include <X11/Xirisw/GlxMDraw.h>
#include <Xm/Xm.h>
#include <Xm/MwmUtil.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

extern DESI	desi;
extern TextInfo	currentInfo;
extern UmscList theList;
extern Widget	backPrefsPanel;
extern char	systype[10];
extern int	currentFrame;
extern int	dumppending;
extern int	needtosave;
extern int	psinited;

static GLXconfig glxConfig [] = {
    { GLX_NORMAL, GLX_RGB, TRUE },
    { 0, 0, 0 }
};

Widget		backPrefsPanel = NULL,
		xSize,
		ySize,
   		glBack,
		absize,
		xlsize,
		solsize,
		cvpsize,
		svhssize,
		chrsize;


/*
 * This routine will draw the desi background.
 */
void
DrawBackCB(Widget w, XtPointer client_data, char *call_data)
{
   short		vert[2];
   short		cv[3], xm, ym, leftc[3], rightc[3];
   short		margin = 40;
   short		safecolor[3];
   /*unsigned short	y;*/
   int	y;
/*
 * Draw the background polygon.
 */
   GLXwinset(XtDisplay(desi.toplevel), XtWindow(w));
   if (strncmp(systype, "GL4DPI", 6)) {	/* It's not a PI -- draw scanlines */
/*
 * machines:
 *		IP4 = 4D/70 or 4D/8[05]
 *		IP5 = 4D/1X0
 *		IP6 = 4D/2[05]		check clock speed with hinv
 *		IP7 = 4D/[234]X0	25mhz=200,33mhz=300,40mhz=400
 *		IP9 = 4D/[234]10
 *		IP12 = 4D/3[05] or Indigo
 *		IP17 = Crimson
 *		IP20 = r4k Indigo
 *		IP22 = r4k Indigo2
 */
      for (y=0; y<(int)desi.back.height; y++) {
         leftc[0] = desi.back.ll[0] + (desi.back.ul[0]-desi.back.ll[0])*(y/(desi.back.height-1.0));
         leftc[1] = desi.back.ll[1] + (desi.back.ul[1]-desi.back.ll[1])*(y/(desi.back.height-1.0));
         leftc[2] = desi.back.ll[2] + (desi.back.ul[2]-desi.back.ll[2])*(y/(desi.back.height-1.0));
         rightc[0] = desi.back.lr[0] + (desi.back.ur[0]-desi.back.lr[0])*(y/(desi.back.height-1.0));
         rightc[1] = desi.back.lr[1] + (desi.back.ur[1]-desi.back.lr[1])*(y/(desi.back.height-1.0));
         rightc[2] = desi.back.lr[2] + (desi.back.ur[2]-desi.back.lr[2])*(y/(desi.back.height-1.0));
         bgnline();
            c3s(leftc);
            vert[0] = 0;                vert[1] = y;v2s(vert);
            c3s(rightc);
            vert[0] = (int)desi.back.width-1;vert[1] = y;v2s(vert);
         endline();
         }
      }
   else {	/* It's a PI -- draw a polygon */
      bgnpolygon();
         c3s(desi.back.ul);
         vert[0] = 0; vert[1] = (int)desi.back.height-1;
         v2s(vert);
         c3s(desi.back.ur);
         vert[0] = (int)desi.back.width-1; vert[1] = (int)desi.back.height-1;
         v2s(vert);
         c3s(desi.back.lr);
         vert[0] = (int)desi.back.width-1; vert[1] = 0;
         v2s(vert);
         c3s(desi.back.ll);
         vert[0] = 0; vert[1]=0;
         v2s(vert);
      endpolygon();
      }
/*
 * Draw the safe area of the background.
 */
   if (backPrefsPanel)
      if (XmToggleButtonGetState(XtNameToWidget(backPrefsPanel, "rc3.safeButton"))) {
         bgnclosedline();
            safecolor[0] = 255 - desi.back.ul[0];
            safecolor[1] = 255 - desi.back.ul[1];
            safecolor[2] = 255 - desi.back.ul[2];
            c3s(safecolor);
            vert[0]=margin;
            vert[1]=(int)desi.back.height-1-margin;
            v2s(vert);
            safecolor[0] = 255 - desi.back.ur[0];
            safecolor[1] = 255 - desi.back.ur[1];
            safecolor[2] = 255 - desi.back.ur[2];
            c3s(safecolor);
            vert[0]=(int)desi.back.width-1-margin;
            vert[1]=(int)desi.back.height-1-margin;
            v2s(vert);
            safecolor[0] = 255 - desi.back.lr[0];
            safecolor[1] = 255 - desi.back.lr[1];
            safecolor[2] = 255 - desi.back.lr[2];
            c3s(safecolor);
            vert[0]=(int)desi.back.width-1-margin;
            vert[1]=margin;
            v2s(vert);
            safecolor[0] = 255 - desi.back.ll[0];
            safecolor[1] = 255 - desi.back.ll[1];
            safecolor[2] = 255 - desi.back.ll[2];
            c3s(safecolor);
            vert[0]=margin;
            vert[1]=margin;
            v2s(vert);
          endclosedline();
          }
   if (dumppending > 0) {
      DumpHandler();
      dumppending = 0;
      }
}

/*
 * Update the background on the fly.
 */
static void
BackChangedCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
XmScaleCallbackStruct *call_data;
{
   needtosave = 1;
        if (!strcmp(XtName(w), "upperLeftred"))
      desi.back.ul[0] = call_data->value;
   else if (!strcmp(XtName(w), "upperLeftgrn"))
      desi.back.ul[1] = call_data->value;
   else if (!strcmp(XtName(w), "upperLeftblu"))
      desi.back.ul[2] = call_data->value;
   else if (!strcmp(XtName(w), "upperRightred"))
      desi.back.ur[0] = call_data->value;
   else if (!strcmp(XtName(w), "upperRightgrn"))
      desi.back.ur[1] = call_data->value;
   else if (!strcmp(XtName(w), "upperRightblu"))
      desi.back.ur[2] = call_data->value;
   else if (!strcmp(XtName(w), "lowerLeftred"))
      desi.back.ll[0] = call_data->value;
   else if (!strcmp(XtName(w), "lowerLeftgrn"))
      desi.back.ll[1] = call_data->value;
   else if (!strcmp(XtName(w), "lowerLeftblu"))
      desi.back.ll[2] = call_data->value;
   else if (!strcmp(XtName(w), "lowerRightred"))
      desi.back.lr[0] = call_data->value;
   else if (!strcmp(XtName(w), "lowerRightgrn"))
      desi.back.lr[1] = call_data->value;
   else if (!strcmp(XtName(w), "lowerRightblu"))
      desi.back.lr[2] = call_data->value;

   DrawBackCB(glBack, (XtPointer)NULL, (char *)NULL);
}
/*
 * Make a label and three text fields.
 */
static Widget
CreateRgbEntry(Widget parent, char *name, short cv[3])
{
   int		n;
   Arg		args[10];
   Widget	rcmain,
   		label,
   		rgbrc,
   		red,
   		grn,
   		blu;
   char		whole_name[20];
/*
 * We need a rowcolumn to hold the label and a group of sliders.
 */
   n = 0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   rcmain = XtCreateWidget(name, xmRowColumnWidgetClass, parent, args, n);
   XtManageChild(rcmain);
/*
 * Here is the label.
 */
   n = 0;
   label = XtCreateWidget("label", xmLabelWidgetClass, rcmain, args, n);
   XtManageChild(label);
/*
 * And here is a rowcolumn to hold the sliders.
 */
   n = 0;
   XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
   rgbrc = XtCreateWidget("rgbrc", xmRowColumnWidgetClass, rcmain, args, n);
   XtManageChild(rgbrc);
/*
 * Each sliders gets a unique name for use later in the callback.
 */
   strcpy(whole_name, name);
   strcat(whole_name, "red");
   n = 0;
   red = XtCreateWidget(whole_name, xmScaleWidgetClass, rgbrc, args, n);
   XtAddCallback(red, XmNdragCallback, (XtCallbackProc)BackChangedCB, NULL);
   XtAddCallback(red, XmNvalueChangedCallback, (XtCallbackProc)BackChangedCB, NULL);
   XtManageChild(red);

   strcpy(whole_name, name);
   strcat(whole_name, "grn");
   n = 0;
   grn = XtCreateWidget(whole_name, xmScaleWidgetClass, rgbrc, args, n);
   XtAddCallback(grn, XmNdragCallback, (XtCallbackProc)BackChangedCB, NULL);
   XtAddCallback(grn, XmNvalueChangedCallback, (XtCallbackProc)BackChangedCB, NULL);
   XtManageChild(grn);

   strcpy(whole_name, name);
   strcat(whole_name, "blu");
   n = 0;
   blu = XtCreateWidget(whole_name, xmScaleWidgetClass, rgbrc, args, n);
   XtAddCallback(blu, XmNdragCallback, (XtCallbackProc)BackChangedCB, NULL);
   XtAddCallback(blu, XmNvalueChangedCallback, (XtCallbackProc)BackChangedCB, NULL);
   XtManageChild(blu);

   return rcmain;
}


void
UpdateBack(int w, int h)
{
   Arg		args[5];
   Dimension	tlwidth, tlheight;
   int		n;
/*
 * Re-size the toplevel shell.
 */
   n = 0;
   XtSetArg(args[n], XtNwidth, &tlwidth); n++;
   XtSetArg(args[n], XtNheight, &tlheight); n++;
   XtGetValues(desi.toplevel, args, n);
   n = 0;
   XtSetArg(args[n], XtNwidth, (int)tlwidth + w - (int)desi.back.width); n++;
   XtSetArg(args[n], XtNheight, (int)tlheight + h - (int)desi.back.height); n++;
   XtSetValues(desi.toplevel, args, n);
   GLXwinset(XtDisplay(desi.back.w), XtWindow(desi.back.w));
/*
 * Set the background widget to the new size.
 */
   n = 0;
   XtSetArg(args[n], XtNwidth, w); n++;
   XtSetArg(args[n], XtNheight, h); n++;
   XtSetValues(glBack, args, n);
/*
 * Update the gl viewport.
 */
   viewport(0, (Screencoord)w-1, 0, (Screencoord)h-1);
   myortho2(-0.5, (Coord)w-0.5, -0.5, (Coord)h-0.5);
/*
 * Store the result.
 */
   desi.back.width = w;
   desi.back.height = h;
/*
 * Display postscript must be re-initialized so that it works with the
 * new sized background.  This is because I have a pixmap the size of
 * the background hanging around that is used by dps.  By closing here,
 * dps will be re-initialized with the new background size the first
 * time text is displayed.
 */
   if (psinited) {
      psclose();
      psinited = 0;
      currentInfo.font= NULL;
      }
}


/*
 * This routine is called when the "Done" button of the back prefs panel
 * is clicked.
 */
static void
NewBackSizeCB(w, client_data, call_data)
Widget			w;
XtPointer		client_data;
XmAnyCallbackStruct	*call_data;
{
   Arg		args[5];
   char		*str;
   int		width, height, n;

/*
 * Get the new width.
 */
   str = XmTextGetString(xSize);
   width = (int)atoi(str);
   XtFree(str);
/*
 * Get the new height.
 */
   str = XmTextGetString(ySize);
   height = (int)atoi(str);
   XtFree(str);
/*
 * Set the background to the new size.
 */
   if (width != (int)desi.back.height || height != (int)desi.back.height)
      UpdateBack(width, height);
}

/*
 * This routine is called when the toplevel window is resized by the user.
 * When this happens, this routine will resize the Desi background to the
 * proper size.
 */
void
daResizeCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmDrawingAreaCallbackStruct	*call_data;
{
   Arg		args[2];
   Dimension	width, height;
   GenericInfo	*thisObject;
   int		n;

   switch (call_data->reason) {
      case XmCR_RESIZE:
/*
 * Get the new size of the selfmoving widget container.
 */
         n = 0;
         XtSetArg(args[n], XmNwidth, &width); n++;
         XtSetArg(args[n], XmNheight, &height); n++;
         XtGetValues(desi.container, args, n);
         if ((int)width == (int)desi.back.width && (int)height == (int)desi.back.height)
            return;
/*
 * Set the background widget to the new size.
 */
         desi.back.width = (int)width - ((int)desi.back.xoffset*2);
         desi.back.height = (int)height - ((int)desi.back.yoffset*2);
         n = 0;
         XtSetArg(args[n], XtNwidth, desi.back.width); n++;
         XtSetArg(args[n], XtNheight, desi.back.height); n++;
         XtSetValues(glBack, args, n);
/*
 * Update the gl viewport.
 */
         GLXwinset(XtDisplay(desi.toplevel), XtWindow(desi.back.w));
         viewport(0, (Screencoord)desi.back.width-1,
                  0, (Screencoord)desi.back.height-1);
         myortho2(-0.5, (Coord)desi.back.width-0.5,
                  -0.5, (Coord)desi.back.height-0.5);
/*
 * Display postscript must be re-initialized so that it works with the
 * new sized background.  This is because I have a pixmap the size of
 * the background hanging around that is used by dps.  By closing here,
 * dps will be re-initialized with the new background size the first
 * time text is displayed.
 */
         if (psinited) {
            psclose();
            psinited = 0;
            currentInfo.font= NULL;
            }
/*
 * I should redraw all of the currently displayed text objects here so that
 * their background will match that of the newly sized desi window.
 */
         thisObject = UmscListSetCurrent(theList, UmscFIRST);
         for (n=0; n<UmscListGetCount(theList); n++) {
            if (thisObject->objtype == TXTOBJ &&
                thisObject->frame == currentFrame)
               DrawText(thisObject);
            thisObject = UmscListGetNext(theList);
            }
         break;
      default:
         printf("Unknown event in daResizeCB\n");
         break;
      }
}


static void
SizeToggleCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmToggleButtonCallbackStruct	*call_data;
{
   Arg		args[5];
   int		n;
/*
 * Return if the button is unselected or if this event was triggered by
 * calling XmToggleButtonSetState.
 */
   if (!call_data->set || !call_data->event)
      return;
   if (!strcmp(XtName(w), "absize")) {
      XmTextSetString(xSize, "720");
      XmTextSetString(ySize, "486");
      }
   else if (!strcmp(XtName(w), "xlsize")) {
      XmTextSetString(xSize, "1024");
      XmTextSetString(ySize, "768");
      }
   else if (!strcmp(XtName(w), "solsize")) {
      XmTextSetString(xSize, "1024");
      XmTextSetString(ySize, "683");
      }
   else if (!strcmp(XtName(w), "cvpsize")) {
      XmTextSetString(xSize, "648");
      XmTextSetString(ySize, "512");
      }
   else if (!strcmp(XtName(w), "chrsize")) {
      XmTextSetString(xSize, "717");
      XmTextSetString(ySize, "509");
      }
   else if (!strcmp(XtName(w), "svhssize")) {
      XmTextSetString(xSize, "768");
      XmTextSetString(ySize, "486");
      }
}



/*
 * BackPopupInit -- creates but does not map BackPopup.
 */
static void
BackPrefsInit(void)
{
   int		n;
   Arg		args[10];
   Widget	rgbRowCol,
   		upperLeft,
   		upperRight,
   		lowerLeft,
   		lowerRight,
   		sep1,
   		sep2,
   		ff,
		rc1,
		rc2,
		rc3,
		xLabel,
		yLabel,
		frame,
   		safeButton,
   		doneButton;

   n = 0;
   XtSetArg(args[n], XmNmwmDecorations, MWM_DECOR_ALL |
					MWM_DECOR_RESIZEH |
					MWM_DECOR_MAXIMIZE); n++;
   XtSetArg(args[n], XmNmwmFunctions,   MWM_FUNC_ALL |
					MWM_FUNC_RESIZE |
					MWM_FUNC_MAXIMIZE); n++;
   backPrefsPanel = XmCreateFormDialog(desi.toplevel, "backPrefsPanel", args, n);

   /* add a rowcolumn for the colors */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(args[n], XmNnumColumns, 2); n++;
   rgbRowCol = XtCreateWidget("rgbRowCol", xmRowColumnWidgetClass,
                              backPrefsPanel, args, n);
   XtManageChild(rgbRowCol);
/*
 * Each of the entries will have a label and 3 text fields.
 */
   upperLeft = CreateRgbEntry(rgbRowCol, "upperLeft", desi.back.ul);
   XtManageChild(upperLeft);
   upperRight = CreateRgbEntry(rgbRowCol, "upperRight", desi.back.ur);
   XtManageChild(upperRight);
   lowerLeft = CreateRgbEntry(rgbRowCol, "lowerLeft", desi.back.ll);
   XtManageChild(lowerLeft);
   lowerRight = CreateRgbEntry(rgbRowCol, "lowerRight", desi.back.lr);
   XtManageChild(lowerRight);
/*
 * Separate the RGB sliders from the size stuff.
 */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, rgbRowCol); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   sep1 = XtCreateWidget("separator", xmSeparatorWidgetClass, backPrefsPanel,
                         args, n);
   XtManageChild(sep1);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, sep1); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNtopOffset, 10); n++;
   XtSetArg(args[n], XmNleftOffset, 10); n++;
   XtSetArg(args[n], XmNrightOffset, 10); n++;
   XtSetArg(args[n], XmNbottomOffset, 10); n++;
   frame = XtCreateWidget("frame", xmFrameWidgetClass, backPrefsPanel, args, n);
   XtManageChild(frame);
   n = 0;
   ff = XtCreateWidget("ff", xmFormWidgetClass, frame, args, n);
   XtManageChild(ff);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   rc1 = XtCreateWidget("rc1", xmRowColumnWidgetClass, ff, args, n);
   XtManageChild(rc1);
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, rc1); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   XtSetArg(args[n], XmNisHomogeneous, False); n++;
   rc2 = XtCreateWidget("rc2", xmRowColumnWidgetClass, ff, args, n);
   XtManageChild(rc2);
/*
 * Separate the size stuff from the buttons.
 */
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, frame); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   sep2 = XtCreateWidget("separator", xmSeparatorWidgetClass, backPrefsPanel,
                         args, n);
   XtManageChild(sep2);
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, sep2); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
   rc3 = XtCreateWidget("rc3", xmRowColumnWidgetClass, backPrefsPanel, args, n);
   XtManageChild(rc3);




   n = 0;
   xLabel = XtCreateWidget("xlabel", xmLabelWidgetClass, rc1, args, n);
   XtManageChild(xLabel);
   n = 0;
   yLabel = XtCreateWidget("ylabel", xmLabelWidgetClass, rc1, args, n);
   XtManageChild(yLabel);
   n = 0;
   xSize = XtCreateWidget("xsize", xmTextWidgetClass, rc1, args, n);
   XtManageChild(xSize);
   n = 0;
   ySize = XtCreateWidget("ysize", xmTextWidgetClass, rc1, args, n);
   XtManageChild(ySize);

   n = 0;
   absize = XtCreateWidget("absize", xmToggleButtonWidgetClass, rc2, args, n);
   XtAddCallback(absize, XmNvalueChangedCallback, (XtCallbackProc)SizeToggleCB, NULL);
   XtManageChild(absize);
   n = 0;
   xlsize = XtCreateWidget("xlsize", xmToggleButtonWidgetClass, rc2, args, n);
   XtAddCallback(xlsize, XmNvalueChangedCallback, (XtCallbackProc)SizeToggleCB, NULL);
   XtManageChild(xlsize);
   n = 0;
   solsize = XtCreateWidget("solsize", xmToggleButtonWidgetClass, rc2, args, n);
   XtAddCallback(solsize, XmNvalueChangedCallback, (XtCallbackProc)SizeToggleCB, NULL);
   XtManageChild(solsize);
   n = 0;
   cvpsize = XtCreateWidget("cvpsize", xmToggleButtonWidgetClass, rc2, args, n);
   XtAddCallback(cvpsize, XmNvalueChangedCallback, (XtCallbackProc)SizeToggleCB, NULL);
   XtManageChild(cvpsize);
   n = 0;
   chrsize = XtCreateWidget("chrsize", xmToggleButtonWidgetClass, rc2, args, n);
   XtAddCallback(chrsize, XmNvalueChangedCallback, (XtCallbackProc)SizeToggleCB, NULL);
   XtManageChild(chrsize);
   n = 0;
   svhssize = XtCreateWidget("svhssize",xmToggleButtonWidgetClass,rc2, args, n);
   XtAddCallback(svhssize, XmNvalueChangedCallback, (XtCallbackProc)SizeToggleCB, NULL);
   XtManageChild(svhssize);




   n = 0;
   safeButton = XtCreateWidget("safeButton", xmToggleButtonWidgetClass,
                               rc3, args, n);
   XtManageChild(safeButton);
   n = 0;
   doneButton = XtCreateWidget("doneButton", xmPushButtonWidgetClass,
                               rc3, args, n);
   XtAddCallback(doneButton, XmNactivateCallback, (XtCallbackProc)unmanageCB, (char *)backPrefsPanel);
   XtAddCallback(doneButton, XmNactivateCallback, (XtCallbackProc)NewBackSizeCB, NULL);
   XtManageChild(doneButton);

   XtManageChild(backPrefsPanel);
}

void
BackPopup()
{
   char	str[20];

   if (backPrefsPanel == NULL)
   	BackPrefsInit();
/*
 * Set the widgets to that they match the background parameters.
 */
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.upperLeft.rgbrc.upperLeftred"), desi.back.ul[0]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.upperLeft.rgbrc.upperLeftgrn"), desi.back.ul[1]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.upperLeft.rgbrc.upperLeftblu"), desi.back.ul[2]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.upperRight.rgbrc.upperRightred"), desi.back.ur[0]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.upperRight.rgbrc.upperRightgrn"), desi.back.ur[1]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.upperRight.rgbrc.upperRightblu"), desi.back.ur[2]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.lowerLeft.rgbrc.lowerLeftred"), desi.back.ll[0]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.lowerLeft.rgbrc.lowerLeftgrn"), desi.back.ll[1]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.lowerLeft.rgbrc.lowerLeftblu"), desi.back.ll[2]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.lowerRight.rgbrc.lowerRightred"), desi.back.lr[0]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.lowerRight.rgbrc.lowerRightgrn"), desi.back.lr[1]);
   XmScaleSetValue(XtNameToWidget(backPrefsPanel, "rgbRowCol.lowerRight.rgbrc.lowerRightblu"), desi.back.lr[2]);
/*
 * Set the text in the size fields.
 */
   sprintf(str, "%d", desi.back.width);
   XmTextSetString(xSize, str);
   sprintf(str, "%d", desi.back.height);
   XmTextSetString(ySize, str);
/*
 * Set the toggle buttons in the radio box.
 */
   XmToggleButtonSetState(absize, False, False);
   XmToggleButtonSetState(xlsize, False, False);
   XmToggleButtonSetState(solsize, False, False);
   XmToggleButtonSetState(cvpsize, False, False);
   XmToggleButtonSetState(chrsize, False, False);
   XmToggleButtonSetState(svhssize, False, False);
   if ((int)desi.back.width == 720 && (int)desi.back.height == 486)
      XmToggleButtonSetState(absize, True, False);
   else if ((int)desi.back.width == 1024 && (int)desi.back.height == 768)
      XmToggleButtonSetState(xlsize, True, False);
   else if ((int)desi.back.width == 1024 && (int)desi.back.height == 683)
      XmToggleButtonSetState(solsize, True, False);
   else if ((int)desi.back.width == 648 && (int)desi.back.height == 512)
      XmToggleButtonSetState(cvpsize, True, False);
   else if ((int)desi.back.width == 717 && (int)desi.back.height == 509)
      XmToggleButtonSetState(chrsize, True, False);
   else if ((int)desi.back.width == 768 && (int)desi.back.height == 486)
      XmToggleButtonSetState(svhssize, True, False);
/*
 * Display the panel.
 */
   XtManageChild(backPrefsPanel);
}

static void
UnselectBackCB(w, client_data, call_data)
Widget			w;
XtPointer		client_data;
HrAnyCallbackStruct	*call_data;
{
   Arg		args[2];
   int		n;
/*
 * For some reason, this does not unselect when shift-clicking.
 */
   n = 0;
   XtSetArg(args[n], XtNselected, False); n++;
   XtSetValues(w, args, n);
}


/*
 * Set the initial preferences.
 */
Widget
BackInit(Widget parent)
{
   Arg		args[10];
   Dimension	dwidth, dheight;
   Widget	smBack;
   int		n;

   desi.back.ul[0] = desi.back.ul[1] = desi.back.ul[2] = 0;
   desi.back.ur[0] = desi.back.ur[1] = desi.back.ur[2] = 0;
   desi.back.ll[0] = desi.back.ll[1] = desi.back.ll[2] = 0;
   desi.back.lr[0] = desi.back.lr[1] = desi.back.lr[2] = 0;
   desi.back.ul[2] = desi.back.ur[2] = 40;
   desi.back.ll[2] = desi.back.lr[2] = 80;
/*
 * Create a self moving widget for the background without any handles.
 */
   /*n = 0;
   XtSetArg(args[n], XtNallowMove, False); n++;
   XtSetArg(args[n], XtNnorthWestHandle, HrNO_HANDLE); n++;
   XtSetArg(args[n], XtNnorthHandle, HrNO_HANDLE); n++;
   XtSetArg(args[n], XtNnorthEastHandle, HrNO_HANDLE); n++;
   XtSetArg(args[n], XtNeastHandle, HrNO_HANDLE); n++;
   XtSetArg(args[n], XtNsouthEastHandle, HrNO_HANDLE); n++;
   XtSetArg(args[n], XtNsouthHandle, HrNO_HANDLE); n++;
   XtSetArg(args[n], XtNsouthWestHandle, HrNO_HANDLE); n++;
   XtSetArg(args[n], XtNwestHandle, HrNO_HANDLE); n++;
   smBack = XtCreateWidget("smBack", hrSelfMovingWidgetClass, parent, args, n);*/
/*
 * Create a glx widget for the background.
 */
   n = 0;
   XtSetArg(args[n], GlxNglxConfig, glxConfig); n++;
   /*glBack = GlxCreateMDraw(smBack, "back", args, n);*/
   /*XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, neighbor); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;*/
   XtSetArg(args[n], XmNtranslations, XtParseTranslationTable("")); n++;
   glBack = GlxCreateMDraw(parent, "back", args, n);
/*
 * Get (and save) the size of the just created glx widget.
 * The X and Y size come from the app-defaults file.
 */
   n = 0;
   XtSetArg(args[n], XtNwidth, &dwidth); n++;
   XtSetArg(args[n], XtNheight, &dheight); n++;
   XtGetValues(glBack, args, n);
   desi.back.width = dwidth;
   desi.back.height = dheight;
/*
 * Cause the background to be centered in the container widget.
 */
   n = 0;
   XtSetArg(args[n], XmNmarginWidth, &desi.back.xoffset); n++;
   XtSetArg(args[n], XmNmarginHeight, &desi.back.yoffset); n++;
   XtGetValues(parent, args, n);
/*
 * Center the glx/selfmoving thing in this form.
 */
   /*n = 0;
   XtSetArg(args[n], XtNxChild, (int)desi.back.xoffset); n++;
   XtSetArg(args[n], XtNyChild, (int)desi.back.yoffset); n++;
   XtSetValues(smBack, args, n);*/
/*
 * Add some callbacks.
 */
   /*XtAddCallback(smBack, XtNdoubleClickCallback, BackPopup, NULL);*/
   /*XtAddCallback(smBack, XtNselectCallback, UnselectBackCB, NULL);*/
   XtAddCallback(glBack, GlxNginitCallback, (XtCallbackProc)GLInitCB, 0);
   XtAddCallback(glBack, GlxNexposeCallback, (XtCallbackProc)DrawBackCB, 0);

   XtManageChild(glBack);
   /*XtManageChild(smBack);*/
   return glBack;
}
