
#include "globals.h"

/* determinate of a 3 by 3 matrix */
float determinate3x3(a11, a12, a13, a21, a22, a23, a31, a32, a33)
float a11, a12, a13, a21, a22, a23, a31, a32, a33;
{

   return(
	     a11 * (a22*a33 - a32*a23) 
	  - (a12 * (a21*a33 - a31*a23)) 
	  + (a13 * (a21*a32 - a31*a22))
	  );
}


float area(p1, p2, p3)   /* (signed) area of a triangle  */
Point2 *p1, *p2, *p3;
{
   return(0.5 * determinate3x3(p1->x,p2->x,p3->x, 
			       p1->y,p2->y,p3->y, 
			       1.0,1.0,1.0));
}


/* find the barycentric coordinate of p in triangle abc */
bary(a, b, c, p, BC) 
Point2 *a, *b,*c,*p;
Barycoord *BC;
{
   float areaABC;

   areaABC = area(a, b, c);

   BC->u = area(p, b, c) / areaABC;
   BC->v = area(a, p, c) / areaABC;
   BC->w = area(a, b, p) / areaABC;
}



/* given a barycentric coordinate of a point, and a triangle, 
   give the xy coordinates of the point */
findoldpoint(BC, oldpoly, p)
Barycoord *BC;
Point2 *oldpoly, *p;
{
   p->x = BC->u* oldpoly[0].x + BC->v* oldpoly[1].x + BC->w* oldpoly[2].x; 
   p->y = BC->u* oldpoly[0].y + BC->v* oldpoly[1].y + BC->w* oldpoly[2].y; 
}







/****************************

     X WINDOWS STUFF

     mostly from the xv program source 

*****************************/



byte *Image;			/* The result array */
byte *RawCTF;			/* The heap array to hold it, raw */


#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define MAX_PSEUDO_COLORS 256
#define PSEUDO_DEPTH 8


/*long screen;    not used globally? */
int create_called = 0;



/* get_pseudo_visual()
 *
 * This routine returns a pointer to a pseudo color visual.
 *              (an 8-bit deep window)
 */

Visual *
   get_pseudo_visual(display,screen)
Display *display;
/*long screen;*/
int screen;  
/* return a pseudo color visual structure pointer */
{
   XVisualInfo vTemplate;    /* template of the visual we want */
   XVisualInfo *visualList;  /* list of matching XVisualInfo structs */
   int i,visualsMatched;
   
   /* find visuals that have depth PSEUDO_DEPTH on the current screen */
   
   vTemplate.screen = screen;
   vTemplate.depth = PSEUDO_DEPTH;
   visualList =XGetVisualInfo(display, VisualScreenMask | VisualDepthMask,
			      &vTemplate, &visualsMatched);
   if (!visualsMatched)
   {
      fprintf(stderr,
	      "There are no 8 bit visuals on this display.\n");
      exit(2);
   }

   for (i = 0; i < visualsMatched; i++)
   {
      if (visualList[i].visual->class == PseudoColor)
      {
	 /*
	   printf("PseudoColor visual matched at %d\n",i);
	   */
	 return(visualList[i].visual);
      }
   }
   fprintf(stderr,"No visuals matched to PseudoColor.\n");
   exit(3);
   /*return(visualList[0].visual);  no sense in returning the wrong window */
}




/* SetArbitraryColorMap()
 *
 * set the colormap to an arbitrary colormap that is passed in intcmap. 
 *
 * The format of intcmap is 32 bits pre map entry, with XRGB for each byte,
 * where X is don't care and there are 8 bits for R, G, and B values.
 *
 */

#define RMASK 0xff0000
#define RSHIFT 16
#define GMASK 0xff00
#define GSHIFT 8
#define BMASK 0xff
#define BeeSHIFT 0

/* X colors are 16 bit quantities, not 8 bit! */
#define LSHIFT 8

SetArbitraryColorMap(display,cmap,pixels,ncolors,intcmap)
Display *display;
Colormap cmap;
unsigned long pixels[];
int  ncolors;
int *intcmap;

{
   int i;
   XColor my_color;
   
   my_color.flags = DoRed | DoGreen | DoBlue;  /* set all three primarys */
   for (i=0; i < ncolors; i++)
   {
      /* this routine could be made faster, but speed is not
       * critical right here...
       */
      my_color.pixel = pixels[i];
      my_color.red = ((intcmap[i] & RMASK) >> RSHIFT) << LSHIFT;
      my_color.green = ((intcmap[i] & GMASK) >> GSHIFT) << LSHIFT;
      my_color.blue = ((intcmap[i] & BMASK) >> BeeSHIFT) << LSHIFT;
      XStoreColor(display,cmap,&my_color);
   }
   XFlush(display);
}


GetEvents(display)
Display *display;
{
   XEvent xreport;
   /*	int xp;*/
   
   /*
    *  XPending should be used if you want to do a 'poll' operation
    *
    printf("start of GetEvents.\n");
    while((xp = XPending(display)) > 0)
    {
    printf("XPending returns %d\n",xp);
    XNextEvent(display, &xreport);
    if (xreport.type == ButtonPress)
    return(1);
    }
    printf("end of GetEvents.\n");
    */
   
   /* Use XNextEvent here to block until a button is pressed */
   XNextEvent(display, &xreport);
   if (xreport.type == ButtonPress)
      return(1);
   return(0);
}





CREWIN(x,y,width,height)         /* create a window */
int *x,*y,*width,*height;
{

   int borderwidth;
   int win_attr_mask;
   XSetWindowAttributes window_attributes ;
   XGCValues values;
   unsigned long valuemask;
   /*   unsigned long xinput_mask;*/
   /*	XEvent report;*/
   long depth; 
   int nplanes/*,status*/;
   unsigned long plane_masks[1];  /* must at least allocate 1 entry */
   
   
   nplanes = 0;
   pixels = (unsigned long *) 
      malloc((unsigned)(MAX_PSEUDO_COLORS * sizeof(long)));
   
   /* Open the display  - uses the value of env var DISPLAY */
   
   if (!( theDisp = XOpenDisplay(""))) {
      fprintf(stderr, "could not open display\n") ;
      fflush(stderr) ;
      exit(1) ;
   }
   theScreen = DefaultScreen(theDisp);
   depth = DisplayPlanes(theDisp,theScreen);
   
   theVisual = get_pseudo_visual(theDisp,theScreen);/*get pseudo color visual*/
   
   theCmap = XCreateColormap (theDisp, RootWindow(theDisp,theScreen),
			      theVisual, AllocNone);
   
   /*	status =*/
   XAllocColorCells(theDisp,theCmap,FALSE,plane_masks,nplanes,pixels,
		    MAX_PSEUDO_COLORS);
   
   /* pseudo color depth is 8 bit planes */
   depth = PSEUDO_DEPTH;
   /*fprintf(stderr, "window depth = %d\n", depth);*/
   
   /* x, y, width and height are passed from fortran. */
   borderwidth = 0;
   
   win_attr_mask = CWBackPixel|CWBorderPixel|CWColormap;
   window_attributes.colormap = theCmap;
   window_attributes.background_pixel = WhitePixel(theDisp,theScreen);
   window_attributes.border_pixel = BlackPixel(theDisp,theScreen);
   
   
   mainW = XCreateWindow(theDisp, RootWindow(theDisp,theScreen),
			 *x,*y,*width,*height,borderwidth,depth,InputOutput,
			 theVisual,win_attr_mask,&window_attributes);
   
   XSetWindowColormap(theDisp,mainW,theCmap);
   
   /* now create a graphics context */
   values.foreground = BlackPixel(theDisp,theScreen);
   values.background = WhitePixel(theDisp,theScreen);
   
   valuemask = GCForeground | GCBackground;
   theGC = XCreateGC(theDisp, mainW,valuemask, &values);
   
   /* now select the input events of interest */
   /*	xinput_mask =*/
   XSelectInput(theDisp,mainW,ExposureMask | KeyPressMask | ButtonPressMask
		| ButtonReleaseMask |  StructureNotifyMask
		);
   
   
   
}











/***************** more X STUFF *****************/

/****************/
HandleEvent(event)
XEvent *event;
/****************/
{

   switch (event->type) {
    case Expose:   {
       XExposeEvent *exp_event = (XExposeEvent *) event;
       
       if (exp_event->window==mainW) 
	  DrawWindow(exp_event->x,exp_event->y,
		     exp_event->width, exp_event->height);
       
    }
      break;
      
    case KeyPress: {
       XKeyEvent *key_event = (XKeyEvent *) event;
       char buf[128];
       KeySym ks;
       XComposeStatus status;
       
       XLookupString(key_event,buf,128,&ks,&status);
       if (buf[0]=='q' || buf[0]=='Q') Quit();
    }
      break;
      
    case ConfigureNotify: {
       XConfigureEvent *conf_event = (XConfigureEvent *) event;
       
       if (conf_event->window == mainW && 
	   (conf_event->width != eWIDE || conf_event->height != eHIGH))
       {
	  fprintf(stderr, "resize from ConfigureNotify %d %d   %d %d\n", 
		  conf_event->width,eWIDE, conf_event->height, eHIGH);
	  Resize(conf_event->width, conf_event->height);
       }
    }
      break;
      
      
    case CirculateNotify:
    case MapNotify:
    case DestroyNotify:
    case GravityNotify:
    case ReparentNotify:
    case UnmapNotify:    
      break;
      
    default:		/* ignore unexpected events */
      break;
   }  /* end of switch */
}


/***********************************/
void FatalError (identifier)
char *identifier;
{
   fprintf(stderr, "%s: %s\n",cmd, identifier);
   exit(-1);
}


/***********************************/
void Quit()
{
   exit(0);
}


/***********************************/
void DrawWindow(x,y,w,h)
{
   XPutImage(theDisp,mainW,theGC,expImage,x,y,x,y,w,h);
}

drawpoint(x,y,color)
int x, y;
unsigned char color;
{
   theImage->data[y*eWIDE + x] = color;
}


/***********************************/
void Resize(w,h)   /* create an expanded image of the image for the new size */
int w,h;
{
   int  ix,iy,ex,ey;
   byte *ximag,*ilptr,*ipptr,*elptr,*epptr;
   static char *rstr = "Resizing Image.  Please wait...";



/*******

      RESIZE doesn't work right  (don't resize!!)

**********/
   /*fprintf(stderr, "Resize(%dw %dh    i=%d %d e=%d %d\n", 
	   w, h, iWIDE, iHIGH, eWIDE, eHIGH);*/
   /* warning:  this code'll only run machines where int=32-bits */
   
   XResizeWindow(theDisp, mainW, w, h);
   
   if (w==iWIDE && h==iHIGH) {		/* very special case */
      if (expImage != theImage) {
	 if (expImage) XDestroyImage(expImage);
	 expImage = theImage;
	 eWIDE = iWIDE;  
	 eHIGH = iHIGH;

      }
   }
   
   else {      		/* have to do some work */

      fprintf(stderr, "resize danger\n");
      /* if it's a big image, this'll take a while.  mention it */
      if (w*h>(500*500)) {
	 XDrawImageString(theDisp,mainW,theGC,CENTERX(mfinfo,w/2,rstr),
			  CENTERY(mfinfo,h/2),rstr, strlen(rstr));
	 XFlush(theDisp);
      }
      
      /* first, kill the old expImage, if one exists */
      if (expImage && expImage != theImage) {
	 free(expImage->data);  expImage->data = NULL;
	 XDestroyImage(expImage);
      }
      
      /* create expImage of the appropriate size */
      eWIDE = w;  
      eHIGH = h;

      ximag = (byte *) malloc((unsigned)(w*h));
      expImage = XCreateImage(theDisp,theVisual,8,ZPixmap,0,ximag,
			      eWIDE,eHIGH,8,eWIDE);
      
      if (!ximag || !expImage) {
	 fprintf(stderr,"ERROR: unable to create a %dx%d image\n",w,h);
	 exit(0);
      }
      
      elptr = epptr = (byte *) expImage->data;
      
      for (ey=0;  ey<eHIGH;  ey++, elptr+=eWIDE) {
	 iy = (iHIGH * ey) / eHIGH;
	 epptr = elptr;
	 ilptr = (byte *) theImage->data + (iy * iWIDE);
	 for (ex=0;  ex<eWIDE;  ex++,epptr++) {
	    ix = (iWIDE * ex) / eWIDE;
	    ipptr = ilptr + ix;
	    *epptr = *ipptr;
	 }
      }

      /* kludge */ Resize(eWIDE, eHIGH);
   }



   
}







clearwin()
{
   int i;
   int max = iWIDE*iHIGH;
   byte *ptr = Image;

   for (i=0; i<max; i++) *ptr++ = 0;

}






copypicmaptoglobal(pic)
InternalPic *pic;
{
   int i;
   int *r, *g, *b;

   r = (int *)pic->cmap[0];
   g = (int *)pic->cmap[1];
   b = (int *)pic->cmap[2];

   for (i=0; i<256; i++) 
   {
      /*printf("%d   %dr %dg %db\n", i, *r, *g, *b);*/
      glcolor[i] =(*r++ << 16) + (*g++ << 8)+ *b++ ;
   }

}


copycmaplimit(from, to)
InternalPic *from , *to;
{
   to->numcolors = from->numcolors;
}



/* take a pair of textures in triangles, and draw a third triangle with 
   a warped, weighted version of the two input textures. */
warp(step, numsteps, trinum, bmesh, emesh, omesh, bpic, epic, outpic)
int step, numsteps, trinum;
Point2 bmesh[2][MESHSIZE][3], emesh[2][MESHSIZE][3], omesh[2][MESHSIZE][3];
InternalPic *bpic, *epic, *outpic;
{
   float pcent = ((float) step) / ((float) numsteps);
   float pcent1 = 1.0 - pcent;
   int i;
   Point2 btri[3], etri[3], otri[3];

   for (i=0; i<3; i++) 
   {
      btri[i].x=(pcent1*bmesh[FROM][trinum][i].x)+pcent*bmesh[TO][trinum][i].x;
      btri[i].y=(pcent1*bmesh[FROM][trinum][i].y)+pcent*bmesh[TO][trinum][i].y;

      etri[i].x=(pcent1*emesh[FROM][trinum][i].x)+pcent*emesh[TO][trinum][i].x;
      etri[i].y=(pcent1*emesh[FROM][trinum][i].y)+pcent*emesh[TO][trinum][i].y;

      otri[i].x=(pcent1*omesh[FROM][trinum][i].x)+pcent*omesh[TO][trinum][i].x;
      otri[i].y=(pcent1*omesh[FROM][trinum][i].y)+pcent*omesh[TO][trinum][i].y;
   }

   concave(3, otri, &GGWIN,  /* 3sided polygon, coordinates in otri, clipped */
	   pcent,        /* weighting of color from beginning texture to end */
	   btri, bpic,       /* beginning triangle and texture */
	   etri, epic, outpic);        /* ending triangle and texture */
}


copypictowin(from)
InternalPic from;
{
   int x, y;
   unsigned char *color;
   
   if (DEBUG) 
      fprintf(stderr, "copying background   %dx%d\n", from.wide, from.high);
   color = from.data;
   for (y=0; y<from.high; y++)
      for (x=0; x<from.wide; x++)
	 drawpoint(x, y, *color++);	


}


clearpic(pic, newcolor)
InternalPic *pic;
int newcolor;
{
   int max, i;
   unsigned char *color;

   color = pic->data;
   max = pic->high * pic->wide;
   for (i=0; i<max; i++) *color++ = newcolor;
}


 /* copy part of a pic to a window */
copypartpictowin(from, xmin, ymin, xmax, ymax) 
InternalPic from;
int xmin, ymin, xmax, ymax;
{
   int x, y;
   unsigned char *color;
   
      if (xmin < 0) xmin = 0;
   if (ymin < 0) ymin = 0;
   if (xmax >= from.wide) xmax = from.wide-1;
   if (ymax >= from.high) ymax = from.high-1;
   
   for (y=ymin; y<=ymax; y++)
   {
      color = &from.data[y*from.wide + xmin];
      for (x=xmin; x<=xmax; x++)
      {
	 drawpoint(x, y, *color++);	
      }
   }

}



copypic(from, to)            /* copy an entire pic, including colormaps */
InternalPic *from, *to;
{
   int x, y, i;
   unsigned char *fromcolor, *tocolor;
   
   if (to->data)
   {
      free(to->data);
   }
   to->data = (unsigned char *)malloc((unsigned) (from->wide*from->high));
   to->wide = from->wide;
   to->high = from->high;

   for (i=0; i< from->numcolors; i++)
   {
      to->cmap[0][i] = from->cmap[0][i];
      to->cmap[1][i] = from->cmap[1][i];
      to->cmap[2][i] = from->cmap[2][i];
   }
   to->numcolors = from->numcolors;
   to->originalnumcolors = from->originalnumcolors;

   fromcolor = from->data;
   tocolor = to->data;
   for (y=0; y<from->high; y++)
   {
      for (x=0; x<from->wide; x++)
      {
	 *tocolor++ = *fromcolor++;
      }
   }
}


copypartpicdata(from, to, xmin, ymin, xmax, ymax) /* copy part of a pic */
InternalPic *from, *to;
int xmin, ymin, xmax, ymax;
{
   int x, y;
   unsigned char *fromcolor, *tocolor;
   

   for (y=ymin; y<=ymax; y++)
   {
      tocolor =   &to->data  [y*to->wide  +xmin];
      fromcolor = &from->data[y*from->wide+xmin];
      for (x=xmin; x<=xmax; x++)
      {
	 *tocolor++ = *fromcolor++;
      }
   }
}






