

/*
    GLE Extrusion, Sweep and Tubing Library Version 2.1
    Copyright (C) 1991, 1993, 1995 Linas Vepstas (linas@fc.net)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Contact linas by writing to linas@fc.net or
    Linas Vepstas
    1518 Enfield Road
    Austin TX 78703-3424
*/


#ifndef PI
#define PI  3.14159265358979
#endif

/* ============================================================ */
/* The folowing defines give a kludgy way of accessing the qmesh primitive */

/*
#define bgntmesh _emu_qmesh_bgnqmesh
#define endtmesh _emu_qmesh_endqmesh
#define c3f _emu_qmesh_c3f
#define n3f _emu_qmesh_n3f
#define v3f _emu_qmesh_v3f
*/

/* ============================================================ */

extern int extrusion_join_style;


extern void up_sanity_check (gleDouble up[3],      /* up vector for contour */
                      int npoints,              /* numpoints in poly-line */
                      gleDouble point_array[][3]);   /* polyline */


extern void draw_raw_style_end_cap (int ncp,     /* number of contour points */
                             gleDouble contour[][2],     /* 2D contour */
                             gleDouble zval,             /* where to draw cap */
                             int frontwards);    /* front or back cap */

extern void draw_round_style_cap_callback (int iloop,
                                  double cap[][3],
                                  float face_color[3],
                                  gleDouble cut_vector[3],
                                  gleDouble bisect_vector[3],
                                  double norms[][3],
                                  int frontwards);

extern void extrusion_raw_join (int ncp,        /* number of contour points */
                         gleDouble contour[][2],    /* 2D contour */
                         gleDouble cont_normal[][2],/* 2D contour normal vecs */
                         gleDouble up[3],           /* up vector for contour */
                         int npoints,           /* numpoints in poly-line */
                         gleDouble point_array[][3],        /* polyline */
                         float color_array[][3],        /* color of polyline */
                         gleDouble xform_array[][2][3]);  /* 2D contour xforms */


extern void extrusion_round_or_cut_join (int ncp, /* number of contour points */
                         gleDouble contour[][2],    /* 2D contour */
                         gleDouble cont_normal[][2],/* 2D contour normal vecs */
                           gleDouble up[3],         /* up vector for contour */
                           int npoints,         /* numpoints in poly-line */
                           gleDouble point_array[][3],      /* polyline */
                           float color_array[][3],      /* color of polyline */
                           gleDouble xform_array[][2][3]);  /* 2D contour xforms */


extern void extrusion_angle_join (int ncp,      /* number of contour points */
                         gleDouble contour[][2],    /* 2D contour */
                         gleDouble cont_normal[][2],/* 2D contour normal vecs */
                           gleDouble up[3],         /* up vector for contour */
                           int npoints,         /* numpoints in poly-line */
                           gleDouble point_array[][3],      /* polyline */
                           float color_array[][3],      /* color of polyline */
                           gleDouble xform_array[][2][3]);  /* 2D contour xforms */

/* -------------------------- end of file -------------------------------- */
