/* gl.h */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Id: gl.h,v 1.9 1995/05/30 13:17:38 brianp Exp $

$Log: gl.h,v $
 * Revision 1.9  1995/05/30  13:17:38  brianp
 * added glGetTexImage(), glGetMap[dfi]v() protos, GL_AUX[123], GL_COEF,
 * GL_DOMAIN, GL_ORDER symbols
 *
 * Revision 1.8  1995/05/29  21:19:54  brianp
 * added GL_TEXTURE_WIDTH, HEIGHT, BORDER, COMPONENTS symbols
 * added glGetMaterial*, glGetPixelMap*, glGetTexGen*, glGetTexParameter* protos
 *
 * Revision 1.7  1995/05/22  17:03:21  brianp
 * Release 1.2
 *
 * Revision 1.6  1995/04/28  20:04:03  brianp
 * added GL_REPLACE_EXT texture symbol
 * fixed glGetString and glGetLighiv prototypes
 *
 * Revision 1.5  1995/04/19  13:47:05  brianp
 * renamed occurances of near and far for SCO x86 Unix
 *
 * Revision 1.4  1995/04/05  18:29:04  brianp
 * added GL_EXT_blend_* compile-time symbols
 *
 * Revision 1.3  1995/03/10  16:28:41  brianp
 * updated for blending extensions
 *
 * Revision 1.2  1995/03/04  19:45:47  brianp
 * 1.1 beta revision
 *
 * Revision 1.1  1995/02/28  21:21:03  brianp
 * Initial revision
 *
 */


#ifndef GL_H
#define GL_H


#ifdef __cplusplus
extern "C" {
#endif




/*
 * Apps can test for this symbol to do conditional compilation if needed.
 */
#define MESA



/*
 *
 * Enumerations
 *
 */

typedef enum {
	/* Boolean values */
	GL_FALSE = 0,
	GL_TRUE = 1,

	/* Data types */
        GL_BYTE,
        GL_UNSIGNED_BYTE,
        GL_SHORT,
        GL_UNSIGNED_SHORT,
        GL_INT,
        GL_UNSIGNED_INT,
        GL_FLOAT,
        GL_2_BYTES,
        GL_3_BYTES,
        GL_4_BYTES,

	/* Primitives */
	GL_LINES,
	GL_POINTS,
	GL_LINE_STRIP,
	GL_LINE_LOOP,
	GL_TRIANGLES,
	GL_TRIANGLE_STRIP,
	GL_TRIANGLE_FAN,
	GL_QUADS,
	GL_QUAD_STRIP,
	GL_POLYGON,
	GL_EDGE_FLAG,

	/* Matrix Mode */
	GL_MATRIX_MODE,
	GL_MODELVIEW,
	GL_PROJECTION,
	GL_TEXTURE,

	/* Points */
	GL_POINT_SMOOTH,
	GL_POINT_SIZE,
	GL_POINT_SIZE_GRANULARITY,
	GL_POINT_SIZE_RANGE,

	/* Lines */
	GL_LINE_SMOOTH,
	GL_LINE_STIPPLE,
	GL_LINE_STIPPLE_PATTERN,
	GL_LINE_STIPPLE_REPEAT,
	GL_LINE_WIDTH,
	GL_LINE_WIDTH_GRANULARITY,
	GL_LINE_WIDTH_RANGE,

	/* Polygons */
	GL_POINT,
	GL_LINE,
	GL_FILL,
	GL_CCW,
	GL_CW,
	GL_FRONT,
	GL_BACK,
	GL_CULL_FACE,
	GL_CULL_FACE_MODE,
	GL_POLYGON_SMOOTH,
	GL_POLYGON_STIPPLE,
	GL_FRONT_FACE,
	GL_POLYGON_MODE,

	/* Display Lists */
        GL_COMPILE,
        GL_COMPILE_AND_EXECUTE,
	GL_LIST_BASE,
	GL_LIST_INDEX,
	GL_LIST_MODE,

	/* Depth buffer */
	GL_NEVER,
	GL_LESS,
	GL_GEQUAL,
	GL_LEQUAL,
	GL_GREATER,
	GL_NOTEQUAL,
	GL_EQUAL,
	GL_ALWAYS,
	GL_DEPTH_TEST,
	GL_DEPTH_BITS,
	GL_DEPTH_CLEAR_VALUE,
	GL_DEPTH_FUNC,
	GL_DEPTH_RANGE,
	GL_DEPTH_WRITEMASK,
	GL_DEPTH_COMPONENT,

	/* Lighting */
	GL_LIGHTING,
	GL_LIGHT0,
	GL_LIGHT1,
	GL_LIGHT2,
	GL_LIGHT3,
	GL_LIGHT4,
	GL_LIGHT5,
	GL_LIGHT6,
	GL_LIGHT7,
	GL_SPOT_EXPONENT,
	GL_SPOT_CUTOFF,
	GL_CONSTANT_ATTENUATION,
	GL_LINEAR_ATTENUATION,
	GL_QUADRATIC_ATTENUATION,
	GL_AMBIENT,
	GL_DIFFUSE,
	GL_SPECULAR,
	GL_SHININESS,
	GL_EMISSION,
	GL_POSITION,
	GL_SPOT_DIRECTION,
	GL_AMBIENT_AND_DIFFUSE,
	GL_COLOR_INDEXES,
	GL_LIGHT_MODEL_TWO_SIDE,
	GL_LIGHT_MODEL_LOCAL_VIEWER,
	GL_LIGHT_MODEL_AMBIENT,
	GL_FRONT_AND_BACK,
	GL_SHADE_MODEL,
	GL_FLAT,
	GL_SMOOTH,
	GL_COLOR_MATERIAL,
	GL_COLOR_MATERIAL_FACE,
	GL_COLOR_MATERIAL_PARAMETER,
	GL_NORMALIZE,

	/* User clipping planes */
	GL_CLIP_PLANE0,
	GL_CLIP_PLANE1,
	GL_CLIP_PLANE2,
	GL_CLIP_PLANE3,
	GL_CLIP_PLANE4,
	GL_CLIP_PLANE5,

	/* Accumulation buffer */
	GL_ACCUM_RED_BITS,
	GL_ACCUM_GREEN_BITS,
	GL_ACCUM_BLUE_BITS,
	GL_ACCUM_ALPHA_BITS,
	GL_ACCUM_CLEAR_VALUE,
	GL_ACCUM,
	GL_ADD,
	GL_LOAD,
	GL_MULT,
	GL_RETURN,

	/* Alpha testing */
	GL_ALPHA_TEST,
	GL_ALPHA_TEST_REF,
	GL_ALPHA_TEST_FUNC,

	/* Blending */
	GL_BLEND,
	GL_BLEND_SRC,
	GL_BLEND_DST,
	GL_ZERO,
	GL_ONE,
	GL_SRC_COLOR,
	GL_ONE_MINUS_SRC_COLOR,
	GL_DST_COLOR,
	GL_ONE_MINUS_DST_COLOR,
	GL_SRC_ALPHA,
	GL_ONE_MINUS_SRC_ALPHA,
	GL_DST_ALPHA,
	GL_ONE_MINUS_DST_ALPHA,
	GL_SRC_ALPHA_SATURATE,

	/* Render Mode */
	GL_FEEDBACK,
	GL_RENDER,
	GL_SELECT,

	/* Feedback */
	GL_2D,
	GL_3D,
	GL_3D_COLOR,
	GL_3D_COLOR_TEXTURE,
	GL_4D_COLOR_TEXTURE,
	GL_POINT_TOKEN,
	GL_LINE_TOKEN,
	GL_LINE_RESET_TOKEN,
	GL_POLYGON_TOKEN,
	GL_BITMAP_TOKEN,
	GL_DRAW_PIXEL_TOKEN,
	GL_COPY_PIXEL_TOKEN,
	GL_PASS_THROUGH_TOKEN,

	/* Fog */
	GL_FOG,
	GL_FOG_MODE,
	GL_FOG_DENSITY,
	GL_FOG_COLOR,
	GL_FOG_INDEX,
	GL_FOG_START,
	GL_FOG_END,
	GL_LINEAR,
	GL_EXP,
	GL_EXP2,

	/* Logic Ops */
	GL_LOGIC_OP,
	GL_LOGIC_OP_MODE,
	GL_CLEAR,
	GL_SET,
	GL_COPY,
	GL_COPY_INVERTED,
	GL_NOOP,
	GL_INVERT,
	GL_AND,
	GL_NAND,
	GL_OR,
	GL_NOR,
	GL_XOR,
	GL_EQUIV,
	GL_AND_REVERSE,
	GL_AND_INVERTED,
	GL_OR_REVERSE,
	GL_OR_INVERTED,

	/* Stencil */
	GL_STENCIL_TEST,
	GL_STENCIL_WRITEMASK,
	GL_STENCIL_BITS,
	GL_STENCIL_FUNC,
	GL_STENCIL_VALUE_MASK,
	GL_STENCIL_REF,
	GL_STENCIL_FAIL,
	GL_STENCIL_PASS_DEPTH_PASS,
	GL_STENCIL_PASS_DEPTH_FAIL,
	GL_STENCIL_CLEAR_VALUE,
	GL_STENCIL_INDEX,
	GL_KEEP,
	GL_REPLACE,
	GL_INCR,
	GL_DECR,

	/* Buffers, Pixel Drawing/Reading */
	GL_NONE,
	GL_LEFT,
	GL_RIGHT,
	/*GL_FRONT,*/
	/*GL_BACK,*/
	/*GL_FRONT_AND_BACK,*/
	GL_FRONT_LEFT,
	GL_FRONT_RIGHT,
	GL_BACK_LEFT,
	GL_BACK_RIGHT,
	GL_AUX0,
	GL_AUX1,
	GL_AUX2,
	GL_AUX3,
	GL_COLOR_INDEX,
	GL_STENCIL_BUFFER,
	GL_DEPTH_BUFFER,
	GL_RED,
	GL_GREEN,
	GL_BLUE,
	GL_ALPHA,
	GL_LUMINANCE,
	GL_LUMINANCE_ALPHA,
	GL_ALPHA_BITS,
	GL_RED_BITS,
	GL_GREEN_BITS,
	GL_BLUE_BITS,
	GL_INDEX_BITS,
	GL_SUBPIXEL_BITS,
	GL_AUX_BUFFERS,
	GL_READ_BUFFER,
	GL_DRAW_BUFFER,
	GL_DOUBLEBUFFER,
	GL_STEREO,
	GL_BITMAP,
	GL_COLOR,
	GL_DEPTH,
	GL_STENCIL,
	GL_DITHER,
	GL_RGB,
	GL_RGBA,

	/* Implementation limits */
	GL_MAX_MODELVIEW_STACK_DEPTH,
	GL_MAX_PROJECTION_STACK_DEPTH,
	GL_MAX_TEXTURE_STACK_DEPTH,
	GL_MAX_ATTRIB_STACK_DEPTH,
	GL_MAX_NAME_STACK_DEPTH,
	GL_MAX_DISPLAYLISTS,
	GL_MAX_LIST_NESTING,
	GL_MAX_LIGHTS,
	GL_MAX_CLIP_PLANES,
	GL_MAX_VIEWPORT_DIMS,
	GL_MAX_PIXEL_MAP_TABLE,
	GL_MAX_EVAL_ORDER,
	GL_MAX_TEXTURE_SIZE,

	/* Gets */
	GL_ATTRIB_STACK_DEPTH,
	GL_COLOR_CLEAR_VALUE,
	GL_COLOR_WRITEMASK,
	GL_CURRENT_INDEX,
	GL_CURRENT_COLOR,
	GL_CURRENT_NORMAL,
	GL_CURRENT_RASTER_COLOR,
	GL_CURRENT_RASTER_DISTANCE,
	GL_CURRENT_RASTER_INDEX,
	GL_CURRENT_RASTER_POSITION,
	GL_CURRENT_RASTER_TEXTURE_COORDS,
	GL_CURRENT_RASTER_POSITION_VALID,
	GL_CURRENT_TEXTURE_COORDS,
	GL_INDEX_CLEAR_VALUE,
	GL_INDEX_MODE,
	GL_INDEX_WRITEMASK,
	GL_MODELVIEW_MATRIX,
	GL_MODELVIEW_STACK_DEPTH,
	GL_NAME_STACK_DEPTH,
	GL_PROJECTION_MATRIX,
	GL_PROJECTION_STACK_DEPTH,
	GL_RENDER_MODE,
	GL_RGBA_MODE,
	GL_TEXTURE_MATRIX,
	GL_TEXTURE_STACK_DEPTH,
	GL_VIEWPORT,


	/* Evaluators */
	GL_AUTO_NORMAL,
	GL_MAP1_COLOR_4,
	GL_MAP1_GRID_DOMAIN,
	GL_MAP1_GRID_SEGMENTS,
	GL_MAP1_INDEX,
	GL_MAP1_NORMAL,
	GL_MAP1_TEXTURE_COORD_1,
	GL_MAP1_TEXTURE_COORD_2,
	GL_MAP1_TEXTURE_COORD_3,
	GL_MAP1_TEXTURE_COORD_4,
	GL_MAP1_VERTEX_3,
	GL_MAP1_VERTEX_4,
	GL_MAP2_COLOR_4,
	GL_MAP2_GRID_DOMAIN,
	GL_MAP2_GRID_SEGMENTS,
	GL_MAP2_INDEX,
	GL_MAP2_NORMAL,
	GL_MAP2_TEXTURE_COORD_1,
	GL_MAP2_TEXTURE_COORD_2,
	GL_MAP2_TEXTURE_COORD_3,
	GL_MAP2_TEXTURE_COORD_4,
	GL_MAP2_VERTEX_3,
	GL_MAP2_VERTEX_4,
	GL_COEFF,
	GL_DOMAIN,
	GL_ORDER,

	/* Hints */
	GL_FOG_HINT,
	GL_LINE_SMOOTH_HINT,
	GL_PERSPECTIVE_CORRECTION_HINT,
	GL_POINT_SMOOTH_HINT,
	GL_POLYGON_SMOOTH_HINT,
	GL_DONT_CARE,
	GL_FASTEST,
	GL_NICEST,

	/* Scissor box */
	GL_SCISSOR_TEST,
	GL_SCISSOR_BOX,

	/* Pixel Mode / Transfer */
	GL_MAP_COLOR,
	GL_MAP_STENCIL,
	GL_INDEX_SHIFT,
	GL_INDEX_OFFSET,
	GL_RED_SCALE,
	GL_RED_BIAS,
	GL_GREEN_SCALE,
	GL_GREEN_BIAS,
	GL_BLUE_SCALE,
	GL_BLUE_BIAS,
	GL_ALPHA_SCALE,
	GL_ALPHA_BIAS,
	GL_DEPTH_SCALE,
	GL_DEPTH_BIAS,
	GL_PIXEL_MAP_S_TO_S_SIZE,
	GL_PIXEL_MAP_I_TO_I_SIZE,
	GL_PIXEL_MAP_I_TO_R_SIZE,
	GL_PIXEL_MAP_I_TO_G_SIZE,
	GL_PIXEL_MAP_I_TO_B_SIZE,
	GL_PIXEL_MAP_I_TO_A_SIZE,
	GL_PIXEL_MAP_R_TO_R_SIZE,
	GL_PIXEL_MAP_G_TO_G_SIZE,
	GL_PIXEL_MAP_B_TO_B_SIZE,
	GL_PIXEL_MAP_A_TO_A_SIZE,
	GL_PIXEL_MAP_S_TO_S,
	GL_PIXEL_MAP_I_TO_I,
	GL_PIXEL_MAP_I_TO_R,
	GL_PIXEL_MAP_I_TO_G,
	GL_PIXEL_MAP_I_TO_B,
	GL_PIXEL_MAP_I_TO_A,
	GL_PIXEL_MAP_R_TO_R,
	GL_PIXEL_MAP_G_TO_G,
	GL_PIXEL_MAP_B_TO_B,
	GL_PIXEL_MAP_A_TO_A,
	GL_PACK_ALIGNMENT,
	GL_PACK_LSB_FIRST,
	GL_PACK_ROW_LENGTH,
	GL_PACK_SKIP_PIXELS,
	GL_PACK_SKIP_ROWS,
	GL_PACK_SWAP_BYTES,
	GL_UNPACK_ALIGNMENT,
	GL_UNPACK_LSB_FIRST,
	GL_UNPACK_ROW_LENGTH,
	GL_UNPACK_SKIP_PIXELS,
	GL_UNPACK_SKIP_ROWS,
	GL_UNPACK_SWAP_BYTES,
	GL_ZOOM_X,
	GL_ZOOM_Y,

	/* Texture mapping */
	GL_TEXTURE_ENV,
	GL_TEXTURE_ENV_MODE,
	GL_TEXTURE_1D,
	GL_TEXTURE_2D,
	GL_TEXTURE_WRAP_S,
	GL_TEXTURE_WRAP_T,
	GL_TEXTURE_MAG_FILTER,
	GL_TEXTURE_MIN_FILTER,
	GL_TEXTURE_ENV_COLOR,
	GL_TEXTURE_GEN_S,
	GL_TEXTURE_GEN_T,
	GL_TEXTURE_GEN_MODE,
	GL_TEXTURE_BORDER_COLOR,
	GL_TEXTURE_WIDTH,
	GL_TEXTURE_HEIGHT,
	GL_TEXTURE_BORDER,
	GL_TEXTURE_COMPONENTS,
	GL_NEAREST_MIPMAP_NEAREST,
	GL_NEAREST_MIPMAP_LINEAR,
	GL_LINEAR_MIPMAP_NEAREST,
	GL_LINEAR_MIPMAP_LINEAR,
	GL_OBJECT_LINEAR,
	GL_OBJECT_PLANE,
	GL_EYE_LINEAR,
	GL_EYE_PLANE,
	GL_SPHERE_MAP,
	GL_DECAL,
	GL_MODULATE,
	GL_NEAREST,
	GL_REPEAT,
	GL_CLAMP,
	GL_S,
	GL_T,
	GL_R,
	GL_Q,
	GL_TEXTURE_GEN_R,
	GL_TEXTURE_GEN_Q,

	/* Utility */
	GL_VENDOR,
	GL_RENDERER,
	GL_VERSION,
	GL_EXTENSIONS,

	/* Errors */
	GL_INVALID_VALUE,
        GL_INVALID_ENUM,
        GL_INVALID_OPERATION,
	GL_STACK_OVERFLOW,
	GL_STACK_UNDERFLOW,
	GL_OUT_OF_MEMORY,

	/* Extensions */
	GL_CONSTANT_COLOR_EXT,
	GL_ONE_MINUS_CONSTANT_COLOR_EXT,
	GL_CONSTANT_ALPHA_EXT,
	GL_ONE_MINUS_CONSTANT_ALPHA_EXT,
	GL_BLEND_EQUATION_EXT,
	GL_MIN_EXT,
	GL_MAX_EXT,
	GL_FUNC_ADD_EXT,
	GL_FUNC_SUBTRACT_EXT,
	GL_FUNC_REVERSE_SUBTRACT_EXT,
	GL_BLEND_COLOR_EXT,
	GL_REPLACE_EXT
} GLenum;


/* GL_NO_ERROR must be zero */
#define GL_NO_ERROR GL_FALSE



/* Compile-time tests for extensions: */
#define GL_EXT_blend_color	1
#define GL_EXT_blend_logic_op	1
#define GL_EXT_blend_minmax	1
#define GL_EXT_blend_subtract	1



typedef enum {
	GL_ACCUM_BUFFER_BIT	= 0x1,
	GL_COLOR_BUFFER_BIT	= 0x2,
	GL_CURRENT_BIT		= 0x4,
	GL_DEPTH_BUFFER_BIT	= 0x8,
	GL_ENABLE_BIT		= 0x10,
	GL_EVAL_BIT		= 0x20,
	GL_FOG_BIT		= 0x40,
	GL_HINT_BIT		= 0x80,
	GL_LIGHTING_BIT		= 0x100,
	GL_LINE_BIT		= 0x200,
	GL_LIST_BIT		= 0x400,
	GL_PIXEL_MODE_BIT	= 0x800,
	GL_POINT_BIT		= 0x1000,
	GL_POLYGON_BIT		= 0x2000,
	GL_POLYGON_STIPPLE_BIT	= 0x4000,
	GL_SCISSOR_BIT		= 0x8000,
	GL_STENCIL_BUFFER_BIT	= 0x10000,
	GL_TEXTURE_BIT		= 0x20000,
	GL_TRANSFORM_BIT	= 0x40000,
	GL_VIEWPORT_BIT		= 0x80000,
	GL_ALL_ATTRIB_BITS	= 0xfffff
} GLbitfield;




/*
 *
 * Data types (architecture dependent in some cases)
 *
 */

/*  C type		GL type		storage                            */
/*-------------------------------------------------------------------------*/
typedef void		GLvoid;
typedef unsigned char	GLboolean;
typedef signed char	GLbyte;		/* 1-byte signed */
typedef short           GLshort;	/* 2-byte signed */
typedef int             GLint;		/* 4-byte signed */
typedef unsigned char	GLubyte;	/* 1-byte unsigned */
typedef unsigned short	GLushort;	/* 2-byte unsigned */
typedef unsigned int	GLuint;		/* 4-byte unsigned */
typedef int             GLsizei;	/* 4-byte signed */
typedef float           GLfloat;	/* single precision float */
typedef float           GLclampf;	/* single precision float in [0,1] */
typedef double          GLdouble;	/* double precision float */
typedef double          GLclampd;	/* double precision float in [0,1] */




/*
 *
 * Assorted functions
 *
 */


extern void glClearIndex( GLfloat c );

extern void glClearColor( GLclampf red,
			  GLclampf green,
			  GLclampf blue,
			  GLclampf alpha );

extern void glClear( GLbitfield mask );

extern void glIndexMask( GLuint mask );

extern void glColorMask( GLboolean red, GLboolean green,
			 GLboolean blue, GLboolean alpha );

extern void glAlphaFunc( GLenum func, GLclampf ref );

extern void glBlendFunc( GLenum sfactor, GLenum dfactor );

extern void glLogicOp( GLenum opcode );

extern void glCullFace( GLenum mode );

extern void glFrontFace( GLenum mode );

extern void glPointSize( GLfloat size );

extern void glLineWidth( GLfloat width );

extern void glLineStipple( GLint factor, GLushort pattern );

extern void glPolygonMode( GLenum face, GLenum mode );

extern void glPolygonStipple( const GLubyte *mask );

extern void glGetPolygonStipple( GLubyte *mask );

extern void glEdgeFlag( GLboolean flag );

extern void glEdgeFlagv( const GLboolean *flag );

extern void glScissor( GLint x, GLint y, GLsizei width, GLsizei height);

extern void glClipPlane( GLenum plane, const GLdouble *equation );

extern void glGetClipPlane( GLenum plane, GLdouble *equation );

extern void glDrawBuffer( GLenum mode );

extern void glReadBuffer( GLenum mode );

extern void glEnable( GLenum cap );

extern void glDisable( GLenum cap );

extern GLboolean glIsEnabled( GLenum cap );


extern void glGetBooleanv( GLenum pname, GLboolean *params );

extern void glGetDoublev( GLenum pname, GLdouble *params );

extern void glGetFloatv( GLenum pname, GLfloat *params );

extern void glGetIntegerv( GLenum pname, GLint *params );


extern void glPushAttrib( GLbitfield mask );

extern void glPopAttrib( void );



/*
 *
 * Miscellaneous
 *
 */


extern GLint glRenderMode( GLenum mode );

extern GLenum glGetError( void );

extern const GLubyte *glGetString( GLenum name );

extern void glFinish( void );

extern void glFlush( void );

extern void glHint( GLenum target, GLenum mode );



/*
 *
 * Depth Buffer
 *
 */


extern void glClearDepth( GLclampd depth );

extern void glDepthFunc( GLenum func );

extern void glDepthMask( GLboolean flag );

extern void glDepthRange( GLclampd near_val, GLclampd far_val );


extern void glClearAccum( GLfloat red, GLfloat green,
			  GLfloat blue, GLfloat alpha );

extern void glAccum( GLenum op, GLfloat value );



/*
 *
 * Transform
 *
 */


extern void glMatrixMode( GLenum mode );

extern void glOrtho( GLdouble left, GLdouble right,
		     GLdouble bottom, GLdouble top,
		     GLdouble near_val, GLdouble far_val );

extern void glFrustum( GLdouble left, GLdouble right,
		       GLdouble bottom, GLdouble top,
		       GLdouble near_val, GLdouble far_val );

extern void glViewport( GLint x, GLint y, GLsizei width, GLsizei height );

extern void glPushMatrix( void );

extern void glPopMatrix( void );

extern void glLoadIdentity( void );

extern void glLoadMatrixd( const GLdouble *m );
extern void glLoadMatrixf( const GLfloat *m );

extern void glMultMatrixd( const GLdouble *m );
extern void glMultMatrixf( const GLfloat *m );

extern void glRotated( GLdouble angle, GLdouble x, GLdouble y, GLdouble z );
extern void glRotatef( GLfloat angle, GLfloat x, GLfloat y, GLfloat z );

extern void glScaled( GLdouble x, GLdouble y, GLdouble z );
extern void glScalef( GLfloat x, GLfloat y, GLfloat z );

extern void glTranslated( GLdouble x, GLdouble y, GLdouble z );
extern void glTranslatef( GLfloat x, GLfloat y, GLfloat z );



/*
 *
 * Display Lists
 *
 */


extern GLboolean glIsList( GLuint list );

extern void glDeleteLists( GLuint list, GLsizei range );

extern GLuint glGenLists( GLsizei range );

extern void glNewList( GLuint list, GLenum mode );

extern void glEndList( void );

extern void glCallList( GLuint list );

extern void glCallLists( GLsizei n, GLenum type, const GLvoid *lists );

extern void glListBase( GLuint base );



/*
 *
 * Drawing Functions
 *
 */

extern void glBegin( GLenum mode );

extern void glEnd( void );


extern void glVertex2d( GLdouble x, GLdouble y );
extern void glVertex2f( GLfloat x, GLfloat y );
extern void glVertex2i( GLint x, GLint y );
extern void glVertex2s( GLshort x, GLshort y );

extern void glVertex3d( GLdouble x, GLdouble y, GLdouble z );
extern void glVertex3f( GLfloat x, GLfloat y, GLfloat z );
extern void glVertex3i( GLint x, GLint y, GLint z );
extern void glVertex3s( GLshort x, GLshort y, GLshort z );

extern void glVertex4d( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void glVertex4f( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void glVertex4i( GLint x, GLint y, GLint z, GLint w );
extern void glVertex4s( GLshort x, GLshort y, GLshort z, GLshort w );

extern void glVertex2dv( const GLdouble *v );
extern void glVertex2fv( const GLfloat *v );
extern void glVertex2iv( const GLint *v );
extern void glVertex2sv( const GLshort *v );

extern void glVertex3dv( const GLdouble *v );
extern void glVertex3fv( const GLfloat *v );
extern void glVertex3iv( const GLint *v );
extern void glVertex3sv( const GLshort *v );

extern void glVertex4dv( const GLdouble *v );
extern void glVertex4fv( const GLfloat *v );
extern void glVertex4iv( const GLint *v );
extern void glVertex4sv( const GLshort *v );


extern void glNormal3b( GLbyte nx, GLbyte ny, GLbyte nz );
extern void glNormal3d( GLdouble nx, GLdouble ny, GLdouble nz );
extern void glNormal3f( GLfloat nx, GLfloat ny, GLfloat nz );
extern void glNormal3i( GLint nx, GLint ny, GLint nz );
extern void glNormal3s( GLshort nx, GLshort ny, GLshort nz );

extern void glNormal3bv( const GLbyte *v );
extern void glNormal3dv( const GLdouble *v );
extern void glNormal3fv( const GLfloat *v );
extern void glNormal3iv( const GLint *v );
extern void glNormal3sv( const GLshort *v );


extern void glIndexd( GLdouble c );
extern void glIndexf( GLfloat c );
extern void glIndexi( GLint c );
extern void glIndexs( GLshort c );

extern void glIndexdv( const GLdouble *c );
extern void glIndexfv( const GLfloat *c );
extern void glIndexiv( const GLint *c );
extern void glIndexsv( const GLshort *c );


extern void glColor3b( GLbyte red, GLbyte green, GLbyte blue );
extern void glColor3d( GLdouble red, GLdouble green, GLdouble blue );
extern void glColor3f( GLfloat red, GLfloat green, GLfloat blue );
extern void glColor3i( GLint red, GLint green, GLint blue );
extern void glColor3s( GLshort red, GLshort green, GLshort blue );
extern void glColor3ub( GLubyte red, GLubyte green, GLubyte blue );
extern void glColor3ui( GLuint red, GLuint green, GLuint blue );
extern void glColor3us( GLushort red, GLushort green, GLushort blue );

extern void glColor4b( GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha );
extern void glColor4d( GLdouble red, GLdouble green,
		       GLdouble blue, GLdouble alpha );
extern void glColor4b( GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha );
extern void glColor4f( GLfloat red, GLfloat green,
		       GLfloat blue, GLfloat alpha );
extern void glColor4i( GLint red, GLint green, GLint blue, GLint alpha );
extern void glColor4s( GLshort red, GLshort green,
		       GLshort blue, GLshort alpha );
extern void glColor4ub( GLubyte red, GLubyte green,
		        GLubyte blue, GLubyte alpha );
extern void glColor4ui( GLuint red, GLuint green, GLuint blue, GLuint alpha );
extern void glColor4us( GLushort red, GLushort green,
		        GLushort blue, GLushort alpha );


extern void glColor3bv( const GLbyte *v );
extern void glColor3dv( const GLdouble *v );
extern void glColor3fv( const GLfloat *v );
extern void glColor3iv( const GLint *v );
extern void glColor3sv( const GLshort *v );
extern void glColor3ubv( const GLubyte *v );
extern void glColor3uiv( const GLuint *v );
extern void glColor3usv( const GLushort *v );

extern void glColor4bv( const GLbyte *v );
extern void glColor4dv( const GLdouble *v );
extern void glColor4fv( const GLfloat *v );
extern void glColor4iv( const GLint *v );
extern void glColor4sv( const GLshort *v );
extern void glColor4ubv( const GLubyte *v );
extern void glColor4uiv( const GLuint *v );
extern void glColor4usv( const GLushort *v );


extern void glTexCoord1d( GLdouble s );
extern void glTexCoord1f( GLfloat s );
extern void glTexCoord1i( GLint s );
extern void glTexCoord1s( GLshort s );

extern void glTexCoord2d( GLdouble s, GLdouble t );
extern void glTexCoord2f( GLfloat s, GLfloat t );
extern void glTexCoord2i( GLint s, GLint t );
extern void glTexCoord2s( GLshort s, GLshort t );

extern void glTexCoord3d( GLdouble s, GLdouble t, GLdouble r );
extern void glTexCoord3f( GLfloat s, GLfloat t, GLfloat r );
extern void glTexCoord3i( GLint s, GLint t, GLint r );
extern void glTexCoord3s( GLshort s, GLshort t, GLshort r );

extern void glTexCoord4d( GLdouble s, GLdouble t, GLdouble r, GLdouble q );
extern void glTexCoord4f( GLfloat s, GLfloat t, GLfloat r, GLfloat q );
extern void glTexCoord4i( GLint s, GLint t, GLint r, GLint q );
extern void glTexCoord4s( GLshort s, GLshort t, GLshort r, GLshort q );

extern void glTexCoord1dv( const GLdouble *v );
extern void glTexCoord1fv( const GLfloat *v );
extern void glTexCoord1iv( const GLint *v );
extern void glTexCoord1sv( const GLshort *v );

extern void glTexCoord2dv( const GLdouble *v );
extern void glTexCoord2fv( const GLfloat *v );
extern void glTexCoord2iv( const GLint *v );
extern void glTexCoord2sv( const GLshort *v );

extern void glTexCoord3dv( const GLdouble *v );
extern void glTexCoord3fv( const GLfloat *v );
extern void glTexCoord3iv( const GLint *v );
extern void glTexCoord3sv( const GLshort *v );

extern void glTexCoord4dv( const GLdouble *v );
extern void glTexCoord4fv( const GLfloat *v );
extern void glTexCoord4iv( const GLint *v );
extern void glTexCoord4sv( const GLshort *v );


extern void glRasterPos2d( GLdouble x, GLdouble y );
extern void glRasterPos2f( GLfloat x, GLfloat y );
extern void glRasterPos2i( GLint x, GLint y );
extern void glRasterPos2s( GLshort x, GLshort y );

extern void glRasterPos3d( GLdouble x, GLdouble y, GLdouble z );
extern void glRasterPos3f( GLfloat x, GLfloat y, GLfloat z );
extern void glRasterPos3i( GLint x, GLint y, GLint z );
extern void glRasterPos3s( GLshort x, GLshort y, GLshort z );

extern void glRasterPos4d( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void glRasterPos4f( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void glRasterPos4i( GLint x, GLint y, GLint z, GLint w );
extern void glRasterPos4s( GLshort x, GLshort y, GLshort z, GLshort w );

extern void glRasterPos2dv( const GLdouble *v );
extern void glRasterPos2fv( const GLfloat *v );
extern void glRasterPos2iv( const GLint *v );
extern void glRasterPos2sv( const GLshort *v );

extern void glRasterPos3dv( const GLdouble *v );
extern void glRasterPos3fv( const GLfloat *v );
extern void glRasterPos3iv( const GLint *v );
extern void glRasterPos3sv( const GLshort *v );

extern void glRasterPos4dv( const GLdouble *v );
extern void glRasterPos4fv( const GLfloat *v );
extern void glRasterPos4iv( const GLint *v );
extern void glRasterPos4sv( const GLshort *v );


extern void glRectd( GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2 );
extern void glRectf( GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2 );
extern void glRecti( GLint x1, GLint y1, GLint x2, GLint y2 );
extern void glRects( GLshort x1, GLshort y1, GLshort x2, GLshort y2 );


extern void glRectdv( const GLdouble *v1, const GLdouble *v2 );
extern void glRectfv( const GLfloat *v1, const GLfloat *v2 );
extern void glRectiv( const GLint *v1, const GLint *v2 );
extern void glRectsv( const GLshort *v1, const GLshort *v2 );



/*
 *
 * Lighting Functions
 *
 */

extern void glShadeModel( GLenum mode );

extern void glLightf( GLenum light, GLenum pname, GLfloat param );
extern void glLighti( GLenum light, GLenum pname, GLint param );
extern void glLightfv( GLenum light, GLenum pname, const GLfloat *params );
extern void glLightiv( GLenum light, GLenum pname, const GLint *params );

extern void glGetLightfv( GLenum light, GLenum pname, GLfloat *params );
extern void glGetLightiv( GLenum light, GLenum pname, GLint *params );

extern void glLightModelf( GLenum pname, GLfloat param );
extern void glLightModeli( GLenum pname, GLint param );
extern void glLightModelfv( GLenum pname, const GLfloat *params );
extern void glLightModeliv( GLenum pname, const GLint *params );

extern void glMaterialf( GLenum face, GLenum pname, GLfloat param );
extern void glMateriali( GLenum face, GLenum pname, GLint param );
extern void glMaterialfv( GLenum face, GLenum pname, const GLfloat *params );
extern void glMaterialiv( GLenum face, GLenum pname, const GLint *params );

extern void glGetMaterialfv( GLenum face, GLenum pname, GLfloat *params );
extern void glGetMaterialiv( GLenum face, GLenum pname, GLint *params );

extern void glColorMaterial( GLenum face, GLenum mode );




/*
 *
 * Raster functions
 *
 */

extern void glPixelZoom( GLfloat xfactor, GLfloat yfactor );

extern void glPixelStoref( GLenum pname, GLfloat param );
extern void glPixelStorei( GLenum pname, GLint param );

extern void glPixelTransferf( GLenum pname, GLfloat param );
extern void glPixelTransferi( GLenum pname, GLint param );

extern void glPixelMapfv( GLenum map, GLint mapsize, const GLfloat *values );
extern void glPixelMapuiv( GLenum map, GLint mapsize, const GLuint *values );
extern void glPixelMapusv( GLenum map, GLint mapsize, const GLushort *values );

extern void glGetPixelMapfv( GLenum map, GLfloat *values );
extern void glGetPixelMapuiv( GLenum map, GLuint *values );
extern void glGetPixelMapusv( GLenum map, GLushort *values );

extern void glBitmap( GLsizei width, GLsizei height,
		      GLfloat xorig, GLfloat yorig,
		      GLfloat xmove, GLfloat ymove,
		      const GLubyte *bitmap );

extern void glReadPixels( GLint x, GLint y, GLsizei width, GLsizei height,
			  GLenum format, GLenum type, GLvoid *pixels );

extern void glDrawPixels( GLsizei width, GLsizei height,
			  GLenum format, GLenum type, const GLvoid *pixels );

extern void glCopyPixels( GLint x, GLint y, GLsizei width, GLsizei height,
			  GLenum type );



/*
 *
 * Stencil functions
 *
 */

extern void glStencilFunc( GLenum func, GLint ref, GLuint mask );

extern void glStencilMask( GLuint mask );

extern void glStencilOp( GLenum fail, GLenum zfail, GLenum zpass );

extern void glClearStencil( GLint s );



/*
 *
 * Texture mapping
 *
 */

extern void glTexGend( GLenum coord, GLenum pname, GLdouble param );
extern void glTexGenf( GLenum coord, GLenum pname, GLfloat param );
extern void glTexGeni( GLenum coord, GLenum pname, GLint param );

extern void glTexGendv( GLenum coord, GLenum pname, const GLdouble *params );
extern void glTexGenfv( GLenum coord, GLenum pname, const GLfloat *params );
extern void glTexGeniv( GLenum coord, GLenum pname, const GLint *params );

extern void glGetTexGendv( GLenum coord, GLenum pname, GLdouble *params );
extern void glGetTexGenfv( GLenum coord, GLenum pname, GLfloat *params );
extern void glGetTexGeniv( GLenum coord, GLenum pname, GLint *params );


extern void glTexEnvf( GLenum target, GLenum pname, GLfloat param );
extern void glTexEnvi( GLenum target, GLenum pname, GLint param );

extern void glTexEnvfv( GLenum target, GLenum pname, const GLfloat *params );
extern void glTexEnviv( GLenum target, GLenum pname, const GLint *params );

extern void glGetTexEnvfv( GLenum target, GLenum pname, GLfloat *params );
extern void glGetTexEnviv( GLenum target, GLenum pname, GLint *params );


extern void glTexParameterf( GLenum target, GLenum pname, GLfloat param );
extern void glTexParameteri( GLenum target, GLenum pname, GLint param );

extern void glTexParameterfv( GLenum target, GLenum pname,
			      const GLfloat *params );
extern void glTexParameteriv( GLenum target, GLenum pname,
			      const GLint *params );

extern void glGetTexParameterfv( GLenum target, GLenum pname, GLfloat *params);
extern void glGetTexParameteriv( GLenum target, GLenum pname, GLint *params );

extern void glGetTexLevelParameterfv( GLenum target, GLint level,
				      GLenum pname, GLfloat *params );
extern void glGetTexLevelParameteriv( GLenum target, GLint level,
				      GLenum pname, GLint *params );


extern void glTexImage1D( GLenum target, GLint level, GLint components,
			  GLsizei width, GLint border,
			  GLenum format, GLenum type, const GLvoid *pixels );

extern void glTexImage2D( GLenum target, GLint level, GLint components,
			  GLsizei width, GLsizei height, GLint border,
			  GLenum format, GLenum type, const GLvoid *pixels );

extern void glGetTexImage( GLenum target, GLint level, GLenum format,
			   GLenum type, GLvoid *pixels );



/*
 *
 * Evaluators
 *
 */


extern void glMap1d( GLenum target, GLdouble u1, GLdouble u2, GLint stride,
		     GLint order, const GLdouble *points );
extern void glMap1f( GLenum target, GLfloat u1, GLfloat u2, GLint stride,
		     GLint order, const GLfloat *points );

extern void glMap2d( GLenum target,
		     GLdouble u1, GLdouble u2, GLint ustride, GLint uorder,
		     GLdouble v1, GLdouble v2, GLint vstride, GLint vorder,
		     const GLdouble *points );
extern void glMap2f( GLenum target,
		     GLfloat u1, GLfloat u2, GLint ustride, GLint uorder,
		     GLfloat v1, GLfloat v2, GLint vstride, GLint vorder,
		     const GLfloat *points );

extern void glGetMapdv( GLenum target, GLenum query, GLdouble *v );
extern void glGetMapfv( GLenum target, GLenum query, GLfloat *v );
extern void glGetMapiv( GLenum target, GLenum query, GLint *v );

extern void glEvalCoord1d( GLdouble u );
extern void glEvalCoord1f( GLfloat u );

extern void glEvalCoord1dv( const GLdouble *u );
extern void glEvalCoord1fv( const GLfloat *u );

extern void glEvalCoord2d( GLdouble u, GLdouble v );
extern void glEvalCoord2f( GLfloat u, GLfloat v );

extern void glEvalCoord2dv( const GLdouble *u );
extern void glEvalCoord2fv( const GLfloat *u );

extern void glMapGrid1d( GLint un, GLdouble u1, GLdouble u2 );
extern void glMapGrid1f( GLint un, GLfloat u1, GLfloat u2 );

extern void glMapGrid2d( GLint un, GLdouble u1, GLdouble u2,
			 GLint vn, GLdouble v1, GLdouble v2 );
extern void glMapGrid2f( GLint un, GLfloat u1, GLfloat u2,
			 GLint vn, GLfloat v1, GLfloat v2 );

extern void glEvalPoint1( GLint i );

extern void glEvalPoint2( GLint i, GLint j );

extern void glEvalMesh1( GLenum mode, GLint i1, GLint i2 );

extern void glEvalMesh2( GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2 );



/*
 *
 * Fog
 *
 */

extern void glFogf( GLenum pname, GLfloat param );

extern void glFogi( GLenum pname, GLint param );

extern void glFogfv( GLenum pname, const GLfloat *params );

extern void glFogiv( GLenum pname, const GLint *params );



/*
 *
 * Selection and Feedback
 *
 */

extern void glFeedbackBuffer( GLsizei size, GLenum type, GLfloat *buffer );

extern void glPassThrough( GLfloat token );

extern void glSelectBuffer( GLsizei size, GLuint *buffer );

extern void glInitNames( void );

extern void glLoadName( GLuint name );

extern void glPushName( GLuint name );

extern void glPopName( void );



/*
 *
 * Unimplemented functions
 *
 */



/*
 *
 * Extensions
 *
 */

extern void glBlendEquationEXT( GLenum mode );

extern void glBlendColorEXT( GLclampf red, GLclampf green,
			     GLclampf blue, GLclampf alpha );



#ifdef __cplusplus
}
#endif

#endif
