#include <stdio.h>
#include <Sender.h>
#include <Receiver.h>

/*
 *	This program takes two arguments: the name of the application
 *	to be found, and a flag specifying whether a new copy of the
 *	application is to be launched, whether it is open or not.
 *	To set the flag to force a new copy of the app to be launched,
 *	type anything for the second argument; the existence of
 *	argv[2] is enough to set the flag.
 *
 *	This program will send the GetPortFromName
 *	message to the local Port Manager, asking for the port
 *	number of the application passed in as argument.  If the
 *	application is currently registered, the Port Manager will
 *	reply with the Port information for that application.  If the
 *	application is not currently running, the SenderGetPortFromName()
 *	method will attempt to launch the application, wait a few seconds,
 *	then ask the Port Manager again if the application is running.
 *
 *	Usage:
 *		getPortFromName <applicationName> [new]
 */

main(int argc, char** argv)
{
  Sender*	sender;
  Receiver*	receiver;
  Port		senderPort;
  Port		appPort;
  PortArray*	appList = (PortArray*)NULL;
  int		counter;
  int		result = 0;
  char*		strdup(char*);

  printf("Starting the test.\n");
  senderPort.hostName = strdup("localhost");
  senderPort.portNumber = PortMgrPortNumber;
  sender = NewSender(&senderPort);				    /* Make a connection with the Port Manager */
  appPort.appName = argv[1];					    /* Fill in Port information for the app being requested */
  if (argc > 2)							    /* Check if this application should launch a new copy... */
    appPort.hostName = LaunchNewApp;				    /* ...of the app specified in argv[1] */
  else
    appPort.hostName = "localhost";
  result = SenderGetPortFromName(sender, &appPort, &appList);	    /* Try to get the requested application's Port information */
  if (result !=0)
  {
    printf("The GetPortFromName message failed for some reason.\n");
    printf("Either the application was not open, or it could not\n");
    printf("be launched, or the Port Manager did not respond.\n");
    exit(result);
  }
  if (appList)							    /* GetPortFromName message was successful */
    {
      printf("Information about apps named %s that are currently registered\n");
      printf("with the Port Manager:\n\n");
      for (counter = 0; counter < appList->numberOfPorts; counter++)
	{
	  printf("%d. Name: %s \t Host: %s \t Port: %d\n",
		 counter+1,
		 appList->portArray[counter].appName,
		 appList->portArray[counter].hostName,
		 appList->portArray[counter].portNumber);
	}
      exit(0);
    }
}
