/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/vcrEdit/RCS/videoObjects.c,v 0.23 92/10/01 17:14:25 drapeau Exp $ */
/* $Log:	videoObjects.c,v $
 * Revision 0.23  92/10/01  17:14:25  drapeau
 * Updated the Config structures for several of the devices supported by the
 * VideoObject library, to reflect improvements in the library's serial line
 * driver code.
 * 
 * Revision 0.22  92/09/04  17:08:49  drapeau
 * Updated file to account for changes in serial line communications.
 * 
 * Revision 1.14  92/09/03  10:25:12  drapeau
 * Changed communications settings for the NEC driver configuration.
 * 
 * Revision 1.13  92/09/02  17:14:04  drapeau
 * Modified device-specific Config structs to reflect the addition of a
 * new field, "flowControl".
 * 
 * Revision 1.12  92/09/01  16:58:56  drapeau
 * A couple of changes:
 * * Updated copyright notice.
 * * Updated default Config structures to reflect new methods added to the
 *   VideoObject.
 * * Cosmetic changes to make code easier to read.
 * * Added function prototypes for better ANSI compliance.
 * 
 * Revision 1.11  92/07/30  15:15:57  drapeau
 * Improved method for setting asynchronous read function.  The previous
 * version, although designed to be independent of any window system or
 * programming toolkit, was still too reliant on the XView toolkit.  This
 * error no longer exists.
 * Also, minor change to PrintDiagnostics() function; it no longer
 * explicitly terminates with a "\n"; the caller must decide that a
 * "\n" is wanted at the end of the string.
 * 
 * Revision 1.10  92/06/16  23:49:15  drapeau
 * Made a number of changes:
 * * Added support for the Sony CVD1000 (aka "Vdeck") device.
 * * Added 'SetAsynchReadFunction' so as to allow the use of generic toolkit
 *   notify functions for file reads.  This is the first step toward making
 *   the VideoObject toolkit-neutral.
 * 
 * Revision 1.0  91/11/15  17:38:28  collab
 * Initial revision
 * 
 * Revision 0.18  91/09/29  16:12:47  lim
 * Put in all drivers.
 * Added DisplayChoice.
 * 
 * Revision 0.17  91/09/24  22:01:29  lim
 * 1. Used relative filename for driver header file.
 * 
 * Revision 0.16  91/08/24  18:00:57  lim
 * Implemented PrintDiagnostics.
 * 
 * Revision 0.15  91/08/23  17:24:48  lim
 * Included NECDriver.h
 * Clear Marker has been removed as one of the video
 * object functions.
 * 
 * Revision 0.14  91/08/21  10:52:54  lim
 * Added second parameter to DevInit(serialPort).
 * 
 * Revision 0.13  91/08/17  20:45:50  lim
 * 1. Configuration no longer has field for 'interruptibleSegmentPlay'.
 * 2. NECInterrupt becomes NECClearMarker.
 * 
 * Revision 0.12  91/08/15  13:04:51  lim
 * *** empty log message ***
 * 
 * Revision 0.11  91/08/09  11:05:29  lim
 * Moved 'NECDriver.h' from 'vcrEdit.h'
 * 
 * Revision 0.10  91/08/08  17:32:34  lim
 * Initial revision.
 * 
 * Revision 0.11  91/08/07  13:33:39  lim
 * 1. DevInit() now returns pointer to VideoObject.
 * 2. Added instance pointer, "theObject" to all public function calls.
 * 3. DisplayError() is added so that device drivers can call it to 
 * display error messages.
 * 
 * Revision 0.10  91/08/02  12:45:00  lim
 * Initial revision.
 *  */

/* WRITING NEW APPLICATION...
 * 1. Replace the header file below with the header file for your own application.
 */

#include "vcrEdit.h"
#include <Pioneer4200Driver.h>
#include <PanasonicOptDriver.h>
#include <Pioneer6000Driver.h>
#include <Sony1550Driver.h>
#include <NECDriver.h>
#include <CVD1000Driver.h>

/* ADDING NEW DRIVERS...
 * 1. Add name of player to the array below.
 * 2. Increment 'numDevices'.
 */

char allDevices[MaxDevices][MaxNameLength]= 
{
  "Pioneer4200",
  "Pioneer6000",
  "Panasonic2026",
  "Sony1550",
  "NEC",
  "CVD1000"
  }
;
int numDevices = 6;


/* INCLUDE VIDEO OBJECTS HERE */


/* Video Object for Pioneer4200 */

static Config Pioneer4200Config = 
{
  "Pioneer4200",
  "/dev/ttya",
  4800,
  10,
  8,
  NoParity,
  No,
  No,
  120,
  -1
  }
;

static VideoObject Pioneer4200Obj = 
{
  &Pioneer4200Config,
  Pioneer4200Play,
  Pioneer4200PlayFromTo,
  Pioneer4200FastForward,
  Pioneer4200Reverse,
  Pioneer4200CalcSpeed,
  Pioneer4200PlayAtSpeedDir,
  Pioneer4200Step,
  Pioneer4200Still,
  Pioneer4200Stop,
  Pioneer4200SetDefaults,
  Pioneer4200SetAudio,
  Pioneer4200SetVideo,
  Pioneer4200SetAddMode,
  Pioneer4200SetAddressDisplay,
  Pioneer4200Eject,
  Pioneer4200Power,
  Pioneer4200QueryFrame,
  Pioneer4200QueryChapter,
  Pioneer4200QueryAudio,
  Pioneer4200QueryVideo,
  Pioneer4200QueryMedium,
  Pioneer4200QueryStatus, 
  Pioneer4200Ping,
  NULL,
  NULL
  }
;

/* Video Object for CVD1000 */

static Config CVD1000Config = 
{
  "CVD1000",
  "/dev/ttya",
  9600,
  -1,
  8,
  NoParity,
  No,
  No,
  60,
  -1
  }
;

static VideoObject CVD1000Obj = 
{
  &CVD1000Config,
  CVD1000Play,
  CVD1000PlayFromTo,
  CVD1000FastForward,
  CVD1000Reverse,
  CVD1000CalcSpeed,
  CVD1000PlayAtSpeedDir,
  CVD1000Step,
  CVD1000Still,
  CVD1000Stop,
  CVD1000SetDefaults,
  CVD1000SetAudio,
  CVD1000SetVideo,
  CVD1000SetAddMode,
  CVD1000SetAddressDisplay,
  CVD1000Eject,
  CVD1000Power,
  CVD1000QueryFrame,
  CVD1000QueryChapter,
  CVD1000QueryAudio,
  CVD1000QueryVideo,
  CVD1000QueryMedium,
  CVD1000QueryStatus, 
  CVD1000Ping,
  CVD1000Record,
  CVD1000RecordFromTo
  }
;

/* Video Object for PanasonicOpticalDiskPlayer */

static Config PanasonicOptConfig = 
{
  "Panasonic2026",
  "/dev/ttyb",
  9600,
  10,
  8,
  NoParity,
  No,
  No,
  300, 
  -1
  }
;

static VideoObject PanasonicOptObj = 
{
  &PanasonicOptConfig,
  PanasonicOptPlay,
  PanasonicOptPlayFromTo,
  PanasonicOptFastForward,
  PanasonicOptReverse,
  PanasonicOptCalcSpeed,
  PanasonicOptPlayAtSpeedDir,
  PanasonicOptStep,
  PanasonicOptStill,
  PanasonicOptStop,						    
  PanasonicOptSetDefaults,					    
  PanasonicOptSetAudio,					    
  PanasonicOptSetVideo,
  NULL,
  PanasonicOptSetAddressDisplay,
  PanasonicOptEject,
  NULL,
  PanasonicOptQueryFrame,
  NULL,
  NULL,
  NULL,
  PanasonicOptQueryMedium,
  PanasonicOptQueryStatus,
  PanasonicOptPing,
  NULL,
  NULL
  }
;

/* Video Object for Pioneer6000 */

static Config Pioneer6000Config = 
{
  "Pioneer6000",
  "/dev/ttyb",
  9600,
  10,
  8,
  NoParity,
  No,
  No,
  90,
  -1
  }
;

static VideoObject Pioneer6000Obj = 
{
  &Pioneer6000Config,
  Pioneer6000Play,
  Pioneer6000PlayFromTo,
  Pioneer6000FastForward,
  Pioneer6000Reverse,
  Pioneer6000CalcSpeed,
  Pioneer6000PlayAtSpeedDir,
  Pioneer6000Step,
  Pioneer6000Still,
  Pioneer6000Stop,						    
  Pioneer6000SetDefaults,					    
  Pioneer6000SetAudio,					    
  Pioneer6000SetVideo,
  NULL,
  Pioneer6000SetAddressDisplay,
  Pioneer6000Eject,
  NULL,
  Pioneer6000QueryFrame,
  NULL,
  NULL,
  NULL,
  NULL,
  Pioneer6000QueryStatus,
  Pioneer6000Ping,
  NULL,
  NULL
  }
;

/* Video Object for Sony1550 */

static Config Sony1550Config = 
{
  "Sony1550",
  "/dev/ttyb",
  1200,
  -1,
  8,
  NoParity,
  No,
  No,
  90,
  -1
  }
;

static VideoObject Sony1550Obj = 
{
  &Sony1550Config,
  Sony1550Play,
  Sony1550PlayFromTo,
  Sony1550FastForward,
  Sony1550Reverse,
  Sony1550CalcSpeed,
  Sony1550PlayAtSpeedDir,
  Sony1550Step,
  Sony1550Still,
  Sony1550Stop,						    
  Sony1550SetDefaults,					    
  Sony1550SetAudio,					    
  Sony1550SetVideo,
  Sony1550SetAddMode,
  Sony1550SetAddressDisplay,
  Sony1550Eject,
  NULL,
  Sony1550QueryFrame,
  Sony1550QueryChapter,
  NULL,
  NULL,
  Sony1550QueryMedium,
  Sony1550QueryStatus,
  Sony1550Ping,
  NULL,
  NULL
  }
;


/* Video Object for NEC PC VCR */

static Config NECConfig = 
{
  "NEC",
  "/dev/ttya",
  1200,
  13,
  8,
  NoParity,
  No,
  No,
  270,
  -1
  }
;

static VideoObject NECObj = 
{
  &NECConfig,
  NECPlay,
  NECPlayFromTo,
  NECFastForward,
  NECReverse,
  NECCalcSpeed,
  NECPlayAtSpeedDir,
  NECStep,
  NECStill,
  NECStop,
  NECSetDefaults,
  NECSetAudio,
  NECSetVideo,
  NECSetAddressingMode,
  NULL,
  NECEject,
  NECPower,
  NECQueryFrame,
  NULL,
  NECQueryAudio,
  NECQueryVideo,
  NECReadHeader,
  NECQueryStatus,
  NECPing,
  NECRecord,
  NECRecordFromTo
  }
;


/* DevInit builds the video object for the appropriate ...
 * ... device and sets up the serial line.  It returns the ...
 * ... pointer to the video object.
 */

VideoObject*
  DevInit(char*	deviceName,
	  char* serialPort)
{
  VideoObject* myVideo;
  
  /* ADDING NEW DRIVERS
     ... Add statements for new device here, as another else-if statement */
  
  if (strcmp(deviceName, "Pioneer4200") == 0)			    /* Set the video object to the appropriate variable */
    myVideo = BuildVideoObject(&Pioneer4200Obj);
  else if (strcmp(deviceName, "Sony1550") == 0)
    myVideo = BuildVideoObject(&Sony1550Obj);
  else if (strcmp(deviceName, "Panasonic2026") == 0)
    myVideo = BuildVideoObject(&PanasonicOptObj);
  else if (strcmp(deviceName, "Pioneer6000") == 0)
    myVideo = BuildVideoObject(&Pioneer6000Obj);
  else if (strcmp(deviceName, "NEC") == 0)
    myVideo = BuildVideoObject(&NECObj);			    
  else if (strcmp(deviceName, "CVD1000") == 0)
    myVideo = BuildVideoObject(&CVD1000Obj);			    
  
  if (PlayerVerified(myVideo, serialPort) != -1)		    /* Sets up serial line for communicating with the device */
    if (SetSerialLine(myVideo->DevConfig, serialPort))
      return myVideo;
    else
      return NULL;
  else
    return NULL;
}								    /* end function DevInit */



/* WRITING NEW APPLICATIONS... 
 * Optional : Replace the code within DisplayError() if a different 
 * error notification function is desired.
 *
 * DO NOT remove the function DisplayError().
 * 
 * DisplayError() is useful in displaying errors other than those dealing
 * with the device.
 */

/* WRITING NEW DRIVERS...
 * IMPORTANT : 
 * Video drivers should be written such that any detectable error
 * is decoded into English and placed into at most 2 strings. Then the
 * driver is responsible for calling DisplayError() which displays the
 * errors appropriately to the user.
 */

/* DisplayError takes 2 strings that explain the error condition encountered.
 */
void
DisplayError(char* errorMsg1,
	     char* errorMsg2)
{
  notice_prompt(vcrEdit_window1->window1, NULL,
		NOTICE_MESSAGE_STRINGS,
		errorMsg1,
		errorMsg2,
		NULL,
		NOTICE_BUTTON,	"OK", 100,
		NULL);
}


/* Display choice message */
int
DisplayChoice(char* msg1,
	      char* msg2,
	      char* r1,
	      char* r2)
{
  int result = notice_prompt(vcrEdit_window1->window1, NULL,
			     NOTICE_MESSAGE_STRINGS,
			     msg1, msg2,
			     NULL,
			     NOTICE_BUTTON_YES, r1,
			     NOTICE_BUTTON_NO, r2, 
			     NULL);
  return result;
  
}


void
PrintDiagnostics(char* msg)
{
  if (diagMode == Yes)
    fprintf(stderr, "%s", msg);
}


static int (*callbackProc)(int);				    /* Pointer to function called when asynch read is needed */

    
Notify_value MyAsyncCallback(Notify_client	client,
			     int		fd)
{
  return((*callbackProc) (fd));
}								    /* end function MyAsyncCallback */



void 
SetAsynchReadFunction(int	(*callback)(int),
		      int	fd,
		      int	onOrOff)
{
  /* Code here would use the callback function provided to be
     called when input occurred on the file descriptor of "theObject".
     For XView, the code might be this:
     */
  callbackProc = callback;
  
  if (onOrOff == FeatureOn)
    notify_set_input_func((Notify_client) AppClient, 
			  MyAsyncCallback, fd);
  else
    notify_set_input_func((Notify_client) AppClient,
			  NOTIFY_FUNC_NULL, fd);		    /* Turn off automatic read */
}								    /* end function SetAsynchReadFunction */
