/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/vcrEdit/RCS/vcrEditOptions.c,v 0.25 92/06/15 14:37:13 drapeau Exp Locker: drapeau $ */
/* $Log:	vcrEditOptions.c,v $
 * Revision 0.25  92/06/15  14:37:13  drapeau
 * Minor change, removed declaration of variable "chosenHost[]" since it is
 * already declared in vcrEdit.h.
 * 
 * Revision 0.24  92/05/14  00:04:16  drapeau
 * * Modified SetPlayer() function: it is no longer called when the
 *   author chooses a player model (the interface was confusing).  Now
 *   it is called only when a new button, labelled "Set Player", is
 *   pressed.
 * * Removed the function "SetPort()" since it is no longer needed, due
 *   to the addition of the "Set Player" button.
 * 
 * Revision 0.23  91/09/29  16:10:35  lim
 * 1. Removed mySerialPort, because we have additional field in
 * port setting ("Default").
 * 2. If player initialization fails in any way or is terminated,
 * player setting is reset to "None".
 * 3. If player initialization fails (NULL video object returned)
 * the user will be notified to check player/serial line.
 * 
 * Revision 0.22  91/09/26  12:33:15  lim
 * Changed 'host' to 'chosenHost' and 'chosenHost' is
 * made global.
 * 
 * Revision 0.21  91/09/03  10:33:14  lim
 * Checked for valid Sender & Receiver before disconnecting in SetNetworkHost.
 * 
 * Revision 0.20  91/08/30  15:15:12  lim
 * Changed error message for no sender.
 * 
 * Revision 0.19  91/08/29  12:12:56  lim
 * Added 'Defaults' to serial port.
 * 
 * Revision 0.18  91/08/28  12:52:35  lim
 * 1. Added SetPreSearch() function, which allows user to choose if
 * presearching should be done when performing on the TimeLine.
 * 
 * Revision 0.17  91/08/27  11:12:52  lim
 * Done button also calls SetNetworkHost(), in case the user did not
 * hit return when he typed in the network host name.
 * 
 * Revision 0.16  91/08/24  18:00:08  lim
 * Implemented PrintDiagnostics. With command line flag '-d', the 
 * app will launch such that it prints all diag messages.
 * 
 * Revision 0.15  91/08/21  10:52:30  lim
 * *** empty log message ***
 * 
 * Revision 0.14  91/08/21  10:44:29  lim
 * Fixed bug about serial port setting. Now, 'mySerialPort' will be
 * set if the video object has not yet been initialized so that only
 * upon initialization will SetSerialLine be called.
 * This setting overrides both the ~/.Xdefaults setting AND the setting
 * coded in the video library.
 * 
 * Revision 0.13  91/08/20  15:21:52  lim
 * currTape is reset to "NULL" if we switch serial ports, because the
 * device is potentially a different one, and therefore what used to be in
 * the old device will no longer be what is in the new device.
 * 
 * Revision 0.12  91/08/16  12:34:29  lim
 * 1. Change serial port setting when setting up driver.
 * 2. Added optionsNetworkHost, which allows users to register with a
 *    PortManager after launching app.
 * 3. Info button moved here.
 * 
 * Revision 0.11  91/08/08  16:33:52  lim
 * 1. Added instance pointer to each public videoObject function call.
 * 2. Able to choose device to use vcrEdit with, using SetPlayer().
 * 
 * Revision 0.10  91/07/16  16:17:10  lim
 * Initial revision.
 *  */

#include "vcrEdit.h"
static char optrcsid[] = "$Header: /Source/Media/collab/vcrEdit/RCS/vcrEditOptions.c,v 0.25 92/06/15 14:37:13 drapeau Exp Locker: drapeau $";
VideoObject* myVideo;						    /* Current video Object */

/* 	OPTIONS FOR CONTROLLING DISPLAY, SEARCH MODE, AUDIO (POPUP WINDOW 1) 	*/

/*
 * Notify callback function for `optionsPlayerStg'.
 */
void SetPlayer(Panel_item item, Event *event)
{
  int		maxSpeed;
  int		choice;
  int		portSelection;
  int		value;
  char		chosenPlayerMsg[27+MaxNameLength];
  char		chosenPortMsg[29];
  char*		playPort;
  Display*	display;
  
  value = xv_get(vcrEdit_optionsPopup->optionsPlayerStg, PANEL_VALUE); /* Determine currently-selected player, if any */
  if (value == 0)						    /* Chose "None" => Return immediately */
    return;
  sprintf(chosenPlayerMsg, "You have chosen the %s player", 
	  allDevices[value-1]);
  portSelection = (int) xv_get(vcrEdit_optionsPopup->port,
			       PANEL_VALUE);
  switch (portSelection)
  {
   case 0:
    strcpy(chosenPortMsg, "and the default serial port.");
    break;
   case 1:
    strcpy(chosenPortMsg, "and serial port A.");
    break;
   case 2:
    strcpy(chosenPortMsg, "and serial port B.");
    break;
  }
  choice = notice_prompt(vcrEdit_optionsPopup->optionsPopup,	    /* Let user confirm player and serial port */
			 NULL, 
			 NOTICE_MESSAGE_STRINGS, chosenPlayerMsg,
			 chosenPortMsg,
			 "Please confirm player and",
			 "serial port selections.",
			 NULL,
			 NOTICE_BUTTON_YES, "Cancel",
			 NOTICE_BUTTON_NO, "OK", 
			 NULL);
  
  if (choice == NOTICE_YES)
  {
    xv_set(vcrEdit_optionsPopup->optionsPlayerStg, PANEL_VALUE, 0, NULL); /* Set player back to "None" */
    return;
  }
  strcpy(deviceName, allDevices[value-1]);			    /* The 0th item is "None" */
  switch (portSelection)
  {
   case 0:
    myVideo = DevInit(deviceName, NULL);
    break;
   case 1:
    myVideo = DevInit(deviceName, "/dev/ttya");
    break;
   case 2:
    myVideo = DevInit(deviceName, "/dev/ttyb");
    break;
  }
  if (myVideo)
  {
    maxSpeed = GetDeviceMaxSpeed(myVideo);			    /* Get max speed for current device */
    xv_set(vcrEdit_window1->speedSlider,			    /* Set slider values to correspond exactly to the ... */
	   PANEL_MIN_VALUE, -(maxSpeed),			    /* ... maximum number of frames per second the player ... */
	   PANEL_MAX_VALUE, maxSpeed,				    /* ... can play */
	   NULL);
    DevSetDefaults(myVideo, 3, 0, 0, 0);			    /* Set device to default settings */
    if (portSelection == 0)
    {
      display = (Display*) xv_get(vcrEdit_window1->window1, XV_DISPLAY); /* Put serial port on options panel */
      playPort = XGetDefault(display, deviceName, "serialPort");
      if (playPort == NULL)
      {
	if ((strcmp(myVideo->DevConfig->serialPort, "/dev/ttya") == 0) || 
	    (strcmp(myVideo->DevConfig->serialPort, "na") == 0))    /* Defaults to /dev/ttya */
	  xv_set(vcrEdit_optionsPopup->port, PANEL_VALUE, 1, NULL); 
	else 
	  if (strcmp(myVideo->DevConfig->serialPort, "/dev/ttyb") == 0)
	    xv_set(vcrEdit_optionsPopup->port, PANEL_VALUE, 2, NULL); 
      }
      else
	if (strcmp(playPort, "/dev/ttya") == 0)
	  xv_set(vcrEdit_optionsPopup->port, PANEL_VALUE, 1, NULL); 
	else
	  xv_set(vcrEdit_optionsPopup->port, PANEL_VALUE, 2, NULL); 
    }
  }
  else
  {
    notice_prompt(vcrEdit_optionsPopup->optionsPopup,		    /* Player has not responded */
		  NULL, 
		  NOTICE_MESSAGE_STRINGS, "The player has failed to respond.", " ",
		  "Please check that :",
		  "1. You have chosen the correct player.                             ",
		  "2. The player is connected at the serial port you selected.",
		  "3. The baud rate and other player attributes are correct.  ",
		  "4. The player is not busy.                                                 ",
		  " ",
		  "and try again.",
		  NULL,
		  NOTICE_BUTTON, "OK", 100,
		  NULL);
    xv_set(vcrEdit_optionsPopup->optionsPlayerStg, PANEL_VALUE, 0, NULL); /* Set player back to "None" */
  }
  /* gxv_start_connections DO NOT EDIT THIS SECTION */
  
  /* gxv_end_connections */
}								    /* end function SetPlayer */


/*
 * Notify callback function for `optionsNetworkHost'.
 */
void
  SetNetworkHost(Panel_item item, Event* event)
{
  char* tmp;
  Port senderPort;
  char diagMsg[30];
  
  tmp = (char *) xv_get(item, PANEL_VALUE);
  if ((strlen(tmp) == 0) || (chosenHost && (strcmp(tmp, chosenHost) == 0)))
    return;
  else
    strcpy(chosenHost, tmp);
  
  if (sender && receiver)
    SenderDisconnectFromPortMgr(sender,&(receiver->receivePort));
  
  sender = NULL;
  receiver = NULL;
  
  senderPort.hostName = chosenHost;
  senderPort.portNumber = PortMgrPortNumber;
  sender = NewSender(&senderPort);
  if (!sender)
  {
    DisplayError("Host name is not valid", "Or Port Manager is not active");
    return;
  }
  receiver = NewReceiver(sender, "vcrEdit", receiverPort);
  sprintf(diagMsg, "Listening on port %d.\n", receiver->transport->xp_port);
  PrintDiagnostics(diagMsg);
  
  return;
}								    /* end function SetNetworkHost */


/*
 * Notify callback function for `optionsInfoButton'.
 */
void
Info(item, event)
        Panel_item      item;
        Event           *event;
{
  xv_set(vcrEdit_infoPopup->infoPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
  xv_set(vcrEdit_infoPopup->infoPopup, XV_SHOW, TRUE, NULL);
}


/*
 * Notify callback function for `optionsVideoStg'.
 */

void
VideoSelect(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
  DevSetVideo(myVideo, value);
}

/*
 * Notify callback function for `optionsMutedScreen'.
 */
void
ScreenSelect(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
  int brightness;

  if (strcmp(deviceName, "NEC") != 0)
    return;
  
 brightness = xv_get(vcrEdit_optionsPopup->optionsBrightStg, 
			  PANEL_VALUE);
  NECScreenSelect(myVideo, value, brightness);
}

/*
 * Notify callback function for `optionsBrightStg'.
 */
void
BrightSelect(item, value, event)
        Panel_item	item;
	int		value;
	Event		*event;
{
  int color;

  if (strcmp(deviceName, "NEC") != 0)
    return;

  color = xv_get(vcrEdit_optionsPopup->optionsMutedScreen,
		     PANEL_VALUE) +1;
  NECScreenSelect(myVideo, color, value);
}


/*
 * Notify callback function for `optionsAudioStg'.
 * Select audio setting 
 */
void
AudioSelect(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
  switch (value) 
  {
   case 0 : xv_set(vcrEdit_window1->window1, FRAME_RIGHT_FOOTER, 
		   "Audio : Mute", NULL);
    break;
   case 1 : xv_set(vcrEdit_window1->window1, FRAME_RIGHT_FOOTER, 
		   "Audio : Left", NULL);
    break;
   case 2 : xv_set(vcrEdit_window1->window1, FRAME_RIGHT_FOOTER, 
		   "Audio : Right", NULL);
    break;
   case 3 : xv_set(vcrEdit_window1->window1, FRAME_RIGHT_FOOTER, 
		   "Audio : Stereo", NULL);
    break;
   case 4 : xv_set(vcrEdit_window1->window1, FRAME_RIGHT_FOOTER,
		   "Audio : Normal", NULL);
    break;
  }
  DevSetAudio(myVideo, value);
  
}


/*
 * Notify callback function for `optionsPreSearch'.
 */
void
SetPreSearch(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
  if (value)							    /* Yes, presearch! */
    preSearch = Yes;
  else
    preSearch = No;
}


/*
 * Notify callback function for `optionsDoneButton'.
 * Calls SetNetworkHost
 * To close the options popup window
 */
void
Done(item, event)
        Panel_item      item;
        Event           *event;
{
  SetNetworkHost(vcrEdit_optionsPopup->optionsNetworkHost, NULL);
  xv_set(vcrEdit_optionsPopup->optionsPopup, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
  xv_set(vcrEdit_optionsPopup->optionsPopup, XV_SHOW, FALSE, NULL);
}

