/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/cdEdit/RCS/main.h,v 2.12 92/07/17 16:32:44 drapeau Exp $ */
/* $Log:	main.h,v $
 * Revision 2.12  92/07/17  16:32:44  drapeau
 * Minor change to preprocessor symbol to avoid possible name conflicts.
 * 
 * Revision 2.11  92/05/29  12:37:43  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 2.10  92/01/03  17:50:06  drapeau
 * Removed inclusion of string.h, letting XView header files include
 * the appropriate definitions.
 * 
 * Revision 2.0  91/10/06  21:01:41  chua
 * Update to version 2.0
 * 
 * Revision 1.25  91/09/24  16:26:49  chua
 * Changed the MaxListSize from 1000 to 100 (unlikely anybody will reach 100 entries in
 * an edit list).
 * 
 * 
 * Revision 1.24  91/09/18  17:26:50  chua
 * Removed the hard path for the include files.
 * 
 * Revision 1.23  91/09/04  11:39:12  chua
 * Added a few extern declarations of functions (errors given by xsaber).
 * 
 * Revision 1.22  91/09/03  15:35:24  chua
 * Do not include the "getopt.h" file here.  Only include it in the cdEdit.c file, 
 * where getopt is used.
 * 
 * Revision 1.21  91/09/03  15:31:43  chua
 * Added the copyright header.
 * 
 * Changed the constants from all capitalized to initial capitalized only.
 * 
 * Added and deleted some variable declarations.
 * 
 * Revision 1.2  91/07/10  11:33:17  chua
 * Deleted the quit variable, as we now use a quit interpose function instead.
 * 
 * Revision 1.1  91/07/09  16:47:27  chua
 * Added a new variable, quit, to keep track of whether the quit button has been pressed.
 * 
 * Revision 1.0  91/07/08  13:46:07  chua
 * Initial revision
 *  */

static char cdEditHrcsid[] = "$Header: /Source/Media/collab/cdEdit/RCS/main.h,v 2.12 92/07/17 16:32:44 drapeau Exp $";

#ifndef _cdEditMain_
#define _cdEditMain_

#include <stdio.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <scsi/scsi.h>
#include <scsi/targets/srdef.h>
#include <sun/dkio.h>
#include <gdd.h>
#include "msf.h"
#include "toc.h"
#include "cdEdit_ui.h"
#include "ConnectPortManager_ui.h"
#include <MAEstro.h>
#include <Sender.h>
#include <Receiver.h>

#define MaxListSize 100
#define MaxLabelLength 256

#define LoadFile	0					    /* Optypes used for checking if changes have been made. */ 
#define DeleteAll 	1
#define QuitcdEdit	2
#define CloseFile	3

#define StopMode	0
#define PlayMode	1
#define PauseMode	2
#define DurationMode 	3
#define Nothing		4

#define Equal 0
#define Greater 1
#define Less 2

#define Current 0
#define Whole 1
#define Clear 2

#define Relative 0
#define Absolute 1

#define OK 	0
#define Error	1

cdEdit_window1_objects				*cdEdit_window1;
cdEdit_EditPopup_objects			*cdEdit_EditPopup;
cdEdit_PreviewPopup_objects			*cdEdit_PreviewPopup;
cdEdit_InfoPopup_objects			*cdEdit_InfoPopup;
ConnectPortManager_PortManagerPopup_objects	*cdEdit_PortManagerPopup;

extern void OpenDoc();						    /* Network protocol functions and variables */
extern void SetSelection();
extern void PerformSelection();
extern char **GetDoc();
extern MAESelection* GetSelection();
extern void HaltSelection();
extern void PauseSelection();
extern void ResumeSelection();
extern void HideApplication();
extern void ShowApplication();
extern IconData *GetAppIcon();

extern int starttrack[MaxListSize];
extern int startmin[MaxListSize];
extern int startsec[MaxListSize];
extern int startframe[MaxListSize];
extern int endtrack[MaxListSize];
extern int endmin[MaxListSize];
extern int endsec[MaxListSize];
extern int endframe[MaxListSize];
extern int volume[MaxListSize];
extern int balance[MaxListSize];
extern int duration[MaxListSize];
extern char label[MaxListSize][MaxLabelLength];		   
extern Xv_font *font;						   

extern int editmin;
extern int editsec;
extern int editTotalTracks;
extern int editnum;
extern int lines;
extern int change;
extern char *cdfilename;
extern int offset;
extern Msf offsetStart;
extern int playerState;
extern int discInPlayer;

extern int fd;	
extern Toc toc;

extern Sender *tempSender;
extern Sender *sender;
extern Receiver *receiver;
extern Port senderPort;
extern int ReceiverPortNumber;					   

extern int numTracks;
extern int startTrack;
extern int endTrack;
extern int displayType;		

extern void EditDone();
extern Notify_value TimerNotify();

extern void AlertMessage();
extern int OpenHandler();
extern int SaveHandler();
extern void LoadStartEnd();
extern int SetDuration();
extern void PreviewStartEnd();
extern void EditAdd();
extern void EditDeleteAll();
extern void SetVolume();
extern void Eject();
extern void cdInit();
extern void CheckOptions();
extern void UpdateHeader();
extern void DimButtons();
extern Msf GetCurrentStart();
extern Msf GetCurrentEnd();
extern void Stop();
extern void Pause();
extern void Play();
extern void GetStartEnd();
extern Msf ConvertRelativeToAbsolute();
extern void UpdateTime();
extern Toc ReadDiscToc();
extern void PrintOnList();
extern void PrintNumEdit();
extern void ConnectPortManager();


#endif
