/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/cdEdit/RCS/connect.c,v 2.0 91/10/06 21:01:15 chua Exp $ */
/* $Log:	connect.c,v $
 * Revision 2.0  91/10/06  21:01:15  chua
 * Update to version 2.0
 * 
 * Revision 1.11  91/09/04  11:35:08  chua
 * Delete the temphostName variable in ConnectPortManager. (not used)
 * 
 * Revision 1.10  91/09/03  15:34:27  chua
 * Rename the version number to 1.10 from 0.99
 * 
 * Revision 0.99  91/09/03  14:44:08  chua
 * This file contains the functions that deal with the PortManager popup window and the
 * connecting and disconnecting to port managers.
 * 
 * The functions are:
 * 
 * NewPortManager: text notify function for the new port manager field in the PortManager
 * 		   popup window.  This will call the ConnectPortManager function.
 * 
 * ConnectPortManager: Tries to create a connection with the port manager specified in
 *  		       the new port manager textfield. If successful, disconnect from the
 * 		       previous port manager.
 * 
 * ClosePortManagerPopup: Closes the PortManager popup window.
 * 
 * ConnectPortManagerHandler: Opens the PortManager popup window.
 *  */

static char connectrcsid[] = "$Header: /Source/Media/collab/cdEdit/RCS/connect.c,v 2.0 91/10/06 21:01:15 chua Exp $";

#include "main.h"

Sender *tempSender;

/*
 * Notify callback function for `NewPortManagerText'.
 * Calls the notify function for the ConnectPortManagerButton when a return is pressed.
 */
Panel_setting NewPortManager(item, event)
     Panel_item	item;
     Event		*event;
{
  ConnectPortManager(item, NULL);
  return panel_text_notify(item, event);
}

/*
 * Notify callback function for `ConnectPortManagerButton'.
 * This function will take the name specifed on the NewPortManagerText textfield and attempt to make a connection 
 * with the port manager on this host.  If it succeeds, it will disconnect from the previous port manager it was connected to (if any).
 */
void ConnectPortManager(item, event)
     Panel_item	item;
     Event		*event;
{
  char buf[100];
  ConnectPortManager_PortManagerPopup_objects	*ip = (ConnectPortManager_PortManagerPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  if (strcmp(senderPort.hostName, (char *) xv_get(ip->NewPortManagerText, PANEL_VALUE)) == 0) /* Do not reconnect if it is the same host */
  {
    return;
  }
  strcpy(senderPort.hostName, (char *) xv_get(ip->NewPortManagerText, PANEL_VALUE));
  tempSender = NewSender(&senderPort);
  if (tempSender)
  {
    if (sender && receiver)					    /* Disconnect from previous Port Manager (if any) */
    {
      DestroyReceiver(sender, receiver);
    }
    sender = tempSender;
    receiver = NewReceiver(sender, "cdEdit", ReceiverPortNumber);
    sprintf(buf, "Current Port Manager : %s\n", senderPort.hostName);
    xv_set(ip->CurrentPortManagerMsg, PANEL_LABEL_STRING, buf, NULL);
  }
  else 
  {
    AlertMessage("Failed to connect with the PortManager.",
		 "Check that the hostname is valid, and that the PortManager is running on it.");
  }
}

/*
 * Notify callback function for `ClosePortManagerPopupButton'.
 * Close the Connect Port Manager popup window
 */
void ClosePortManagerPopup(item, event)
     Panel_item	item;
     Event		*event;
{
  xv_set(cdEdit_PortManagerPopup->PortManagerPopup, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
  xv_set(cdEdit_PortManagerPopup->PortManagerPopup, XV_SHOW, FALSE, NULL);
}

/*
 * Menu handler for `OptionsMenu (Connect with new Port Manager ...)'.
 * Open the popup window to choose a new port manager to connect to.
 */
Menu_item ConnectPortManagerHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    xv_set(cdEdit_PortManagerPopup->PortManagerPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(cdEdit_PortManagerPopup->PortManagerPopup, XV_SHOW, TRUE, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}
