/*
 * VideoEdit_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `VideoEdit.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "VideoEdit_ui.h"

/*
 * Create object `previewMenu' in the specified instance.
 */
Xv_opaque
VideoEdit_previewMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	PreviewStartEnd(Menu_item, Menu_generate);
	extern Menu_item	EditPreview(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Video Preview",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play entire edit",
			MENU_GEN_PROC, PreviewStartEnd,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play part of edit...",
			MENU_GEN_PROC, EditPreview,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Video Preview",
		NULL);
	return obj;
}

/*
 * Create object `editAudioMenu' in the specified instance.
 */
Xv_opaque
VideoEdit_editAudioMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	EditAudioStereo(Menu_item, Menu_generate);
	extern Menu_item	EditAudioRight(Menu_item, Menu_generate);
	extern Menu_item	EditAudioLeft(Menu_item, Menu_generate);
	extern Menu_item	EditAudioMute(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Stereo",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Stereo",
			MENU_GEN_PROC, EditAudioStereo,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Right",
			MENU_GEN_PROC, EditAudioRight,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Left",
			MENU_GEN_PROC, EditAudioLeft,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Mute",
			MENU_GEN_PROC, EditAudioMute,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Stereo",
		NULL);
	return obj;
}

/*
 * Create object `DocMenu' in the specified instance.
 */
Xv_opaque
VideoEdit_DocMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	FileLoad(Menu_item, Menu_generate);
	extern Menu_item	FileSave(Menu_item, Menu_generate);
	extern Menu_item	FileSaveAs(Menu_item, Menu_generate);
	extern Menu_item	EditCloseFile(Menu_item, Menu_generate);
	extern Menu_item	EditCloseWindow(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Open",
			MENU_GEN_PROC, FileLoad,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save",
			MENU_GEN_PROC, FileSave,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save As...",
			MENU_GEN_PROC, FileSaveAs,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close File",
			MENU_GEN_PROC, EditCloseFile,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close Window",
			MENU_GEN_PROC, EditCloseWindow,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `window1'.
 */
VideoEdit_window1_objects *
VideoEdit_window1_objects_initialize(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (VideoEdit_window1_objects *) calloc(1, sizeof (VideoEdit_window1_objects))))
		return (VideoEdit_window1_objects *) NULL;
	if (!ip->window1)
		ip->window1 = VideoEdit_window1_window1_create(ip, owner);
	if (!ip->remoteCtrlControls)
		ip->remoteCtrlControls = VideoEdit_window1_remoteCtrlControls_create(ip, ip->window1);
	if (!ip->optionsButton)
		ip->optionsButton = VideoEdit_window1_optionsButton_create(ip, ip->remoteCtrlControls);
	if (!ip->editButton)
		ip->editButton = VideoEdit_window1_editButton_create(ip, ip->remoteCtrlControls);
	if (!ip->quitButton)
		ip->quitButton = VideoEdit_window1_quitButton_create(ip, ip->remoteCtrlControls);
	if (!ip->frameTxt)
		ip->frameTxt = VideoEdit_window1_frameTxt_create(ip, ip->remoteCtrlControls);
	if (!ip->Num1)
		ip->Num1 = VideoEdit_window1_Num1_create(ip, ip->remoteCtrlControls);
	if (!ip->Num2)
		ip->Num2 = VideoEdit_window1_Num2_create(ip, ip->remoteCtrlControls);
	if (!ip->Num3)
		ip->Num3 = VideoEdit_window1_Num3_create(ip, ip->remoteCtrlControls);
	if (!ip->Num4)
		ip->Num4 = VideoEdit_window1_Num4_create(ip, ip->remoteCtrlControls);
	if (!ip->Num5)
		ip->Num5 = VideoEdit_window1_Num5_create(ip, ip->remoteCtrlControls);
	if (!ip->Num6)
		ip->Num6 = VideoEdit_window1_Num6_create(ip, ip->remoteCtrlControls);
	if (!ip->Num7)
		ip->Num7 = VideoEdit_window1_Num7_create(ip, ip->remoteCtrlControls);
	if (!ip->Num8)
		ip->Num8 = VideoEdit_window1_Num8_create(ip, ip->remoteCtrlControls);
	if (!ip->Num9)
		ip->Num9 = VideoEdit_window1_Num9_create(ip, ip->remoteCtrlControls);
	if (!ip->searchButton)
		ip->searchButton = VideoEdit_window1_searchButton_create(ip, ip->remoteCtrlControls);
	if (!ip->Num0)
		ip->Num0 = VideoEdit_window1_Num0_create(ip, ip->remoteCtrlControls);
	if (!ip->currFrameButton)
		ip->currFrameButton = VideoEdit_window1_currFrameButton_create(ip, ip->remoteCtrlControls);
	if (!ip->remoteIconControls)
		ip->remoteIconControls = VideoEdit_window1_remoteIconControls_create(ip, ip->window1);
	if (!ip->pauseButton)
		ip->pauseButton = VideoEdit_window1_pauseButton_create(ip, ip->remoteIconControls);
	if (!ip->playButton)
		ip->playButton = VideoEdit_window1_playButton_create(ip, ip->remoteIconControls);
	if (!ip->stopButton)
		ip->stopButton = VideoEdit_window1_stopButton_create(ip, ip->remoteIconControls);
	if (!ip->scanRevButton)
		ip->scanRevButton = VideoEdit_window1_scanRevButton_create(ip, ip->remoteIconControls);
	if (!ip->scanFwdButton)
		ip->scanFwdButton = VideoEdit_window1_scanFwdButton_create(ip, ip->remoteIconControls);
	if (!ip->revSkipButton)
		ip->revSkipButton = VideoEdit_window1_revSkipButton_create(ip, ip->remoteIconControls);
	if (!ip->revStepButton)
		ip->revStepButton = VideoEdit_window1_revStepButton_create(ip, ip->remoteIconControls);
	if (!ip->fwdStepButton)
		ip->fwdStepButton = VideoEdit_window1_fwdStepButton_create(ip, ip->remoteIconControls);
	if (!ip->fwdSkipButton)
		ip->fwdSkipButton = VideoEdit_window1_fwdSkipButton_create(ip, ip->remoteIconControls);
	if (!ip->speedTxt)
		ip->speedTxt = VideoEdit_window1_speedTxt_create(ip, ip->remoteIconControls);
	if (!ip->speedMsg)
		ip->speedMsg = VideoEdit_window1_speedMsg_create(ip, ip->remoteIconControls);
	if (!ip->speedSlider)
		ip->speedSlider = VideoEdit_window1_speedSlider_create(ip, ip->remoteIconControls);
	if (!ip->ejectButton)
		ip->ejectButton = VideoEdit_window1_ejectButton_create(ip, ip->remoteIconControls);
	return ip;
}

/*
 * Create object `window1' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_window1_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque		window1_image;
	static unsigned short	window1_bits[] = {
#include "icons/VideoEditIcon"
	};
	
	window1_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, window1_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 230,
		XV_HEIGHT, 419,
		XV_LABEL, "Videodisc Remote Controller",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, window1_image,
			NULL),
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `remoteCtrlControls' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_remoteCtrlControls_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 184,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `optionsButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_optionsButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Options(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsButton",
		XV_X, 12,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Options...",
		PANEL_NOTIFY_PROC, Options,
		NULL);
	return obj;
}

/*
 * Create object `editButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_editButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Edit(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editButton",
		XV_X, 100,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " Edit...",
		PANEL_NOTIFY_PROC, Edit,
		NULL);
	return obj;
}

/*
 * Create object `quitButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_quitButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Quit(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:quitButton",
		XV_X, 168,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " Quit  ",
		PANEL_NOTIFY_PROC, Quit,
		NULL);
	return obj;
}

/*
 * Create object `frameTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_frameTxt_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	SearchKbd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:frameTxt",
		XV_X, 48,
		XV_Y, 44,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 5,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Frame: ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 54000,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, SearchKbd,
		NULL);
	return obj;
}

/*
 * Create object `Num1' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num1_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		One(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    1    ",
		PANEL_NOTIFY_PROC, One,
		NULL);
	return obj;
}

/*
 * Create object `Num2' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num2_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Two(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    2    ",
		PANEL_NOTIFY_PROC, Two,
		NULL);
	return obj;
}

/*
 * Create object `Num3' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num3_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Three(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    3    ",
		PANEL_NOTIFY_PROC, Three,
		NULL);
	return obj;
}

/*
 * Create object `Num4' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num4_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Four(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 100,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    4    ",
		PANEL_NOTIFY_PROC, Four,
		NULL);
	return obj;
}

/*
 * Create object `Num5' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num5_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Five(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 100,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    5    ",
		PANEL_NOTIFY_PROC, Five,
		NULL);
	return obj;
}

/*
 * Create object `Num6' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num6_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Six(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 100,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    6    ",
		PANEL_NOTIFY_PROC, Six,
		NULL);
	return obj;
}

/*
 * Create object `Num7' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num7_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Seven(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 124,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    7    ",
		PANEL_NOTIFY_PROC, Seven,
		NULL);
	return obj;
}

/*
 * Create object `Num8' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num8_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Eight(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 124,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    8    ",
		PANEL_NOTIFY_PROC, Eight,
		NULL);
	return obj;
}

/*
 * Create object `Num9' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num9_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Nine(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 124,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    9    ",
		PANEL_NOTIFY_PROC, Nine,
		NULL);
	return obj;
}

/*
 * Create object `searchButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_searchButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Search(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:searchButton",
		XV_X, 16,
		XV_Y, 148,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Search",
		PANEL_NOTIFY_PROC, Search,
		NULL);
	return obj;
}

/*
 * Create object `Num0' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_Num0_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Zero(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 148,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    0    ",
		PANEL_NOTIFY_PROC, Zero,
		NULL);
	return obj;
}

/*
 * Create object `currFrameButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_currFrameButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		CurrentFrame(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:currFrameButton",
		XV_X, 160,
		XV_Y, 148,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    ?    ",
		PANEL_NOTIFY_PROC, CurrentFrame,
		NULL);
	return obj;
}

/*
 * Create object `remoteIconControls' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_remoteIconControls_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 183,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 235,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `pauseButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_pauseButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Pause(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		pauseButton_image;
	static unsigned short	pauseButton_bits[] = {
#include "icons/pauseIcon"
	};
	
	pauseButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, pauseButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:pauseButton",
		XV_X, 20,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, pauseButton_image,
		PANEL_NOTIFY_PROC, Pause,
		NULL);
	return obj;
}

/*
 * Create object `playButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_playButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Play(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		playButton_image;
	static unsigned short	playButton_bits[] = {
#include "icons/playIcon"
	};
	
	playButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, playButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:playButton",
		XV_X, 92,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, playButton_image,
		PANEL_NOTIFY_PROC, Play,
		NULL);
	return obj;
}

/*
 * Create object `stopButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_stopButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Stop(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		stopButton_image;
	static unsigned short	stopButton_bits[] = {
#include "icons/stopIcon"
	};
	
	stopButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, stopButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:stopButton",
		XV_X, 160,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, stopButton_image,
		PANEL_NOTIFY_PROC, Stop,
		NULL);
	return obj;
}

/*
 * Create object `scanRevButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_scanRevButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ScanReverse(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		scanRevButton_image;
	static unsigned short	scanRevButton_bits[] = {
#include "icons/rwIcon"
	};
	
	scanRevButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, scanRevButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:scanRevButton",
		XV_X, 64,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, scanRevButton_image,
		PANEL_NOTIFY_PROC, ScanReverse,
		NULL);
	return obj;
}

/*
 * Create object `scanFwdButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_scanFwdButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ScanForward(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		scanFwdButton_image;
	static unsigned short	scanFwdButton_bits[] = {
#include "icons/ffIcon"
	};
	
	scanFwdButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, scanFwdButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:scanFwdButton",
		XV_X, 124,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, scanFwdButton_image,
		PANEL_NOTIFY_PROC, ScanForward,
		NULL);
	return obj;
}

/*
 * Create object `revSkipButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_revSkipButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ReverseSkip(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		revSkipButton_image;
	static unsigned short	revSkipButton_bits[] = {
#include "icons/rIndexIcon"
	};
	
	revSkipButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, revSkipButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:revSkipButton",
		XV_X, 12,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, revSkipButton_image,
		PANEL_NOTIFY_PROC, ReverseSkip,
		NULL);
	return obj;
}

/*
 * Create object `revStepButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_revStepButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ReverseStep(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		revStepButton_image;
	static unsigned short	revStepButton_bits[] = {
#include "icons/rStepIcon"
	};
	
	revStepButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, revStepButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:revStepButton",
		XV_X, 72,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, revStepButton_image,
		PANEL_NOTIFY_PROC, ReverseStep,
		NULL);
	return obj;
}

/*
 * Create object `fwdStepButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_fwdStepButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ForwardStep(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		fwdStepButton_image;
	static unsigned short	fwdStepButton_bits[] = {
#include "icons/fStepIcon"
	};
	
	fwdStepButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, fwdStepButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:fwdStepButton",
		XV_X, 120,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, fwdStepButton_image,
		PANEL_NOTIFY_PROC, ForwardStep,
		NULL);
	return obj;
}

/*
 * Create object `fwdSkipButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_fwdSkipButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ForwardSkip(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		fwdSkipButton_image;
	static unsigned short	fwdSkipButton_bits[] = {
#include "icons/fIndexIcon"
	};
	
	fwdSkipButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, fwdSkipButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:fwdSkipButton",
		XV_X, 176,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, fwdSkipButton_image,
		PANEL_NOTIFY_PROC, ForwardSkip,
		NULL);
	return obj;
}

/*
 * Create object `speedTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_speedTxt_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 32,
		XV_Y, 144,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 5,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Speed :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `speedMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_speedMsg_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 132,
		XV_Y, 144,
		PANEL_LABEL_STRING, "frames/sec",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `speedSlider' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_speedSlider_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Speed(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:speedSlider",
		XV_X, 8,
		XV_Y, 172,
		PANEL_SLIDER_WIDTH, 200,
		PANEL_TICKS, 0,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, -240,
		PANEL_MAX_VALUE, 240,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, Speed,
		NULL);
	return obj;
}

/*
 * Create object `ejectButton' in the specified instance.
 */
Xv_opaque
VideoEdit_window1_ejectButton_create(VideoEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Eject(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		ejectButton_image;
	static unsigned short	ejectButton_bits[] = {
#include "icons/ejectIcon"
	};
	
	ejectButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, ejectButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:ejectButton",
		XV_X, 88,
		XV_Y, 200,
		PANEL_LABEL_IMAGE, ejectButton_image,
		PANEL_NOTIFY_PROC, Eject,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `optionsPopup'.
 */
VideoEdit_optionsPopup_objects *
VideoEdit_optionsPopup_objects_initialize(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (VideoEdit_optionsPopup_objects *) calloc(1, sizeof (VideoEdit_optionsPopup_objects))))
		return (VideoEdit_optionsPopup_objects *) NULL;
	if (!ip->optionsPopup)
		ip->optionsPopup = VideoEdit_optionsPopup_optionsPopup_create(ip, owner);
	if (!ip->optionsControls)
		ip->optionsControls = VideoEdit_optionsPopup_optionsControls_create(ip, ip->optionsPopup);
	if (!ip->optionsPlayerStg)
		ip->optionsPlayerStg = VideoEdit_optionsPopup_optionsPlayerStg_create(ip, ip->optionsControls);
	if (!ip->setPlayerButton)
		ip->setPlayerButton = VideoEdit_optionsPopup_setPlayerButton_create(ip, ip->optionsControls);
	if (!ip->optionsPortStg)
		ip->optionsPortStg = VideoEdit_optionsPopup_optionsPortStg_create(ip, ip->optionsControls);
	if (!ip->optionsNetworkHost)
		ip->optionsNetworkHost = VideoEdit_optionsPopup_optionsNetworkHost_create(ip, ip->optionsControls);
	if (!ip->optionsAudioStg)
		ip->optionsAudioStg = VideoEdit_optionsPopup_optionsAudioStg_create(ip, ip->optionsControls);
	if (!ip->optionsSearchStg)
		ip->optionsSearchStg = VideoEdit_optionsPopup_optionsSearchStg_create(ip, ip->optionsControls);
	if (!ip->optionsDisplayStg)
		ip->optionsDisplayStg = VideoEdit_optionsPopup_optionsDisplayStg_create(ip, ip->optionsControls);
	if (!ip->optionsInfoButton)
		ip->optionsInfoButton = VideoEdit_optionsPopup_optionsInfoButton_create(ip, ip->optionsControls);
	if (!ip->optionsDoneButton)
		ip->optionsDoneButton = VideoEdit_optionsPopup_optionsDoneButton_create(ip, ip->optionsControls);
	return ip;
}

/*
 * Create object `optionsPopup' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsPopup_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 386,
		XV_HEIGHT, 227,
		XV_LABEL, "Video Options",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `optionsControls' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsControls_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, 385,
		XV_HEIGHT, 224,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `optionsPlayerStg' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsPlayerStg_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsPlayerStg",
		XV_X, 44,
		XV_Y, 12,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Player:",
		PANEL_CHOICE_STRING, 0, "None",
		NULL);
	return obj;
}

/*
 * Create object `setPlayerButton' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_setPlayerButton_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		SetPlayerHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 260,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Set Player",
		PANEL_NOTIFY_PROC, SetPlayerHandler,
		NULL);
	return obj;
}

/*
 * Create object `optionsPortStg' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsPortStg_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsPortStg",
		XV_X, 16,
		XV_Y, 40,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Serial Port:",
		PANEL_CHOICE_STRINGS,
			"Default",
			"A",
			"B",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `optionsNetworkHost' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsNetworkHost_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	SetNetworkHost(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsNetworkHost",
		XV_X, 8,
		XV_Y, 76,
		PANEL_VALUE_DISPLAY_LENGTH, 30,
		PANEL_VALUE_STORED_LENGTH, 30,
		PANEL_LABEL_STRING, "Network Host :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, SetNetworkHost,
		NULL);
	return obj;
}

/*
 * Create object `optionsAudioStg' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsAudioStg_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		Audio(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsAudioStg",
		XV_X, 8,
		XV_Y, 104,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Audio:    ",
		PANEL_NOTIFY_PROC, Audio,
		PANEL_CHOICE_STRINGS,
			"Off",
			"Left",
			"Right",
			"Stereo",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `optionsSearchStg' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsSearchStg_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		SearchSet(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsSearchStg",
		XV_X, 8,
		XV_Y, 144,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Search:  ",
		PANEL_NOTIFY_PROC, SearchSet,
		PANEL_CHOICE_STRINGS,
			"Frame",
			"Chapter",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `optionsDisplayStg' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsDisplayStg_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		DisplaySelect(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsDisplayStg",
		XV_X, 232,
		XV_Y, 144,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Display:",
		PANEL_NOTIFY_PROC, DisplaySelect,
		PANEL_CHOICE_STRINGS,
			"Off",
			"On",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `optionsInfoButton' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsInfoButton_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		Info(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsInfoButton",
		XV_X, 72,
		XV_Y, 192,
		PANEL_LABEL_STRING, "Info ...",
		PANEL_NOTIFY_PROC, Info,
		NULL);
	return obj;
}

/*
 * Create object `optionsDoneButton' in the specified instance.
 */
Xv_opaque
VideoEdit_optionsPopup_optionsDoneButton_create(VideoEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		Done(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:optionsDoneButton",
		XV_X, 248,
		XV_Y, 192,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Done",
		PANEL_NOTIFY_PROC, Done,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `editPopup'.
 */
VideoEdit_editPopup_objects *
VideoEdit_editPopup_objects_initialize(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (VideoEdit_editPopup_objects *) calloc(1, sizeof (VideoEdit_editPopup_objects))))
		return (VideoEdit_editPopup_objects *) NULL;
	if (!ip->editPopup)
		ip->editPopup = VideoEdit_editPopup_editPopup_create(ip, owner);
	if (!ip->editFileControls)
		ip->editFileControls = VideoEdit_editPopup_editFileControls_create(ip, ip->editPopup);
	if (!ip->editDocButton)
		ip->editDocButton = VideoEdit_editPopup_editDocButton_create(ip, ip->editFileControls);
	if (!ip->editScrollListControls)
		ip->editScrollListControls = VideoEdit_editPopup_editScrollListControls_create(ip, ip->editPopup);
	if (!ip->editListMsg)
		ip->editListMsg = VideoEdit_editPopup_editListMsg_create(ip, ip->editScrollListControls);
	if (!ip->editNumEditMsg)
		ip->editNumEditMsg = VideoEdit_editPopup_editNumEditMsg_create(ip, ip->editScrollListControls);
	if (!ip->editTableHeader)
		ip->editTableHeader = VideoEdit_editPopup_editTableHeader_create(ip, ip->editScrollListControls);
	if (!ip->editTableHeader2)
		ip->editTableHeader2 = VideoEdit_editPopup_editTableHeader2_create(ip, ip->editScrollListControls);
	if (!ip->editScrollList)
		ip->editScrollList = VideoEdit_editPopup_editScrollList_create(ip, ip->editScrollListControls);
	if (!ip->editSelectionControls)
		ip->editSelectionControls = VideoEdit_editPopup_editSelectionControls_create(ip, ip->editPopup);
	if (!ip->editNewEditMsg)
		ip->editNewEditMsg = VideoEdit_editPopup_editNewEditMsg_create(ip, ip->editSelectionControls);
	if (!ip->editStartTxt)
		ip->editStartTxt = VideoEdit_editPopup_editStartTxt_create(ip, ip->editSelectionControls);
	if (!ip->editGetStartButton)
		ip->editGetStartButton = VideoEdit_editPopup_editGetStartButton_create(ip, ip->editSelectionControls);
	if (!ip->editInstruct1)
		ip->editInstruct1 = VideoEdit_editPopup_editInstruct1_create(ip, ip->editSelectionControls);
	if (!ip->editEndTxt)
		ip->editEndTxt = VideoEdit_editPopup_editEndTxt_create(ip, ip->editSelectionControls);
	if (!ip->editGetEndButton)
		ip->editGetEndButton = VideoEdit_editPopup_editGetEndButton_create(ip, ip->editSelectionControls);
	if (!ip->editInstruct2)
		ip->editInstruct2 = VideoEdit_editPopup_editInstruct2_create(ip, ip->editSelectionControls);
	if (!ip->editSpeedTxt)
		ip->editSpeedTxt = VideoEdit_editPopup_editSpeedTxt_create(ip, ip->editSelectionControls);
	if (!ip->editSpeedMsg)
		ip->editSpeedMsg = VideoEdit_editPopup_editSpeedMsg_create(ip, ip->editSelectionControls);
	if (!ip->editDurTxt)
		ip->editDurTxt = VideoEdit_editPopup_editDurTxt_create(ip, ip->editSelectionControls);
	if (!ip->editDurSecMsg)
		ip->editDurSecMsg = VideoEdit_editPopup_editDurSecMsg_create(ip, ip->editSelectionControls);
	if (!ip->editAudioMenuButton)
		ip->editAudioMenuButton = VideoEdit_editPopup_editAudioMenuButton_create(ip, ip->editSelectionControls);
	if (!ip->editLabelTxt)
		ip->editLabelTxt = VideoEdit_editPopup_editLabelTxt_create(ip, ip->editSelectionControls);
	if (!ip->editAudioMsg)
		ip->editAudioMsg = VideoEdit_editPopup_editAudioMsg_create(ip, ip->editSelectionControls);
	if (!ip->editAddButton)
		ip->editAddButton = VideoEdit_editPopup_editAddButton_create(ip, ip->editSelectionControls);
	if (!ip->editModButton)
		ip->editModButton = VideoEdit_editPopup_editModButton_create(ip, ip->editSelectionControls);
	if (!ip->editDelButton)
		ip->editDelButton = VideoEdit_editPopup_editDelButton_create(ip, ip->editSelectionControls);
	if (!ip->editDelAllButton)
		ip->editDelAllButton = VideoEdit_editPopup_editDelAllButton_create(ip, ip->editSelectionControls);
	if (!ip->editPreviewButton)
		ip->editPreviewButton = VideoEdit_editPopup_editPreviewButton_create(ip, ip->editSelectionControls);
	return ip;
}

/*
 * Create object `editPopup' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editPopup_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 529,
		XV_HEIGHT, 500,
		XV_LABEL, "Untitled",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `editFileControls' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editFileControls_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, 528,
		XV_HEIGHT, 40,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `editDocButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editDocButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editDocButton",
		XV_X, 28,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Document",
		PANEL_ITEM_MENU, VideoEdit_DocMenu_create((caddr_t) ip, ip->editPopup),
		NULL);
	return obj;
}

/*
 * Create object `editScrollListControls' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editScrollListControls_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 39,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 235,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `editListMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editListMsg_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 236,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Edit List",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editNumEditMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editNumEditMsg_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 396,
		XV_Y, 17,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "No. of Edits : 0",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editTableHeader' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editTableHeader_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Edit #           Label                         Start         End      Audio ",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editTableHeader2' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editTableHeader2_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 436,
		XV_Y, 48,
		PANEL_LABEL_STRING, "Speed",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editScrollList' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editScrollList_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern int		List(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editScrollList",
		XV_X, 4,
		XV_Y, 72,
		PANEL_LIST_WIDTH, 490,
		PANEL_LIST_DISPLAY_ROWS, 7,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, TRUE,
		PANEL_NOTIFY_PROC, List,
		NULL);
	return obj;
}

/*
 * Create object `editSelectionControls' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editSelectionControls_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 273,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 226,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `editNewEditMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editNewEditMsg_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 176,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Current Selection : New Edit",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editStartTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editStartTxt_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editStartTxt",
		XV_X, 16,
		XV_Y, 48,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 5,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Start  : ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 99999,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editGetStartButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editGetStartButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		GetStart(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editGetStartButton",
		XV_X, 160,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "<-",
		PANEL_NOTIFY_PROC, GetStart,
		NULL);
	return obj;
}

/*
 * Create object `editInstruct1' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editInstruct1_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 204,
		XV_Y, 56,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Get current frame ",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editEndTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editEndTxt_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editEndTxt",
		XV_X, 16,
		XV_Y, 76,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 5,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "End    : ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 99999,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editGetEndButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editGetEndButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		GetEnd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editGetEndButton",
		XV_X, 160,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "<-",
		PANEL_NOTIFY_PROC, GetEnd,
		NULL);
	return obj;
}

/*
 * Create object `editInstruct2' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editInstruct2_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 208,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "number from disc",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editSpeedTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editSpeedTxt_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	EditSpeedStg(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editSpeedTxt",
		XV_X, 356,
		XV_Y, 80,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_LABEL_STRING, "Speed:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 600,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, EditSpeedStg,
		NULL);
	return obj;
}

/*
 * Create object `editSpeedMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editSpeedMsg_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 416,
		XV_Y, 104,
		PANEL_LABEL_STRING, "(frames/sec)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editDurTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editDurTxt_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editDurTxt",
		XV_X, 16,
		XV_Y, 108,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Approximate duration :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editDurSecMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editDurSecMsg_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 252,
		XV_Y, 108,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "seconds",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editAudioMenuButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editAudioMenuButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editAudioMenuButton",
		XV_X, 420,
		XV_Y, 136,
		PANEL_LABEL_STRING, "Stereo",
		PANEL_ITEM_MENU, VideoEdit_editAudioMenu_create((caddr_t) ip, ip->editPopup),
		NULL);
	return obj;
}

/*
 * Create object `editLabelTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editLabelTxt_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editLabelTxt",
		XV_X, 16,
		XV_Y, 140,
		PANEL_VALUE_DISPLAY_LENGTH, 22,
		PANEL_VALUE_STORED_LENGTH, 22,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Label :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editAudioMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editAudioMsg_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 356,
		XV_Y, 140,
		PANEL_LABEL_STRING, "Audio:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editAddButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editAddButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditAdd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editAddButton",
		XV_X, 16,
		XV_Y, 176,
		PANEL_LABEL_WIDTH, 60,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    Add",
		PANEL_NOTIFY_PROC, EditAdd,
		NULL);
	return obj;
}

/*
 * Create object `editModButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editModButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditModify(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editModButton",
		XV_X, 112,
		XV_Y, 176,
		PANEL_LABEL_WIDTH, 60,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Modify",
		PANEL_NOTIFY_PROC, EditModify,
		NULL);
	return obj;
}

/*
 * Create object `editDelButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editDelButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditDelete(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editDelButton",
		XV_X, 216,
		XV_Y, 176,
		PANEL_LABEL_WIDTH, 60,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Delete",
		PANEL_NOTIFY_PROC, EditDelete,
		NULL);
	return obj;
}

/*
 * Create object `editDelAllButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editDelAllButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditDeleteAll(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:editDelAllButton",
		XV_X, 312,
		XV_Y, 176,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Delete All...",
		PANEL_NOTIFY_PROC, EditDeleteAll,
		NULL);
	return obj;
}

/*
 * Create object `editPreviewButton' in the specified instance.
 */
Xv_opaque
VideoEdit_editPopup_editPreviewButton_create(VideoEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 420,
		XV_Y, 176,
		PANEL_LABEL_WIDTH, 60,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Preview  ",
		PANEL_ITEM_MENU, VideoEdit_previewMenu_create((caddr_t) ip, ip->editPopup),
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `previewPopup'.
 */
VideoEdit_previewPopup_objects *
VideoEdit_previewPopup_objects_initialize(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (VideoEdit_previewPopup_objects *) calloc(1, sizeof (VideoEdit_previewPopup_objects))))
		return (VideoEdit_previewPopup_objects *) NULL;
	if (!ip->previewPopup)
		ip->previewPopup = VideoEdit_previewPopup_previewPopup_create(ip, owner);
	if (!ip->previewControls)
		ip->previewControls = VideoEdit_previewPopup_previewControls_create(ip, ip->previewPopup);
	if (!ip->previewMsg)
		ip->previewMsg = VideoEdit_previewPopup_previewMsg_create(ip, ip->previewControls);
	if (!ip->previewSecMsg)
		ip->previewSecMsg = VideoEdit_previewPopup_previewSecMsg_create(ip, ip->previewControls);
	if (!ip->previewPlayFirstButton)
		ip->previewPlayFirstButton = VideoEdit_previewPopup_previewPlayFirstButton_create(ip, ip->previewControls);
	if (!ip->previewPlayFirstTxt)
		ip->previewPlayFirstTxt = VideoEdit_previewPopup_previewPlayFirstTxt_create(ip, ip->previewControls);
	if (!ip->previewPlayLastButton)
		ip->previewPlayLastButton = VideoEdit_previewPopup_previewPlayLastButton_create(ip, ip->previewControls);
	if (!ip->previewPlayLastTxt)
		ip->previewPlayLastTxt = VideoEdit_previewPopup_previewPlayLastTxt_create(ip, ip->previewControls);
	if (!ip->previewDoneButton)
		ip->previewDoneButton = VideoEdit_previewPopup_previewDoneButton_create(ip, ip->previewControls);
	return ip;
}

/*
 * Create object `previewPopup' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewPopup_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 244,
		XV_HEIGHT, 172,
		XV_LABEL, "Video Preview",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `previewControls' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewControls_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `previewMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewMsg_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 72,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Play Part of Edit",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `previewSecMsg' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewSecMsg_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 36,
		PANEL_LABEL_STRING, "(in seconds)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `previewPlayFirstButton' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewPlayFirstButton_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewStart(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:previewPlayFirstButton",
		XV_X, 180,
		XV_Y, 64,
		PANEL_ITEM_COLOR, gcm_color_index("Midnight Blue"),
		PANEL_LABEL_STRING, "<- ",
		PANEL_NOTIFY_PROC, PreviewStart,
		NULL);
	return obj;
}

/*
 * Create object `previewPlayFirstTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewPlayFirstTxt_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	PreviewStartTxt(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:previewPlayFirstTxt",
		XV_X, 11,
		XV_Y, 68,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Play first : ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 999,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, PreviewStartTxt,
		NULL);
	return obj;
}

/*
 * Create object `previewPlayLastButton' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewPlayLastButton_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewEnd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:previewPlayLastButton",
		XV_X, 180,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Midnight Blue"),
		PANEL_LABEL_STRING, "<- ",
		PANEL_NOTIFY_PROC, PreviewEnd,
		NULL);
	return obj;
}

/*
 * Create object `previewPlayLastTxt' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewPlayLastTxt_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	PreviewEndTxt(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:previewPlayLastTxt",
		XV_X, 11,
		XV_Y, 100,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_LABEL_STRING, "Play last  : ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, PreviewEndTxt,
		NULL);
	return obj;
}

/*
 * Create object `previewDoneButton' in the specified instance.
 */
Xv_opaque
VideoEdit_previewPopup_previewDoneButton_create(VideoEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewDone(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:previewDoneButton",
		XV_X, 68,
		XV_Y, 132,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Close window",
		PANEL_NOTIFY_PROC, PreviewDone,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `infoPopup'.
 */
VideoEdit_infoPopup_objects *
VideoEdit_infoPopup_objects_initialize(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (VideoEdit_infoPopup_objects *) calloc(1, sizeof (VideoEdit_infoPopup_objects))))
		return (VideoEdit_infoPopup_objects *) NULL;
	if (!ip->infoPopup)
		ip->infoPopup = VideoEdit_infoPopup_infoPopup_create(ip, owner);
	if (!ip->infoControls)
		ip->infoControls = VideoEdit_infoPopup_infoControls_create(ip, ip->infoPopup);
	if (!ip->infoMsg5)
		ip->infoMsg5 = VideoEdit_infoPopup_infoMsg5_create(ip, ip->infoControls);
	if (!ip->infoMsg6)
		ip->infoMsg6 = VideoEdit_infoPopup_infoMsg6_create(ip, ip->infoControls);
	if (!ip->infoMsg7)
		ip->infoMsg7 = VideoEdit_infoPopup_infoMsg7_create(ip, ip->infoControls);
	if (!ip->infoMsg1)
		ip->infoMsg1 = VideoEdit_infoPopup_infoMsg1_create(ip, ip->infoControls);
	if (!ip->infoMsg3)
		ip->infoMsg3 = VideoEdit_infoPopup_infoMsg3_create(ip, ip->infoControls);
	if (!ip->infoMsg2)
		ip->infoMsg2 = VideoEdit_infoPopup_infoMsg2_create(ip, ip->infoControls);
	if (!ip->infoMsg4)
		ip->infoMsg4 = VideoEdit_infoPopup_infoMsg4_create(ip, ip->infoControls);
	if (!ip->infoMsg8)
		ip->infoMsg8 = VideoEdit_infoPopup_infoMsg8_create(ip, ip->infoControls);
	if (!ip->infoOkButton)
		ip->infoOkButton = VideoEdit_infoPopup_infoOkButton_create(ip, ip->infoControls);
	return ip;
}

/*
 * Create object `infoPopup' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoPopup_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 501,
		XV_HEIGHT, 291,
		XV_LABEL, "Video Info",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `infoControls' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoControls_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "BG1");
	return obj;
}

/*
 * Create object `infoMsg5' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoMsg5_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 170,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Video Edit   Version 1.12",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg6' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoMsg6_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 49,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "An application for annotating video from videodisc (or videotape)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg7' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoMsg7_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 32,
		XV_Y, 68,
		PANEL_LABEL_STRING, "designed for use with the MAEstro Multimedia Authoring Environment",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg1' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoMsg1_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 192,
		XV_Y, 112,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "by Wee-Lee Lim",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg3' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoMsg3_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 152,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg2' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoMsg2_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 187,
		XV_Y, 176,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " Stanford University",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg4' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoMsg4_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 192,
		XV_Y, 196,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Stanford, California",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg8' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoMsg8_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 94,
		XV_Y, 232,
		PANEL_LABEL_STRING, "For more info, contact maestro@sioux.stanford.edu",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoOkButton' in the specified instance.
 */
Xv_opaque
VideoEdit_infoPopup_infoOkButton_create(VideoEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	extern void		InfoDone(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "VideoEdit:infoOkButton",
		XV_X, 230,
		XV_Y, 264,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "OK",
		PANEL_NOTIFY_PROC, InfoDone,
		NULL);
	return obj;
}

