/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/QuoteMaker/RCS/editList.c,v 2.11 92/05/14 15:40:46 drapeau Exp $ */
/* $Log:	editList.c,v $
 * Revision 2.11  92/05/14  15:40:46  drapeau
 * Updated copyright info on the source.
 * 
 * Revision 2.10  91/12/31  18:40:49  drapeau
 * Removed the inclusion of string.h, since XView will include the
 * appropriate definitions.
 * 
 * Revision 2.0  91/09/30  15:02:23  derek
 * Version number changed to 2.0.
 * 
 * Revision 1.55  91/09/18  20:54:12  derek
 * The Makefile is changed due to the changes made in the collab/ directory.
 * 
 * Revision 1.54  91/09/15  20:06:20  derek
 * The following things are done:
 * 1.      The foreground of mainTextPane and Quote Window are set to be black.
 *         Also, the color of all the text fields are set to black.
 * 2.      Now the quoted text will be shown directly on the Quote Window
 *         when a panel-item selection is made.  The text will also be shown
 *         while the author is highlighting a selection in the text window.
 * 3.      The inconsistency problem regarding text selection is being taken
 *         care of.  When the mouse cursor re-enters the text window,
 *         the selection will be highlighted again.
 * 4.      When the play button is pressed, the text currently selected
 *         in the text window (rather than the text initially associated
 *         with the edit) will be displayed.
 * 5.      The name of the menu_option "Show Quote Window Specifications panel"
 *         is shortened to be "Quote Window Options ..."
 * 6.      A notify_interpose_destroy_func() is being added to fix the bug
 *         that QuoteMaker might exit without killing the Quote Window (which
 *         is also a base window).
 * 7.      When a different font family or font style is selected, the change
 *         will be automatically be reflected on the Quote Window (without the
 *         need to "play" the edit in order to verify the font).  For font
 *         size, the change will be reflected when either a return character is
 *         entered at the text field or when one of those numeric "arrows"
 *         are pressed.
 * 8.      The play button will now flash when an edit is being played.
 *         Pause button will also glow when playing is paused.
 * 9.      In the course of playing, when another edit is selected,
 *         the playing will be stopped.
 * 10.     I have used Saber to clean up the code.
 * 11.     The left-over "NewEditListPopUp" window is removed.
 * 12.     The bug that when quote window is iconified, it wont be un-iconified
 *         when the edit is played in timeline, is fixed.
 * 13.     The DurationEstimate function is changed so that it no longer
 *         needs an edit to be selected first.  It will take textWindowStart
 *         and textWindowEnd directly as input parameters.
 * 
 * 
 * 
 * Revision 1.53  91/09/05  15:47:57  derek
 * The following changes are made:
 * 1.      The name "Quoted Text Window" has been changed to "Quote Window"
 *         in the app.
 * 2.      ShowApplication() and HideApplication() is changed because of the
 *         the change of quote window from a popup to a basewindow.
 * 3.      The QuitProc of QuoteMaker is fixed so that the quote window,
 *         as a base window, will be destroyed separately.
 * 4.      Now hitting return in the label field will not result in adding
 *         a new edit.
 * 5.      Copyright messages are included in front of every .h and .c file.
 * 6.      The scrollbar and the footer of the Quote Window are hidden.
 * 7.      I have changed the include openpanel.h statement in QuoteMaker.c
 *         to include Browse.h.
 * 8.      The delete bug corresponding to the change that the panel-list
 *         must have a choice -- is fixed.  Also, the corresponding bug
 *         for deleteAll is also fixed.
 * 9.      Now, deleteAll and deletion of the last item in Panel_list
 *         will cause the panel-list to be destroyed and a new one will
 *         be created.
 * 10.     GetOpt files have been removed from the directory.  Corresponding
 *         changes are made.
 * 11.     The start and end byte fields are removed from the main panel.
 * 12.     I have put iconify, hide and show quote window to be buttons
 *         instead of menu options.
 * 13.     I have removed the PreviewPanelPopup and incorporated its features into
 *         the main panel.  The three buttons:  pause, play and stop and
 *         the DurationGauge are moved to the main panel.  But the
 *         StatusMessage is removed.
 * 14.     The EnableLocationChange and EnableSizeChange choice setting
 *         are removed.  There are no longer such choices.
 * 15.     Right now if a panel-item is selected and if another panel-item
 *         is picked, the DeselectList() operation in the middle is
 *         eliminated.  This operation involves updating of text fields and
 *         messages and its removal speeds up the program.  The panel-list
 *         must now take at least one choice.  (A choice must be selected
 *         whenever there is at least one item on the list).  And now
 *         there is no way to deselect a list by the user.
 * 16.     The "modified bit" associated with the CurrentSelectionNumberLabel
 *         is implemented.  Now, if a selection is picked, and if either
 *         the quote window is moved or any text fields are changed, the
 *         modified bit will be on.
 * 17.     The Show-text-window button and the Show-quote-window-specifications-popup
 *         button are removed.  They are now menu options under the Options Menu.
 * 18.     The Modify button has its name changed to "Update Edit".
 * 
 * Revision 1.52  91/08/28  14:06:03  derek
 * The following things are done:
 * 1.	I have changed the NewEditList option to call the file browser
 * 	instead of giving a popup window.
 * 2.	I ahve renamed all the options in the file menu so that they
 * 	are clearer and more informative.
 * 3.	The documentFileType has been changed from "DTR" (which was
 * 	a copying fault :)) to "QuoteMaker".
 * 4.	I ahve changed the stop button so that if it sees that 
 * 	HideQTWAfterPlayingEdit is true, stopplay will hide the window too.
 * 5.	I have changed QuoteMaker.G (the interface) so that there is no
 * 	way to deselect a fontfamily and fontstyle item from the panel list
 * 	(ie. a choice is required.)
 * 
 * Revision 1.51  91/08/27  14:37:27  derek
 * The following things are done:
 * 1.	The QuotedTextWindow is changed from a base window to a popup window
 * 	(now it's called QuotedMaker_quotedTextBaseWindow).  I have also
 * 	added a few options: show, hide and iconify QTW and also created
 * 	an icon for QTW.
 * 2.	The quoted text will be set in PerformSelection() instead of 
 * 	in SetSelection().
 * 3.	I have changed the Document field and the EditList field of 
 * 	QuoteMaker so that they will display fill paths.
 * 
 * Revision 1.50  91/08/26  12:10:10  derek
 * The following things are done:
 * 1.	I have added a few notice_prompts to the linkProtocol (network)
 * 	functions to give warnings about invalid document names.
 * 2.	The quoted text window will by default be hidden during "blank"
 * 	times. ie. when it is not displaying any text.  The interface has
 * 	been changed so that it now has a HideQuotedTExtWindowAfterPreview
 * 	check box.  The QuotedTextWindow will either stay on the screen
 * 	or be hidden as the author desires.
 * 3.	Make the changes corresponding to the changing of name from OpenPanel
 * 	to Browse.
 * 4.	The return value bug for OpenHandler, SaveHandler is fixed.
 * 5.	I have changed the code so that Save and SaveAs will behave correctly.
 * 	The SaveAs PopUp/Open PopUp are removed.  Browse check is 
 * 	incorporated in the applications.
 * 6.	The QuoteMaker file format has been changed.  An EditNumber field	
 * 	has been added.
 * 7.	Changes corresponding to the return value by OpenDoc and SetSelection
 * 	are made.
 * 8.	GetAppIcon() has been implemented.
 * 9.	Fonts specified in the Edit-list will be preloaded in OpenDoc().
 * 	This will hopefully eliminate the startup delay needed to load
 * 	the font when we put text onto the Quoted TExt Window for the 
 * 	first time.
 * 10.	The "play" button will now play things specified in the 
 * 	QuotedTExtWindowSpecificationsPopUp (instead of those specified
 * 	in the editList).
 * 11.	The show selection button is replaced by the set selection button.
 * 	The Set Selection button willl now not only set the current
 * 	edit parameters but will also highlight the corresponding section
 * 	in the text.  Also, when one item on the panel-list is clicked on,
 * 	the corresponding segment in the text will also be highlighted.
 * 12.	Notify events which tells the app to show the size and location 
 * 	of the Quoted Text Window are set up.  ie. those text-fields
 * 	on the interface will be updated instantaneously.
 * 16.	editList.label is being sent across the network.
 * 17.	The title bar and the footer of the QuotedTExtWindow are hidden.
 * 
 * Revision 1.49  91/08/13  22:52:30  derek
 * I have incorporated the openpanel/savepanel stuff.
 * 
 * Revision 1.48  91/08/12  10:54:36  derek
 * I attempted to debug the edit-list section.  This should be a more
 * stable version.
 * 
 * Revision 1.47  91/08/09  18:18:40  derek
 * I removed all the free() statements from the code to
 * fix the bug and improve run-time efficiency.
 * 
 * Revision 1.46  91/08/08  21:47:33  derek
 * I fixed an edit list bug.
 * 
 * Revision 1.45  91/07/15  12:18:48  derek
 * 1.      I have added font selection panel to the application.
 *         Now a user can specify a font by choosing a font family, a font
 *         style and font size.
 * 2.      Location and size fields are added to the application.  User
 *         can specify the size and location of the QuotedTextWindow.
 * 3.      A duration estimate button is added to estimate how long the
 *         the quoted text should last.
 * 4.      Interface has been redesigned to accomodate the addition of
 *         font, size and location functionalities.
 * 6.      EditList file format has been changed to accomodate the new
 *         fields.  They are:  location (x,y), width, height, font family,
 *         font style, font width for QuotedTextWindow.
 * 5.      Two timers have been added in an attempt to ensure accuracy
 *         of gauge-updating in the preview panel.
 * 6.      Command line args are now supported.
 * 7.      I have cleaned up the code by using saber.
 * 8.      Several bugs from previous revision are fixed.
 * 
 * 
 * Revision 1.44  91/07/02  15:07:48  derek
 * QuoteMaker now fully speaks the new MAEstro protocol.
 * 
 * Revision 1.43  91/07/01  18:51:24  derek
 * The following things are done:
 * 1.	The interface is redesigned.  Duration fields are added to each 
 * 	edit list.
 * 2.	The function panel (functions Window) is implemented.  The 
 * 	application is now capable of being "played", "stopped" and
 * 	"paused".  The sense of "time" is now complete.
 * 3.	Makefile fixed.  
 * 4.	Declaration errors left by previous author are cleaned up.
 * 5.	Redundant malloc statements removed.   Certain other
 * 	functions are changed to improve code efficiency.
 * 6.	Code cleaned up by saber.  Removed redundant
 * 	variables.
 * 
 * Revision 1.42  91/06/27  18:21:15  derek
 * I have cleaned up some of the comments.  No change in code.
 * 
 * Revision 1.41  91/06/19  17:45:15  drapeau
 * No changes; changing RCS revision numbers.
 * 
 * Revision 1.4  91/05/06  01:53:45  drapeau
 * Using new version of RCS for this file.  No serious changes made to the file.
 * 
 * Revision 1.3  91/01/06  20:18:23  drapeau
 * Modified DeselectList() so that it dims Delete and Modify buttons when list
 * is de-selected.
 * 
 * Revision 1.2  90/12/05  14:51:17  drapeau
 * Modified ReadEditListFromFile() -- fixed error in call to FormatEntry.
 * Previous version called FormatEntry with "counter" as argument instead of
 * "counter+1"; the error caused the edit list numbering to be displayed
 * incorrectly (the edit list numbers started at 0 instead of 1).
 * 
 * Revision 1.1  90/12/04  17:21:46  drapeau
 * Initial revision
 *  */

static char rcsid[] = "$Header: /Source/Media/collab/QuoteMaker/RCS/editList.c,v 2.11 92/05/14 15:40:46 drapeau Exp $";

/*
 * QuoteMaker.c - Notify and event callback function stubs.
 * This file was copied from "QuoteMaker_stubs.c", which was
 * generated by `gxv' from `QuoteMaker.G'.
 * Modified by George Drapeau on October 26, 1990.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "QuoteMaker_ui.h"
#include <sys/stat.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/server.h>          
#include <xview/seln.h>            
#include "Sender.h"
#include "Receiver.h"
#include "quoteMakerDefs.h"
#include <Browse.h>


Menu_item ShowOpenEditListPopup(item, op)			    /* Menu handler for `fileMenu (Open Edit List...)'. */
     Menu_item		item;
     Menu_generate	op;
{
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    Browse(NULL, BrowseOpen, IS_EDITLIST, documentFirstLine, documentFileType);
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}								    /* end function ShowOpenEditListPopup */




Menu_item SaveEditListHandler(item, op)			    /* Menu handler for `fileMenu (Save Edit List...)'. */
     Menu_item	item;
     Menu_generate	op;
{
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    if (strcmp(absoluteEditListName, "NoneSpecified") == 0
	|| strlen(absoluteEditListName) == 0)
    {
      Browse(NULL, BrowseSave, IS_EDITLIST, documentFirstLine, documentFileType);
    }
    else
    {
      (void) WriteEditListToFile(absoluteEditListName, SAVE);
    }
    
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}								    /* end function SaveEditListHandler */

/*
 * Menu handler for `fileMenu (Save Edit List As...)'.
 */
Menu_item
SaveEditListAsHandler(item, op)
	Menu_item	item;
	Menu_generate	op;
{
  switch (op) {
   case MENU_DISPLAY:
    break;

   case MENU_DISPLAY_DONE:
    break;

   case MENU_NOTIFY:
    Browse(NULL, BrowseSave, IS_EDITLIST, documentFirstLine, documentFileType);
    break;

   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}


/*
 * Menu handler for `fileMenu (New document to annotate...)'.
 */
Menu_item NewDocumentToAnnotateHandler(item, op)			    
     Menu_item	item;
     Menu_generate	op;
{
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    Browse(NULL, BrowseOpen, IS_TEXTFILE, NULL, NULL);
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}								    /* end function NewDocumentToAnnotateHandler */


void DeselectList()
{
  int selected;
  
  selected = Selected();
  if (selected != NO_CURRENT_EDIT)
  {
    xv_set (QuoteMaker_baseWindow->editListScrolledList,
	    PANEL_LIST_SELECT, selected, FALSE,
	    NULL);
  }
  xv_set (QuoteMaker_baseWindow->currentSelectionNumberLabel,
	  PANEL_LABEL_STRING, "   ",
	  NULL);
  xv_set(QuoteMaker_baseWindow->deleteButton,
	 PANEL_INACTIVE, TRUE, NULL);				    /* De-activate the Delete and Modify buttons */
  xv_set(QuoteMaker_baseWindow->modifyButton,
	 PANEL_INACTIVE, TRUE, NULL);
}								    /* end function DeselectList */



void EmptyList()
{
  int size;
  int counter;
  
  size = ListSize();
  for (counter = size - 1; counter > -1; counter --)
  {
    xv_set (QuoteMaker_baseWindow->editListScrolledList,
	    PANEL_LIST_DELETE, counter,
	    NULL);
  }
  editList.numItems = 0;
}								    /* end function EmptyList */



int ListSize()
{
  return(editList.numItems);
}								    /* end function ListSize */


int Selected()
{
  int selected;
  int size;
  int counter;
  
  selected = NO_CURRENT_EDIT;
  size = ListSize();
  counter = 0;
  while ((counter < size) && (selected == NO_CURRENT_EDIT))
  {
    if (xv_get (QuoteMaker_baseWindow->editListScrolledList,
		PANEL_LIST_SELECTED, counter) == TRUE)
    {
      selected = counter;
      break;
    }
    else
      counter ++;
  }
  return selected;
}



int
  ReadEditListFromFile(editListName, caller)
char*	editListName;
int	caller;
{
  int	  	size, counter, start, end;
  int     	locX, locY, sizeWidth, sizeHeight;
  int     	hideQTWAfterPlayingEdit;
  double  	duration;
  int     	fontFamily, fontStyle, fontSize;
  char	  	fileType[MAX_FILETYPE_LEN + 1];
  char	  	message[MAX_MESSAGE_LEN + 1];
  char	  	documentName[MAXPATHLEN + 1];  
  char	  	entry[MAX_ENTRY_LEN + 1];
  char*	  	tempLabel;
  FILE*	  	fp;
  int     	garbage;
  int     	result;
  struct stat	fileInfo;
  
  if (editListName == NULL)					    /* Was a file name entered? */
  {								    /* No, inform author and return w/o doing anything */
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"You need to specify an edit list.");
    return FILE_NOT_OK;
  }
  result = stat(editListName,&fileInfo);			    /* Attempt to get info about the specified file */
  if ((result != 0) || (fileInfo.st_mode & S_IFDIR))		    /* Is the file non-existant, or is it a directory? */
  {								    /* No, file doesn't exist, or if it exists, it's... */
    sprintf (message, "Cannot find '%s'.", editListName);	    /* ...a directory.  Inform author of the mistake... */
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,	    /* ...and return without doing anything more. */
			message);
    return FILE_NOT_OK;						    /* Return without doing anything more */
  }

  if (strcmp(ShortName(editListName), "NoneSpecified") == 0)	    
  {
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"'NoneSpecified' is an unacceptable name.");
  }
  

  if (unsavedChangesExist == YES)
    GiveOneLastChanceToSave();

  fp = fopen (editListName, "r");				    /* Attempt to open the specified file */
  if (fp == (FILE*)NULL)					    /* Did the open succeed? */
  {								    /* No, inform author and return w/o doing anything */
    sprintf(message,
	    "Unable to open the file named %s.\n",editListName);
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			message);
    return FILE_NOT_OK;
  }
  fscanf (fp, "#%s Edit Document#\n", fileType);		    /* Is this file a QuoteMaker file? */
  if (strcmp(fileType, "QuoteMaker"))				    /* No, this is not a QuoteMaker file */
  {								    /* Inform the author of the mistake and return */
    if (caller == USER)
    {
      sprintf (message, "'%s' is not a QuoteMaker edit list.", ShortName (editListName));
      AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			  message);
    }
    return FILE_NOT_OK;						    /* Exit regardless if called from network or by... */
								    /* ...the author. */
  }
  fscanf(fp,"#Annotated Document:\t%s\n",documentName);		    /* Attempt to read the name of the document... */
  /* ...being annotated. */
  if (documentName == NULL)					    /* Was document name invalid or not there somehow? */
  {								    /* Bad document name; close the file and return... */
    fclose(fp);							    /* ...without doing any further work. */
    return FILE_NOT_OK;
  }

  UnHighlightSelection();
  DeselectList();
  ResetCurrentSelection();
  EmptyList();

  fscanf (fp, "#Number of Edits:\t%d\n", &size);		    /* Read the size of the edit list to be read in */
  editList.numItems = size;
  for (counter = 0; counter < size; counter ++)			    /* Read through the edit list file, loading it... */
  {								    /* ...into the edit list, entry by entry. */
    fscanf(fp, "#EditNumber:\t%d\n#Start:\t%d\n#End:\t%d\n#Duration:\t%lf\n#LocX:\t%d\n#LocY:\t%d\n#SizeWidth:\t%d\n#SizeHeight:\t%d\n#FontFamily:\t%d\n#FontStyle:\t%d\n#FontSize:\t%d\n#HideQTWAfterPlayingEdit:\t%d\n", 
	   &garbage,
	   &start, &end, &duration, &locX, &locY, &sizeWidth,
	   &sizeHeight, &fontFamily, &fontStyle, &fontSize, &hideQTWAfterPlayingEdit);
    fgets(entry,512,fp);
    tempLabel = &entry[8];					    /* Skip over "#Label: " characters, point right... */
    /* ...at the label. */
    tempLabel[strlen(tempLabel)-1] = '\0';			    /* Replace newline character with NULL character */
    editList.start[counter] = start;				    /* Load this entry into the current item in the... */
    /* ...edit list. */
    editList.end[counter] = end;
    editList.duration[counter] = duration;

    editList.locX[counter] = locX;
    editList.locY[counter] = locY;
    editList.sizeWidth[counter] = sizeWidth;
    editList.sizeHeight[counter] = sizeHeight;

    editList.fontFamily[counter] = fontFamily;
    editList.fontStyle[counter] = fontStyle;
    editList.fontSize[counter] = fontSize;

    editList.hideQTWAfterPlayingEdit[counter] = hideQTWAfterPlayingEdit;

    if (editList.label[counter])
      free(editList.label[counter]);
    editList.label[counter] = (char*)strdup(tempLabel);
    xv_set (QuoteMaker_baseWindow->editListScrolledList,
	    PANEL_LIST_INSERT, counter,
	    PANEL_LIST_STRING, counter, FormatEntry(counter+1,tempLabel, duration, hideQTWAfterPlayingEdit),
	    PANEL_LIST_FONT, counter, listFont,
	    NULL);
    fgets(entry,512,fp);					    /* Skip over blank line to advance to next entry */
  }

  UpdateNumEditsMessage();
  SetDocument(documentName);
  if (caller == USER)						    /* This test is to prevent main text window to be... */
    Show(&QuoteMaker_textWindowPopup->textWindowPopup);		    /* ...shown when "OpenDoc()" is called from the... */
  /* ...network. */
  SetEditList(editListName);
  unsavedChangesExist = NO;

  if (editList.numItems >= 1)					    /* Set the current selection to be the first one.    */
  {								    /* ...This corresponds to the change that now...     */
    SetCurrentSelection(0);					    /* ...the user cannot deselect a list.               */
    DisplayTextOnQuoteWindow();
  }
  
  return FILE_OK;
}								    /* end function ReadEditListFromFile */



/*
 *  The value of saveAsFlag indicates whether we want "save" or "saveAs".
 */
int
  WriteEditListToFile (editListName, saveAsFlag)
char* editListName;
int   saveAsFlag;
{
  int		size, counter;
  char		message[MAX_MESSAGE_LEN + 1];
  FILE* 	fp;
  char  	documentName[MAXPATHLEN + 1];  
  int		response;
  struct stat	fileInfo;
  
  size = ListSize();

  if (editListName == NULL)					    /* Was the file name to save the edit list invalid? */
  {								    /* Yes, inform author of the mistake and return... */
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,	    /* ...without doing anything. */
			"You need to specify an edit list.");
    return FILE_NOT_OK;
  }
  
  if (strcmp(ShortName(editListName),"NoneSpecified") == 0)	    /* Did the author try to save the document as... */
  {								    /* ..."NoneSpecified"? */
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,	    /* Yes, inform author of the mistake and return... */
	  "'NoneSpecified' is not an acceptable name.");	    /* ...without doing anything more. */
    return FILE_NOT_OK;
  }
  strcpy(documentName,						    /* Get the name of the document being annotated */
	 (char *) xv_get(QuoteMaker_baseWindow->docNameLabel,
			 PANEL_LABEL_STRING));
  if (strcmp(documentName, "None Loaded") == 0)			    /* Is the author trying to save an empty document? */
  {								    /* Yes, inform author of the mistake and return... */
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,	    /* ...without doing anything more. */
			"You have not specified the document you are annotating.");
    return FILE_NOT_OK;
  }

  response = stat(editListName,&fileInfo);			    /* Attempt to get info about the specified file */
  if (saveAsFlag == SAVE_AS &&
      (response == 0) && (!(fileInfo.st_mode & S_IFDIR)))	    /* Does the file exist (.. is it *not* a directory)? */
  {								    /* Yes, file exists and is not a directory. */
    sprintf(message, "'%s' already exists.", ShortName(editListName));
    response = notice_prompt(QuoteMaker_baseWindow->baseWindow, NULL,
			     NOTICE_MESSAGE_STRINGS, message,
			     "Do you wish to overwrite it?",
			     NULL,
			     NOTICE_BUTTON_YES, "Yes",
			     NOTICE_BUTTON_NO, "No",
			     NULL);
    if (response == NOTICE_NO)
      return FILE_NOT_OK;
  }

  fp = fopen (editListName, "w");				    /* Attempt to open the edit list passed in for... */
  /* ...writing. */
  if (fp == (FILE*)NULL)					    /* Did the open fail? */
  {								    /* Yes, unable to open the file for writing. ... */
    sprintf (message, "'%s' is a bad pathname.", editListName);	    /* ...Report this to the author and return w/o... */
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,	    /* ...doing anything. */
			message);
    return FILE_NOT_OK;
  }

  fprintf (fp, "#QuoteMaker Edit Document#\n");			    /* Write the file header determining the type... */
  /* ... of this file. */
  fprintf (fp, "#Annotated Document:\t%s\n", absoluteDocumentName); /* Write the name of the text file being annotated */
  fprintf (fp, "#Number of Edits:\t%d\n\n", size);		    /* Write the number of edits made for this document */
  for (counter = 0; counter < size; counter ++)			    /* Loop through each item in the edit list, ... */
  {								    /* ...writing the contents of each item to the file. */
    fprintf(fp, "#EditNumber:\t%d\n#Start:\t%d\n#End:\t%d\n#Duration:\t%lf\n#LocX:\t%d\n#LocY:\t%d\n#SizeWidth:\t%d\n#SizeHeight:\t%d\n#FontFamily:\t%d\n#FontStyle:\t%d\n#FontSize:\t%d\n#HideQTWAfterPlayingEdit:\t%d\n#Label:\t%s\n\n",	    
	    counter + 1,
	    editList.start[counter],
	    editList.end[counter],
	    editList.duration[counter],
	    editList.locX[counter],
	    editList.locY[counter],
	    editList.sizeWidth[counter],
	    editList.sizeHeight[counter],
	    editList.fontFamily[counter],
	    editList.fontStyle[counter],
	    editList.fontSize[counter],
	    editList.hideQTWAfterPlayingEdit[counter],
	    editList.label[counter]);
  }
  fclose (fp);							    /* Close the file just written */

  unsavedChangesExist = NO;
  SetEditList(editListName);
  return FILE_OK;
}								    /* end function WriteEditListToFile */


void SetEditList(editListName)
     char*	editListName;
{
  char	fancyEditListName[MAXPATHLEN + 1];
  
  if (strcmp(editListName, "NoneSpecified") != 0)
  {
    xv_set(QuoteMaker_baseWindow->editListNameLabel,
	   PANEL_LABEL_STRING, (char *) editListName,
	   NULL);

    realpath(editListName, absoluteEditListName);
  }
  else
  {
    sprintf(fancyEditListName, "Untitled%d", untitledEditListNum);
    xv_set(QuoteMaker_baseWindow->editListNameLabel,
	   PANEL_LABEL_STRING, (char *) fancyEditListName,
	   NULL);

    strcpy(absoluteEditListName, "NoneSpecified");
  }
  return;
}								    /* end function SetEditList */


void DeleteItemFromEditList(itemNumber)
     int	itemNumber;
{
  int	i;
  
  if (itemNumber+1 == editList.numItems)			    /* Is the last item in the last being deleted? */
  {								    /* Yes, don't need to shuffle any items up in... */
    editList.numItems--;					    /* Update number of items in the edit list */
    xv_set(QuoteMaker_baseWindow->editListScrolledList,		    /* Clear the entry on the display so that the...    */
	   PANEL_LIST_STRING, itemNumber, "",			    /* ..."ghost" wont show up again.                   */
	   PANEL_LIST_FONT, itemNumber, listFont,
	   NULL);
    RedrawEditList(itemNumber);
    return;
  }

  for (i = itemNumber; i < editList.numItems; i++)		    /* Shift each subsequent entry in the edit list... */
  {								    /* ...up by one. */
    editList.start[i] = editList.start[i+1];
    editList.end[i] = editList.end[i+1];
    editList.label[i] = editList.label[i+1];
    editList.duration[i] = editList.duration[i+1];
    editList.locX[i] = editList.locX[i+1];
    editList.locY[i] = editList.locY[i+1];
    editList.sizeWidth[i] = editList.sizeHeight[i+1];
    editList.fontFamily[i] = editList.fontFamily[i+1];
    editList.fontStyle[i] = editList.fontStyle[i+1];
    editList.fontSize[i] = editList.fontSize[i+1];
    editList.hideQTWAfterPlayingEdit[i] = editList.hideQTWAfterPlayingEdit[i+1];
  }

  if (atoi(xv_get(QuoteMaker_QuoteWindowSpecificationsPopup->EditNumberMessage,
		  PANEL_LABEL_STRING)) == itemNumber)
  {
    ClearQuoteWindowSpecificationsPopup();
  }

  editList.numItems--;						    /* Update number of items in the edit list */
  xv_set(QuoteMaker_baseWindow->editListScrolledList,		    /* Clear the entry on the display so that the...    */
	 PANEL_LIST_STRING, itemNumber, "",			    /* ..."ghost" wont show up again.                   */
	 PANEL_LIST_FONT, itemNumber, listFont,
	 NULL);
  RedrawEditList(itemNumber);
  return;
}								    /* end function DeleteItemFromEditList */


void
  ClearQuoteWindowSpecificationsPopup()
{
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->EditNumberMessage,
	 PANEL_LABEL_STRING, "None", NULL);
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->LocationMessage,
	 PANEL_LABEL_STRING, "", NULL);
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->SizeMessage,
	 PANEL_LABEL_STRING, "", NULL);

  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontFamilyList,
	 PANEL_LIST_SELECT, currentFontFamily, FALSE, NULL);	    /*  deselect font family lists.                    */
  currentFontFamily = NONE_SELECTED;

  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontStyleList,
	 PANEL_LIST_SELECT, currentFontStyle, FALSE, NULL);	    /*  deselect font style lists.                     */
  currentFontStyle = NONE_SELECTED;
  
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontSizeTextField,
	 PANEL_VALUE, 20, NULL);

  EnableHideQTWAfterPlayingEdit();

  SetFontPanel(0, 0, 24);					    /*  Pre-set font panel to 0, 0, 24.                */
}


void	RedrawEditList(itemNumber)
     int	itemNumber;
{
  int	i;
  
  for(i=itemNumber; i < editList.numItems; i++)			    /* Draw all the items in the edit list starting... */
  {								    /* ...from item number "itemNumber" */
    xv_set (QuoteMaker_baseWindow->editListScrolledList,
	    PANEL_LIST_STRING, i, FormatEntry(i + 1,
					      editList.label[i],
					      editList.duration[i],
					      editList.hideQTWAfterPlayingEdit[i]),
	    PANEL_LIST_FONT, i, listFont,
	    NULL);
  }
  return;
}								    /* end function RedrawEditList */


void
  CheckIfEditModified(isTextFieldOrChoice)
BOOL  isTextFieldOrChoice;
{
  int    selected;
  
  selected = Selected();
  if (selected != NO_CURRENT_EDIT)
  {
    sprintf(msg, "%d (modified)", selected + 1);
    xv_set(QuoteMaker_baseWindow->currentSelectionNumberLabel,
	   PANEL_LABEL_STRING, msg, NULL);
    if (isTextFieldOrChoice)
    {
      EditTextFieldOrChoiceModified = TRUE;
    }
  }
}


void
  ClearEditModified()
{
  int    selected;
  
  selected = Selected();
  if (selected != NO_CURRENT_EDIT)
  {
    sprintf(msg, "%d", selected + 1);
    xv_set(QuoteMaker_baseWindow->currentSelectionNumberLabel,
	   PANEL_LABEL_STRING, msg, NULL);
    EditTextFieldOrChoiceModified = FALSE;
  }
}
