#!/bin/sh
#
# Installing CE tables for MaMA
#

set -u
set -x

MaMACETEMPLATE="${MaMAHOME}/MaMA/include/CE/MaMA_EditFile.CE"
MaMACETMP="/tmp/MaMACETMP"

sed "s:MaMAHOME:${MaMAHOME}:g" < "${MaMACETEMPLATE}" > "${MaMACETMP}"

if test -f "${HOME}/.cetables/cetables"
then
    ce_db_merge user -from_ascii "${MaMACETMP}"
    echo "--- Merging MaMA attributes in Classing Engine"
else
    ce_db_build user -from_ascii "${MaMACETMP}"
    echo "--- Building Classing Engine table for MaMA attributes"
fi

#rm -f "${MaMACETMP}"

exit 0
