/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_write.c                                                   |
|                                                                              |
|    Contents : Functions to write editlist info to a file                     |
|                                                                              |
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>

extern EDITLISTINFO *EditListInfo;

/******************************************************************************\
*                                                                              *
*        Name : WriteEditList2File                                             *
*                                                                              *
* Description : writes an EditList to a file                                   *
*                                                                              *
\******************************************************************************/

int
WriteEditList2File(EDITLIST *EditListPtr)
{
    FILE *EditListFile;
    char EditListFilename[MAXPATHLEN];

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);

    strcpy(EditListFilename, EditListInfo->FullFileName);

    if((EditListFile = fopen(EditListFilename, "w")) == NULL)
    {
	notice_prompt (MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Unable to open the file!"),
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return(False);
    }

    fprintf(EditListFile, "#MaMA_EDIT_LIST_FILE-");
    fprintf(EditListFile, MaMA_VERSION);
    fprintf(EditListFile, "\n#BEGIN_EDITLIST\n");

    while (EditListPtr != NIL(EDITLIST *))
    {
        WriteEdit2File(EditListFile, EditListPtr);
        EditListPtr = EditListPtr->next;
    }
    fprintf(EditListFile, "#END_EDITLIST\n");
    fclose(EditListFile);

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
    return(True);
}

/******************************************************************************\
*                                                                              *
*        Name : WriteEdit2File                                                 *
*                                                                              *
* Description : write edit info to file                                        *
*                                                                              *
\******************************************************************************/

void
WriteEdit2File(FILE *EditListFile, EDITLIST *EditListPtr)
{
    ACTIONLIST *ActionListPtr;

    fprintf(EditListFile, "#BEGIN_EDIT\n");
    fprintf(EditListFile, "#%s\n", EditListPtr->Label);
    fprintf(EditListFile, "#%d\n", EditListPtr->TotalDur);
    ActionListPtr = EditListPtr->ActionList;

    while(ActionListPtr != NIL(ACTIONLIST *))
    {
        WriteActionList2File(EditListFile, ActionListPtr);
        ActionListPtr = ActionListPtr->next;
    }

    fprintf(EditListFile, "#END_EDIT\n");
}

/******************************************************************************\
*                                                                              *
*        Name : WriteActionList2File                                           *
*                                                                              *
* Description : write ActionList info to file                                  *
*                                                                              *
\******************************************************************************/

void
WriteActionList2File(FILE *EditListFile, ACTIONLIST *ActionListPtr)
{
    fprintf(EditListFile, "#BEGIN_ACTION\n");
    fprintf(EditListFile, "#%s\n", ActionListPtr->Path->Dir);
    fprintf(EditListFile, "#%s\n", ActionListPtr->Path->File);
    fprintf(EditListFile, "#%d\n", ActionListPtr->Duration);
    fprintf(EditListFile, "#%d\n", ActionListPtr->Action->ActionType);
    switch(ActionListPtr->Action->ActionType)
    {
        case Jump:
            fprintf(EditListFile, "#%s\n", 
                ActionListPtr->Action->Param->Hyperlink);

            break;
        case GotoFP:

            break;
        case GotoNP:
            fprintf(EditListFile, "#%d\n", ActionListPtr->Action->Param->Times);

            break;
        case GotoPP:
            fprintf(EditListFile, "#%d\n", ActionListPtr->Action->Param->Times);

            break;
        case GotoLP:

            break;
        case ZoomIn:
            fprintf(EditListFile, "#%d\n", ActionListPtr->Action->Param->Fit);

            break;
        case ZoomOut:
            fprintf(EditListFile, "#%d\n", ActionListPtr->Action->Param->Fit);

            break;
        case Zoom100:
            fprintf(EditListFile, "#%d\n", ActionListPtr->Action->Param->Fit);

            break;
        case OpenDoc:

            break;
        case CloseDoc:

            break;
        case QuitDoc:

            break;
        case InitDoc:

            break;
    }
    fprintf(EditListFile, "#END_ACTION\n");
}
