/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_automnt.c                                                 |
|                                                                              |
|    Contents : Functions to perform on the editlist                           |
|                                                                              |
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>


/******************************************************************************\
*                                                                              *
*        Name : PrintAutoMntList                                               *
*                                                                              *
* Description : Prints the contents of the auto mount list                     *
*                                                                              *
\******************************************************************************/

void
PrintAutoMntList(AUTOMNTLIST *AutoMntListPtr)
{
    fprintf(stderr,"--A--U--T--O--M--N--T--L--I--S--T--\n");
    while(AutoMntListPtr != NIL(AUTOMNTLIST *))
    {
        fprintf(stderr, "\tDirectory    : {%s}\n",AutoMntListPtr->Dir);
        /*Print(Debug_Msg);*/
        AutoMntListPtr = AutoMntListPtr->next;
    }
    fprintf(stderr,"-----------------------------------\n");
}

/******************************************************************************\
*                                                                              *
*        Name : DeleteSelectedAutoMnt                                          *
*                                                                              *
* Description : Delete the first selected from the AutoMntList                 *
*                                                                              *
\******************************************************************************/

AUTOMNTLIST 
*DeleteSelectedAutoMnt(AUTOMNTLIST *AutoMntListPtr)
{
    AUTOMNTLIST *Tmp;
    AUTOMNTLIST *ReturnPtr;
    int row;
    int i;

    ReturnPtr = AutoMntListPtr;

    row = (int)xv_get(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_FIRST_SELECTED);

    if (row < 0)
    {
        return(NIL(AUTOMNTLIST *));
    }

    xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_DELETE, row, NULL);

    if (row == 0)
    {
        if (AutoMntListPtr->next != NIL(AUTOMNTLIST *))
        {
            xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_SELECT, 0, TRUE, 
                NULL);
            (AutoMntListPtr->next)->Selected = True;
        }
        return(AutoMntListPtr->next);
    }

    for (i = 0; i < row - 1; i++)
    {
        AutoMntListPtr = AutoMntListPtr->next;
    }

    Tmp = AutoMntListPtr->next;
    AutoMntListPtr->next = (AutoMntListPtr->next)->next;
    free(Tmp);

    xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_SELECT, 0, TRUE, NULL);
    ReturnPtr->Selected = True;

    return(ReturnPtr);
}

/******************************************************************************\
*                                                                              *
*        Name : UnselectAutoMnt                                                *
*                                                                              *
* Description : Deselect all edits of AutoMntList                              *
*                                                                              *
\******************************************************************************/

void
UnselectAutoMnt(AUTOMNTLIST *AutoMntListPtr)
{
    while(AutoMntListPtr != NIL(AUTOMNTLIST *))
    {
        AutoMntListPtr->Selected = False;
        AutoMntListPtr = AutoMntListPtr->next;
    }
}

/******************************************************************************\
*                                                                              *
*        Name : SelectAutoMnt                                                  *
*                                                                              *
* Description : Set the field Selected of AutoMntList to "Value"               *
*               Deselect all other entries                                     *
*                                                                              *
\******************************************************************************/

void
SelectAutoMnt(AUTOMNTLIST *AutoMntListPtr, int row)
{
    int    entry;

    entry = 0;
    CurAutoMnt = NIL(AUTOMNTLIST *);

    while (AutoMntListPtr != NIL(AUTOMNTLIST *))
    {
        AutoMntListPtr->Selected = False;

        if (entry++ == row)
        {
            AutoMntListPtr->Selected = True;
            CurAutoMnt = AutoMntListPtr;
        }
        AutoMntListPtr = AutoMntListPtr->next;
    } 
}

/******************************************************************************\
*                                                                              *
*        Name : AddAutoMnt                                                     *
*                                                                              *
* Description : Adds a new entry in AutoMntList                                *
*                                                                              *
\******************************************************************************/

AUTOMNTLIST 
*AddAutoMnt(AUTOMNTLIST *AutoMntListPtr)
{
    AUTOMNTLIST *NewAutoMnt;
    char *dir;

    dir = (char *)xv_get(MaMA_Pref_Panel->Add_AutoMnt_tf, PANEL_VALUE);

    if (0 == strncmp(dir, "\0", 1))
    {
        return(AutoMntListPtr);
    }

    UnselectAutoMnt(AutoMntListPtr);

    NewAutoMnt = (AUTOMNTLIST *)malloc((unsigned )sizeof(AUTOMNTLIST));
    NewAutoMnt->next = AutoMntListPtr;
    NewAutoMnt->Selected = True;
    strcpy(NewAutoMnt->Dir, dir);

    xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_INSERT, 0, 
        PANEL_LIST_STRING, 0, dir, NULL);
    xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_SELECT, 0, TRUE, NULL);

    xv_set(MaMA_Pref_Panel->Add_AutoMnt_tf, PANEL_VALUE, "",  NULL);
    return(NewAutoMnt);
}
 
/******************************************************************************\
*                                                                              *
*        Name : GetSelectedAutoMnt                                             *
*                                                                              *
* Description : Return a pointer to the currently selected AutoMnt             *
*                                                                              *
\******************************************************************************/

AUTOMNTLIST
*GetSelectedAutoMnt(AUTOMNTLIST *AutoMntListPtr)
{
    while (AutoMntListPtr != NIL(AUTOMNTLIST *))
    {
        if (AutoMntListPtr->Selected)
        {
            return(AutoMntListPtr);
        }
        AutoMntListPtr = AutoMntListPtr->next;
    }
    return(NIL(AUTOMNTLIST *));
}
 
/******************************************************************************\
*                                                                              *
*        Name : FreeAutoMntList                                                *
*                                                                              *
* Description : Frees the allocated space for the AutoMntList                  *
*                                                                              *
\******************************************************************************/

void
FreeAutoMntList(AUTOMNTLIST *AutoMntListPtr)
{
    AUTOMNTLIST *Tmp;

    if (AutoMntListPtr == NIL(AUTOMNTLIST *))
    {
        return;
    }

    while (AutoMntListPtr != NIL(AUTOMNTLIST *))
    {
        Tmp = AutoMntListPtr;
        AutoMntListPtr = AutoMntListPtr->next;
        free(Tmp);
    }
}


/******************************************************************************\
*                                                                              *
*        Name : RemoveAutoMntDir                                               *
*                                                                              *
* Description : Removes the name of the auto mount dir from the given path     *
*                                                                              *
\******************************************************************************/

char
*RemoveAutoMntDir(char *Path)
{
    int i;
    int len;
    AUTOMNTLIST *AutoMntListPtr;

    i = 0;

    AutoMntListPtr = AutoMntList;
    /*
     * Check for each entry in auto mount array
     */
    while(AutoMntListPtr != NIL(AUTOMNTLIST *))
    {
        len = strlen(AutoMntListPtr->Dir) - 1;	/* length of this automnt dir */
        /*
         * Does given path start with this auto mount dir?
         */
        if (0 == strncmp(Path, AutoMntListPtr->Dir, len))
        {
            int j;

            for (j = 0; j <= len; j++, Path++); /* Skip auto mount dir        */
            return(Path);                       /* return chopped path        */        }

        AutoMntListPtr = AutoMntListPtr->next;
    }
 
    /*
     * No auto mount dir found => return original
     */
    return(Path);
}

