/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/bryant/DisplayTool/RCS/file.c,v 1.1 92/10/29 13:54:32 drapeau Exp $ */
/* $Log:	file.c,v $
 * Revision 1.1  92/10/29  13:54:32  drapeau
 * Initial revision
 *  */
static char dtFile[] = "$Header: /Source/Media/bryant/DisplayTool/RCS/file.c,v 1.1 92/10/29 13:54:32 drapeau Exp $";

#include "DisplayTool.h"
#include "externs.h"



int 
  OpenEditFile(void)
{
  int	i, counter, temp1, temp2;
  int	totalNumberOfImages = 0;
  char	message[MaxLength];
  char	line[MAXPATHLEN];
  char	fileType[MaxLength];
  char*	tempFilename;
  char*	tempDuration;
  char*	tempLabel;
  FILE*	fp;
  
  fp = (FILE *)fopen(currentFilename, "r");
  fscanf (fp, "#%s Document#\n", fileType);			
  if (strcmp(fileType, "DisplayTool"))				
    {								
      sprintf (message, "'%s' is not an DisplayTool list\n", currentFilename);
      notice_prompt(baseWindow->baseWindow, NULL,
		    NOTICE_MESSAGE_STRINGS,
		    message,
		    NULL,
		    NOTICE_BUTTON_YES, "OK",
		    NULL);
      return None;
      fclose(fp);
    }
  fscanf (fp, "#Number of Slides:\t%d\n", &temp1);		
  numSlides = temp1;
  fscanf (fp, "#Number of Images:\t%d\n", &temp1);		
  numSlidesImages = temp1;
  for (counter=0; counter<numSlides; counter++)
    {
      fgets(line,512,fp);					    /* skip the #Slide: */                              
      fgets(line,512,fp);	                                
      tempLabel = &line[9];
      tempLabel[strlen(tempLabel)-1] = '\0';	        
      slide[counter]->label = (char *)strdup(tempLabel);			        
      fgets(line,512,fp);	                                
      tempDuration = &line[11];
      tempDuration[strlen(tempDuration)-1] = '\0';	        
      slide[counter]->duration = (char *)strdup(tempDuration);			        
      fscanf (fp, "#NumImages:\t%d\n", &temp1);		
      slide[counter]->numberOfImages = temp1;
      for (i=0; i<slide[counter]->numberOfImages; i++)
	{
	  dtImage[totalNumberOfImages] = (IMAGE)malloc(sizeof(struct ImageStruct));
	  NullFields(dtImage[totalNumberOfImages]);
	  fgets(line,MAXPATHLEN,fp);	                                
	  tempFilename = &line[11];
	  tempFilename[strlen(tempFilename)-1] = '\0';	        
	  dtImage[totalNumberOfImages]->filename = (char *)strdup(tempFilename);
	  fscanf (fp, "#LocXY:\t\t%d %d\n", &temp1, &temp2);		
	  dtImage[totalNumberOfImages]->corner.x = (int)(temp1/largeFactor);
	  dtImage[totalNumberOfImages]->corner.y = (int)(temp2/largeFactor);
	  fscanf (fp, "#WidthHeight:\t%d %d\n", &temp1, &temp2);		
	  dtImage[totalNumberOfImages]->largeWidth = (int)temp1;
	  dtImage[totalNumberOfImages]->largeHeight = (int)temp2;
	  dtImage[totalNumberOfImages]->slide = counter;
	  slide[counter]->imageIds[i] = totalNumberOfImages++;
	}
    } 
  fclose(fp);
  SetCurrentSlide(0);
  sprintf(message, "Total Number of Slides :  %d", numSlides);
  xv_set(baseWindow->totalNumberOfSlidesMessage, PANEL_LABEL_STRING, 
	 message, NULL);
  if ((int)xv_get(slidesScrollbar, SCROLLBAR_VIEW_START) != 0)
    xv_set(slidesScrollbar, SCROLLBAR_VIEW_START, 0, NULL); 
  changes = False; 
  return(0);
}								    /* end function OpenEditFile */





int                                            /* browser code */
  OpenHandler(char *proposedPath, int id)
{
  char temp[MaxLength];
  int i, j;
  
  if (id != 0)							    /* Was this a request to open a DisplayTool document? */
    {								    /* Yes, continue */
      if (strstr(proposedPath, "untitled") == NULL && strlen(proposedPath) > 0) 
	{
	  if (verbose)
	    printf("Opening Edit List: %s\n", proposedPath);
	  strcpy(currentFilename, proposedPath);
	  sprintf(temp, "DisplayTool Document :  \"%s\"", proposedPath);
	  xv_set(baseWindow->baseWindow, XV_LABEL, temp, NULL);
	  if (numSlidesImages > 0)
	    ClearAll(NULL, MENU_NOTIFY);
	  if (slideSize != Small)
	    ShowFullSize(NULL, Small, NULL);
	  OpenEditFile();
	  theCmap = slidesCmap;
	  theDisp = display;
	  if (performing == 0)					    /* Only load all slides if not in performance mode; i.e.,... */
	    for (i=0; i<numSlides; i++)				    /* ...if not being called by another MAEstro application */
	      DisplayImages(i);
	  previousSlide = 0;
	  selectedSlide = 0;
	  SetCurrentSlide(1);
	  xv_set(slidePopup->duration, PANEL_VALUE, slide[selectedSlide]->duration, NULL);
	  if (slide[selectedSlide]->label)
	    if (strncmp(slide[selectedSlide]->label, "No Label", 8) != 0)
	      xv_set(slidePopup->label, PANEL_VALUE, slide[selectedSlide]->label, NULL);
	    else
	      xv_set(slidePopup->label, PANEL_VALUE, "", NULL);
	  RedrawRectangles();
	  SlidesRepaint(NULL, NULL, NULL, NULL); 
	}
    }
  else								    /* No, don't open a DisplayTool document; instead, open... */
    LoadGalleryImage(proposedPath);				    /* ...an image to put in the gallery */
  return 0;
}								    /* end function OpenHandler */

int								    /* Browser code */
  SaveHandler(char *proposedPath, int id)
{
  char temp[MaxLength];
  if (strstr(proposedPath, "untitled") == NULL && strlen(proposedPath) > 0) 
    {
      CheckGeometry();
      strcpy(currentFilename, proposedPath);
      WriteSequenceToFile();
      return 0;
    }
  else
    {
      sprintf(temp, "Can't save to %s.\n", proposedPath);
      notice_prompt(baseWindow->baseWindow, NULL,
		    NOTICE_MESSAGE_STRINGS,
		    temp,
		    "Try saving to a different name.",
		    NULL,
		    NOTICE_BUTTON_YES, "OK",
		    NULL);
      return None;
    }
}

void WriteSequenceToFile(void)
{
  FILE *fp, *fpRead;
  char fileType[MaxLength];
  int response, imageNum, slideNum;
  int i, counter;
  int maxSlide;
  char message[MaxLength];
  if (strstr(currentFilename, "untitled") != NULL || strlen(currentFilename) == 0) 
    {
      Browse(realpath(currentFilename, dummy), 
	     BrowseSave, NULL, "#DisplayTool Document#", "DisplayTool"); 
      return;
    }
  if ((fpRead = fopen(currentFilename, "r")) != (FILE *)NULL)
    {
      fscanf (fpRead, "#%s Document#\n", fileType);	
      if (strcmp(fileType, "DisplayTool"))				
	{								
	  sprintf (message, "'%s' exists and is not a DisplayTool list.\n", currentFilename);
	  response = notice_prompt(baseWindow->baseWindow, NULL,
				   NOTICE_MESSAGE_STRINGS,
				   message,
				   "Go ahead and overwrite its contents?",
				   NULL,
				   NOTICE_BUTTON_NO, "Yes",
				   NOTICE_BUTTON_YES, "Cancel",
				   NULL);
	  if (response == NOTICE_YES)
	    {
	      fclose(fpRead);
	      return;
	    }
	}
      else
	{
	  sprintf (message, "'%s' is already a DisplayTool list.\n", currentFilename);
	  response = notice_prompt(baseWindow->baseWindow, NULL,
				   NOTICE_MESSAGE_STRINGS,
				   message,
				   "Go ahead and overwrite its contents?",
				   NULL,
				   NOTICE_BUTTON_NO, "Yes",
				   NOTICE_BUTTON_YES, "Cancel",
				   NULL);
	  if (response == NOTICE_YES)
	    {
	      fclose(fpRead);
	      return;
	    }
	}
    }
  if ((fp = fopen(currentFilename, "w")) == (FILE *)NULL)
    {
      sprintf(message, "Can't open '%s' for writing.", currentFilename);
      notice_prompt(baseWindow->baseWindow, NULL,
		    NOTICE_MESSAGE_STRINGS,
		    message,
		    NULL,
		    NOTICE_BUTTON_YES, "OK",
		    NULL);
      fclose(fp);
      return;
    }
  if (slideSize != Small)
    {
      xv_set(baseWindow->showFullSize, PANEL_VALUE, 2, NULL);
      ShowFullSize(NULL, Small, NULL);
      
    }
  if (numSlidesImages == 0)
    {
      notice_prompt(baseWindow->baseWindow, NULL,
		    NOTICE_MESSAGE_STRINGS,
		    "No sequence to save.",
		    NULL,
		    NOTICE_BUTTON_YES, "OK",
		    NULL);
      return;
    }
  maxSlide = GetMaxSlide();
  for (i=0; i<MaxNumSlides; i++)
    slide[i]->numberOfImages = 0;
  for (counter = 0; counter < numSlidesImages; counter ++)	
    {
      slideNum = dtImage[counter]->slide;
      slide[slideNum]->imageIds[slide[slideNum]->numberOfImages++] = counter;
    }
  fprintf (fp, "#DisplayTool Document#\n");
  fprintf (fp, "#Number of Slides:\t%d\n", maxSlide+1);	
  fprintf (fp, "#Number of Images:\t%d\n", numSlidesImages);
  for (counter = 0; counter <= maxSlide; counter ++)			   
    {	
      fprintf(fp, "\n#Slide:\t%d\n#Label:\t\t%s\n#Duration:\t%s\n#NumImages:\t%d\n",	   
	      counter+1, slide[counter]->label,  slide[counter]->duration, slide[counter]->numberOfImages);
      for (i=0; i<slide[counter]->numberOfImages; i++)
	{
	  imageNum = slide[counter]->imageIds[i];
	  fprintf(fp, "#Filename:\t%s\n#LocXY:\t\t%d %d\n#WidthHeight:\t%d %d\n",	   
		  dtImage[imageNum]->filename, 6 * dtImage[imageNum]->corner.x, 
		  6 * dtImage[imageNum]->corner.y,
		  dtImage[imageNum]->largeWidth, dtImage[imageNum]->largeHeight);
	}
    }
  fclose (fp);							   
  changes = False; 
  return;
}								    /* end function WriteSequenceToFile */



void 
  LoadGalleryImage(char *file)
{
  IMAGE	tempImage = (IMAGE)NULL;
  
  sprintf(diagString, "Entering LoadGalleryImage with filename %s.\n", file);
  PrintDTDiagnostics(diagString);
  theCmap = galleryCmap;
  theDisp = display;
  XSetLineAttributes(display, theGC, 2, LineSolid, CapProjecting, JoinMiter);
  if (gallery[numGalleryImages] != (IMAGE)NULL)
    PrintDTDiagnostics("In LoadGalleryImage, gallery image is already allocated.\n");
  if ((gallery[numGalleryImages] =				    /* CreateImage will allocate and zero-fill an... */
       CreateImage(file)) != NULL)				    /* ...IMAGE structure */
    {
      tempImage = gallery[numGalleryImages];
      PaintGalleryImage(numGalleryImages);			    /* Draw the new gallery image in the Gallery  */
      numGalleryImages++;
    }
}								    /* end function LoadGalleryImage */
