/*
 * DisplayTool_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `DisplayTool.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "DisplayTool_ui.h"

/*
 * Create object `imagesMenu' in the specified instance.
 */
Xv_opaque
DisplayTool_imagesMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	LoadImages(Menu_item, Menu_generate);
	extern Menu_item	ClearSelectedImages(Menu_item, Menu_generate);
	extern Menu_item	ClearGallery(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Images:",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Load Images ...",
			MENU_GEN_PROC, LoadImages,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear Selected Images",
			MENU_GEN_PROC, ClearSelectedImages,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear Gallery",
			MENU_GEN_PROC, ClearGallery,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Images:",
		NULL);
	return obj;
}

/*
 * Create object `documentMenu' in the specified instance.
 */
Xv_opaque
DisplayTool_documentMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	OpenSequence(Menu_item, Menu_generate);
	extern Menu_item	Info(Menu_item, Menu_generate);
	extern Menu_item	SaveSequence(Menu_item, Menu_generate);
	extern Menu_item	SaveSequenceAs(Menu_item, Menu_generate);
	extern Menu_item	Help(Menu_item, Menu_generate);
	extern Menu_item	Close(Menu_item, Menu_generate);
	extern Menu_item	QuitDisplayTool(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Document:",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Open ...",
			MENU_GEN_PROC, OpenSequence,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Info ...",
			MENU_GEN_PROC, Info,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save Sequence",
			MENU_GEN_PROC, SaveSequence,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save Sequence As ...",
			MENU_GEN_PROC, SaveSequenceAs,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Help ...",
			MENU_GEN_PROC, Help,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close",
			MENU_GEN_PROC, Close,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Quit",
			MENU_GEN_PROC, QuitDisplayTool,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Document:",
		NULL);
	return obj;
}

/*
 * Create object `slidesMenu' in the specified instance.
 */
Xv_opaque
DisplayTool_slidesMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	SlideInfo(Menu_item, Menu_generate);
	extern Menu_item	RedrawSlides(Menu_item, Menu_generate);
	extern Menu_item	CopySlide(Menu_item, Menu_generate);
	extern Menu_item	CutSlide(Menu_item, Menu_generate);
	extern Menu_item	InsertClipboardSlide(Menu_item, Menu_generate);
	extern Menu_item	InsertNewSlide(Menu_item, Menu_generate);
	extern Menu_item	ClearSlide(Menu_item, Menu_generate);
	extern Menu_item	ClearAll(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Slides:",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Slide Info ...",
			MENU_GEN_PROC, SlideInfo,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Redraw Slides",
			MENU_GEN_PROC, RedrawSlides,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Copy Slide",
			MENU_GEN_PROC, CopySlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Cut Slide",
			MENU_GEN_PROC, CutSlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Insert Clipboard Slide",
			MENU_GEN_PROC, InsertClipboardSlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Insert New Slide",
			MENU_GEN_PROC, InsertNewSlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear Slide",
			MENU_GEN_PROC, ClearSlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear All",
			MENU_GEN_PROC, ClearAll,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Slides:",
		NULL);
	return obj;
}

/*
 * Create object `imageEditMenu' in the specified instance.
 */
Xv_opaque
DisplayTool_imageEditMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	DuplicateImage(Menu_item, Menu_generate);
	extern Menu_item	CutImage(Menu_item, Menu_generate);
	extern Menu_item	ResizeImageGeneral(Menu_item, Menu_generate);
	extern Menu_item	ResizeImagePlus10Percent(Menu_item, Menu_generate);
	extern Menu_item	ResizeImageMinus10Percent(Menu_item, Menu_generate);
	extern Menu_item	ImageEditSetToOriginalSize(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Edit Image:",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Duplicate Image",
			MENU_GEN_PROC, DuplicateImage,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Cut",
			MENU_GEN_PROC, CutImage,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Resize",
			MENU_GEN_PROC, ResizeImageGeneral,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Resize + 10%",
			MENU_GEN_PROC, ResizeImagePlus10Percent,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Resize - 10%",
			MENU_GEN_PROC, ResizeImageMinus10Percent,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set To Original Size",
			MENU_GEN_PROC, ImageEditSetToOriginalSize,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Edit Image:",
		NULL);
	return obj;
}

/*
 * Create object `selectSlideMenu' in the specified instance.
 */
Xv_opaque
DisplayTool_selectSlideMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	NextSlide(Menu_item, Menu_generate);
	extern Menu_item	PreviousSlide(Menu_item, Menu_generate);
	extern Menu_item	FirstSlide(Menu_item, Menu_generate);
	extern Menu_item	LastSlide(Menu_item, Menu_generate);
	extern Menu_item	SlideNumberPopup(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Select Slide:",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Next Slide",
			MENU_GEN_PROC, NextSlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Previous Slide",
			MENU_GEN_PROC, PreviousSlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "First Slide",
			MENU_GEN_PROC, FirstSlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Last Slide",
			MENU_GEN_PROC, LastSlide,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Slide Number ...",
			MENU_GEN_PROC, SlideNumberPopup,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Select Slide:",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `baseWindow'.
 */
DisplayTool_baseWindow_objects *
DisplayTool_baseWindow_objects_initialize(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (DisplayTool_baseWindow_objects *) calloc(1, sizeof (DisplayTool_baseWindow_objects))))
		return (DisplayTool_baseWindow_objects *) NULL;
	if (!ip->baseWindow)
		ip->baseWindow = DisplayTool_baseWindow_baseWindow_create(ip, owner);
	if (!ip->controls1)
		ip->controls1 = DisplayTool_baseWindow_controls1_create(ip, ip->baseWindow);
	if (!ip->message1)
		ip->message1 = DisplayTool_baseWindow_message1_create(ip, ip->controls1);
	if (!ip->documentButton)
		ip->documentButton = DisplayTool_baseWindow_documentButton_create(ip, ip->controls1);
	if (!ip->imagesButton)
		ip->imagesButton = DisplayTool_baseWindow_imagesButton_create(ip, ip->controls1);
	if (!ip->currentImageMsg)
		ip->currentImageMsg = DisplayTool_baseWindow_currentImageMsg_create(ip, ip->controls1);
	if (!ip->gallery)
		ip->gallery = DisplayTool_baseWindow_gallery_create(ip, ip->baseWindow);
	if (!ip->borderControls)
		ip->borderControls = DisplayTool_baseWindow_borderControls_create(ip, ip->baseWindow);
	if (!ip->showFullSizeMessage)
		ip->showFullSizeMessage = DisplayTool_baseWindow_showFullSizeMessage_create(ip, ip->borderControls);
	if (!ip->message4)
		ip->message4 = DisplayTool_baseWindow_message4_create(ip, ip->borderControls);
	if (!ip->currentSlideMessage)
		ip->currentSlideMessage = DisplayTool_baseWindow_currentSlideMessage_create(ip, ip->borderControls);
	if (!ip->slidesButton)
		ip->slidesButton = DisplayTool_baseWindow_slidesButton_create(ip, ip->borderControls);
	if (!ip->showFullSize)
		ip->showFullSize = DisplayTool_baseWindow_showFullSize_create(ip, ip->borderControls);
	if (!ip->totalNumberOfSlidesMessage)
		ip->totalNumberOfSlidesMessage = DisplayTool_baseWindow_totalNumberOfSlidesMessage_create(ip, ip->borderControls);
	if (!ip->slides)
		ip->slides = DisplayTool_baseWindow_slides_create(ip, ip->baseWindow);
	if (!ip->controls2)
		ip->controls2 = DisplayTool_baseWindow_controls2_create(ip, ip->baseWindow);
	return ip;
}

/*
 * Create object `baseWindow' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_baseWindow_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque		baseWindow_image;
	static unsigned short	baseWindow_bits[] = {
#include "DisplayTool.icon"
	};
	Xv_opaque		baseWindow_image_mask;
	static unsigned short	baseWindow_mask_bits[] = {
#include "DisplayTool.icon"
	};
	
	baseWindow_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, baseWindow_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	baseWindow_image_mask = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, baseWindow_mask_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 645,
		XV_HEIGHT, 619,
		XV_LABEL, "Display Tool Document :  \"untitled\"",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, baseWindow_image,
			ICON_MASK_IMAGE, baseWindow_image_mask,
			NULL),
		NULL);
	return obj;
}

/*
 * Create object `controls1' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_controls1_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 54,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message1' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_message1_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 224,
		XV_Y, 8,
		PANEL_LABEL_STRING, "IMAGE GALLERY:  Drag images onto the slides",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `documentButton' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_documentButton_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 20,
		PANEL_LABEL_STRING, "Document",
		PANEL_ITEM_MENU, DisplayTool_documentMenu_create((caddr_t) ip, ip->baseWindow),
		NULL);
	return obj;
}

/*
 * Create object `imagesButton' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_imagesButton_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 128,
		XV_Y, 20,
		PANEL_LABEL_STRING, "Images",
		PANEL_ITEM_MENU, DisplayTool_imagesMenu_create((caddr_t) ip, ip->baseWindow),
		NULL);
	return obj;
}

/*
 * Create object `currentImageMsg' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_currentImageMsg_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 224,
		XV_Y, 32,
		PANEL_LABEL_STRING, "Current Image: None",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `gallery' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_gallery_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	extern Notify_value	DisplayTool_baseWindow_gallery_event_callback(Xv_window, Event *, Notify_arg, Notify_event_type);
	extern void	GalleryRepaint(Canvas, Xv_window, Display *, Window, Xv_xrectlist *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 53,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 211,
		CANVAS_REPAINT_PROC, GalleryRepaint,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	gcm_initialize_colors(obj, "White", NULL);
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) DisplayTool_baseWindow_gallery_event_callback, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `borderControls' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_borderControls_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 263,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 48,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `showFullSizeMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_showFullSizeMessage_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 144,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Show Full Size:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message4' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_message4_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 288,
		XV_Y, 8,
		PANEL_LABEL_STRING, "SLIDES:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `currentSlideMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_currentSlideMessage_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 352,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Current Slide    # 1 ",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `slidesButton' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_slidesButton_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Slides",
		PANEL_ITEM_MENU, DisplayTool_slidesMenu_create((caddr_t) ip, ip->baseWindow),
		NULL);
	return obj;
}

/*
 * Create object `showFullSize' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_showFullSize_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		ShowFullSize(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TOGGLE, PANEL_FEEDBACK, PANEL_MARKED,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 144,
		XV_Y, 18,
		PANEL_CHOICE_NCOLS, 3,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, ShowFullSize,
		PANEL_CHOICE_STRINGS,
			"Yes",
			"No",
			NULL,
		PANEL_VALUE, 0,
		NULL);
	return obj;
}

/*
 * Create object `totalNumberOfSlidesMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_totalNumberOfSlidesMessage_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 288,
		XV_Y, 24,
		PANEL_LABEL_STRING, "Total Number of Slides :  0  ",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `slides' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_slides_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	extern Notify_value	DisplayTool_baseWindow_slides_event_callback(Xv_window, Event *, Notify_arg, Notify_event_type);
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 310,
		XV_WIDTH, 597,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	gcm_initialize_colors(obj, "White", NULL);
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) DisplayTool_baseWindow_slides_event_callback, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `controls2' in the specified instance.
 */
Xv_opaque
DisplayTool_baseWindow_controls2_create(DisplayTool_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 595,
		XV_Y, 310,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `infoPopup'.
 */
DisplayTool_infoPopup_objects *
DisplayTool_infoPopup_objects_initialize(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (DisplayTool_infoPopup_objects *) calloc(1, sizeof (DisplayTool_infoPopup_objects))))
		return (DisplayTool_infoPopup_objects *) NULL;
	if (!ip->infoPopup)
		ip->infoPopup = DisplayTool_infoPopup_infoPopup_create(ip, owner);
	if (!ip->InfoControlPanel)
		ip->InfoControlPanel = DisplayTool_infoPopup_InfoControlPanel_create(ip, ip->infoPopup);
	if (!ip->appNameMessage)
		ip->appNameMessage = DisplayTool_infoPopup_appNameMessage_create(ip, ip->InfoControlPanel);
	if (!ip->appNameMessage1)
		ip->appNameMessage1 = DisplayTool_infoPopup_appNameMessage1_create(ip, ip->InfoControlPanel);
	if (!ip->appDescriptionMessage1)
		ip->appDescriptionMessage1 = DisplayTool_infoPopup_appDescriptionMessage1_create(ip, ip->InfoControlPanel);
	if (!ip->appDescriptionMessage2)
		ip->appDescriptionMessage2 = DisplayTool_infoPopup_appDescriptionMessage2_create(ip, ip->InfoControlPanel);
	if (!ip->developerMessage)
		ip->developerMessage = DisplayTool_infoPopup_developerMessage_create(ip, ip->InfoControlPanel);
	if (!ip->message5)
		ip->message5 = DisplayTool_infoPopup_message5_create(ip, ip->InfoControlPanel);
	if (!ip->copyrightMessage)
		ip->copyrightMessage = DisplayTool_infoPopup_copyrightMessage_create(ip, ip->InfoControlPanel);
	if (!ip->copyrightMessage2)
		ip->copyrightMessage2 = DisplayTool_infoPopup_copyrightMessage2_create(ip, ip->InfoControlPanel);
	if (!ip->copyrightMessage3)
		ip->copyrightMessage3 = DisplayTool_infoPopup_copyrightMessage3_create(ip, ip->InfoControlPanel);
	if (!ip->moreInfoMessage)
		ip->moreInfoMessage = DisplayTool_infoPopup_moreInfoMessage_create(ip, ip->InfoControlPanel);
	if (!ip->info)
		ip->info = DisplayTool_infoPopup_info_create(ip, ip->InfoControlPanel);
	return ip;
}

/*
 * Create object `infoPopup' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_infoPopup_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 532,
		XV_HEIGHT, 292,
		XV_LABEL, "Display Tool Info",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `InfoControlPanel' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_InfoControlPanel_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `appNameMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_appNameMessage_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 144,
		XV_Y, 12,
		PANEL_LABEL_STRING, "Display Tool",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `appNameMessage1' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_appNameMessage1_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 256,
		XV_Y, 12,
		PANEL_LABEL_STRING, "Version 1.3",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `appDescriptionMessage1' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_appDescriptionMessage1_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 92,
		XV_Y, 40,
		PANEL_LABEL_STRING, "An application for displaying and manipulating images",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `appDescriptionMessage2' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_appDescriptionMessage2_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 64,
		PANEL_LABEL_STRING, "designed for use with the MAEstro Multimedia Authoring Environment",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `developerMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_developerMessage_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 96,
		PANEL_LABEL_STRING, "by Bryant Marks and Janylyn Marks",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message5' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_message5_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 120,
		PANEL_LABEL_STRING, "Modifications by George Drapeau",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyrightMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_copyrightMessage_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 80,
		XV_Y, 160,
		PANEL_LABEL_STRING, "Copyright (C) 1992 Libraries and Information Resources (L&IR)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyrightMessage2' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_copyrightMessage2_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 196,
		XV_Y, 180,
		PANEL_LABEL_STRING, "Stanford University",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyrightMessage3' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_copyrightMessage3_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 196,
		XV_Y, 200,
		PANEL_LABEL_STRING, "Stanford, California",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `moreInfoMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_moreInfoMessage_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 96,
		XV_Y, 224,
		PANEL_LABEL_STRING, "For more information, contact maestro@sioux.stanford.edu",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `info' in the specified instance.
 */
Xv_opaque
DisplayTool_infoPopup_info_create(DisplayTool_infoPopup_objects *ip, Xv_opaque owner)
{
	extern void		DoneHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 232,
		XV_Y, 256,
		PANEL_LABEL_STRING, "OK",
		PANEL_NOTIFY_PROC, DoneHandler,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `helpPopup'.
 */
DisplayTool_helpPopup_objects *
DisplayTool_helpPopup_objects_initialize(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (DisplayTool_helpPopup_objects *) calloc(1, sizeof (DisplayTool_helpPopup_objects))))
		return (DisplayTool_helpPopup_objects *) NULL;
	if (!ip->helpPopup)
		ip->helpPopup = DisplayTool_helpPopup_helpPopup_create(ip, owner);
	if (!ip->controls3)
		ip->controls3 = DisplayTool_helpPopup_controls3_create(ip, ip->helpPopup);
	if (!ip->info2)
		ip->info2 = DisplayTool_helpPopup_info2_create(ip, ip->controls3);
	if (!ip->message2)
		ip->message2 = DisplayTool_helpPopup_message2_create(ip, ip->controls3);
	if (!ip->message3)
		ip->message3 = DisplayTool_helpPopup_message3_create(ip, ip->controls3);
	if (!ip->message6)
		ip->message6 = DisplayTool_helpPopup_message6_create(ip, ip->controls3);
	if (!ip->message7)
		ip->message7 = DisplayTool_helpPopup_message7_create(ip, ip->controls3);
	if (!ip->message8)
		ip->message8 = DisplayTool_helpPopup_message8_create(ip, ip->controls3);
	return ip;
}

/*
 * Create object `helpPopup' in the specified instance.
 */
Xv_opaque
DisplayTool_helpPopup_helpPopup_create(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 544,
		XV_HEIGHT, 579,
		XV_LABEL, "Display Tool Help",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls3' in the specified instance.
 */
Xv_opaque
DisplayTool_helpPopup_controls3_create(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `info2' in the specified instance.
 */
Xv_opaque
DisplayTool_helpPopup_info2_create(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	extern void		DoneHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 216,
		XV_Y, 16,
		PANEL_LABEL_STRING, "OK",
		PANEL_NOTIFY_PROC, DoneHandler,
		NULL);
	return obj;
}

/*
 * Create object `message2' in the specified instance.
 */
Xv_opaque
DisplayTool_helpPopup_message2_create(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 48,
		PANEL_LABEL_STRING, "To resize images, use the rightmost mouse button and drag the image from one",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message3' in the specified instance.
 */
Xv_opaque
DisplayTool_helpPopup_message3_create(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 64,
		PANEL_LABEL_STRING, "of the corners.",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message6' in the specified instance.
 */
Xv_opaque
DisplayTool_helpPopup_message6_create(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 96,
		PANEL_LABEL_STRING, "Set the duration field in seconds to the desired length of time to display each",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message7' in the specified instance.
 */
Xv_opaque
DisplayTool_helpPopup_message7_create(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 112,
		PANEL_LABEL_STRING, "slide, or press the \"Until Next Slide\" button.  This puts the slide in \"indefinite\"",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message8' in the specified instance.
 */
Xv_opaque
DisplayTool_helpPopup_message8_create(DisplayTool_helpPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 128,
		PANEL_LABEL_STRING, "mode, so that it will display indefinitely until the next slide is displayed.",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `slidePopup'.
 */
DisplayTool_slidePopup_objects *
DisplayTool_slidePopup_objects_initialize(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (DisplayTool_slidePopup_objects *) calloc(1, sizeof (DisplayTool_slidePopup_objects))))
		return (DisplayTool_slidePopup_objects *) NULL;
	if (!ip->slidePopup)
		ip->slidePopup = DisplayTool_slidePopup_slidePopup_create(ip, owner);
	if (!ip->controls5)
		ip->controls5 = DisplayTool_slidePopup_controls5_create(ip, ip->slidePopup);
	if (!ip->selectSlideButton)
		ip->selectSlideButton = DisplayTool_slidePopup_selectSlideButton_create(ip, ip->controls5);
	if (!ip->currentSlideInfoMessage)
		ip->currentSlideInfoMessage = DisplayTool_slidePopup_currentSlideInfoMessage_create(ip, ip->controls5);
	if (!ip->label)
		ip->label = DisplayTool_slidePopup_label_create(ip, ip->controls5);
	if (!ip->indefiniteButton)
		ip->indefiniteButton = DisplayTool_slidePopup_indefiniteButton_create(ip, ip->controls5);
	if (!ip->duration)
		ip->duration = DisplayTool_slidePopup_duration_create(ip, ip->controls5);
	if (!ip->imageList)
		ip->imageList = DisplayTool_slidePopup_imageList_create(ip, ip->controls5);
	if (!ip->imageNameMessage)
		ip->imageNameMessage = DisplayTool_slidePopup_imageNameMessage_create(ip, ip->controls5);
	if (!ip->imageName)
		ip->imageName = DisplayTool_slidePopup_imageName_create(ip, ip->controls5);
	if (!ip->imageFormatMessage)
		ip->imageFormatMessage = DisplayTool_slidePopup_imageFormatMessage_create(ip, ip->controls5);
	if (!ip->imageFormat)
		ip->imageFormat = DisplayTool_slidePopup_imageFormat_create(ip, ip->controls5);
	if (!ip->imageOriginalSizeMessage)
		ip->imageOriginalSizeMessage = DisplayTool_slidePopup_imageOriginalSizeMessage_create(ip, ip->controls5);
	if (!ip->imageOriginalSize)
		ip->imageOriginalSize = DisplayTool_slidePopup_imageOriginalSize_create(ip, ip->controls5);
	if (!ip->imageWidth)
		ip->imageWidth = DisplayTool_slidePopup_imageWidth_create(ip, ip->controls5);
	if (!ip->imageEditButton)
		ip->imageEditButton = DisplayTool_slidePopup_imageEditButton_create(ip, ip->controls5);
	if (!ip->imageHeight)
		ip->imageHeight = DisplayTool_slidePopup_imageHeight_create(ip, ip->controls5);
	if (!ip->imageXPosition)
		ip->imageXPosition = DisplayTool_slidePopup_imageXPosition_create(ip, ip->controls5);
	if (!ip->imageYPosition)
		ip->imageYPosition = DisplayTool_slidePopup_imageYPosition_create(ip, ip->controls5);
	return ip;
}

/*
 * Create object `slidePopup' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_slidePopup_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 437,
		XV_HEIGHT, 507,
		XV_LABEL, "Slide Information",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls5' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_controls5_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `selectSlideButton' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_selectSlideButton_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 20,
		PANEL_LABEL_STRING, "Select Slide",
		PANEL_ITEM_MENU, DisplayTool_selectSlideMenu_create((caddr_t) ip, ip->slidePopup),
		NULL);
	return obj;
}

/*
 * Create object `currentSlideInfoMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_currentSlideInfoMessage_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 24,
		PANEL_LABEL_STRING, "Current Slide    # 1 ",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `label' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_label_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	extern void		LabelEventProc(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 64,
		PANEL_VALUE_DISPLAY_LENGTH, 28,
		PANEL_VALUE_STORED_LENGTH, 255,
		PANEL_LABEL_STRING, "Label :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_LEVEL, PANEL_ALL,
		PANEL_EVENT_PROC, LabelEventProc,
		NULL);
	return obj;
}

/*
 * Create object `indefiniteButton' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_indefiniteButton_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	extern void		Indefinite(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 248,
		XV_Y, 100,
		PANEL_LABEL_STRING, "Until Next Slide",
		PANEL_NOTIFY_PROC, Indefinite,
		NULL);
	return obj;
}

/*
 * Create object `duration' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_duration_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	extern void		DurationEventProc(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 104,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Display Time (in sec) :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_LEVEL, PANEL_ALL,
		PANEL_EVENT_PROC, DurationEventProc,
		NULL);
	return obj;
}

/*
 * Create object `imageList' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageList_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	extern int		ImageList(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 152,
		PANEL_LIST_WIDTH, 390,
		PANEL_LIST_DISPLAY_ROWS, 5,
		PANEL_LIST_TITLE, "Images:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, TRUE,
		PANEL_NOTIFY_PROC, ImageList,
		NULL);
	return obj;
}

/*
 * Create object `imageNameMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageNameMessage_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 312,
		PANEL_LABEL_STRING, "Image Name: ",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `imageName' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageName_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 120,
		XV_Y, 312,
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `imageFormatMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageFormatMessage_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 336,
		PANEL_LABEL_STRING, "Image Format: ",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `imageFormat' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageFormat_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 128,
		XV_Y, 336,
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `imageOriginalSizeMessage' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageOriginalSizeMessage_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 360,
		PANEL_LABEL_STRING, "Original Size (WxH):",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `imageOriginalSize' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageOriginalSize_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 360,
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `imageWidth' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageWidth_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	ImageWidth(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 392,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Displayed Width:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 1200,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, ImageWidth,
		NULL);
	return obj;
}

/*
 * Create object `imageEditButton' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageEditButton_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 280,
		XV_Y, 392,
		PANEL_LABEL_STRING, "Edit Image",
		PANEL_ITEM_MENU, DisplayTool_imageEditMenu_create((caddr_t) ip, ip->slidePopup),
		NULL);
	return obj;
}

/*
 * Create object `imageHeight' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageHeight_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	ImageHeight(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 416,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Displayed Height:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 1200,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, ImageHeight,
		NULL);
	return obj;
}

/*
 * Create object `imageXPosition' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageXPosition_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	ImageXPosition(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 440,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "X Position:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 1200,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, ImageXPosition,
		NULL);
	return obj;
}

/*
 * Create object `imageYPosition' in the specified instance.
 */
Xv_opaque
DisplayTool_slidePopup_imageYPosition_create(DisplayTool_slidePopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	ImageYPosition(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 464,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Y Position:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 1200,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, ImageYPosition,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `slideNumberPopup'.
 */
DisplayTool_slideNumberPopup_objects *
DisplayTool_slideNumberPopup_objects_initialize(DisplayTool_slideNumberPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (DisplayTool_slideNumberPopup_objects *) calloc(1, sizeof (DisplayTool_slideNumberPopup_objects))))
		return (DisplayTool_slideNumberPopup_objects *) NULL;
	if (!ip->slideNumberPopup)
		ip->slideNumberPopup = DisplayTool_slideNumberPopup_slideNumberPopup_create(ip, owner);
	if (!ip->controls4)
		ip->controls4 = DisplayTool_slideNumberPopup_controls4_create(ip, ip->slideNumberPopup);
	if (!ip->slideNumber)
		ip->slideNumber = DisplayTool_slideNumberPopup_slideNumber_create(ip, ip->controls4);
	return ip;
}

/*
 * Create object `slideNumberPopup' in the specified instance.
 */
Xv_opaque
DisplayTool_slideNumberPopup_slideNumberPopup_create(DisplayTool_slideNumberPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 380,
		XV_HEIGHT, 86,
		XV_LABEL, "Slide Number",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls4' in the specified instance.
 */
Xv_opaque
DisplayTool_slideNumberPopup_controls4_create(DisplayTool_slideNumberPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `slideNumber' in the specified instance.
 */
Xv_opaque
DisplayTool_slideNumberPopup_slideNumber_create(DisplayTool_slideNumberPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	SlideNumber(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 32,
		PANEL_VALUE_DISPLAY_LENGTH, 4,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Slide Number:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, SlideNumber,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `resizePopup'.
 */
DisplayTool_resizePopup_objects *
DisplayTool_resizePopup_objects_initialize(DisplayTool_resizePopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (DisplayTool_resizePopup_objects *) calloc(1, sizeof (DisplayTool_resizePopup_objects))))
		return (DisplayTool_resizePopup_objects *) NULL;
	if (!ip->resizePopup)
		ip->resizePopup = DisplayTool_resizePopup_resizePopup_create(ip, owner);
	if (!ip->controls6)
		ip->controls6 = DisplayTool_resizePopup_controls6_create(ip, ip->resizePopup);
	if (!ip->message9)
		ip->message9 = DisplayTool_resizePopup_message9_create(ip, ip->controls6);
	if (!ip->message11)
		ip->message11 = DisplayTool_resizePopup_message11_create(ip, ip->controls6);
	if (!ip->info1)
		ip->info1 = DisplayTool_resizePopup_info1_create(ip, ip->controls6);
	return ip;
}

/*
 * Create object `resizePopup' in the specified instance.
 */
Xv_opaque
DisplayTool_resizePopup_resizePopup_create(DisplayTool_resizePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 400,
		XV_HEIGHT, 150,
		XV_LABEL, "Resize Information",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls6' in the specified instance.
 */
Xv_opaque
DisplayTool_resizePopup_controls6_create(DisplayTool_resizePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message9' in the specified instance.
 */
Xv_opaque
DisplayTool_resizePopup_message9_create(DisplayTool_resizePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 40,
		PANEL_LABEL_STRING, "To resize images, use the rightmost mouse button",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message11' in the specified instance.
 */
Xv_opaque
DisplayTool_resizePopup_message11_create(DisplayTool_resizePopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 56,
		PANEL_LABEL_STRING, "and drag the image from one of its corners.",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `info1' in the specified instance.
 */
Xv_opaque
DisplayTool_resizePopup_info1_create(DisplayTool_resizePopup_objects *ip, Xv_opaque owner)
{
	extern void		DoneHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 144,
		XV_Y, 104,
		PANEL_LABEL_STRING, "OK",
		PANEL_NOTIFY_PROC, DoneHandler,
		NULL);
	return obj;
}

