/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/record.c,v 1.0 92/01/07 14:21:05 drapeau Exp Locker: derek $ */
/* $Log:	record.c,v $
 * Revision 1.0  92/01/07  14:21:05  drapeau
 * Modified StopRecord() to clean up keeping track of currentSoundFile
 * variable and updating the appropriate headers.
 * Modified RemoveSoundFileInTmp(), using the unlink() system call
 * instead of the more awkward use of the system() function.
 * Also, Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 0.19  91/09/18  22:47:36  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.18  91/08/27  18:06:11  derek
 * The SizeToFit bug is fixed.
 * 
 * Revision 0.17  91/08/13  20:38:38  derek
 * The buttons (play, pause, record) will now flash after they are pressed.
 * This only applies to times when audio files (not edit-lists) are 
 * played.
 * 
 * Revision 0.16  91/08/07  16:24:42  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.15  91/07/30  11:45:46  derek
 * I have fixed the tmp file conflict bug.
 * 
 * Revision 0.14  91/07/24  12:52:11  derek
 * Disk editing is done.  Now the application can record sound infinitely,
 * as long as there is disk space available.  Command line args are also
 * supported.
 * 
 * Revision 0.13  91/07/23  21:25:25  derek
 * This version is not ready for release.  Disk space editing is half-done:
 * the application can play an infinite sound and the canvases can handle
 * infinite sound files.  The app is pretty bug free too, I think.  The
 * weakness is that it cannot record sond infinitely.
 * 
 * Revision 0.12  91/06/26  15:55:51  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.11  91/06/05  15:00:07  derek
 * checking in after porting the code to collab
 * 
 * Revision 0.10  1991/04/25  01:51:52  derek
 * This version is checked in on 4/24/91
 * */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/record.c,v 1.0 92/01/07 14:21:05 drapeau Exp Locker: derek $";

#include "dtr.h"
#include "dtr_ui.h"

void
  InitRecord()
{
  tmpnam(SoundFileInTmp);
}


void
  StartRecord()
{
  Audio_info tmpinfo;
  unsigned   Ilen;
  char       *info = NULL;
  extern     dtr_editListPanelPopUp_objects *dtr_editListPanelPopUp;
  
  EVENT("Start_Record");
  
  (void) audio_pause_record(Audio_fd);				    /*  Pause the input and flush the read queue.       */
  (void) audio_flush_record(Audio_fd);
  
  Buffer.hdr = Device_rhdr;
  Buffer.display.position = 0;
  Buffer.display.last = -1;
  Buffer.draining = FALSE;
  Buffer.hdr.data_size = 0;
/**************
  AllocBuffer(audio_secs_to_bytes(&Buffer.hdr, (double)MAX_RECORD_TIME));
**************/
  
  Buffer.display.start = -1;					    /*  Initializing start and end points for display.. */
  Buffer.play.start = 0;					    /*  ...and play.                                    */
  Buffer.display.end = -1;
  Buffer.play.end = 0;
  
  ClearVUMeterCanvas();
  
  ActiveFlag |= RECORD;						    /*  Restart input and reset counters.  SIGPOLL...   */
  AUDIO_INITINFO(&tmpinfo);					    /*  ...will start reading.                          */
  tmpinfo.record.pause = 0;
  tmpinfo.record.samples = 0;
  tmpinfo.record.error = 0;
  (void) audio_setinfo(Audio_fd, &tmpinfo);
  ResetVUMeter();						    /*  Reset VU Meter.                                 */
/*
  SetWaveEditModeOff();						    
*/
  FileReady = TRUE;
  SoundBufferReady = FALSE;
  BufferSaved = FALSE;
  tmpSoundFd = open(SoundFileInTmp,				    /*  Try to open a new file for saving the sound.    */
		    O_WRONLY | O_CREAT | O_TRUNC,
		    0666);
  tmpSoundHdr = Buffer.hdr;
  tmpSoundHdr.data_size = 0;
  if ((tmpSoundFd < 0) ||
      (audio_write_filehdr(tmpSoundFd, &tmpSoundHdr, info, Ilen)
       != AUDIO_SUCCESS))
  {
    fprintf(stderr, "Error:  Recording error\n");
    exit(0);
  }
  
  xv_set(dtr_editListPanelPopUp->addButton,			    
	 PANEL_INACTIVE, TRUE, NULL);
  xv_set(dtr_editListPanelPopUp->modifyButton,
	 PANEL_INACTIVE, TRUE, NULL);
  xv_set(dtr_editListPanelPopUp->deleteButton,			    
	 PANEL_INACTIVE, TRUE, NULL);
  xv_set(dtr_editListPanelPopUp->deleteAllButton,
	 PANEL_INACTIVE, TRUE, NULL);
  SetButtonGlowTimer(GLOW_INTERVAL);
}								    /* end function StartRecord */


/*
 *  This is the routine that is called from the main loop that reads
 *  sound from the device.  Now, when recording, the VUMeter will
 *  be updated by this function instead of by having a timer calling
 *  UpdateVUMeter.
 */
void
  RecordService()
{
  int	readsize;
  int	rtn;
  static  unsigned char  data[512];
  int   level;
  int   i;
  
  EVENT("Record_Service");
  
  if (ioctl(Audio_fd, FIONREAD, &readsize) < 0)
  {
    PERROR("FIONREAD");
    return;
  }
  
  if ((readsize == 0) || ((readsize < SCOPE_WIDTH) &&		    /*  Dont bother if there is nothing to read, or...  */
			  !Buffer.draining))			    /*  ...if not much (and we're not draining input.). */
    return;							    /*  Also, Buffer.hdr.alloc_size = MAX_RECORD_SIZE.. */
								    /*  ...(due to StartRecord().                       */
  
  for (;;)
  {
    rtn = read(Audio_fd, (char *)data, 512);
    for (level = 0, i = 0; i < 512; i+=2)			    /*  Start updating VUMeter.                         */
    {
      if (abs((int)audio_u2c(data[i])) > level)
	level = abs((int)audio_u2c(data[i]));
    }
    CalculateLevelAndDisplayVUMeter(level);
    if (rtn < 0)
    {
      if (errno != EWOULDBLOCK)
	PERROR("read");
      break;
    }
    else
    {
      write(tmpSoundFd, (char *)data, rtn);
    }
    Buffer.hdr.data_size += rtn;
    if (ioctl(Audio_fd, FIONREAD, &readsize) < 0)
      return;
  }
}								    /* end function RecordService */


void
  StopRecord()
{
  unsigned	u;
  extern        dtr_mainWindow_objects               *dtr_mainWindow;
  extern        dtr_editListPanelPopUp_objects          *dtr_editListPanelPopUp;
  
  EVENT("Stop_Record");
  ActiveFlag &= ~RECORD;
  if (WaitFlag & RECORD)					    /*  If waiting for device open, quit waiting now.   */
  {
    WaitFlag &= ~RECORD;
    return;
  }
  (void) audio_pause_record(Audio_fd);				    /*  Pause the device so that we can drain the input */
  Buffer.draining = TRUE;					    /*  Read residual input, if any.                    */
  RecordService();
  Buffer.draining = FALSE;
  (void) audio_get_record_error(Audio_fd, &u);
  Audio_state.record.error = u;
  if (!ActiveFlag)
  {
    AudioFlushClose();
  }
  audio_rewrite_filesize(tmpSoundFd, Buffer.hdr.data_size);
  close(tmpSoundFd);
  ClearVUMeterCanvas();
  if (Buffer.play.end == 0)					    /*  Set new endpoints (if not selected during...    */
  {								    /*  ...record) & redisplay.                         */
    Buffer.display.end = Buffer.play.end = 
      Buffer.hdr.data_size - 1;
  }
  Buffer.display.start = Buffer.play.start;
  FileUpdate();
  UpdateMessageDisplay();
  FrameStartingSecond = 0.0;
  sprintf(currentSoundFile, "%s", SoundFileInTmp);
  UpdateHeader(TRUE);
  SoundBufferReady = ReadSoundFile(TRUE);
  FileReady = FALSE;
  SameSoundFile = TRUE;
  ResetWaveCanvas();
  ResetGlobalWaveCanvas();
  RepaintWaveCanvas();
  RepaintGlobalWaveCanvas();
  CancelButtonGlowTimer();
  xv_set(dtr_editListPanelPopUp->addButton,
	 PANEL_INACTIVE, FALSE, NULL);
  xv_set(dtr_editListPanelPopUp->modifyButton,
	 PANEL_INACTIVE, FALSE, NULL);
  xv_set(dtr_editListPanelPopUp->deleteButton,			    
	 PANEL_INACTIVE, FALSE, NULL);
  xv_set(dtr_editListPanelPopUp->deleteAllButton,
	 PANEL_INACTIVE, FALSE, NULL);
  xv_set(dtr_editListPanelPopUp->editListScrollList,
	 PANEL_INACTIVE, FALSE, NULL);

  SetWaveEditModeOn();

}								    /* end function StopRecord */


void
  RemoveSoundFileInTmp()
{
  unlink(SoundFileInTmp);
}
