/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*$Header: /Source/Media/collab/DTR/RCS/openpanel.c,v 2.0 92/01/06 17:58:08 drapeau Exp Locker: derek $*/
/* $Log:	openpanel.c,v $
 * Revision 2.0  92/01/06  17:58:08  drapeau
 * Modified both OpenHandler() and SaveHandler() to reflect the newly-integrated
 * ReadSoundFile() function.
 * Also, Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 1.9  91/10/09  17:22:02  derek
 * Save Edit List bug fixed.
 * 
 * Revision 1.8  91/09/18  22:47:31  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 1.7  91/08/22  15:48:52  derek
 * The format of the DTR edit-list has been changed.  The header is 
 * changed from "#DTR Edit File#" to "#DTR Edit Document#".  Also,
 * EditNumber is added to every edit within the edit-list.
 * 
 * Revision 1.6  91/08/21  11:34:23  derek
 * The following changes are made:
 * 1.	Now the duration and size of the recorded sound will be displayed
 * 	during recording.
 * 2.	I have changed GetSelection() corresponding to the request of Tek joo
 * 3.	Info Panel is added to the application.
 * 4.	Fixed SizeToFitHandler() so that when no file or buffer is currently
 * 	loaded, it would not do anything (except giving a warning
 * 	notice_prompt).
 * 5.	Inplemented the `Close' Menu option in the document menu.
 * 6.	Fixed the bug in which after ClearAll and I press PreviewEdit,
 * 	the edit wont be played.
 * 7.	I have made the changes corresponding to the change in OpenPanel's
 * 	name.  (from OpenPanel to Browse).
 * 8.	Incorporated BrowseCheck to check command line arg.
 * 9.	Changed most EditingStatusMessages to NoticePrompts.
 * 10.	SoundFileSaveAsPopUp and EditListSaveAsPopUp are removed 
 * 	from the application.
 * 
 * Revision 1.5  91/08/16  18:10:44  derek
 * 
 * The following things are done:
 * 1.	I have fixed an openpanel bug in my code in which I 
 * 	made the app return the wrong values to OpenHandler and
 * 	the SaveHandler.
 * 2.	The flashing color of the play button has been changed from
 * 	Red to Green.
 * 3.	Fixed a quantization bug: Buffer.play.end, when converted
 * 	from endingTimeInSec, should not exceed Buffer_hdr_data_size - 1.
 * 
 * Revision 1.4  91/08/14  16:14:07  derek
 * Fixed a few saving/appending bugs.
 * 
 * Revision 1.3  91/08/08  21:44:43  derek
 * Fixed a number of bugs.
 * 
 * Revision 1.2  91/08/07  16:24:32  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 1.1  91/08/06  12:41:49  derek
 * Initial revision
 *  */
static char rcsid[] = "$Header: /Source/Media/collab/DTR/RCS/openpanel.c,v 2.0 92/01/06 17:58:08 drapeau Exp Locker: derek $";

#include "dtr.h"
#include "dtr_ui.h"

extern  dtr_mainWindow_objects *dtr_mainWindow;

void
  InitOpenPanel()
{
  (void) CreateBrowse(OpenHandler,
		      SaveHandler,
		      dtr_mainWindow->mainWindow);
  documentFirstLine = (char *)strdup("#DTR Edit Document#");
  documentFileType = (char *)strdup("DTR");
}


/*
 *  This OpenHandler is called by Browse(), which in turn is invoked by
 *  Menu_item Open(item, op).
 */
int
  OpenHandler(proposedPath, id)
char  *proposedPath;
int   id;
{
  int    status;

  status = FILE_NOT_OK;
  switch(id)
  {
   case IS_SOUNDFILE:
    sprintf(currentSoundFile,"%s",proposedPath);
    UpdateHeader(FALSE);
    if (WaveEditMode == FALSE)
    {
      FileReady = ReadSoundFile(FALSE);
      SoundBufferReady = FALSE;
    }
    else
    {
      SoundBufferReady = ReadSoundFile(TRUE);
      FileReady = FALSE;
    }
    SameSoundFile = TRUE;
    if ((FileReady == TRUE) || (SoundBufferReady == TRUE)) 
    {
      RepaintWaveCanvas();
      RepaintGlobalWaveCanvas();
      status = FILE_OK;
    }
    else
    {
      sprintf(currentSoundFile,"Untitled");
      UpdateHeader(FALSE);
    }

    break;
    
   case IS_EDITLIST:
    status = ReadEditListFromFile(proposedPath, USER);
    break;
   
   default:
    fprintf(stderr, "Unknown id value in OpenHandler.\n");
    status = FILE_NOT_OK;
    break;
  }
  
  return(status);
}


/*
 *  This SaveHandler is called by Browse(), which in turn is invoked by
 *  Menu_item Save(item, op).
 */
int
  SaveHandler(proposedPath, id)
char  *proposedPath;
int   id;
{
  char    	sourceFileName[80];
  char    	destFileName[80];
  BOOL    	append;
  char    	reply;
  BOOL    	exists;
  struct stat	st;
    
  switch(id)
  {
   case IS_SOUNDFILE:
    sprintf(currentSoundFile,"%s",proposedPath);
    UpdateHeader(FALSE);
    if ((WaveEditMode == TRUE) && (SoundBufferReady == FALSE))	    /*  If in Edit mode and the sound buffer is not...  */
    {								    /*  ...ready, we need not save anything.            */
      return FILE_NOT_OK;
    }
    strcpy(sourceFileName, Buffer.filename);
    if (strcmp(sourceFileName, "\0") == 0)			    /*  Here, currentSoundFile contains the...          */
    {								    /*  ...destFileName.  Buffer.filename contains...   */
      AlertByNoticePrompt(dtr_mainWindow->menuControlPanel,	    /*  ...sourceFileName.                              */
			  " Error --- No source sound available."); 
      return FILE_NOT_OK;
    }
    exists = (stat(currentSoundFile, &st) == 0);
    if (!exists)
      append = FALSE;
    else 
    {
      reply = notice_prompt(dtr_mainWindow->menuControlPanel, NULL, /*  destination file already exists.  Should ask... */
			    NOTICE_MESSAGE_STRINGS,		    /*  use if he really wants to append or overwrite.  */
			    "File exists.  Append data to existing",
			    "file or overwrite it?",
			    NULL,
			    NOTICE_BUTTON, "Append", 'A',
			    NOTICE_BUTTON, "Overwrite", 'O',
			    NOTICE_BUTTON, "Cancel", 'C',
			    NULL);
      if (reply == 'A')
	append = TRUE;
      else if (reply == 'O')
	append = FALSE;
      else return FILE_NOT_OK;
    }
    return(SaveSoundFile(append, sourceFileName, currentSoundFile));
    break;
   case IS_EDITLIST:
    return(WriteEditListToFile(proposedPath));
    break;
   default:
    fprintf(stderr, "Unknown id value in SaveHandler.\n");
    break;
  }								    /* end switch(id) */
}								    /* end function SaveHandler */

