#if !defined(UNIXLIB_H)
#define UNIXLIB_H


#include "config.h"
#include "proto.h"


/*
 *  Globals
 */
 
extern char *optarg;
extern int optind;
extern int opterr;
extern int argerr;


/*
 *  Defines
 */

#define OPTCHR       '-'
#define OPT_UNKNOWN  '?'

#if defined(ATARI_ST)
#define POINTDIR_STR ".\\"
#define BPOINTDIR_STR "..\\"
#define SLASH_STR    "\\"
#define SLASH_CHAR   '\\'
#define MAXNAMLEN       12        /* name must be no longer than this */
#define lstat(a,b)  stat(a,b)
#include <ext.h>

#elif defined(MSDOS)
#define POINTDIR_STR ".\\"
#define BPOINTDIR_STR "..\\"
#define SLASH_STR    "\\"
#define SLASH_CHAR   '\\'
#define MAXNAMLEN       12        /* name must be no longer than this */
#define lstat(a,b)  stat(a,b)
#define MAXPATH 1024

#elif defined(SUN) || defined(SEQUENT386) || defined(AVIION)
#define POINTDIR_STR "./"
#define BPOINTDIR_STR "../"
#define SLASH_STR    "/"
#define SLASH_CHAR   '/'
#define MAXPATH MAXPATHLEN
#define SEEK_SET     0
#define SEEK_CUR     1
#define SEEK_END     2
#include <sys/param.h>

#else
#error Wrong machine type. Edit config.h and follow the instructions.

#endif /* machine type */

#define EOLN        10


/*
 *  Typedefs
 */

#if defined(ATARI_ST) || defined(MSDOS)
struct direct
  {
    unsigned long  d_fileno;                    /* file number of entry */
    unsigned short d_reclen;                   /* length of this record */
    unsigned short d_namlen;              /* length of string in d_name */
    char           d_name[MAXNAMLEN + 1];
  };

#elif defined(SUN) || defined(SEQUENT386) || defined(AVIION)
#include <sys/types.h>
#include <sys/dir.h>

#else
#error Wrong machine type. Edit config.h and follow the instructions.

#endif


/*
 *  Prototypes
 */

int scandir __P((char *path, struct direct *(*namelist[]),
                 int (*selectfun) __P((struct direct *d)),
                 int (*sortfun) __P((struct direct **d1,
                                     struct direct **d2)) ));

int alphasort __P((struct direct **d1, struct direct **d2));

int no_pointdir __P((struct direct *d));

char *getwd __P((char *buf));

int getopt __P((int argc, char *argv[], char *opts));
char *getarg __P((int argc, char *argv[], char *opts));


#endif /* !defined(UNIXLIB_H) */

