#include <stdio.h>
#include <ctype.h>
#include <raster_lib.h>
#include <sys/types.h>
#include <sys/file.h>
#ifdef sys5
#include <fcntl.h>
#endif
#include <pixlib.h>

char Usage[] = "%s [--] device output-file [-w left top] [-s height width] [-o offset]\n";
char *Example[] = {
    "\tReadpic reads an image from the specified rastertech 'device'\n",
    "\tand creates an output lucasfilm format image. Normally the full\n",
    "\t512x512 screen is read back. Smaller images may be specified by\n",
    "\tgiving a different heigth and width with the -s flag, and\n",
    "\tthe upper left corner of the image may be moved with the -w flag.\n",
    "\n\tIf offset is specified, the image is written starting that many\n",
    "\tbytes into output-file\n",
    "\n\tNormally the upper left corner is (-256,255)\n",
    NullPtr(char)
};

main (argc, argv)
int	argc;
char   *argv[];
{
    char *devname = NULL,
	 *lffname = NULL;
    u_char *image, *init_image();
    int mypixfun(), i,
	count, stat,
	height = 512,
	width = 512,
	left = -256,
	top = 255,
	offset = 0;

    for (i = 1; i < argc; i++) {
	if (!strcmp(argv[i],"--"))
	    userhelp(argv[0],Usage,Example);
	if (!strcmp (argv[i], "-w")) {
	    if (!sscanf(argv[++i],"%d",&left) || !sscanf(argv[++i],"%d",&top))
		gr_bomb ("Not enough arguments to -w\n");
	} else if (!strcmp (argv[i], "-s")) {
	    if (!sscanf(argv[++i],"%d",&height) || !sscanf(argv[++i],"%d",&width))
		gr_bomb ("Not enough arguments to -s\n");
	} else if (!strcmp(argv[i], "-o")) {
	    if (!sscanf(argv[++i], "%d", &offset))
		gr_bomb("No argument to -o\n");
	} else {
	    if (devname == NULL)
		devname = argv[i];
	    else if (lffname == NULL)
		lffname = argv[i];
	    else
		userhelp(argv[0],Usage,Example);
	}
    }

    /* Check parameters */
    /* This is really a horrible, unportable kludge... sigh */
    if (strcmp(devname,"/dev/rt0") && strcmp(devname,"/dev/rt1"))
	gr_bomb("Device must be a DMA rastertech. The only one is /dev/rt0!\n");

    if (lffname == NULL)
	gr_bomb("No output file specified\n");

    if (height < 1 || width < 1 || height > 512 || width > 512)
	gr_bomb("Bad height (%d) or width (%d): must be in range 1..512\n",
	    height,width);

    printf("Reading a [%d,%d] pixel window from [%d,%d]\n",
	height,width,left,top);

    /* Allocate space for image */
    image = init_image(height,width);

    /* Init framebuffer */
    rtinit (devname, RTMODE_DMA, 1024);
    entgra ();
    movabs(left,top);
    rdmode(1);	    /* Binary */
    readf(0);	    /* 24-bit */
    emptyb();

    count = readw(height,width,128,image);
    quit();

    printf("Got %d pixels, expecting %d\n",count,height * width);

    if (offset != 0) {
	int fd = open(lffname, O_WRONLY|O_CREAT, 0644);
	if (fd == -1)
	    gr_bomb("Error opening output file %s\n", lffname);
	else
	    stat =
		write_lff_fd(fd,
			    (off_t)offset,
			     height, width,
			     1, 1,
			     FORMAT_RGB,
			     STORAGE_DUMP,
			     0, 0, /* left + 256, top - 255, */
			     LFF_VERSION,
			     0,
			     mypixfun);
    } else
	stat = write_lff(
	      lffname,
	      height, width,
	      1, 1,
	      FORMAT_RGB,
	      STORAGE_DUMP,
	      0, 0, /* left + 256, top - 255, */
	      LFF_VERSION,
	      0,
	      mypixfun);
    if (stat != LFF_OK)
	printf("Error writing output file: %s\n", pixerrmess(stat));
}

u_char *Image;
int Height, Width;

u_char *init_image(height,width)
int height, width;
{
    char *malloc();

    Image = (u_char *)malloc(height * width * 3);

    if (Image == NullPtr(u_char))
	gr_bomb("Failure to allocate %d bytes for incore image\n",
	    height * width * 3);

    Height = height;
    Width = width;
    return Image;
}

int mypixfun(row, column, length, pixels)
int row, column, length;
register RGBPIXEL *pixels;
{
    register unsigned char *ptr = &Image[3 * (row * Width + column)];
    register int count = length;

    while (count--) {
	*pixels++ = RGB8(ptr[0],ptr[1],ptr[2]);
	ptr += 3;
    }

    return length;
}
