/* ppmtolff - convert PPM to .LFF format
 *
 * Jon Leech 11/17/92
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "pixlib.h"
#include <ppm.h>

LFF_HDR Imagehdr;

char Usage[] = "%s [--] input-file output-file\n";
char *Example[] = {
    "\tppmtolff converts a PPM file to a lucasfilm file\n",
    "\n\tExample: ppmtolfftoppm image.ppm image.lff\n",
    NullPtr(char)
};

main (argc, argv)
int	argc;
char   *argv[];
{
    int  i, mode, status, getpixfun();
    char *ppmname = NULL, *outname = NULL;
    FILE *fp;
    pixel **ipixels;
    int width, height;
    pixval maxval;

    for (i = 1; i < argc; i++) {
	if (!strcmp(argv[i],"--"))
	    userhelp(argv[0],Usage,Example);
	else {
	    if (ppmname == NULL)
		ppmname = argv[i];
	    else if (outname == NULL)
		outname = argv[i];
	    else
		userhelp(argv[0],Usage,Example);
	}
    }

    if (!ppmname || !outname)
	gr_bomb("%s requires an input and output file name\n", argv[0]);

    if (!(fp = fopen(ppmname, "r")))
	gr_bomb("Can't read %s\n", ppmname);

    /* Read the PPM file */
    /* libppm doesn't seem to do any error checking?! */
    ipixels = ppm_readppm(fp, &width, &height, &maxval);

    /* Now write the image */
    printf("Writing %s\n", outname);
    pixinit(ipixels, height, width);
    status = write_lff(
	outname,
	height, width,
	1, 1,
	FORMAT_RGB,
	STORAGE_DUMP,
	0, 0,
	LFF_VERSION,
	0,
	getpixfun);
    if (status != LFF_OK)
	gr_error("Error writing output file %s: %s\n",
	    outname, pixerrmess(status));
    else
	printf("Finished writing %s\n", outname);

    return 0;
}

static pixel **Image;
static int Height, Width;

pixinit(image, height, width)
pixel **image;
int height, width;
{
    Image = image;
    Height = height;
    Width = width;
}

/*
    Function called by write_lff, which returns the next line from the
	input image.
*/
int getpixfun(row,col,length,pixels)
int row, col, length;
RGBPIXEL pixels[];
{
    int i;
    pixel *pixsrc = Image[row];

    /* Convert each pixel from PPM to LFF format */
    for (i = 0; i < length; i++) {
	pixel p;

	p = pixsrc[col+i];
	pixels[i] = RGB8(PPM_GETR(p), PPM_GETG(p), PPM_GETB(p));
    }
    return length;
}
